/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.uri.URISyntaxException;
import java.io.Serializable;

public final class URI
implements Comparable,
Serializable {
    private transient String scheme;
    private transient String fragment;
    private transient String authority;
    private transient String userInfo;
    private transient String host;
    private transient int port = -1;
    private transient String path;
    private transient String query;
    private volatile transient String schemeSpecificPart;
    private volatile transient int hash;
    private int length = 16;
    private volatile String string;
    private static final long L_DIGIT = URI.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = URI.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = URI.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_HEX = L_DIGIT;
    private static final long H_HEX = URI.highMask('A', 'F') | URI.highMask('a', 'f');
    private static final long L_MARK = URI.lowMask("-_.!~*'()");
    private static final long H_MARK = URI.highMask("-_.!~*'()");
    private static final long L_UNRESERVED = L_ALPHANUM | L_MARK;
    private static final long H_UNRESERVED = H_ALPHANUM | H_MARK;
    private static final long L_RESERVED = URI.lowMask(";/?:@&=+$,[]");
    private static final long H_RESERVED = URI.highMask(";/?:@&=+$,[]");
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_URIC = L_RESERVED | L_UNRESERVED | 1L;
    private static final long H_URIC = H_RESERVED | H_UNRESERVED | 0L;
    private static final long L_PCHAR = L_UNRESERVED | 1L | URI.lowMask(":@&=+$,");
    private static final long H_PCHAR = H_UNRESERVED | 0L | URI.highMask(":@&=+$,");
    private static final long L_PATH = L_PCHAR | URI.lowMask(";/");
    private static final long H_PATH = H_PCHAR | URI.highMask(";/");
    private static final long L_DASH = URI.lowMask("-");
    private static final long H_DASH = URI.highMask("-");
    private static final long L_DOT = URI.lowMask(".");
    private static final long H_DOT = URI.highMask(".");
    private static final long L_USERINFO = L_UNRESERVED | 1L | URI.lowMask(";:&=+$,");
    private static final long H_USERINFO = H_UNRESERVED | 0L | URI.highMask(";:&=+$,");
    private static final long L_REG_NAME = L_UNRESERVED | 1L | URI.lowMask("$,;:@&=+");
    private static final long H_REG_NAME = H_UNRESERVED | 0L | URI.highMask("$,;:@&=+");
    private static final long L_SERVER = L_USERINFO | L_ALPHANUM | L_DASH | URI.lowMask(".:@[]");
    private static final long H_SERVER = H_USERINFO | H_ALPHANUM | H_DASH | URI.highMask(".:@[]");
    private static final long L_SCHEME = 0L | L_DIGIT | URI.lowMask("+-.");
    private static final long H_SCHEME = H_ALPHA | 0L | URI.highMask("+-.");

    private URI() {
    }

    public URI(String str) throws URISyntaxException {
        this.length = str.length();
        Parser lParser = new Parser(str);
        lParser.parse(false);
    }

    public URI parseServerAuthority() throws URISyntaxException {
        if (this.host != null || this.authority == null) {
            return this;
        }
        this.defineString();
        new Parser(this.string).parse(true);
        return this;
    }

    public URI normalize() {
        return URI.normalize(this);
    }

    public URI resolve(URI uri) {
        return URI.resolve(this, uri);
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.path == null;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof URI)) {
            return false;
        }
        URI that = (URI)ob;
        if (this.isOpaque() != that.isOpaque()) {
            return false;
        }
        if (!URI.equalIgnoringCase(this.scheme, that.scheme)) {
            return false;
        }
        if (!URI.equal(this.fragment, that.fragment)) {
            return false;
        }
        if (this.isOpaque()) {
            return URI.equal(this.schemeSpecificPart, that.schemeSpecificPart);
        }
        if (!URI.equal(this.path, that.path)) {
            return false;
        }
        if (!URI.equal(this.query, that.query)) {
            return false;
        }
        if (this.authority == that.authority) {
            return true;
        }
        if (this.host != null) {
            if (!URI.equal(this.userInfo, that.userInfo)) {
                return false;
            }
            if (!URI.equalIgnoringCase(this.host, that.host)) {
                return false;
            }
            if (this.port != that.port) {
                return false;
            }
        } else if (this.authority != null ? !URI.equal(this.authority, that.authority) : this.authority != that.authority) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = URI.hashIgnoringCase(0, this.scheme);
        h = URI.hash(h, this.fragment);
        if (this.isOpaque()) {
            h = URI.hash(h, this.schemeSpecificPart);
        } else {
            h = URI.hash(h, this.path);
            h = URI.hash(h, this.query);
            if (this.host != null) {
                h = URI.hash(h, this.userInfo);
                h = URI.hashIgnoringCase(h, this.host);
                h += 1949 * this.port;
            } else {
                h = URI.hash(h, this.authority);
            }
        }
        this.hash = h;
        return h;
    }

    public int compareTo(Object ob) {
        URI that = (URI)ob;
        int c = URI.compareIgnoringCase(this.scheme, that.scheme);
        if (c != 0) {
            return c;
        }
        if (this.isOpaque()) {
            if (that.isOpaque()) {
                c = URI.compare(this.schemeSpecificPart, that.schemeSpecificPart);
                if (c != 0) {
                    return c;
                }
                return URI.compare(this.fragment, that.fragment);
            }
            return 1;
        }
        if (that.isOpaque()) {
            return -1;
        }
        if (this.host != null && that.host != null) {
            c = URI.compare(this.userInfo, that.userInfo);
            if (c != 0) {
                return c;
            }
            c = URI.compareIgnoringCase(this.host, that.host);
            if (c != 0) {
                return c;
            }
            c = this.port - that.port;
            if (c != 0) {
                return c;
            }
        } else {
            c = URI.compare(this.authority, that.authority);
            if (c != 0) {
                return c;
            }
        }
        if ((c = URI.compare(this.path, that.path)) != 0) {
            return c;
        }
        c = URI.compare(this.query, that.query);
        if (c != 0) {
            return c;
        }
        return URI.compare(this.fragment, that.fragment);
    }

    public String toString() {
        this.defineString();
        return this.string;
    }

    private static int toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c + 32;
        }
        return c;
    }

    private static boolean equal(String s, String t) {
        if (s == t) {
            return true;
        }
        if (s != null && t != null) {
            if (s.length() != t.length()) {
                return false;
            }
            if (s.indexOf(37) < 0) {
                return s.equals(t);
            }
            int n = s.length();
            int i = 0;
            while (i < n) {
                char c = s.charAt(i);
                char d = t.charAt(i);
                if (c != '%') {
                    if (c != d) {
                        return false;
                    }
                    ++i;
                    continue;
                }
                if (URI.toLower(s.charAt(++i)) != URI.toLower(t.charAt(i))) {
                    return false;
                }
                if (URI.toLower(s.charAt(++i)) != URI.toLower(t.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean equalIgnoringCase(String s, String t) {
        if (s == t) {
            return true;
        }
        if (s != null && t != null) {
            int n = s.length();
            if (t.length() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (URI.toLower(s.charAt(i)) == URI.toLower(t.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int hash(int hash, String s) {
        if (s == null) {
            return hash;
        }
        return hash * 127 + s.hashCode();
    }

    private static int hashIgnoringCase(int hash, String s) {
        if (s == null) {
            return hash;
        }
        int h = hash;
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            h = 31 * h + URI.toLower(s.charAt(i));
        }
        return h;
    }

    private static int compare(String s, String t) {
        if (s == t) {
            return 0;
        }
        if (s != null) {
            if (t != null) {
                return s.compareTo(t);
            }
            return -1;
        }
        return 1;
    }

    private static int compareIgnoringCase(String s, String t) {
        if (s == t) {
            return 0;
        }
        if (s != null) {
            if (t != null) {
                int tn;
                int sn = s.length();
                int n = sn < (tn = t.length()) ? sn : tn;
                for (int i = 0; i < n; ++i) {
                    int c = URI.toLower(s.charAt(i)) - URI.toLower(t.charAt(i));
                    if (c == 0) continue;
                    return c;
                }
                return sn - tn;
            }
            return 1;
        }
        return -1;
    }

    private static void appendAuthority(StringBuffer sb, String authority, String userInfo, String host, int port) {
        if (host != null) {
            boolean needBrackets;
            sb.append("//");
            if (userInfo != null) {
                sb.append(URI.quote(userInfo, L_USERINFO, H_USERINFO));
                sb.append('@');
            }
            boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
            if (needBrackets) {
                sb.append('[');
            }
            sb.append(host);
            if (needBrackets) {
                sb.append(']');
            }
            if (port != -1) {
                sb.append(':');
                sb.append(port);
            }
        } else if (authority != null) {
            sb.append("//");
            sb.append(URI.quote(authority, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
        }
    }

    private void appendSchemeSpecificPart(StringBuffer sb, String opaquePart, String authority, String userInfo, String host, int port, String path, String query) {
        if (opaquePart != null) {
            sb.append(URI.quote(opaquePart, L_URIC, H_URIC));
        } else {
            URI.appendAuthority(sb, authority, userInfo, host, port);
            if (path != null) {
                sb.append(URI.quote(path, L_PATH, H_PATH));
            }
            if (query != null) {
                sb.append('?');
                sb.append(URI.quote(query, L_URIC, H_URIC));
            }
        }
    }

    private static void appendFragment(StringBuffer sb, String fragment) {
        if (fragment != null) {
            sb.append('#');
            sb.append(URI.quote(fragment, L_URIC, H_URIC));
        }
    }

    private String toString(String scheme, String opaquePart, String authority, String userInfo, String host, int port, String path, String query, String fragment) {
        StringBuffer sb = new StringBuffer(this.length);
        if (scheme != null) {
            sb.append(scheme);
            sb.append(':');
        }
        this.appendSchemeSpecificPart(sb, opaquePart, authority, userInfo, host, port, path, query);
        URI.appendFragment(sb, fragment);
        return sb.toString();
    }

    private void defineString() {
        if (this.string != null) {
            return;
        }
        this.string = this.toString(this.scheme, this.isOpaque() ? this.schemeSpecificPart : null, this.authority, this.userInfo, this.host, this.port, this.path, this.query, this.fragment);
    }

    private static String resolvePath(String base, String child, boolean absolute) {
        int i = base.lastIndexOf(47);
        int cn = child.length();
        String path = "";
        if (cn == 0) {
            if (i >= 0) {
                path = base.substring(0, i + 1);
            }
        } else {
            StringBuffer sb = new StringBuffer(child.length() + i + 1);
            if (i >= 0) {
                sb.append(base.substring(0, i + 1));
            }
            sb.append(child);
            path = sb.toString();
        }
        String np = URI.normalize(path);
        return np;
    }

    private static URI resolve(URI base, URI child) {
        if (base.isOpaque() || child.isOpaque()) {
            return child;
        }
        if (child.scheme == null && child.authority == null && child.path.equals("") && child.fragment != null && child.query == null) {
            if (base.fragment != null && child.fragment.equals(base.fragment)) {
                return base;
            }
            URI ru = new URI();
            ru.scheme = base.scheme;
            ru.authority = base.authority;
            ru.userInfo = base.userInfo;
            ru.host = base.host;
            ru.port = base.port;
            ru.path = base.path;
            ru.fragment = child.fragment;
            ru.query = base.query;
            return ru;
        }
        if (child.scheme != null) {
            return child;
        }
        URI ru = new URI();
        ru.scheme = base.scheme;
        ru.query = child.query;
        ru.fragment = child.fragment;
        if (child.authority == null) {
            String cp;
            ru.authority = base.authority;
            ru.host = base.host;
            ru.userInfo = base.userInfo;
            ru.port = base.port;
            String string = cp = child.path == null ? "" : child.path;
            ru.path = cp.length() > 0 && cp.charAt(0) == '/' ? child.path : URI.resolvePath(base.path, cp, base.isAbsolute());
        } else {
            ru.authority = child.authority;
            ru.host = child.host;
            ru.userInfo = child.userInfo;
            ru.host = child.host;
            ru.port = child.port;
            ru.path = child.path;
        }
        return ru;
    }

    private static URI normalize(URI u) {
        if (u.isOpaque() || u.path == null || u.path.length() == 0) {
            return u;
        }
        String np = URI.normalize(u.path);
        if (np == u.path) {
            return u;
        }
        URI v = new URI();
        v.scheme = u.scheme;
        v.fragment = u.fragment;
        v.authority = u.authority;
        v.userInfo = u.userInfo;
        v.host = u.host;
        v.port = u.port;
        v.path = np;
        v.query = u.query;
        return v;
    }

    private static int needsNormalization(String path) {
        int p;
        boolean normal = true;
        int ns = 0;
        int end = path.length() - 1;
        for (p = 0; p <= end && path.charAt(p) == '/'; ++p) {
        }
        if (p > 1) {
            normal = false;
        }
        block1: while (p <= end) {
            if (path.charAt(p) == '.' && (p == end || path.charAt(p + 1) == '/' || path.charAt(p + 1) == '.' && (p + 1 == end || path.charAt(p + 2) == '/'))) {
                normal = false;
            }
            ++ns;
            while (p <= end) {
                if (path.charAt(p++) != '/') continue;
                while (p <= end && path.charAt(p) == '/') {
                    normal = false;
                    ++p;
                }
                continue block1;
            }
        }
        return normal ? -1 : ns;
    }

    private static void split(char[] path, int[] segs) {
        int p;
        int end = path.length - 1;
        int i = 0;
        for (p = 0; p <= end && path[p] == '/'; ++p) {
            path[p] = '\u0000';
        }
        block1: while (p <= end) {
            segs[i++] = p++;
            while (p <= end) {
                if (path[p++] != '/') continue;
                path[p - 1] = '\u0000';
                while (p <= end && path[p] == '/') {
                    path[p++] = '\u0000';
                }
                continue block1;
            }
        }
        if (i != segs.length) {
            throw new InternalError();
        }
    }

    private static int join(char[] path, int[] segs) {
        int ns = segs.length;
        int end = path.length - 1;
        int p = 0;
        if (path[p] == '\u0000') {
            path[p++] = 47;
        }
        for (int i = 0; i < ns; ++i) {
            int q = segs[i];
            if (q == -1) continue;
            if (p == q) {
                while (p <= end && path[p] != '\u0000') {
                    ++p;
                }
                if (p > end) continue;
                path[p++] = 47;
                if (p > end || path[p] != '\u0000') continue;
                path[p++] = 47;
                continue;
            }
            if (p < q) {
                while (q <= end && path[q] != '\u0000') {
                    path[p++] = path[q++];
                }
                if (q > end) continue;
                path[p++] = 47;
                if (q + 1 > end || path[q + 1] != '\u0000') continue;
                path[p++] = 47;
                continue;
            }
            throw new InternalError();
        }
        return p;
    }

    private static void removeDots(char[] path, int[] segs) {
        int ns = segs.length;
        int end = path.length - 1;
        for (int i = 0; i < ns; ++i) {
            int q;
            int j;
            int dots = 0;
            do {
                int p;
                if (path[p = segs[i]] != '.') continue;
                if (p == end) {
                    dots = 1;
                    break;
                }
                if (path[p + 1] == '\u0000') {
                    dots = 1;
                    break;
                }
                if (path[p + 1] != '.' || p + 1 != end && path[p + 2] != '\u0000') continue;
                dots = 2;
                break;
            } while (++i < ns);
            if (i > ns || dots == 0) break;
            if (dots == 1) {
                segs[i] = -1;
                continue;
            }
            for (j = i - 1; j >= 0 && segs[j] == -1; --j) {
            }
            if (j < 0 || path[q = segs[j]] == '.' && path[q + 1] == '.' && path[q + 2] == '\u0000') continue;
            segs[i] = -1;
            segs[j] = -1;
        }
    }

    private static void maybeAddLeadingDot(char[] path, int[] segs) {
        int f;
        if (path[0] == '\u0000') {
            return;
        }
        int ns = segs.length;
        for (f = 0; f < ns && segs[f] < 0; ++f) {
        }
        if (f >= ns || f == 0) {
            return;
        }
        int p = segs[f];
        boolean exception = false;
        try {
            while (path[p] != ':' && path[p] != '\u0000') {
                ++p;
            }
        }
        catch (Exception e) {
            exception = true;
        }
        if (exception || path[p] == '\u0000') {
            return;
        }
        path[0] = 46;
        path[1] = '\u0000';
        segs[0] = 0;
    }

    public static String normalize(String ps) {
        int ns = URI.needsNormalization(ps);
        if (ns < 0) {
            return ps;
        }
        char[] path = ps.toCharArray();
        int[] segs = new int[ns];
        URI.split(path, segs);
        URI.removeDots(path, segs);
        URI.maybeAddLeadingDot(path, segs);
        return new String(path, 0, URI.join(path, segs));
    }

    private static long lowMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c >= '@') continue;
            m |= 1L << c;
        }
        return m;
    }

    private static long highMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            m |= 1L << c - 64;
        }
        return m;
    }

    private static long lowMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 63), 0);
        int l = Math.max(Math.min(last, 63), 0);
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static long highMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 127), 64) - 64;
        int l = Math.max(Math.min(last, 127), 64) - 64;
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static boolean match(char c, long lowMask, long highMask) {
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }

    private static void appendEscape(StringBuffer sb, byte b) {
        sb.append((char)b);
    }

    private static void appendEncoded(StringBuffer sb, char c) {
        sb.append(c);
    }

    private static String quote(String s, long lowMask, long highMask) {
        StringBuffer sb = null;
        boolean allowNonASCII = (lowMask & 1L) != 0L;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                if (!URI.match(c, lowMask, highMask)) {
                    if (sb == null) {
                        sb = new StringBuffer();
                        sb.append(s.substring(0, i));
                    }
                    URI.appendEscape(sb, (byte)c);
                    continue;
                }
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (allowNonASCII && (Character.isSpaceChar(c) || Character.isISOControl(c))) {
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append(s.substring(0, i));
                }
                URI.appendEncoded(sb, c);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb == null ? s : sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String uri = "#";
        System.out.println(new URI(uri));
    }

    private class Parser {
        private String input;
        private boolean requireServerAuthority = false;
        private int ipv6byteCount = 0;

        Parser(String s) {
            this.input = s;
            URI.this.string = s;
        }

        private void fail(String reason) throws URISyntaxException {
            throw new URISyntaxException(this.input, reason);
        }

        private void fail(String reason, int p) throws URISyntaxException {
            throw new URISyntaxException(this.input, reason, p);
        }

        private void failExpecting(String expected, int p) throws URISyntaxException {
            this.fail("Expected " + expected, p);
        }

        private String substring(int start, int end) {
            return this.input.substring(start, end);
        }

        private char charAt(int p) {
            return this.input.charAt(p);
        }

        private boolean at(int start, int end, char c) {
            return start < end && this.charAt(start) == c;
        }

        private boolean at(int start, int end, String s) {
            int p = start;
            int sn = s.length();
            if (sn > end - p) {
                return false;
            }
            int i = 0;
            while (i < sn && this.charAt(p++) == s.charAt(i++)) {
            }
            return i == sn;
        }

        private int scan(int start, int end, char c) {
            if (start < end && this.charAt(start) == c) {
                return start + 1;
            }
            return start;
        }

        private int scan(int start, int end, String err, String stop) {
            int p;
            for (p = start; p < end; ++p) {
                char c = this.charAt(p);
                if (err.indexOf(c) >= 0) {
                    return -1;
                }
                if (stop.indexOf(c) >= 0) break;
            }
            return p;
        }

        private int scanEscape(int start, int n, char first) throws URISyntaxException {
            int p = start;
            char c = first;
            if (c == '%') {
                if (p + 3 <= n && URI.match(this.charAt(p + 1), L_HEX, H_HEX) && URI.match(this.charAt(p + 2), L_HEX, H_HEX)) {
                    return p + 3;
                }
                if (this.charAt(p + 1) == '&') {
                    return p + 1;
                }
                this.fail("Malformed escape pair", p);
            } else if (c > '\u0080' && !Character.isSpaceChar(c) && !Character.isISOControl(c)) {
                return p + 1;
            }
            return p;
        }

        private int scan(int start, int n, long lowMask, long highMask) throws URISyntaxException {
            int p = start;
            while (p < n) {
                int q;
                char c = this.charAt(p);
                if (c == '\\' || URI.match(c, lowMask, highMask)) {
                    ++p;
                    continue;
                }
                if ((lowMask & 1L) == 0L || (q = this.scanEscape(p, n, c)) <= p) break;
                p = q;
            }
            return p;
        }

        private void checkChars(int start, int end, long lowMask, long highMask, String what) throws URISyntaxException {
            int p = this.scan(start, end, lowMask, highMask);
            if (p < end) {
                this.fail("Illegal character in " + what, p);
            }
        }

        private void checkChar(int p, long lowMask, long highMask, String what) throws URISyntaxException {
            this.checkChars(p, p + 1, lowMask, highMask, what);
        }

        void parse(boolean rsa) throws URISyntaxException {
            int ssp;
            this.requireServerAuthority = rsa;
            int n = this.input.length();
            int p = this.scan(0, n, "/?#", ":");
            if (p >= 0 && this.at(p, n, ':')) {
                if (p == 0) {
                    this.failExpecting("scheme name", 0);
                }
                this.checkChar(0, 0L, H_ALPHA, "scheme name");
                this.checkChars(1, p, L_SCHEME, H_SCHEME, "scheme name");
                URI.this.scheme = this.substring(0, p);
                ssp = ++p;
                if (this.at(p, n, '/')) {
                    p = this.parseHierarchical(p, n);
                } else {
                    int q = this.scan(p, n, "", "#");
                    if (q <= p) {
                        this.failExpecting("scheme-specific part", p);
                    }
                    this.checkChars(p, q, L_URIC, H_URIC, "opaque part");
                    p = q;
                }
            } else {
                ssp = 0;
                p = this.parseHierarchical(0, n);
            }
            URI.this.schemeSpecificPart = this.substring(ssp, p);
            if (this.at(p, n, '#')) {
                URI.this.fragment = this.substring(p + 1, n);
                p = n;
            }
            if (p < n) {
                this.fail("end of URI", p);
            }
        }

        private int parseHierarchical(int start, int n) throws URISyntaxException {
            int q;
            int p = start;
            if (this.at(p, n, '/') && this.at(p + 1, n, '/')) {
                q = this.scan(p += 2, n, "", "/?#");
                if (q > p) {
                    p = this.parseAuthority(p, q);
                } else if (q >= n) {
                    this.failExpecting("authority", p);
                }
            }
            q = this.scan(p, n, "", "?#");
            URI.this.path = this.substring(p, q);
            p = q;
            if (this.at(p, n, '?')) {
                q = this.scan(++p, n, "", "#");
                URI.this.query = this.substring(p, q);
                p = q;
            }
            return p;
        }

        private int parseAuthority(int start, int n) throws URISyntaxException {
            boolean regChars;
            int p;
            int q = p = start;
            URISyntaxException ex = null;
            boolean serverChars = this.scan(p, n, L_SERVER, H_SERVER) == n;
            boolean bl = regChars = this.scan(p, n, L_REG_NAME, H_REG_NAME) == n;
            if (regChars && !serverChars) {
                URI.this.authority = this.substring(p, n);
                return n;
            }
            if (serverChars) {
                try {
                    q = this.parseServer(p, n);
                    if (q < n) {
                        this.failExpecting("end of authority", q);
                    }
                    URI.this.authority = this.substring(p, n);
                }
                catch (URISyntaxException x) {
                    URI.this.userInfo = null;
                    URI.this.host = null;
                    URI.this.port = -1;
                    if (this.requireServerAuthority) {
                        throw x;
                    }
                    ex = x;
                    q = p;
                }
            }
            if (q < n) {
                if (regChars) {
                    URI.this.authority = this.substring(p, n);
                } else {
                    if (ex != null) {
                        throw ex;
                    }
                    this.fail("Illegal character in authority", q);
                }
            }
            return n;
        }

        private int parseServer(int start, int n) throws URISyntaxException {
            int p = start;
            int q = this.scan(p, n, "/?#", "@");
            if (q >= p && this.at(q, n, '@')) {
                this.checkChars(p, q, L_USERINFO, H_USERINFO, "user info");
                URI.this.userInfo = this.substring(p, q);
                p = q + 1;
            }
            if (this.at(p, n, '[')) {
                if ((q = this.scan(++p, n, "/?#", "]")) > p && this.at(q, n, ']')) {
                    this.parseIPv6Reference(p, q);
                    p = q + 1;
                } else {
                    this.failExpecting("closing bracket for IPv6 address", q);
                }
            } else {
                q = this.parseIPv4Address(p, n);
                if (q <= p) {
                    q = this.parseHostname(p, n);
                }
                p = q;
            }
            if (this.at(p, n, ':') && (q = this.scan(++p, n, "", "/")) > p) {
                this.checkChars(p, q, L_DIGIT, 0L, "port number");
                try {
                    URI.this.port = Integer.parseInt(this.substring(p, q));
                }
                catch (NumberFormatException x) {
                    this.fail("Malformed port number", p);
                }
                p = q;
            }
            if (p < n) {
                this.failExpecting("port number", p);
            }
            return p;
        }

        private int scanByte(int start, int n) throws URISyntaxException {
            int p = start;
            int q = this.scan(p, n, L_DIGIT, 0L);
            if (q <= p) {
                return q;
            }
            if (Integer.parseInt(this.substring(p, q)) > 255) {
                return p;
            }
            return q;
        }

        private int scanIPv4Address(int start, int n, boolean strict) throws URISyntaxException {
            int p = start;
            int m = this.scan(p, n, L_DIGIT | L_DOT, 0L | H_DOT);
            if (m <= p || strict && m != n) {
                return -1;
            }
            int q = this.scanByte(p, m);
            if (q > p && (q = this.scan(p = q, m, '.')) > p && (q = this.scanByte(p = q, m)) > p && (q = this.scan(p = q, m, '.')) > p && (q = this.scanByte(p = q, m)) > p && (q = this.scan(p = q, m, '.')) > p && (q = this.scanByte(p = q, m)) > p) {
                p = q;
                if (q >= m) {
                    return q;
                }
            }
            this.fail("Malformed IPv4 address", q);
            return -1;
        }

        private int takeIPv4Address(int start, int n, String expected) throws URISyntaxException {
            int p = this.scanIPv4Address(start, n, true);
            if (p <= start) {
                this.failExpecting(expected, start);
            }
            return p;
        }

        private int parseIPv4Address(int start, int n) throws URISyntaxException {
            int p = this.scanIPv4Address(start, n, false);
            if (p > start) {
                URI.this.host = this.substring(start, p);
            }
            return p;
        }

        private int parseHostname(int start, int n) throws URISyntaxException {
            int q;
            int p = start;
            int l = -1;
            while ((q = this.scan(p, n, L_ALPHANUM, H_ALPHANUM)) > p) {
                l = p;
                if (q > p && (q = this.scan(p = q, n, L_ALPHANUM | L_DASH, H_ALPHANUM | H_DASH)) > p) {
                    if (this.charAt(q - 1) == '-') {
                        this.fail("Illegal character in hostname", q - 1);
                    }
                    p = q;
                }
                if ((q = this.scan(p, n, '.')) > p && (p = q) < n) continue;
            }
            if (p < n && !this.at(p, n, ':')) {
                this.fail("Illegal character in hostname", p);
            }
            if (l < 0) {
                this.failExpecting("hostname", start);
            }
            if (!URI.match(this.charAt(l), 0L, H_ALPHA)) {
                this.fail("Illegal character in hostname", l);
            }
            URI.this.host = this.substring(start, p);
            return p;
        }

        private int parseIPv6Reference(int start, int n) throws URISyntaxException {
            int p = start;
            int q = this.scanHexSeq(p, n);
            if (q > p) {
                p = q;
                if (this.at(p, n, "::")) {
                    p = this.scanHexPost(p + 2, n);
                } else if (this.at(p, n, ':')) {
                    p = this.takeIPv4Address(p + 1, n, "IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else if (this.at(p, n, "::")) {
                p = this.scanHexPost(p + 2, n);
            }
            if (p < n) {
                this.fail("Malformed IPv6 address", start);
            }
            if (this.ipv6byteCount > 16) {
                this.fail("IPv6 address too long", start);
            }
            URI.this.host = this.substring(start - 1, p + 1);
            return p;
        }

        private int scanHexPost(int start, int n) throws URISyntaxException {
            int p = start;
            if (p == n) {
                return p;
            }
            int q = this.scanHexSeq(p, n);
            if (q > p) {
                p = q;
                if (this.at(p, n, ':')) {
                    ++p;
                    p = this.takeIPv4Address(p, n, "hex digits or IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else {
                p = this.takeIPv4Address(p, n, "hex digits or IPv4 address");
                this.ipv6byteCount += 4;
            }
            return p;
        }

        private int scanHexSeq(int start, int n) throws URISyntaxException {
            int p = start;
            int q = this.scan(p, n, L_HEX, H_HEX);
            if (q <= p) {
                return -1;
            }
            if (this.at(q, n, '.')) {
                return -1;
            }
            this.ipv6byteCount += 2;
            p = q;
            while (p < n && this.at(p, n, ':') && !this.at(p + 1, n, ':')) {
                if ((q = this.scan(++p, n, L_HEX, H_HEX)) <= p) {
                    this.failExpecting("digits for an IPv6 address", p);
                }
                if (this.at(q, n, '.')) {
                    --p;
                    break;
                }
                if (q > p + 4) {
                    this.fail("IPv6 hexadecimal digit sequence too long", p);
                }
                this.ipv6byteCount += 2;
                p = q;
            }
            return p;
        }
    }
}

