/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.clip;

import com.sun.portal.rewriter.util.clip.CLIPOption;
import com.sun.portal.rewriter.util.clip.CLIPParser;
import com.sun.portal.rewriter.util.clip.CLIPSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CLIPSubCommand {
    private String subCommandName;
    private List orderedOptions;
    private Map validOptions;
    private Map defaultOptionValues;
    private int minOperands;
    private int maxOperands;
    private final String operandsHelpID;
    private final String subCommandHelpID;

    public CLIPSubCommand(String aSubCommandName, CLIPOption[] aOptions, int aMinOperands, int aMaxOperands, String aOperandsHelpID, String aSubCommandHelpID) throws IllegalArgumentException {
        this.setSubCommandName(aSubCommandName);
        this.setOptions(aSubCommandName, aOptions);
        this.setMinOperands(aSubCommandName, aMinOperands);
        this.setMaxOperands(aSubCommandName, aMinOperands, aMaxOperands);
        this.subCommandHelpID = aSubCommandHelpID;
        this.operandsHelpID = aOperandsHelpID;
    }

    public String getSubCommandName() {
        return this.subCommandName;
    }

    public List getOrderedOptions() {
        return this.orderedOptions;
    }

    public Map getValidOptions() {
        return this.validOptions;
    }

    public Map getDefaultOptionValues() {
        return this.defaultOptionValues;
    }

    public int getMinOperands() {
        return this.minOperands;
    }

    public int getMaxOperands() {
        return this.maxOperands;
    }

    public String getSubCommandHelp() {
        return CLIPSpec.getLocaleHelper().getLocalizedString(this.subCommandHelpID);
    }

    public String getOperandsHelp() {
        return CLIPSpec.getLocaleHelper().getLocalizedString(this.operandsHelpID);
    }

    private void setSubCommandName(String aName) {
        if (aName != null) {
            CLIPParser.verifyName(aName, "CLIPSubCommand");
        }
        this.subCommandName = aName;
    }

    private void setOptions(String aSubCommandName, CLIPOption[] aOptions) {
        CLIPOption helpOption = new CLIPOption("help", null, 0, "false", "optionHelp");
        this.validOptions = new HashMap();
        this.orderedOptions = new ArrayList();
        this.validOptions.put(helpOption.getLongName(), helpOption);
        this.orderedOptions.add(helpOption);
        if (aOptions != null) {
            for (int i = 0; i < aOptions.length; ++i) {
                if (aOptions[i] == null) {
                    throw new IllegalArgumentException("CLIPSubCommand: " + aSubCommandName + "', option instances can not be NULL");
                }
                if (this.validOptions.containsKey(aOptions[i].getLongName())) {
                    throw new IllegalArgumentException("CLIPSubCommand: " + aSubCommandName + "', option long names can not be duplicated within a CLIPParser instance");
                }
                this.validOptions.put(aOptions[i].getLongName(), aOptions[i]);
                this.orderedOptions.add(aOptions[i]);
                if (aOptions[i].getShortName() == null) continue;
                if (this.validOptions.containsKey(aOptions[i].getShortName())) {
                    throw new IllegalArgumentException("CLIPSubCommand: " + aSubCommandName + "', option short names can not be duplicated within a CLIPParser instance");
                }
                this.validOptions.put(aOptions[i].getShortName(), aOptions[i]);
            }
        }
        this.setDefaultOptionValues(aOptions);
    }

    private void setDefaultOptionValues(CLIPOption[] aOptions) {
        this.defaultOptionValues = new HashMap();
        if (aOptions != null) {
            for (int i = 0; i < aOptions.length; ++i) {
                String[] defaultValues = aOptions[i].getDefaultValues();
                if (defaultValues == null) continue;
                ArrayList<String> l = new ArrayList<String>();
                for (int j = 0; j < defaultValues.length; ++j) {
                    l.add(defaultValues[j]);
                }
                this.defaultOptionValues.put(aOptions[i].getLongName(), l);
            }
        }
    }

    private void setMinOperands(String aSubCommandName, int aMinOperands) {
        if (aMinOperands < 0) {
            throw new IllegalArgumentException("CLIPSubCommand: " + aSubCommandName + "', minimum number of operands can not be less than zero");
        }
        this.minOperands = aMinOperands;
    }

    private void setMaxOperands(String aSubCommandName, int aMinOperands, int aMaxOperands) {
        if (aMinOperands > aMaxOperands) {
            throw new IllegalArgumentException("CLIPSubCommand: " + aSubCommandName + "', maximum number of operands can not be less than minimum number of operands");
        }
        this.maxOperands = aMaxOperands;
    }

    public String toString() {
        return "\nSubCommandName: " + this.subCommandName + "\n" + "OrderedOptions: " + this.orderedOptions + "\n" + "Valid Options: " + this.validOptions + "\n" + "Default Option Values: " + this.defaultOptionValues + "\n" + "Min Operands: " + this.minOperands + "\n" + "Max Operands: " + this.maxOperands + "\n" + "Sub Command Help: " + this.getSubCommandHelp() + "\n" + "Operands Help: " + this.getOperandsHelp() + "\n";
    }
}

