/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.services.idsame;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.portal.rewriter.services.DataService;
import com.sun.portal.rewriter.services.DataServiceException;
import com.sun.portal.rewriter.services.DataServiceHelper;
import com.sun.portal.rewriter.services.idsame.IDSAMEEventListenerImpl;
import com.sun.portal.rewriter.util.StringHelper;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.Set;

public final class IDSAMEDataService
implements DataService {
    private static final IDSAMEEventListenerImpl registar = new IDSAMEEventListenerImpl();
    private static final String SERVICE_NAME = "SunPortalRewriterService";
    private static final String SERVICE_SCHEMA_NAME = "SunPortalRewriterGlobal";
    private static final String ATTRIBUTE_NAME = "sunPortalRewriterRuleset";
    private static final String SUBCONFIG_ID = "SunPortalRewriterRuleSets";
    private final ServiceConfig config;
    private ServiceConfigManager configManager;
    static /* synthetic */ Class class$com$sun$portal$rewriter$services$idsame$IDSAMELogHandler;

    public IDSAMEDataService(Properties aProps) throws DataServiceException {
        this(IDSAMEDataService.createSSOToken(aProps));
    }

    public IDSAMEDataService(SSOToken aSSOToken) throws DataServiceException {
        this.config = this.getConfig(aSSOToken);
    }

    public String deleteKey(String aRuleSetIDKey) throws DataServiceException {
        IDSAMEDataService.checkRuleSetIDKeyInput(aRuleSetIDKey);
        String lMatchedRuleSetID = StringHelper.findMatchByIgnoringCase(this.retrieveKeys(), aRuleSetIDKey);
        String result = this.optimisticDeleteKey(lMatchedRuleSetID);
        return result;
    }

    public String retrieveXML(String aRuleSetIDKey) throws DataServiceException {
        IDSAMEDataService.checkRuleSetIDKeyInput(aRuleSetIDKey);
        return this.optimisticRetrieveXML(aRuleSetIDKey.toLowerCase());
    }

    public String storeXML(String aRuleSetIDKey, String aXMLRuleSet) throws DataServiceException {
        try {
            IDSAMEDataService.checkRuleSetIDKeyInput(aRuleSetIDKey);
            IDSAMEDataService.checkRuleSetInput(aXMLRuleSet);
            String oldXML = this.optimisticDeleteKey(aRuleSetIDKey);
            this.config.addSubConfig(aRuleSetIDKey.toLowerCase(), SUBCONFIG_ID, 0, IDSAMEDataService.prepareAttributeValue(aXMLRuleSet));
            return oldXML;
        }
        catch (Exception e) {
            throw new DataServiceException(e.getMessage(), e);
        }
    }

    public Set retrieveKeys() throws DataServiceException {
        try {
            return Collections.unmodifiableSet(this.config.getSubConfigNames());
        }
        catch (SMSException smse) {
            throw new DataServiceException(smse.getMessage(), smse);
        }
    }

    private static Map prepareAttributeValue(String aXMLRuleSet) {
        HashSet<String> set = new HashSet<String>(1);
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>(1);
        set.add(aXMLRuleSet);
        map.put(ATTRIBUTE_NAME, set);
        return map;
    }

    private String optimisticDeleteKey(String aRuleSetIDKey) throws DataServiceException {
        try {
            String oldXML = null;
            if (this.matchesWithID(aRuleSetIDKey) != null) {
                oldXML = this.optimisticRetrieveXML(aRuleSetIDKey);
                this.config.removeSubConfig(aRuleSetIDKey);
            }
            return oldXML;
        }
        catch (SMSException smse) {
            throw new DataServiceException(smse.getMessage(), smse);
        }
        catch (SSOException ssoe) {
            throw new DataServiceException(ssoe.getMessage(), ssoe);
        }
    }

    private String optimisticRetrieveXML(String aRuleSetIDKey) throws DataServiceException {
        try {
            ServiceConfig subConfig = this.config.getSubConfig(aRuleSetIDKey);
            if (null == subConfig) {
                return null;
            }
            Map attributes = subConfig.getAttributes();
            Set values = (Set)attributes.get(ATTRIBUTE_NAME);
            Iterator itr = values.iterator();
            return (String)itr.next();
        }
        catch (SMSException smse) {
            throw new DataServiceException(smse.getMessage(), smse);
        }
        catch (SSOException ssoe) {
            throw new DataServiceException(ssoe.getMessage(), ssoe);
        }
    }

    public String matchesWithID(String aRuleSetIDKey) throws DataServiceException {
        String match = StringHelper.findMatchByIgnoringCase(this.retrieveKeys(), aRuleSetIDKey);
        return match;
    }

    private ServiceConfig getConfig(SSOToken token) throws DataServiceException {
        try {
            this.configManager = new ServiceConfigManager(SERVICE_NAME, token);
            IDSAMEDataService.registerForIDSMAEEvents(this.configManager);
            ServiceConfig globalConfig = this.configManager.getGlobalConfig(null);
            return globalConfig.getSubConfig(SERVICE_SCHEMA_NAME);
        }
        catch (SSOException te) {
            throw new DataServiceException("Not able to get ServiceConfigManager - ", te);
        }
        catch (SMSException smse) {
            throw new DataServiceException(smse.getMessage(), smse);
        }
    }

    public Observable getChangeNotifier() {
        return registar;
    }

    private static void registerForIDSMAEEvents(ServiceConfigManager aConfigManager) {
        aConfigManager.addListener((ServiceListener)registar);
    }

    private static void checkRuleSetIDKeyInput(String aRuleSetIDKey) {
        if (null == aRuleSetIDKey || 0 == aRuleSetIDKey.trim().length()) {
            throw new IllegalArgumentException("aRuleSetIDKey cannot be null or empty");
        }
    }

    private static void checkRuleSetInput(String aXMLRuleSet) {
        if (null == aXMLRuleSet || 0 == aXMLRuleSet.trim().length()) {
            throw new IllegalArgumentException("aXMLRuleSet cannot be nullor empty");
        }
    }

    private static SSOToken createSSOToken(Properties aProps) throws DataServiceException {
        final String lBindDN = aProps.getProperty("USER_NAME", "");
        String lPassword = aProps.getProperty("PASSWORD", "");
        try {
            return SSOTokenManager.getInstance().createSSOToken(new Principal(){

                public String getName() {
                    return lBindDN;
                }
            }, lPassword);
        }
        catch (Exception e) {
            throw new DataServiceException(e.getMessage(), e, 5001);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DataServiceHelper.initLogSystem(class$com$sun$portal$rewriter$services$idsame$IDSAMELogHandler == null ? (class$com$sun$portal$rewriter$services$idsame$IDSAMELogHandler = IDSAMEDataService.class$("com.sun.portal.rewriter.services.idsame.IDSAMELogHandler")) : class$com$sun$portal$rewriter$services$idsame$IDSAMELogHandler);
    }
}

