/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.services.ids;

import com.sun.portal.rewriter.rom.DataRule;
import com.sun.portal.rewriter.rom.DataRuleCollection;
import com.sun.portal.rewriter.rom.common.Attribute;
import com.sun.portal.rewriter.rom.common.AttributeRule;
import com.sun.portal.rewriter.rom.common.TagTextRule;
import com.sun.portal.rewriter.rom.html.AppletRule;
import com.sun.portal.rewriter.rom.html.FormRule;
import com.sun.portal.rewriter.rom.js.FunctionRule;
import com.sun.portal.rewriter.rom.js.Variable;
import com.sun.portal.rewriter.rom.js.VariableRule;
import com.sun.portal.rewriter.services.ids.DataSource;
import com.sun.portal.rewriter.services.ids.IDSRuleBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class IDSRuleCollectionBuilder {
    IDSRuleCollectionBuilder() {
    }

    static DataRuleCollection getHTMLAppletRuleCollection(DataSource aDataSource) {
        String[] appletStrings = aDataSource.getHTMLAppletData();
        ArrayList<AppletRule> list = new ArrayList<AppletRule>(appletStrings.length);
        for (int i = 0; i < appletStrings.length; ++i) {
            AppletRule applet = IDSRuleBuilder.buildAppletRule(appletStrings[i]);
            list.add(applet);
        }
        DataRule[] appletRules = list.toArray(new DataRule[0]);
        return new DataRuleCollection("Applet", appletRules);
    }

    static DataRuleCollection getHTMLFormRuleCollection(DataSource aDataSource) {
        String[] formStrings = aDataSource.getHTMLFormData();
        ArrayList<FormRule> list = new ArrayList<FormRule>(formStrings.length);
        for (int i = 0; i < formStrings.length; ++i) {
            FormRule formRule = IDSRuleBuilder.buildFormRule(formStrings[i]);
            list.add(formRule);
        }
        DataRule[] formRules = list.toArray(new DataRule[0]);
        return new DataRuleCollection("Form", formRules);
    }

    static DataRuleCollection getHTMLAttributeRuleCollection(DataSource aDataSource) {
        String[] attrStrings = aDataSource.getHTMLAttributeData();
        ArrayList<AttributeRule> list = new ArrayList<AttributeRule>(attrStrings.length);
        for (int i = 0; i < attrStrings.length; ++i) {
            AttributeRule attr = IDSRuleBuilder.buildAttributeRule(attrStrings[i]);
            list.add(attr);
        }
        list.addAll(IDSRuleCollectionBuilder.getHTMLJSTokenRules(aDataSource));
        DataRule[] attrRules = list.toArray(new DataRule[0]);
        return new DataRuleCollection("Attribute", attrRules);
    }

    private static List getHTMLJSTokenRules(DataSource aDataSource) {
        String[] jsTokens = aDataSource.getHTMLJSTokenData();
        ArrayList<AttributeRule> lList = new ArrayList<AttributeRule>();
        for (int i = 0; i < jsTokens.length; ++i) {
            lList.add(new AttributeRule(new Attribute(jsTokens[i], null, null, "DJS", null)));
        }
        return lList;
    }

    static DataRuleCollection getJSVariableRuleCollection(DataSource aDataSource) {
        ArrayList<DataRule> allVariables = new ArrayList<DataRule>();
        List<DataRule> urlDataRules = Arrays.asList(IDSRuleCollectionBuilder.buildVariables(aDataSource.getJSURLVariablesData(), "URL"));
        allVariables.addAll(urlDataRules);
        List<DataRule> expressionDataRules = Arrays.asList(IDSRuleCollectionBuilder.buildVariables(aDataSource.getJSExpressionVariablesData(), "EXPRESSION"));
        allVariables.addAll(expressionDataRules);
        List<DataRule> dhtmlDataRules = Arrays.asList(IDSRuleCollectionBuilder.buildVariables(aDataSource.getJSDHTMLVariablesData(), "DHTML"));
        allVariables.addAll(dhtmlDataRules);
        List<DataRule> djsDataRules = Arrays.asList(IDSRuleCollectionBuilder.buildVariables(aDataSource.getJSDJSVariablesData(), "DJS"));
        allVariables.addAll(djsDataRules);
        List<DataRule> systemDataRules = Arrays.asList(IDSRuleCollectionBuilder.buildVariables(aDataSource.getJSSystemVariablesData(), "SYSTEM"));
        allVariables.addAll(systemDataRules);
        DataRule[] allRules = allVariables.toArray(new DataRule[0]);
        return new DataRuleCollection("Variable", allRules);
    }

    static DataRuleCollection getJSFunctionRuleCollection(DataSource aDataSource) {
        ArrayList<DataRule> allFunctions = new ArrayList<DataRule>();
        List<DataRule> urlDataRules = Arrays.asList(IDSRuleCollectionBuilder.buildFunctions(aDataSource.getJSURLFunctionData(), "URL"));
        allFunctions.addAll(urlDataRules);
        List<DataRule> expressionDataRules = Arrays.asList(IDSRuleCollectionBuilder.buildFunctions(aDataSource.getJSExpressionFunctionData(), "EXPRESSION"));
        allFunctions.addAll(expressionDataRules);
        List<DataRule> dhtmlDataRules = Arrays.asList(IDSRuleCollectionBuilder.buildFunctions(aDataSource.getJSDHTMLFunctionData(), "DHTML"));
        allFunctions.addAll(dhtmlDataRules);
        List<DataRule> djsDataRules = Arrays.asList(IDSRuleCollectionBuilder.buildFunctions(aDataSource.getJSDJSFunctionData(), "DJS"));
        allFunctions.addAll(djsDataRules);
        DataRule[] allRules = allFunctions.toArray(new DataRule[0]);
        return new DataRuleCollection("Function", allRules);
    }

    private static DataRule[] buildVariables(String[] variables, String type) {
        ArrayList<VariableRule> list = new ArrayList<VariableRule>(variables.length);
        for (int i = 0; i < variables.length; ++i) {
            VariableRule dataRule = new VariableRule(new Variable(variables[i], type, null));
            list.add(dataRule);
        }
        return list.toArray(new DataRule[0]);
    }

    private static DataRule[] buildFunctions(String[] variables, String type) {
        ArrayList<FunctionRule> list = new ArrayList<FunctionRule>(variables.length);
        for (int i = 0; i < variables.length; ++i) {
            FunctionRule dataRule = IDSRuleBuilder.buildFunctionRule(variables[i], type);
            list.add(dataRule);
        }
        return list.toArray(new DataRule[0]);
    }

    static DataRuleCollection getXMLAttributeRuleCollection(DataSource aDataSource) {
        int length = 0;
        String[] xmlAttrs = aDataSource.getXMLAttributeData();
        if (xmlAttrs != null) {
            length = xmlAttrs.length;
        }
        ArrayList<AttributeRule> list = new ArrayList<AttributeRule>(length);
        for (int i = 0; i < length; ++i) {
            AttributeRule xAttr = IDSRuleBuilder.buildAttributeRule(xmlAttrs[i]);
            list.add(xAttr);
        }
        DataRule[] dataRules = list.toArray(new DataRule[0]);
        return new DataRuleCollection("Attribute", dataRules);
    }

    static DataRuleCollection getXMLTagTextRuleCollection(DataSource aDataSource) {
        int length = 0;
        String[] xmlTS = aDataSource.getXMLTagTextData();
        if (xmlTS != null) {
            length = xmlTS.length;
        }
        ArrayList<TagTextRule> list = new ArrayList<TagTextRule>(length);
        for (int i = 0; i < length; ++i) {
            TagTextRule xTS = IDSRuleBuilder.buildTagTextRule(xmlTS[i]);
            list.add(xTS);
        }
        DataRule[] dataRules = list.toArray(new DataRule[0]);
        return new DataRuleCollection("TagText", dataRules);
    }
}

