/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom;

import com.sun.portal.rewriter.rom.Data;
import com.sun.portal.rewriter.rom.Rule;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rewriter.util.re.RegExp;

public abstract class DataRule
implements Rule {
    public static final DataRule[] EMPTY_DATA_RULE_ARRAY = new DataRule[0];
    private final Data data;
    private final Pattern[] sourceSpec;

    protected DataRule(Data aData) {
        this.data = aData;
        this.sourceSpec = DataRule.createAttributeSpec(this.data.getSource(), true);
    }

    public final String getCollectionID() {
        return this.data.getCollectionID();
    }

    public final Data getData() {
        return this.data;
    }

    public final String toXML() {
        return this.data.toXML();
    }

    public final boolean matches(Data aMache) {
        if (aMache != null && this.plugableMatch(aMache)) {
            return DataRule.match(this.sourceSpec, aMache.getSource());
        }
        return false;
    }

    protected abstract boolean plugableMatch(Data var1);

    public abstract boolean isValid();

    protected static Pattern[] createAttributeSpec(String aRule) {
        return DataRule.createAttributeSpec(aRule, false);
    }

    protected static Pattern[] createAttributeSpec(String aRule, boolean aIgnoreCase) {
        return Pattern.convert2Patterns(RegExp.splitElements(aRule, ";"), aIgnoreCase);
    }

    public static final Pattern[] createValuePatternSpec(String aData) {
        return Pattern.convert2Patterns(RegExp.parsePatterns(aData, ";", "**"));
    }

    protected static final boolean doBasicValidation(String[] valueList) {
        int i;
        int len = 0;
        for (i = valueList.length - 1; i >= 0 && (len = valueList[i].length()) <= 0; --i) {
        }
        if (len <= 0) {
            return false;
        }
        for (i = valueList.length - 1; i >= 0; --i) {
            if (valueList[i].equals("*")) continue;
            return true;
        }
        return false;
    }

    protected static final boolean match(Pattern[] aRules, String aValue) {
        return RegExp.match(aRules, aValue);
    }

    protected static final boolean match(Pattern aRule, String aValue) {
        return RegExp.match(aRule, aValue);
    }
}

