/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util;

import com.aligo.pim.PimTimeZoneType;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimTimeZoneGMTTypeMapper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class WebDavDate {
    private Date m_oDate;
    private String m_szFormattedDate;
    private ExWebDavPimSession m_oPimSession;

    public WebDavDate(Date date, ExWebDavPimSession pimSession) {
        this.m_oDate = date;
        this.m_oPimSession = pimSession;
    }

    public WebDavDate(String formattedString, boolean isItRecurringFormat, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        try {
            this.m_oPimSession = pimSession;
            this.m_szFormattedDate = formattedString;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            sdf.setTimeZone(timeZone);
            this.m_oDate = sdf.parse(this.m_szFormattedDate);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public WebDavDate(String formattedString, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        try {
            this.m_oPimSession = pimSession;
            this.m_szFormattedDate = formattedString;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            sdf.setTimeZone(timeZone);
            this.m_oDate = sdf.parse(this.m_szFormattedDate);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getDate() {
        return this.m_oDate;
    }

    public int getIntegerMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.m_oDate);
        return cal.get(2) + 1;
    }

    public int getIntegerDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.m_oDate);
        return cal.get(5);
    }

    public void resetToNextDay() {
        PimTimeZoneType pimTimeZoneType = this.m_oPimSession.getTimeZone();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(ExWebDavPimTimeZoneGMTTypeMapper.getType(pimTimeZoneType)));
        cal.setTime(this.m_oDate);
        cal.set(cal.get(1), cal.get(2), cal.get(5) + 1, 0, 0, 0);
        this.m_oDate = cal.getTime();
    }

    public void resetToThisDay() {
        PimTimeZoneType pimTimeZoneType = this.m_oPimSession.getTimeZone();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(ExWebDavPimTimeZoneGMTTypeMapper.getType(pimTimeZoneType)));
        cal.setTime(this.m_oDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        this.m_oDate = cal.getTime();
    }

    public String getFormattedDateForRecurrence() {
        if (this.m_szFormattedDate == null && this.m_oDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            sdf.setTimeZone(timeZone);
            this.m_szFormattedDate = sdf.format(this.m_oDate);
        }
        return this.m_szFormattedDate;
    }

    public String getFormattedDate() {
        if (this.m_szFormattedDate == null && this.m_oDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            sdf.setTimeZone(timeZone);
            this.m_szFormattedDate = sdf.format(this.m_oDate);
        }
        return this.m_szFormattedDate;
    }

    public boolean equals(WebDavDate date) {
        int result;
        Date toCompare;
        return this.m_oDate != null && date != null && (toCompare = date.getDate()) != null && (result = toCompare.compareTo(this.m_oDate)) == 0;
    }

    public boolean after(WebDavDate date) {
        Date toCompare;
        if (this.m_oDate != null && date != null && (toCompare = date.getDate()) != null) {
            return this.m_oDate.after(toCompare);
        }
        return false;
    }
}

