#!/usr/bin/perl

################################################################################
# 
# Sample Script used to transmit events from StorADE to a different management
# application.
# The name of this script need to be added to the StorADE configuration
# in Administration -> General Maintenance -> Email/Script.
# This function allows to run a script along with each event sent in an email.
# This script is executed for each new event and receives the following
# arguments:
# 
#   -C [category]    : the category of the event (t3|a5k ..)
#   -G [event_code]  : The Event Code (three numbers).
#   -S [severity]    : the severity of the event (1=warning,2=error,3=down)
#   -A [Actionable]  : Actionable event (TRUE | FALSE)
#   -E [event_type]  : Event Type
#   -T [target]      : The target of event (Ex: 'switch:1000023EA348A')
#   -N [TargetName]  : The name of the target (Ex: 'switch-1a')
#   -I [IPno]        : IPnumber of device if available.
#   -D [description] : The description of the event.
# 
# Note: This script must be able to run from a cron environment.
#       IE: Use full paths for commands.
# 
# 
# <b>Complete example , with the script '/usr/local/bin/test':</b>
# 
# /opt/SUNWstade/sbin/sample_script.pl -C "t3" -S "2" -E "communicationLostEvent" \
#      -T "switch:10000023EA348A" -N "sw1a" \
#      -G " 21.26.37" \
#      -A "TRUE" \
#      -D "Lost communication (out of band) with switch swa1"
#      -I "[ipno]"
# 
# 
################################################################################# 



use Getopt::Std;


getopts("C:G:S:A:E:T:N:I:D:", \%opts);


$EventCategory = $opts{C};
$EventCode     = $opts{G};
$Severity      = $opts{S};  # 0=notice,1=warning,2=error,3=down
$Actionable    = $opts{A};
$EventType     = $opts{E};
$DeviceKey     = $opts{T};
$DeviceName    = $opts{N};
$DeviceIP      = $opts{I};
$EventDesc     = $opts{D};

# This information can now be used to call other cli commands 

$command = "cli_command $EventDesc";
system($command);


# Or it can just be logged into a file.

$today  = `date`;
open(W, ">/tmp/EventLog");
print W <<EOF;

Date       : $today
EventCode  : $EventCode
Severity   : $Severity
Description
$EventDesc
----------------------------------------------------------------------------
EOF
close(W);



