package Trap::SAMFS;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Name:  $ 
#  $Id: SAMFS.pm,v 1.10 2004/06/18 22:34:55 bkeslin Exp $

use strict qw(vars);
use State;
use PDM::Parse;
use Report;
use Policies;
use Trap;


sub REGISTER {
   return ['.1.3.6.1.4.1.42.2.28.21.1'];
}

use vars qw(@SAM_SEV  %SAM_MAP);

# This line is unused but, but here in case we revert back to using snmptrapd where we
# dont specify a MIB.
#@SAM_SEV = ('Unusable','Alert','Critical','Error','Warning', 'Notice', 'Information');

%SAM_MAP = ('2.1.1' => 'trap_type',
            '2.1.2' => 'severity',
            '2.1.5' => 'systemID',
            '2.1.3' => 'msg',
            '2.1.6' => 'date',
            '2.2.9' => 'details',
           );


sub RUN {
 Debug->print3("->>>Running SAMFS Trap Agent");
  my($trap_agent, $lines, $errors) = @_;

  my $renv   = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  my(%DEV, $x);
  my $policies = Policies->new("samfs_policies");

  my $devs = $Config->devices();
  foreach my $d (@$devs) {
     $DEV{$d->{ipno}} = $d;
  }

  for ($x = 0; $x <= $#$lines; $x++ ) {
     my $line = Trap->last_snmp($lines->[$x], 3);
     my $sev  = $line->{'2.1.2'};
     my $topic= $line->{'2.1.1'};
     my $id   = $line->{'2.1.5'};
     my $desc1 = $line->{'2.1.3'};
     $desc1 =~ s/\\\"//g; 
     my $ip   = $line->{IP};
     my $dev_name=$DEV{$ip}{name};
     my $key  = $DEV{$ip}{key};
     my ($desc2, $devvendor, $devmodel, $devpath, $loglines);

     if ($line->{"9.1.7"}) {
       $desc2 = $line->{"9.1.7"};
       $devpath = $line->{"9.1.2"};
       $devvendor = $line->{"9.1.4"};
       $devmodel = $line->{"9.1.5"};
       $loglines = ["$line->{DATE} $line->{TIME} $line->{DEVICE} $ip Sev:$sev Type:$topic SystemID:$id Description: $desc1 $desc2 Device Data: $devvendor $devmodel $devpath"];
     } else {
       $loglines = ["$line->{DATE} $line->{TIME} $line->{DEVICE} $ip Sev:$sev Type:$topic SystemID:$id Description: $desc1"];
     }

     my $y = 0;
     my $key = "samfs:$key:$topic";
     my $key0= "samfs:$key";
     $policies->run($errors, 
                    $loglines, \$y, 
                    $topic,
                    $dev_name, 
                    $key, 
                    $ip,
                    $key0, 
                    1);
  }
}

1;
