package Trap::5210;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Name:  $ 
#  $Id: 5210.pm,v 1.5 2004/08/16 21:51:30 kdesai Exp $

use strict qw(vars);
use State;
use PDM::Parse;
use Report;
use Policies;
use Trap;
use Labels;



sub REGISTER {
   #return ['enterprises.42.2.28.13.3.14.1'];
   return ['.1.3.6.1.4.1.42.2.28.13.3.14.1'];
}

sub RUN {
  my($trap_agent, $lines, $errors) = @_;

  my $LB = Labels->read("Trap::5210");

  my $renv   = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  my(%DEV, $x);
  my $policies = Policies->new("5210_policies");

  my $devs = $Config->devices();
  foreach my $d (@$devs) {
     $DEV{$d->{ipno}} = $d;
  }

  for ($x = 0; $x <= $#$lines; $x++ ) {
     my $line = Trap->last_snmp($lines->[$x], 3);
     #my $fulltrapID = $line->{'snmpTrap.snmpTrapOID.0'};
     my $fulltrapID = $line->{'4.1.0'};
     my $ix = rindex($fulltrapID,".");
     my $trapID = substr($fulltrapID,$ix+1);

     my $severity = "severity_".$trapID;
     my $topicAttributeName = "topicAttributeName_".$trapID;
     my $description = "descr_".$trapID;
     my $sev  = $LB->{"$severity"};
     my $alltopic= $LB->{"$topicAttributeName"};
     my $traptype = "trapType_".$trapID;
     my $trptype= $LB->{"$traptype"};

     my(@ary_topics) = split(/\,/, $alltopic);
     my $topic = $ary_topics[0]; 

     my $id   = $line->{IP};
#     my $desc = $LB->{"$description"};
     my $ip   = $line->{IP};
     my $dev_name=$DEV{$ip}{name};
     my $key  = $DEV{$ip}{key};
  
     my $i = 0;
     my @data;
     my $numberofdatalines = 0;
     $numberofdatalines = $#ary_topics;
     my $dataline = Trap->last_snmp($lines->[$x], 50); # 50 is useless
     my ($key1, $value);

     while (($key1, $value) = each %$dataline) {

        if ( ($i <= $numberofdatalines) && ($key1 =~ /.1.3.6.1.4.1.42.2.28.13.3.14.1/) ) { 
          #$data .= "$ary_topics[$i] = $value"; 
	  
	  $data[$i] = $value;
	  $i++;
	}
     }

     my $desc = $LB->expand("$description", @data);

     my $loglines = ["$line->{DATE} $line->{TIME} $line->{DEVICE} $ip Sev:$sev Type:$topic TrapType:$trptype SystemID:$id Description: $desc"];

     my $y = 0;
     my $key = "5210:$key:$topic";
     my $key0= "5210:$key";
     $policies->run($errors, 
                    $loglines, \$y, 
                    $topic,
                    $dev_name, 
                    $key, 
                    $ip,
                    $key0, 
                    1);
  }
}

1;
