package Timelapse;
use RasDB;

#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Timelapse.pm,v 1.10 2004/04/12 16:57:12 ccadieux Exp $


use vars qw ($DB);

%DATA = ();

#  module value is now type:key

sub startDev {
  my($o, $dev) = @_;
  $o->start("$dev->{type}:$dev->{key}");
}

sub stopDev {
  my($o, $dev) = @_;
  $o->stop("$dev->{type}:$dev->{key}", $dev->{name}, $dev->{ipno});
}


sub start {
  my($o, $module) = @_;
  
  $DATA{$module}[0] = time;
  $DATA{$module}[1] = 1;
}

sub stop {
  my($o, $module, $name, $ipno) = @_;
  

  $DB    = RasDB->new("TIMELAPSE");
  return if (!$DB);

  my $h  = $DB->hash();

  if ($DATA{$module}[1] == 1) {
    $DB->Lock();
    my $el = $h->{$module} || {};
    my $time = time - $DATA{$module}[0];
    $el->{count}++;
    $el->{duration}         += $time;
    $el->{name}             = $name;
    $el->{ipno}             = $ipno;
    $el->{last_run_duration} = $time;
    if ($time >= $el->{max_run_duration}) {
       $el->{max_run_duration}  = $time ;
       $el->{max_run_date}      = Util->get_today();
    }
    $el->{last_run_date}     = Util->get_today();
    $h->{$module}            = $el;
    $DB->UnLock();
  }
}



sub serialize {
  my($class) = @_;

  open(OO, ">" . System->get_home() . "/DATA/timelapse.data");
  $DB    = RasDB->new("TIMELAPSE");
  return if (!$DB);

  my $h  = $DB->hash();
  $DB->Lock();
  require Data::Dumper;
  print OO Data::Dumper::Dumper($h);
  $DB->UnLock();
  close(OO);
}

sub clear {
  my($class, $host) = @_;
  require Util::Http;

  if (!$host) {
    unlink System->get_home() . "/DATA/timelapse.data";
    unlink System->get_home() . "/DATA/TIMELAPSE.db";
  } else {
    Util::Http->deleteFile($host, "timelapse.data", 20);
    Util::Http->deleteFile($host, "TIMELAPSE.db", 20);
  }
}

sub readAll {
  my($o,$host) = @_;
  my($F, $out, $VAR1);
  require Util::Http;

  if (!$host) {
    $F = System->get_home() . "/DATA/timelapse.data";
    open(O,$F);
    my @a = <O>; close(O);
    eval "@a";
    return $VAR1;
  } else {
     my $data = Util::Http->readFile($host, "timelapse.data", 15);
     eval $data;
     return $VAR1;
  }
}





1;
