package Tasks;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use System;
use strict;

# $VAR1 = bless( { 
#             'info' => {
#                    'name' => 'Expert',
#                    'sectionName' => 'EXPERT'
#                       },
#             'no' => {
#                      'e' => 1,
#                      'v' => 2
#                     },
#             'opts' => [
#                    undef,
#                    {
#                     'name' => 'Stress Mode',
#                     'type' => 'checkbox',
#                     'size' => undef,
#                      'opt' => '-e'
#                    },
#                    {
#                     'name' => 'Verbose Mode',
#                     'type' => 'checkbox',
#                     'size' => undef,
#                      'opt' => '-v'
#                    }
#                    ]
#               }, 'AF_Command' );
# 
#  returns a list of test objects that can be done on a certain type/component
#  $comp used for storage, $register for host
#  each test object represent a kind of test.
#  if comp='e', all tests are returned
#  if a test is oob, it's always returned
#  StorTools Specific commands (must start with ST_)
#
sub ST_getTestList {
  my($class, $af, $type, $node, $comp) = @_;
  my(@L, $ports, $hp);
  my $renv = System->get_renv();

  if ($type eq "host") {
     $ports = $node->portInfo();
     $hp = $ports->[substr($comp,1)];
  }

  foreach my $com ($af->commandList()) {
     my $c = $af->commandByName($com);
     my $info = $c->info();
     next if ($info->{devType} ne $type);
     if (index(",sp,host,", ",$type,") >= 0) {
       if ($comp eq "e" ||
           ($info->{fruType} eq
             substr($hp->{RegisterName},0,length($info->{fruType})) )) {
          push(@L, $c);
       }

     } else {
       if ($comp eq "e" || ($info->{node} && substr($info->{node},0,1) eq substr($comp,0,1)) ) {
          push(@L, $c);
       }
     }
  }
  return \@L;
}

#
#  define options for a command
#  change -o dev=.. into -o "dev=..."
#  
#
sub ST_options {
  my($class, $opt1, $opt2) = @_;
  if($opt1 !~ /\-o/){ #if no -o don't do crap
    return $opt1;
  }
  if (!$opt2) {
    if ($opt1 =~ /dev\=/) {
      $opt1 =~ s/dev\=/\"dev=/;
      return "$opt1\"";
    } else {
      return $opt1;
    }
  }
  my $o1;
  $o1 = $opt1;
  $opt1 =~ /\-o (.*)/;
  if ($1) {
    $o1 =~ s/\-o /-o \"dev=$opt2|/;
  } else{
    $o1 =~ s/\-o /-o \"dev=$opt2/;
  }
  return "$o1\"";
}

#
# find the stortools command
#
sub ST_command {
  my($class, $command) = @_;

  my $command1;

  $command1 = System->get_home() . "/Diags/bin/" . $command;

  if (System->bitMode() eq "64") {
    my $c = System->get_home() . "/Diags/bin/sparcv9/$command";
    $command1 = $c if (-x $c);
  }

  return $command1;
}


1;
