package TO::SVE2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::Node';
use strict;
use TO;
sub leaf { 1 }

sub id {
  my($node) = @_;
  return $node->name() . "/" . $node->{info}{sw_ipAddr};
}
  

sub newFromDev {
  my($class, $Topo, $host, $dev, $exist) = @_;
  my($x);
  my $type  = $class->type();
  my $name  = "$type:$dev->{key}";
  my $new = 0;

  my($switches) = $Topo->[1];
  my($syns)     = $Topo->[4];
  my $renv      = System->get_renv();

  if (!defined($switches->{$name})) {
     $new= 1;
     my($obj) = {};
     $obj->{info}{name}    = $name;
     $obj->{info}{type}    = $type;
     $obj->{info}{BoxName} = $dev->{name};
     $obj->{info}{mgmtLevel} = $dev->{mgmtLevel} || "D";
     $obj->{info}{class}   = "switch.$type";
     $obj->{info}{sw_WWN}  = $dev->{wwn};
     $obj->{info}{sw_ipAddr} = $dev->{ipno};

     $obj->{port} = [];

     require Agent::SVE2;
     my $report = {};
     my $err = Agent::SVE2->getLinks($dev, $report);
     if ($report) {
       my ($x);
       for ($x=0; $x <= $report->{"info.port_cnt"}; $x++) {
            #my $wwn = $report->{"port.$x.LocalPortWWN"};
            my $wwn = $report->{"port.$x.WWN"};
            $syns->{$wwn} = "$name:$x";
            $obj->{port}[$x] = undef;
            $obj->{portInfo}[$x] = { 
                       PortWWN => $report->{"port.$x.PortWWN"},
                         State => $report->{"port.$x.disk_state"},
                          Proc => $report->{"port.$x.disk_proc"},
                          Path => $report->{"port.$x.disk_path"},
                  LocalPortWWN => $wwn,
                                     };
       }
     }
     $obj->{info}{ProductID} = uc($type);
     $obj->{info}{host}      = $host;
     $obj->{info}{host_type} = "oob";

     bless($obj, 'TO::' . uc($type));
     $syns->{$dev->{wwn}} = $name;
     $switches->{$name}  = $obj;
  }
  return ($new ,$switches->{$name});
}

sub addFromConfig {
  my($class, $topo, $Config) = @_;

  my $devs = $Config->myDevices();
  my $renv = $Config->renv();

  foreach my $dev (@$devs) {
     next if ($dev->{type} ne $class->type());
     next if (!$dev->isMineToMonitor());
     my $k = $dev->{type} . ":" . $dev->key();
     my $node = $topo->nodeByName($k);
     $class->newFromDev($topo, $renv->{hostname}, $dev, $node);
  }
}

sub iconLayout {
  my($sw, $orient) = @_;
  return "F0D0F0/sve2.gif,_,,$orient";
}


sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp = $State->components($name);
  my $i = $Comp->value("e");
  my $enc = $i->[0];
  my $encInfo = $i->[1];
  my ($disk, $diskInfo);

  my ($other, $otherInfo, $mic, $mic_info);

  $Comp->other([], \$other, \$otherInfo);

  my($x, $port, $portInfo);
  my $ports = $node->{portInfo};

  for ($x=0; $x <= $#$ports; $x++) {
    my $el = $ports->[$x]{Slot};
    if ($el) {
      $portInfo .= "[" . substr($el,1,1) . "-" . substr($el,3,1) . "],";
    } else {
      $portInfo .= ",";
    }
  }

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);
}


sub portLabel {
  my($node, $port) = @_;
  my $ports = $node->portInfo();

  return $ports->[$port]{Slot} || "dsp-$port";
}


sub type { "sve2"};

sub revision {
  my $sw = @_;
  my $vol = $sw->volInfo();
  if ($vol) {
     foreach my $k (keys %$vol) {
         return $vol->{$k}{Revision};
     }
  }
  return undef;
}

sub isCascaded { 0 }


sub getLogicalPaths{
  my($self) = @_;
  my $volinfo =$self->volInfo();
  my @paths;
  foreach my $path (keys %$volinfo){
    push(@paths, $path);
  }
  return @paths;
}
1;
