package TO::SE2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use TO::SE;
use base 'TO::SE';
use strict;

sub leaf { 1 }
sub type { "se2" }


sub addPorts {
  my($class, $obj, $LINKS, $syns, $se_key) = @_;

  my $p;
  for ($p=0; $p < $LINKS->{'info.portTotal'} ; $p++) {
     next if (!$LINKS->{"fcPort.$p.LocalPortWWN"});
     $syns->{"S" . $LINKS->{"fcPort.$p.LocalPortWWN"}}  = "$se_key:$p";
     my $wwn = $LINKS->{"fcPort.$p.PortWWN"} || $LINKS->{"fcPort.$p.RemoteWWN"};
     if (!$obj->{portInfo}[$p]) {
       $obj->{portInfo}[$p]  = {
               PortWWN        => $wwn,
               RemotePortWWN  => $LINKS->{"fcPort.$p.RemoteWWN"},
               LocalPortWWN   => $LINKS->{"fcPort.$p.LocalPortWWN"},
               sw_PortType    => $LINKS->{"fcPort.$p.PortType"},
               PortState      => $LINKS->{"fcPort.$p.PortState"},
               PortStatus     => $LINKS->{"fcPort.$p.PortStatus"},
               Name           => $LINKS->{"fcPort.$p.Name"},
               PortId         => $LINKS->{"fcPort.$p.PortId"},
              };
     } else {
       $obj->{portInfo}[$p]{PortWWN}      = $wwn;
       $obj->{portInfo}[$p]{RemotePortWWN}= $LINKS->{"fcPort.$p.RemoteWWN"};
       $obj->{portInfo}[$p]{LocalPortWWN} = $LINKS->{"fcPort.$p.LocalPortWWN"};
       $obj->{portInfo}[$p]{sw_PortType}  = $LINKS->{"fcPort.$p.PortType"};
       $obj->{portInfo}[$p]{PortState}    = $LINKS->{"fcPort.$p.PortState"};
       $obj->{portInfo}[$p]{PortStatus}   = $LINKS->{"fcPort.$p.PortStatus"};
       $obj->{portInfo}[$p]{Name}         = $LINKS->{"fcPort.$p.Name"};
       $obj->{portInfo}[$p]{PortId}       = $LINKS->{"fcPort.$p.PortId"};
     }
  }
}




1;
