package TO::DSP;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Discman;
use strict;
use TO;
sub leaf { 1 }
use TO::SVE2;
use base 'TO::SVE2';


sub type { "dsp"};


sub newFromDev {
  my($class, $Topo, $host, $dev, $exist) = @_;
  my $type  = $class->type();
  my $name  = "$type:$dev->{key}";
  my $new = 0;

  my($switches) = $Topo->[1];
  my($syns)     = $Topo->[4];
  my $renv      = System->get_renv();
  my $obj       = {};
  if (!$exist) {
     $new = 1;
     $obj->{info}{name}    = $name;
     $obj->{info}{type}    = $type;
     $obj->{info}{class}   = "storage.$type";
     $obj->{info}{sw_WWN}  = $dev->{wwn};
     $obj->{port} = [];
     $obj->{portInfo} = [];
  } else {
     $obj = $exist;
  }
  $class->set_host_type($obj, "oob", $host);
  $obj->{info}{mgmtLevel} = $dev->{mgmtLevel} || "D";
  $obj->{info}{BoxName}   = $dev->{name};
  $obj->{info}{sw_ipAddr} = $dev->{ipno};
  $obj->{info}{ProductID} = uc($type);

  require Agent::DSP;
  my $report = {};
  my $err = Agent::DSP->getConfig($dev, $report);
  if ($report) {
     my($m, $p);
     my $port=0;
     for ($m=1; $m <= 10; $m++) {
       next if (!exists $report->{"fibrePort.m${m}p1.Name"});
       for ($p=1; $p <= 8; $p++) {
          my $el = "m${m}p$p";
          my $wwn = lc($report->{"fibrePort.$el.PortWwn"});
          $wwn =~ s/\://g;
          $port = Discman::find_port2($obj, $wwn);
          $syns->{$wwn} = "$name:$port";
          $obj->{portInfo}[$port]{LocalPortWWN} = $wwn;
          $obj->{portInfo}[$port]{PortWWN}      = $report->{"fibrePort.$el.RemoteWWN"};
          $obj->{portInfo}[$port]{Slot}         = $el;
          $obj->{portInfo}[$port]{PortLabel}    = "Module$m-Port$p";
          $obj->{portInfo}[$port]{PortNo}       = $port;
          $obj->{portInfo}[$port]{State}        = $report->{"fibrePort.$el.PortState"};
          $obj->{portInfo}[$port]{PortType}     = $report->{"fibrePort.$el.PortType"};
       }
     }
  }

  bless($obj, 'TO::' . uc($type));
  $syns->{$dev->{wwn}} = $name;
  $switches->{$name}  = $obj;

  return ($new ,$switches->{$name});
}


1;
