package Service::Inventory;
use strict;
use System;
use Inventory;
use Html::Flow;
use Labels;
use Service::Advisor;
use bytes;

sub upd {
  my($q) = @_;
  print Html->body();
  print Html->header2("service.service.invent_upd");
  my $ruser = System->get_ruser();
  my $deny  = Roles->verifyRole($q, "admin");

  my $LB = Labels->read("Service::Inventory");
  my $LB2 = Labels->read("Service::Advisor");

  print Html::Flow->display([
      [ $LB->{curr}, 'Service::Inventory::upd',         1, 1 ],
      [ $LB->{gen},  'Service::Inventory::upd2',  0, 0 ],
      [ $LB->{save},'Service::Inventory::upd3',  0, 0 ],
        ], {width => $Style::WIDTH});

  my $inv = Inventory->readInventory();
  if (!$inv) {
     print Html->warning($LB->{no_inv});
  } else {
    my $lock = LockManager->new();
    my $locki = $lock->exists("system", 1) || {};
    my ($app,$key0, $desc, $start, $mins, $ip, $name) = split(/\|/, $locki->{info}); 
    my $hours = int($mins / 60);

    my $input = ["<input type=hidden name=GO value=Service::Inventory::upd2>", 
                    "ACTION_disc", $LB->{submit_gen} ] if (!$deny);

    my $lock_name = Service::Advisor->user_name();

    if ($locki->{pid} && $lock_name ne $key0) {
       print Html->warning($LB2->expand(warn2 => $name, $start, $hours, $desc));
       $input = undef;
    }
      
    print &show_($q, $inv, "Service::Inventory::upd", undef, $input);
      
  }

  return;

  print "<br><table border=0 cellspacing=0 width=$Style::WIDTH>
    <tr><td><form><input type=hidden name=GO value=Service::Inventory::upd2>
    <center><b>".
    Html::Screen->submitButton("ACTION_disc", $LB->{submit_gen})
    ."</table>";
  print "</form>";
  
}

sub upd2 {
  my($q) = @_;
  print Html->body();
  print Html->header2("service.service.invent_upd");
  my $LB = Labels->read("Service::Inventory");

  print Html::Flow->display([
      [ $LB->{curr}, 'Service::Inventory::upd',           0, 1 ],
      [ $LB->{gen},  'Service::Inventory::upd2',    1, 0 ],
      [ $LB->{save}, 'Service::Inventory::upd3',    0, 0 ],
        ], {width => $Style::WIDTH});

  my $renv = System->get_renv();
  my $model = $renv->{solution_model};
  my $short = System->hostname();
  my $ix = index($short, ".");
  if ($ix > 0) {
     $short = substr($short,0,$ix);
  }
  my $oinv = Inventory->readInventory();
  print "</center>Probing...<br>\n";
  my($trace_out, $inv) = Inventory->readMaserati($short, undef, 1, 1, $model);    
  if (!$inv) {
     print "$LB->{failed} $model!";
     return;
  }
  $inv->{model} = $model;
  my $F = "/tmp/inv_upd_$$";
  $inv->writeInventory($F, 1, 1); # HTML=1, skip_vmcfg=1

  print &display_($inv, $oinv);

  print "<br><table border=0 cellspacing=0 width=$Style::WIDTH>
    <tr><td><form>
     <input type=hidden name=GO value=Service::Inventory::upd3>
     <input type=hidden name=F value=$F>
    <center><b>
    <input type=submit name=ACTION_save value=\"$LB->{submit_save}\">
    </table>";
  print "</form>";

}

sub upd3 {
  my($q) = @_;
  print Html->body();
  print Html->header2("service.service.invent_upd");
  my $ruser      = System->get_ruser();
  my $LB = Labels->read("Service::Inventory");

  print Html::Flow->display([
      [ $LB->{curr},  'Service::Inventory::upd',            0, 1 ],
      [ $LB->{gen} ,  'Service::Inventory::upd2',     0, 1 ],
      [ $LB->{save},  'Service::Inventory::upd3',     1, 0 ],
        ], {width => $Style::WIDTH});


  if ($q->{ACTION_save}) {
     my $inv = Inventory->readInventory($q->{F});
     if ($inv) {
       $inv->writeInventory(undef, 1);
       $inv->writeConfig("write");
       print Html->info($LB->{inv_saved});
       my $cnt = $inv->deviceCount();
       Inventory->log($LB->expand(new_inv => $ruser->{userid}, $cnt));
       unlink $q->{F};
     } else {
       print Html->warning($LB->{no_inv});
     }
  }

  my $inv = Inventory->readInventory();
  if (!$inv) {
     print Html->warning($LB->{no_inv});
  } else {
    print &show_($q, $inv, "Service::Inventory::upd", $LB->{upd_inv});
  }
}


sub display_ {
  my($inv, $oinv) = @_;
  my $LB = Labels->read("Service::Inventory");

  my $out =  "<table border=1 cellspacing=0 cellpadding=0 bgcolor=white width=$Style::WIDTH>
  <tr><td colspan=4 bgcolor=$Style::DARK><font color=white><b>$LB->{curr}</td>
  <tr bgcolor=$Style::LIGHT>
       <th>$LB->{type}
       <th>$LB->{name}
       <th>$LB->{ip}
       <th>$LB->{status}
  ";
  my $tot;
  if (!$oinv) {
    my $devs = $inv->getDevices();
    foreach my $d (@$devs) {
      $out .= "<tr><td><center>$d->{type}<td>&nbsp;$d->{name}<td>&nbsp;$d->{ipno}<td>&nbsp;</td>";
    }
    $out .= "</table>";
  } else {
    my $devs = $inv->getKeys();
    my $odevs = $oinv->getKeys();
    foreach my $k (keys %$devs) {
      my $d = $devs->{$k};
      if (exists($odevs->{$k})) {
         my $frus = $d->frus();
         my $ofrus   = $odevs->{$k}{frus};
         my $changes;
         foreach my $fruid (keys %$frus) {
             my $fru = $frus->{$fruid};
             my $ofru = $ofrus->{$fruid} || {};

	     foreach my $entry (keys %$fru){
	        if (!exists($ofru->{$entry})) {
                   $changes .= "-Fru $fruid:$entry has been added.<br>";
		   last;
                }elsif ($fru->{$entry} ne $ofru->{$entry}) {
                   $changes .= "-$entry of $fruid changed from '$ofru->{$entry}' to '$fru->{$entry}'<br> ";
                }
	     }
         }
         foreach my $fruid (keys %$ofrus) {
             my $ofru = $ofrus->{$fruid};
             my $fru = $frus->{$fruid} || {};

	     foreach my $entry (keys %$ofru){
	        if (!exists($fru->{$entry})) {
                   $changes .= "-Fru $fruid:$entry has been removed.<br>";
		   last;
		} # else we have already compared versions above
	     }
         }
         if ($changes) {
           $out .= "<tr><td><center>$d->{type}<td>&nbsp;$d->{name}<td>&nbsp;$d->{ipno}</td><td><b><center><font color=red>Fru Changes</td>";
           $out .= "<tr><td>&nbsp;<td colspan=3><font color=navy>$changes</td>";
           $tot++;
         } else {
           $out .= "<tr><td><center>$d->{type}<td>&nbsp;$d->{name}<td>&nbsp;$d->{ipno}</td><td><font color=green><b><center>$LB->{no_change}</td>";
         }
      } else {
         $out .= "<tr bgcolor=#CCFFCC><td><center>$d->{type}<td>&nbsp;$d->{name}<td>&nbsp;$d->{ipno}<td><center><b>$LB->{added}</td>";
         $tot++;
      }
    }
    foreach my $k (keys %$odevs) {
      if (!exists($devs->{$k})) {
         my $d = $odevs->{$k};
         $out .= "<tr bgcolor=#FFCCCC><td><center>$d->{type}<td>&nbsp;$d->{name}<td>&nbsp;$d->{ipno}<td><center><b>$LB->{delete}</td>";
         $tot++;
      }
    }
  }
  $out .= "</table>";
  #$out .= "<b>Inventory is current!</b>" if (!$tot);
  return $out;
}

sub show {
  my($q) = @_;
  print Html->body();
  print Html->header2("service.util.invent_show");
  my $inv = Inventory->readInventory();
  if (!$inv) {
     print Html->warning("No inventory available!");
     return;
  }
  print &show_($q, $inv, "Service::Inventory::show");
}


sub show_ {
  my($q, $inv, $url, $label, $button) = @_;
  my $renv = System->get_renv();
  my $details = $q->{details};
  my $IP      = $q->{ip};
  my ($b1,$b2, $b11, $b21);
  my $LB = Labels->read("Service::Inventory");

  if ($q->{details}) {
    $b1 = "<b>"; $b11 = "</b>";
  } else {
    $b2 = "<b>"; $b21 = "</b>";
  }
  $label = $LB->{curr} if (!$label);

  my $scr = Html::Screen->new();
  $scr->add("<form>$button->[0]");

  my $click = "<font color=white>[ <a href=\"$Http::WEBPROC?GO=$url\"><font color=white>".
      "${b2}$LB->{summ}${b21}</font></a> | <a href=\"$Http::WEBPROC?GO=$url&details=1\">".
      "<font color=white>${b1}$LB->{detail}${b11}</font></a> ]";

  my(@array);
  my $devs = $inv->getDevices();
  my $cnt;
  foreach my $d (@$devs) {
      my $u = "<a href=\"$Http::WEBPROC?GO=$url&ip=$d->{ipno}\">$d->{name}</a>";
      my $u_close = "<a href=\"$Http::WEBPROC?GO=$url&ip=$d->{ipno}&CLOSE=1\">$d->{name}</a>";

      if ($details || $IP eq $d->{ipno} && !$q->{CLOSE}) {
        my $frus = $d->frus();
        foreach my $fruid (sort keys %$frus) {
           my $fru = $frus->{$fruid};
           
           my $rev  = $d->revisionString($fru) || "N/A";
           my $prod = $d->serialString($fru)   || "N/A";
   
           push(@array, ["<x $cnt>- $u_close", "$fruid $fru->{type}", "<small>$prod", $rev]);
        }
      } else {
        push(@array, [ "<x $cnt>+ $u", undef, undef, $d->{sysRevision}]);
      }
      $cnt++;
  }
  $q->{SORT} = 1;
  $scr->list($q, { title => $label . "&nbsp;&nbsp;&nbsp;" . $click, pageSize => 60, interactive => 1},
    [
    [ l => $LB->{name}, 'n' ],
    [ l => $LB->{fru} ],
    [ l => $LB->{vendor} ],
    [ l => $LB->{rev} ],
    ],
    \@array,
    [
    [ l => $button->[1], $button->[2] ],
    ]);

  $scr->add("</form>");
  return $scr->out();
}

1;
