package Service::Disable;
use Html;
use strict;
use MG::T3;
use MG::DSP;
use MG::Util;
use PDM::ConfigFile;
use Service::Fru;
use Process;

################################################
#
# BOOT -W
# use in htdocs/Service/MasME/*.html
# <svc window_help=Service::Disable::boot_w>Reboot the machine</a>
#
################################################

sub boot_w {
  my($q) = @_;

  require Service::Array;
  print Html->body();
  my $meta;

  my $L = Labels->read("Service::Disable");
  my $ID = "array_boot";
  my $INFO;

  my $time = $q->{time} + 15;
  $time = 60 if ($time > 60);
  my $meta = "<meta http-equiv=Refresh content=\"10;URL=$Http::WEBPROC?GO=Service::Disable::boot_w&time=$time\">";

  if ($q->{ACTION_start}) {
     my $array = $q->{array}; # diag78
     my $cmd = System->get_home() . 
                 "/sysbin/array_boot -i $array -p \"$q->{password}\"";
     print $meta;
     system("$cmd&");
     print Html->header2("", undef, undef, undef, {popup => 1});
     print Html->info($L->expand(started => "boot -w"));
     return;

  } else {
    my $status = Process->status(undef, $ID);
    my $info   = Process->read(undef, $ID);
  
    print $meta if ($status =~ /Running/);
    print Html->header2("", undef, undef, undef, {popup => 1});
    my $age = Process->age($ID);

    if  ($info->{data}{status} =~ /ERROR/) {
       print Html->error("$L->{status}: $status <br>$info->{data}{trace}");

    } elsif ($age < 6) { # display status if last run is within 6 hours.
       print Html->info( "$L->{status}: $status <br>$info->{data}{trace}");
    }
    return if ($status =~ /Running/);
  }

  print Html->header2("", undef, undef, undef, {popup => 1});
  print $INFO if ($INFO);
 
  my($renv, $devs) = PDM::ConfigFile->read();
  my(%TAKEN);
  foreach my $d (@$devs) {
    if ($d->{name} =~ /^array(\d+)/) {
      $TAKEN{$d->{name}} = 1;
    }
  }
  my $new ;
  my ($l);
  open(O, "/etc/hosts");
  while ($l = <O>) {
     my($ip0, $name, $rest) = split(/\s+/, $l);
     if ($name =~ /^array/ && !$TAKEN{$name}) {
       $new .= "<option>$name</option>";
     }
  }
  close(O);
  if (!$new) {
     print Html->error("$new cannot be configured, not in /etc/hosts");
  }
  print "<table border=0 width=$Style::WIDTH ><tr><td>$L->{boot_help}</table>";

  my $scr = Html::Screen->new();
  $scr->add(" <form  method=get>
      <input type=hidden name=GO value=Service::Disable::boot_w>");
   $scr->table( { title => $L->{boot_title} },
   [
   [ f => $L->{boot_array}, "<select name=array>$new</select>" ],
   [ f => $L->{boot_pass} , "<input type=password name=password size=10>"],
   ]);
    $scr->button2([
    [ l => 'ACTION_start', $L->{boot_submit} ],
    ]);
   $scr->add("</form>");
   print $scr->out();

}




################################################
# let user select a fru before calling &disk.
################################################

sub fromList {
  my($q) = @_;
  print Html->body();

  # PROCESS Service::Fru::select
  if (my $sel = Service::Fru::selected($q)) {
     ($q->{KEY},$q->{FRU},$q->{DEV_NAME}) = split(/\:/, $sel);
     $q->{run} = 1;
     $q->{_HEADER2} = "service.wizard.dis";
     &disk($q);
     return;
  }
  print Html->header2("service.wizard.dis");
  $q->{_BACK} = "Service::Disable::fromList";
  Service::Fru::select($q);
}

################################################
# UNIT
################################################

sub fruStatWin {
  my($q) = @_;
  $q->{_HEADER2} = "service.wizard.array";
  &array($q);
}

#  will return fruStat | volStat etc.. against all arrays.
#
sub allStat {
  my($q) = @_;
  my $command = $q->{command};

  my $renv = System->get_renv();
  my ($renv2, $devs) = PDM::ConfigFile->read();
  print Html->body();
  my $L = Labels->read("Service::Disable");

  foreach my $d (@$devs) {
     next if ($d->{type} ne "6020");
     my $t3 = MG::T3->new($d);
     my $rc = $t3->fru_stat($command);

     print "&nbsp;<br>";
     print Html->step($L->expand(stat => "$d->{name}"));
     print $rc->report2html();
  }
}
 
sub fruStat {
  my($q) = @_;
  my $fru = $q->{FRU};
  my $key = $q->{KEY};
  my $run = $q->{run};
  my $L = Labels->read("Service::Disable");

  my $Config = PDM::ConfigFile->read();
  my $dev = $Config->deviceByKey($key);
  
  if ($q->{_HEADER2}) {
    print Html->body();
    print Html->header2($q->{_HEADER2}, undef, undef, undef, {noDoc => 1, noCrumb => 1, noTabs => 1});
  }

  if (!$dev) {
    print Html->error($L->{no_dev});
    return;
  }
  my $t3 = MG::T3->new($dev);
  my $rc = $t3->fru_stat($fru);

  print "&nbsp;<br>";
  print Html->step($L->expand(stat => "$dev->{name} - $fru"));

  print $rc->report2html();

  print "&nbsp;";

  if ($rc->warning()) {
    print Html->warning($rc->warning(), undef);
  }
  if ($rc->error()) {
    print Html->error($rc->error(), undef);
  }
}



######################
# DISK
######################

sub arrayDiskWin {
  my($q) = @_;
  $q->{_HEADER2} = "service.wizard.array";
  &disk($q);
}

# called directly (fromList) of from Advisor (diskWin) with a fru already defined
# INPUT: $q->{_HEADER2} : which header to use
#        $q->{run} : 0: verify, 1: verify and run.
#
 
sub disk {
  my($q) = @_;
  my $fru = $q->{FRU};
  my $key = $q->{KEY};
  my $run = $q->{run};

  my $Config = PDM::ConfigFile->read();
  my $dev = $Config->deviceByKey($key);
  my $L = Labels->read("Service::Disable");
  
  if ($q->{_HEADER2}) {
    print Html->body();
    print Html->header2($q->{_HEADER2}, undef, undef, undef, {noDoc => 1, noCrumb => 1, noTabs => 1});
  }

  if (!$dev) {
    print Html->error($L->{no_dev});
    return;
  }
  my $t3 = MG::T3->new($dev);
  if ($q->{ACTION_proceed}) {

     my $rc = $t3->do_disk_disable($fru);
     print Html->step($L->expand(disable => "$dev->{name} - $fru"));
     print $rc->report2html();
     print "&nbsp;";
     if ($rc->error()) {
       print Html->error( $rc->error(),undef);
     } else {
       print Html->info($L->{now_disable},undef);
     }
     print "<p>[ <a href=/rashttp?GO=Service::Disable::disk&_HEADER2=$q->{_HEADER2}&FRU=$fru&KEY=$key&run=1>$L->{back_ver}</a> ]";
     return;
  }
  
  my $rc = $t3->pre_disk_disable($fru);

  print "&nbsp;<br>";
  print Html->step($L->expand('disk_ver' => "$dev->{name} - $fru"));

  print $rc->report2html();

  print "&nbsp;";
  if ($rc->warning()) {
    print Html->warning($rc->warning(), undef);
  }
  if ($rc->error()) {
    print Html->error($rc->error(), undef);
    return;
  } else {
    my $pro = ", ready to proceed." if ($run);
    #print Html->info("No error found$pro",undef);
  }
  return;
  my $hid = Html->makeHidden($q,"GO,ACTION_proceed");
  print "<form>$hid
    <input type=hidden name=GO value=Service::Disable::disk>
    <input type=submit name=ACTION_proceed value=\"$L->{submit_proceed}\">
    </form>";
}

######################
# CONTROLLER
######################

sub arrayControllerWin {
  my($q) = @_;
  $q->{_HEADER2} = "service.wizard.array";
  &controller($q);
}

sub controller {
  my($q) = @_;
  my $fru = $q->{FRU};
  my $key = $q->{KEY};
  my $run = $q->{run};
  my $L = Labels->read("Service::Disable");

  my $Config = PDM::ConfigFile->read();
  my $dev = $Config->deviceByKey($key);
  
  if ($q->{_HEADER2}) {
    print Html->body();
    print Html->header2($q->{_HEADER2}, undef, undef, undef, {noDoc => 1, noCrumb => 1, noTabs => 1});
  }

  if (!$dev) {
    print Html->error($L->{no_dev});
    return;
  }
  my $t3 = MG::T3->new($dev);
  
  my $rc = $t3->pre_controller_disable($fru);

  print "&nbsp;<br>";
  print Html->step($L->expand('ctrl_ver' => "$dev->{name} - $fru"));

  print $rc->report2html();

  print "&nbsp;";

  print Html->warning($rc->warning(), undef) if ($rc->warning());
  print Html->error($rc->error(), undef) if ($rc->error());
}

######################
# LOOPCARD
######################

sub arrayLoopcardWin {
  my($q) = @_;
  $q->{_HEADER2} = "service.wizard.array";
  &loopcard($q);
}

sub loopcard {
  my($q) = @_;
  my $fru = $q->{FRU};
  my $key = $q->{KEY};
  my $run = $q->{run};
  my $L = Labels->read("Service::Disable");

  my $Config = PDM::ConfigFile->read();
  my $dev = $Config->deviceByKey($key);
  
  if ($q->{_HEADER2}) {
    print Html->body();
    print Html->header2($q->{_HEADER2}, undef, undef, undef, {noDoc => 1, noCrumb => 1, noTabs => 1});
  }

  if (!$dev) {
    print Html->error($L->{no_dev});
    return;
  }
  my $t3 = MG::T3->new($dev);
  
  my $rc = $t3->pre_loopcard_disable($fru);

  print "&nbsp;<br>";
  print Html->step($L->expand(loop_ver => "$dev->{name} - $fru"));

  print $rc->report2html();

  print "&nbsp;";

  print Html->warning($rc->warning(), undef) if ($rc->warning());
  print Html->error($rc->error(), undef) if ($rc->error());
}

######################
# POWER
######################

sub arrayPowerWin {
  my($q) = @_;
  $q->{_HEADER2} = "service.wizard.array";
  &arraypower($q);
}

sub arraypower {
  my($q) = @_;
  my $fru = $q->{FRU};
  my $key = $q->{KEY};
  my $run = $q->{run};
  my $L = Labels->read("Service::Disable");

  my $Config = PDM::ConfigFile->read();
  my $dev = $Config->deviceByKey($key);
  
  if ($q->{_HEADER2}) {
    print Html->body();
    print Html->header2($q->{_HEADER2}, undef, undef, undef, {noDoc => 1, noCrumb => 1, noTabs => 1});
  }

  if (!$dev) {
    print Html->error($L->{no_dev});
    return;
  }
  my $t3 = MG::T3->new($dev);
  
  my $rc = $t3->pre_arraypower_disable($fru);

  print Html->step($L->expand('pow_ver' => "$dev->{name} - $fru"));

  print $rc->report2html();

  print "&nbsp;";

  print Html->warning($rc->warning(), undef) if ($rc->warning());
  print Html->error($rc->error(), undef) if ($rc->error());
}

######################
# Battery
######################

sub arrayBatteryWin {
  my($q) = @_;
  $q->{_HEADER2} = "service.wizard.array";
  &arraybattery($q);
}

sub arraybattery {
  my($q) = @_;
  my $fru = $q->{FRU};
  my $key = $q->{KEY};
  my $run = $q->{run};

  my $Config = PDM::ConfigFile->read();
  my $dev = $Config->deviceByKey($key);
  my $L = Labels->read("Service::Disable");
  
  if ($q->{_HEADER2}) {
    print Html->body();
    print Html->header2($q->{_HEADER2}, undef, undef, undef, {noDoc => 1, noCrumb => 1, noTabs => 1});
  }

  if (!$dev) {
    print Html->error($L->{no_dev});
    return;
  }
  my $t3 = MG::T3->new($dev);
  
  my $rc = $t3->pre_arraybattery_disable($fru);

  print Html->step($L->expand('bat_ver' => "$dev->{name} - $fru"));

  print $rc->report2html();

  print "&nbsp;";

  print Html->warning($rc->warning(), undef) if ($rc->warning());
  print Html->error($rc->error(), undef) if ($rc->error());
}

######################
# BOX
######################

sub arrayNolocateWin {
  my($q) = @_;
  $q->{_HEADER2} = "service.wizard.array";
  $q->{NOLOCATE} = 1;
  &arrayLocate($q);
}

sub arrayLocateWin {
  my($q) = @_;
  $q->{_HEADER2} = "service.wizard.array";
  &arrayLocate($q);
}

sub arrayLocate {
  my($q) = @_;
  my $fru = $q->{FRU};
  my $key = $q->{KEY};
  my $run = $q->{run};
  my $L = Labels->read("Service::Disable");

  my $Config = PDM::ConfigFile->read();
  my $dev = $Config->deviceByKey($key);
  
  if ($q->{_HEADER2}) {
    print Html->body();
    print Html->header2($q->{_HEADER2}, undef, undef, undef, {noDoc => 1, noCrumb => 1, noTabs => 1});
  }

  if (!$dev) {
    print Html->error($L->{no_dev});
    return;
  }
  my $t3 = MG::T3->new($dev);
  
  my ($rc, $label);
  if ($q->{NOLOCATE}) {
     $rc = $t3->array_nolocate($fru);
     $label = $L->expand('clear_loc' => "$dev->{name} - $fru");
  } else {
     $rc = $t3->array_locate($fru);
     $label = $L->expand('set_loc' => "$dev->{name} - $fru");
  }

  print Html->step($label);

  print $rc->report2html();

  print "&nbsp;";

  print Html->warning($rc->warning(), undef) if ($rc->warning());
  print Html->error($rc->error(), undef) if ($rc->error());
}

######################
# DSP
######################

sub dspWin {
  my($q) = @_;
  $q->{_HEADER2} = "service.wizard.dsp";
  &dsp($q);
}

sub dsp {
  my($q) = @_;
  my $fru = $q->{FRU};
  my $key = $q->{KEY};
  my $run = $q->{run};
  my $L = Labels->read("Service::Disable");

  my $Config = PDM::ConfigFile->read();
  my $dev = $key ? $Config->deviceByKey($key) : $Config->deviceByType("dsp");
  
  if ($q->{_HEADER2}) {
    print Html->body();
    print Html->header2($q->{_HEADER2}, undef, undef, undef, {noDoc => 1, noCrumb => 1, noTabs => 1});
  }

  if (!$dev) {
    print Html->error($L->{no_dev});
    return;
  }
  my $dsp = MG::DSP->new($dev);
  
  my $rc = $dsp->pre_disable($fru);

  print "&nbsp;<br>";
  print Html->step($L->expand(fru_ver => "$dev->{name} - $fru"));

  print $rc->report2html();

  print "&nbsp;";

  print Html->warning($rc->warning(), undef) if ($rc->warning());
  print Html->error($rc->error(), undef) if ($rc->error());
}

1;
