package Service::Core;
use System;
use strict;

sub coreBase {
  my $renv = System->get_renv();
  return  $renv->{"corefiles.base"} || "/var/crash";
}


sub core_list {

  my $TMP = "/tmp/storade_core.tmp";
  unlink $TMP;
  my $base = &coreBase();
  my $len = length($base);
  system("/usr/bin/find $base -type 'f' -print > $TMP");
  
  open(O,$TMP);
  my ($l, @L);
  while ($l = <O>) {
     chop($l);
     push(@L, $l);
  }
  close(O);
  my @OUT;
  foreach my $l (sort @L) {
     my $time = Util->get_file_created($l);
     my $l0 = substr($l,$len);
     my($null, $dev, $path) = split(/\//, $l0, 3);
     if (length($path) > 50) {
        $path = substr($path,0,50) . " " . substr($path, 50);
     }
     push(@OUT, [$l,$l0, $dev, $time, $path]);
  }
  return \@OUT;
}

sub list {
  my($q) = @_;

  my $renv = System->get_renv();
  my $deny  = Roles->verifyRole($q, "admin");

  my $L = Labels->read("Service::Core");


  print Html->body();
  print Html->header2("service.util.core");
  if ($q->{ACTION_selected}) {
    my $del;
    foreach my $e (keys %$q) {
       if (substr($e,0,4) eq "del_") {
          my $f = substr($e,4);
          unlink $f;
          $del++;
       }
    }
    print Html->info("$del $L->{file_del}");
  }
  my $L2 = &core_list();
  my(@array);
  foreach my $el (@$L2) {
     my $time = $el->[4];
     $time =~ s/ /&nbsp;/g;
     my $url = "<a href=/Crash/$el->[1]>$el->[4]</a>";
     push(@array, [ "<input type=checkbox name=del_$el->[0]>", $el->[2], 
                   $url, $el->[3] ] );
  }


  my $scr = Html::Screen->new();
  $scr->add(" <form><input type=hidden name=GO value=Service::Core::list>");

  $scr->list($q, { title => "$L->{title}", interactive => 1 },
    [
    [ c => "$L->{delete}"],
    [ l => "$L->{device}", "+" ],
    [ l => "$L->{file}", "+" ],
    [ l => "$L->{date}", "+" ],
    ],
    \@array,
    [
      [ l => "ACTION_selected", "$L->{del_sel}", $deny ],
    ]
    );
   $scr->add("</form>");
   print $scr->out();

}


1;
