#
# SCCS Info:      pragma ident   "@(#)T3UI.pm 1.49     04/05/06 15:17:34 SMI"
#
#  Copyright (c) 2001 Sun Microsystems, Inc, All Rights Reserved.
#
#  Perl Module for SE T3 UI
#
package SE::T3UI;

use lib qw ( /opt/SUNWstade/lib );
use strict;
use IO::File;  # VERY VERY IMPORTANT for sysopen to work; DO NOT REMOVE!!!!!
#use SE::T3;
use SE::Util;
use SE::WebUtil;
use Agent::T3;

my $webproc = "rashttp.2";
#my $webproc = "rascgi";

my $homeStr = "Sun StorEdge Series Config";
my $homeURL = "/$webproc?GO=GUI::SE::index";

my $validateStr = "Store/Clear T3+ Password";
#my $validateStr = "Store/Clear T3+ Password Validation";
my $validateAction = "SE::T3UI::validate";
my $validateURL = "/$webproc?GO=" . $validateAction;

my $mpStr = "MP Drive Failback Support";
my $mpAction = "SE::T3UI::mpFailback";
my $mpURL = "/$webproc?GO=" . $mpAction;

my $dispStr = "Display T3+ Config";
my $dispAction = "SE::T3UI::dispConfig";
my $dispURL = "/$webproc?GO=" . $dispAction;

my $saveStr = "Save T3+ Config";
my $saveAction = "SE::T3UI::saveConfig";
my $saveURL = "/$webproc?GO=" . $saveAction;

my $configStr        = "Configure T3+(s)";
my $configAction     = "SE::T3UI::startConfig";
my $configURL        = "/$webproc?GO=" . $configAction;
my $defaultConfigStr = "Default Configuration";
my $defaultConfigURL = "/$webproc?GO=SE::T3UI::defaultConfig";

my $chooseAction     = "SE::T3UI::chooseDefaultOrCustom";
my $commitAction     = "SE::T3UI::commitConfig";

my $customConfigStr  = "Custom Configuration";
my $customConfigURL  = "/$webproc?GO=SE::T3UI::customConfig";

my $restoreStr = "Restore T3+ Config";
my $restoreAction = "SE::T3UI::restoreConfig";
my $restoreURL = "/$webproc?GO=" . $restoreAction;

my $portSLModeStr = "Set Switch Port SL Mode Per T3+ Sun StorEdge Array";
my $sLModeStr = "Port SL Mode: ";
my @slOnOff = ( "on", "off" );
my $setPortSLModeStr = "\"Set Port SL Mode\"";
my $portSLModeAction = "SE::T3UI::portSLMode";
my $portSLModeURL = "/$webproc?GO=" . $portSLModeAction;

my $createDiskPoolStr    = "Create Disk Pools";
my $createDiskPoolAction = "SE::T3UI::createDiskPool";
my $createDiskPoolURL    = "/$webproc?GO=" . $createDiskPoolAction;

my $removeDiskPoolStr    = "Remove Disk Pools";
my $removeDiskPoolAction = "SE::T3UI::removeDiskPool";
my $removeDiskPoolURL    = "/$webproc?GO=" . $removeDiskPoolAction;

my $verifyStr     = "Verify T3+ Config";
my $verifyAction  = "SE::T3UI::verifyConfig";
my $verifyURL     = "/$webproc?GO=" . $verifyAction;

my $busyStr    = "Configuration Status";
my $busyAction = "SE::T3UI::busyUnits";
my $busyURL    = "/$webproc?GO=" . $busyAction;

my $modifySysStr     = "Modify T3+ System Parameters";
my $modifySysAction  = "SE::T3UI::modifySys";
my $modifySysURL     = "/$webproc?GO=" . $modifySysAction;

my $t3SelectedStr = "T3+ Selected:";
my $t3AvailStr    = "T3+(s) available:";
my $t3InUseStr    = "T3+(s) in use:";

my $manageDiskPoolsStr    = "Manage Disk Pools";
my $manageDiskPoolsAction = "SE::T3UI::manageDiskPools";
my $manageDiskPoolsURL    = "/$webproc?GO=" . $manageDiskPoolsAction;

my $lunSliceStr    = "Manage Sun StorEdge T3+ Array LUN Slicing";
my $lunSliceAction = "SE::T3UI::manageLunSlicing";
my $lunSliceURL    = "/$webproc?GO=" . $lunSliceAction;

my $createSliceStr     = "Create Sun StorEdge T3+ Array LUN Slice";
my $createSliceAction  = "SE::T3UI::createSlice";
my $createSliceURL     = "/$webproc?GO=" . $createSliceAction;

my $removeSliceStr     = "Remove Sun StorEdge T3+ Array LUN Slice";
my $removeSliceAction  = "SE::T3UI::removeSlice";
my $removeSliceURL     = "/$webproc?GO=" . $removeSliceAction;

my $showSliceStr     = "Display Sun StorEdge T3+ Array LUN Slice/Mask Info";
my $showSliceAction  = "SE::T3UI::showSlice";
my $showSliceURL     = "/$webproc?GO=" . $showSliceAction;

my $showMaskStr     = "Display Sun StorEdge T3+ Array LUN Mask/Slice Info";

my $lunMaskStr    = "Manage Sun StorEdge T3+ Array LUN Masking";
my $lunMaskAction = "SE::T3UI::manageLunMasking";
my $lunMaskURL    = "/$webproc?GO=" . $lunMaskAction;

my $createT3GroupStr     = "Create T3+ Group";
my $createT3GroupAction  = "SE::T3UI::createT3Group";
my $createT3GroupURL     = "/$webproc?GO=" . $createT3GroupAction;

my $removeT3GroupStr     = "Remove T3+ Group";
my $removeT3GroupAction  = "SE::T3UI::removeT3Group";
my $removeT3GroupURL     = "/$webproc?GO=" . $removeT3GroupAction;

my $addToT3GroupStr     = "Add WWN to T3+ Group";
my $addToT3GroupAction  = "SE::T3UI::addToT3Group";
my $addToT3GroupURL     = "/$webproc?GO=" . $addToT3GroupAction;

my $delFromT3GroupStr     = "Delete WWN from T3+ Group";
my $delFromT3GroupAction  = "SE::T3UI::delFromT3Group";
my $delFromT3GroupURL     = "/$webproc?GO=" . $delFromT3GroupAction;

my $setT3LunPermStr     = "Set Sun StorEdge T3+ Array LUN Permissions";
my $setT3LunPermAction  = "SE::T3UI::setT3LunPerm";
my $setT3LunPermURL     = "/$webproc?GO=" . $setT3LunPermAction;

my $enableT3VolSlicingStr     = "Enable T3+ Vol Slicing";
my $enableT3VolSlicingAction  = "SE::T3UI::enableT3VolSlicing";
my $enableT3VolSlicingURL     = "/$webproc?GO=" . $enableT3VolSlicingAction;

my $viewT3ResultsStr    = "View the last results of Creating diskpools on T3(s)";
my $viewT3ResultsAction = "SE::T3UI::viewT3Results";
my $viewT3ResultsURL    = "/$webproc?GO=" . $viewT3ResultsAction;

my $viewT3DPResultsStr    = "View the last results of Removing diskpools on T3(s)";
my $viewT3DPResultsAction = "SE::T3UI::viewT3DPResults";
my $viewT3DPResultsURL    = "/$webproc?GO=" . $viewT3DPResultsAction;

my $viewT3DispResultsStr    = "View the last results of Display All T3(s) Configuration";
my $viewT3DispResultsAction = "SE::T3UI::viewT3DispResults";
my $viewT3DispResultsURL    = "/$webproc?GO=" . $viewT3DispResultsAction;

my $saveT3DispResultsStr    = "View the last results of Save All T3(s) Configuration";
my $saveT3DispResultsAction = "SE::T3UI::saveT3DispResults";
my $saveT3DispResultsURL    = "/$webproc?GO=" . $saveT3DispResultsAction;

my $viewT3SliceResultsStr    = "View the last results of Creating Slice(s) on T3(s)";
my $viewT3SliceResultsAction = "SE::T3UI::viewT3SliceResults";
my $viewT3SliceResultsURL    = "/$webproc?GO=" . $viewT3SliceResultsAction;

my $viewT3refresh = "Refresh";

my $indy3900OnlyStr = "<h2>This command can only be run on a"
	            . " Sun StorEdge 3910 or 3960 system.</h2>";

my $warning = "All data on this unit will be lost."
	    . "  Do you wish to continue?";

my $warningLUN = "All data on this LUN(s) will be lost."
               . "  Do you wish to continue?";

my $warningPools = "All data on this disk pool(s) will be lost."
               . "  Do you wish to continue?";

my $allStr = "All";
my $volParam = "vol";
my $sliceSizeParam = "ss";
my $sliceNameParam = "sn";
my $sliceNumParam = "snu";
my $numSlices;
my $numSliceParam = "nsp";
my $optListParam = "olp";

my $true=1;
my $false=0;

my $realSystem = $true;

my $passFileName = "/opt/SUNWstade/DATA/SE_T3.dat";

$T3UI::secfgBinDir = "/opt/SUNWsecfg/bin";

my $t3Param        = "t3";
my $raidParam      = "raid";
my $lunsParam      = "luns";
my $readaheadParam = "readahead";
my $nacaParam      = "naca";
my $mpParam        = "mp";
my $blocksizeParam = "blocksize";
my $slModeParam    = "slmode";
my $pswdParam      = "pswd";
my $forceParam     = "force";
my $reconRateParam = "rr";
my $fcParam = "fc";
my $dsParam = "ds";
my $ondgParam = "ond";

my $gNameParam = "gn";
my $wwnNameParam = "wwn";
my $wwnListParam = "wwnl";
my $lunNameParam = "lnp";
my $permNameParam = "pnp";

my $stepParam      = "step";

my $forceRestoreStr = "Force the current configuration to be destroyed and"
	            . " the previous configuration to be recreated.";

my $yesStr = "Yes";
my $noStr  = "No";

my @yesno = ( $yesStr, $noStr );

sub debugRequest ()
{
    my $self = shift;
    my ( $request ) = @_ if @_;

    if ( 0 )
    {
	my %h = %$request;

	while ( my ( $key,  $value) = each %h ) 
	{
	    print "<BR>key = " . $key . " val =  " . $value;
	}
    }
}


sub viewT3SliceResults ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $viewT3SliceResultsAction );

    #if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    #{
    #    print  $indy6900OnlyStr;
    #    return;
    #}

    	my $t3name = `cat /tmp/t3ID`;

        my @crumb = ( [ $homeStr , $homeURL ],
                      [ $lunSliceStr => $lunSliceURL ]
                    );
        print SE::WebUtil->createCrumb( \@crumb, $viewT3SliceResultsStr );

        &viewSliceResults($t3name, $viewT3SliceResultsURL);

}


sub viewSliceResults ()
{

my ( $t3Name, $refreshURL ) = @_ if @_;



    my $command = "/usr/bin/cat /tmp/se6900_slice_$t3Name";
    my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 0 );
    if ( $retVal == 0)
    {
        print $stdout;
    }
    else
    {
        print "<br>No slice creations results were found for T3+ $t3Name.<br>";
    }

    print "<br></pre>";
    print "<a href=$refreshURL>$viewT3refresh</a>";


}


sub viewT3Results ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $viewT3ResultsAction );

    #if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    #{
    #    print  $indy6900OnlyStr;
    #    return;
    #}

    	my $t3name = `cat /tmp/t3ID`;

        my @crumb = ( [ $homeStr , $homeURL ],
                      [ $createDiskPoolStr => $createDiskPoolURL ]
                    );
        print SE::WebUtil->createCrumb( \@crumb, $viewT3ResultsStr );

        &viewDPCreateResults($t3name, $viewT3ResultsURL);

}


sub viewDPCreateResults ()
{

my ( $t3Name, $refreshURL ) = @_ if @_;


    my $command = "/usr/bin/cat /tmp/se6900_cdp_$t3Name";
    my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 0 );
    if ( $retVal == 0)
    {
        print $stdout;
    }
    else
    {
        print "<br>No disk pool creations results were found for T3+ $t3Name.<br>";
    }

    print "<br></pre>";
    print "<a href=$refreshURL>$viewT3refresh</a>";


}


sub viewT3DPResults ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $viewT3DPResultsAction );

    my $t3name = `cat /tmp/t3ID`;

    my @crumb = ( [ $homeStr , $homeURL ],
                  [ $removeDiskPoolStr => $removeDiskPoolURL ]
                );
    print SE::WebUtil->createCrumb( \@crumb, $viewT3DPResultsStr );

    &viewDPRemoveResults($t3name, $viewT3DPResultsURL);

}


sub viewDPRemoveResults ()
{

    my ( $t3Name, $refreshURL ) = @_ if @_;


    my $command = "/usr/bin/cat /tmp/se6900_rdp_$t3Name";
    my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 0 );
    if ( $retVal == 0)
    {
        print $stdout;
    }
    else
    {
        print "<br>No disk pool remove results were found for T3+ $t3Name.<br>";
    }

    print "<br></pre>";
    print "<a href=$refreshURL>$viewT3refresh</a>";

}


sub viewT3DispResults ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $viewT3DispResultsAction );

    #if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    #{
    #    print  $indy6900OnlyStr;
    #    return;
    #}


        my @crumb = ( [ $homeStr , $homeURL ],
                      [ $dispStr => $dispURL ]
                    );
        print SE::WebUtil->createCrumb( \@crumb, $viewT3DispResultsStr );

        &viewT3DisplayResults(1, $viewT3DispResultsURL);

}


sub viewT3DisplayResults ()
{

my ( $num, $refreshURL ) = @_ if @_;


    my $command = "/usr/bin/cat /tmp/se6900_AllT3";
    my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 0 );
    if ( $retVal == 0)
    {
        print $stdout;
    }
    else
    {
        print "<br>No config info was found for All T3+(s) <br>";
    }

    print "<br></pre>";
    print "<a href=$refreshURL>$viewT3refresh</a>";



}


sub saveT3DispResults ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $saveT3DispResultsAction );

    #if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    #{
    #    print  $indy6900OnlyStr;
    #    return;
    #}


        my @crumb = ( [ $homeStr , $homeURL ],
                      [ $saveStr => $saveURL ]
                    );
        print SE::WebUtil->createCrumb( \@crumb, $saveT3DispResultsStr );

        &saveT3DisplayResults(1, $saveT3DispResultsURL);

}


sub saveT3DisplayResults ()
{

my ( $num, $refreshURL ) = @_ if @_;


    my $command = "/usr/bin/cat /tmp/se6900_AllSaveT3";
    my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 0 );
    if ( $retVal == 0)
    {
        print $stdout;
    }
    else
    {
        print "<br>No save info was found for All T3+(s) <br>";
    }

    print "<br></pre>";
    print "<a href=$refreshURL>$viewT3refresh</a>";



}


sub mpFailback ()
{

my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $mpAction,
                                                  $mpStr ) )
    {
        return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $dispAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
        return;
    }
   
    if ( $request->{$t3Param} )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
                      [ $mpStr, $mpURL ]
                    );
        print SE::WebUtil->createCrumb( \@crumb, $request->{$t3Param} );

        my $passwd = &getSavedT3Password ();

        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;

        my $command = "$T3UI::secfgBinDir/failbackt3path"
                    . " -n $request->{$t3Param}";

        SE::Util->execCmd2 ( $command, 1 );

        $ENV{PASSWD} = $prePasswd;
    }
    else
    {
        my @crumb = ( [ $homeStr, $homeURL ],
                      [ $mpStr, $mpURL ]
		     );
        print SE::WebUtil->createCrumb( \@crumb, $mpStr );

        #DAVID_NEEDS_LIB_T3
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ("NOALL");

        if ( $errStr )
        {
            print "<h3><pre>$errStr</pre></h3>";
	    return;
        }

        my @fields = (
            [ "static", $t3InUseStr, $busyStr ],
            [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
            );

        my @buttons = ( [ "DEFAULT", "Submit" ] );

        print SE::WebUtil->createForm ( $mpStr,
                                    $mpAction,
                                    \@buttons,
                                    \@fields );
    }

    print SE::WebUtil->createTail ();


} #end of mpFailback


sub dispConfig
{
    my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $dispAction, 
						  $dispStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $dispAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }
    
    if ( $request->{$t3Param} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $dispStr, $dispURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$t3Param} );

	#print SE::T3->getHTMLOutput ( 
				   #" for $request->{$t3Param}", 
				   #$request->{$t3Param},
				   #&getSavedT3Password () );

	my $passwd = &getSavedT3Password ();

	my $prePasswd = $ENV{PASSWD};
	$ENV{PASSWD} = $passwd ;

	my $command = "$T3UI::secfgBinDir/showt3"
		    . " -n $request->{$t3Param}";

	if ( $request->{$t3Param} eq "All" )
	{
		SE::Util->execCmdBGOutputToFile ( $command, 1, $viewT3DispResultsURL, "AllT3" );
	}
	else
	{
		SE::Util->execCmd2( $command, 1 );
	}

	$ENV{PASSWD} = $prePasswd;
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );
	print SE::WebUtil->createCrumb( \@crumb, $dispStr );

	#DAVID_NEEDS_LIB_T3 
	my ( $t3list, $busyStr, $errStr  ) = &getT3s ();

	if ( $errStr )
	{
	    print "<h3><pre>$errStr</pre></h3>";
	    return;
	}

	my @fields = ( 
	    [ "static", $t3InUseStr, $busyStr ],
	    [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
	    );

	my @buttons = ( [ "DEFAULT", "Display" ] );

	print SE::WebUtil->createForm ( $dispStr,
				    $dispAction,
				    \@buttons,
				    \@fields );
    }

    print SE::WebUtil->createTail ();
}


sub saveConfig ()
{
    my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $saveAction, 
						  $saveStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $saveAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    if ( $request->{$t3Param} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $saveStr, $saveURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $request->{$t3Param} );

	#USAGE 
	# savet3config -n t3b#[[,t3b2]|ALL] [-help]
	# where: 
	#   -help        - print usage
	#   -n <t3 list> - list of t3s to save
	#   -n ALL       - save all available T3s

	my $passwd = &getSavedT3Password ();

	my $prePasswd = $ENV{PASSWD};
	$ENV{PASSWD} = $passwd ;

	my $command = "$T3UI::secfgBinDir/savet3config"
		    . " -n $request->{$t3Param}";

	if ( $request->{$t3Param} eq "All" )
        {
                SE::Util->execCmdBGOutputToFile ( $command, 1, $saveT3DispResultsURL, "AllSaveT3");
        }
        else
        {
		my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );
        }


	$ENV{PASSWD} = $prePasswd;
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );

	print SE::WebUtil->createCrumb( \@crumb, $saveStr );

	#DAVID_NEEDS_LIB_T3 
	my ( $t3list, $busyStr, $errStr  ) = &getT3s ();

	if ( $errStr )
	{
	    print "<h3><pre>$errStr</pre></h3>";
	    return;
	}

	my @fields = ( 
	    [ "static", $t3InUseStr, $busyStr ],
	    [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
	    );

	my @buttons = ( [ "DEFAULT", "Save" ] );

	print SE::WebUtil->createForm ( $saveStr,
				    $saveAction,
				    \@buttons,
				    \@fields );
    }

    print SE::WebUtil->createTail ();
}


sub verifyConfig ()
{
    my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $verifyAction, 
						  $verifyStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $verifyAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    if ( $request->{$t3Param} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $verifyStr, $verifyURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $request->{$t3Param} );

	#DAVID_NEEDS_LIB 
	# my status = &verifyT3 ( $request->{$t3Param} );

	# USAGE
        # checkt3config -n t3b#[[,t3b2]|ALL] [-help]
        # where: 
        # -help        - print usage
        # -n <t3 list> - list of t3s to check
        # -n ALL       - check all available T3s 

	my $passwd = &getSavedT3Password ();

	my $prePasswd = $ENV{PASSWD};
	$ENV{PASSWD} = $passwd ;

	my $command = " $T3UI::secfgBinDir/checkt3config"
		    . " -n $request->{$t3Param} -v";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );

	$ENV{PASSWD} = $prePasswd;
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );

	print SE::WebUtil->createCrumb( \@crumb, $verifyStr );

	#DAVID_NEEDS_LIB_T3 
	my ( $t3list, $busyStr, $errStr  ) = &getT3s ();

	if ( $errStr )
	{
	    print "<h3><pre>$errStr</pre></h3>";
	    return;
	}

	my @fields = ( 
	    [ "static", $t3InUseStr, $busyStr ],
	    [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
	    );

	my @buttons = ( [ "DEFAULT", "Verify" ] );

	print SE::WebUtil->createForm ( $verifyStr,
				    $verifyAction,
				    \@buttons,
				    \@fields );
    }

    print SE::WebUtil->createTail ();
}


sub restoreConfig ()
{
    my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $restoreAction, 
						  $restoreStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $restoreAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr, $homeURL ] );

	print SE::WebUtil->createCrumb( \@crumb, $restoreStr );

	#DAVID_NEEDS_LIB_T3 
	my ( $t3list, $busyStr, $errStr  ) = &getT3s ();

	if ( $errStr )
	{
	    print "<h3><pre>$errStr</pre></h3>";
	    return;
	}

	my @fields = ( 
	    [ "static", $t3InUseStr, $busyStr ],
	    [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
	    [ "radio", $forceRestoreStr, $forceParam, \@yesno, 1 ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $restoreStr,
				    $restoreAction,
				    \@buttons,
				    \@fields );
				    #\%opts );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $restoreStr, $restoreURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Select Sun StorEdge T3+ Array LUN(s) to Restore" );

	my $lunCount;

	if ( $request->{$t3Param} eq $allStr )
	{
	    $lunCount = 4;
	}
	else
	{
	    my $cmd = "/usr/bin/cat"
	        . " /opt/SUNWsecfg/etc/$request->{$t3Param}/restore |"
	        . " /usr/bin/wc -l";

	    $lunCount = `$cmd`;
	    # this removes leading and ending spaces
	    $lunCount =~ s/^\s*(.*)\s$/$1/o;
	}

	my %lunHash = ( "1"=>"1" , "2"=>"2"  );

	if ( $lunCount eq "4" )
	{
	    %lunHash = ( "1"=>"1" , "2"=>"2", "3"=>"3", "4"=>"4"  );
	}

	my @fields = ( 
	    [ "static", $t3SelectedStr, $request->{$t3Param} ],
	    [ "hidden", $t3Param, $request->{$t3Param} ],

	    [ "static", $forceRestoreStr, $request->{$forceParam} ],
	    [ "hidden", $forceParam, $request->{$forceParam} ],

	    [ "checkbox", "Select which Sun StorEdge T3+ Array LUN(s) to restore.", 
			  $lunsParam, \%lunHash ],

	    [ "hidden", $stepParam, "3restore" ]
	    );

	my @buttons = ( [ "NOTUSED", "\"Restore Config\"", $warningLUN ] );
	my %opts = ( "longlived" => "2" );

	print SE::WebUtil->createForm ( $restoreStr,
				    $restoreAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "3restore" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $restoreStr, $restoreURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Restoring "
					  . $request->{$t3Param} );

	#USAGE 
        # restoret3config -n t3b#[[,t3b2]|ALL] 
        #                 -l [1,[2,[3..]]|ALL] [-f ] | [-help]
        #where: 
        #   -help         - print usage
        #   -f            - force a full restore, will reintialize all LUNs
        #   -n <t3 list>  - list of t3s to restore
        #   -l <lun list> - list of luns to restore
        #   -l ALL        - restore ALL luns 

	my $passwd = &getSavedT3Password ();

	my $prePasswd = $ENV{PASSWD};
	$ENV{PASSWD} = $passwd ;

	my $luns;

	if ( $request->{1} )
	{
	    if ( $luns )
	    {
		$luns = $luns . ",";
	    }
	    $luns .= "1";
	}
	if ( $request->{2} )
	{
	    if ( $luns )
	    {
		$luns = $luns . ",";
	    }
	    $luns .= "2";
	}
	if ( $request->{3} )
	{
	    if ( $luns )
	    {
		$luns = $luns . ",";
	    }
	    $luns .= "3";
	}
	if ( $request->{4} )
	{
	    if ( $luns )
	    {
		$luns = $luns . ",";
	    }
	    $luns .= "4";
	}

	if ( !$luns )
	{
	    print ( "<h2>No luns were selected.</h2>" );
	    return;
	} 

	my $forceFlag;

	if ( $request->{$forceParam} eq $yesStr )
	{
	    $forceFlag = " -f";
	}

	my $command; 

	if ( $request->{$t3Param} eq $allStr )
	{
	    my ( $t3list, $busyStr,$errStr  ) = &getT3s ();
             if ( $errStr )
             {
                   print "<h3><pre>$errStr</pre></h3>";
                   return;
             }

        print "<br><h2>All T3+ are being restored in the background </h2>";
        print "<h2>To check progress click on : </h2> <a href=$busyURL> View the Results";
        print "</a> </br>";

	    foreach my $oneT3 ( @$t3list )
	    {
		if ( $oneT3 ne $allStr )
		{
		    $command 
			= " $T3UI::secfgBinDir/restoret3config "
			. " -n $oneT3 " #key diff
			. $forceFlag
			. " -l $luns " ;


              SE::Util->execCmdBGOutputToFile ( $command, 0, $busyURL,$oneT3 );

		   # SE::Util->execCmdBG ( $command, 1,
		#	  "You may monitor its status in the"
		#	. " \"T3+ $busyStr\" and \"View Log\" sections." );
#
		    #print "--$command--";
		}
	    }
	}
	else
	{
	    $command 
		= " $T3UI::secfgBinDir/restoret3config "
		. " -n $request->{$t3Param} " #key diff
		. $forceFlag
		. " -l $luns " ;

        SE::Util->execCmdBGOutputToFile ( $command, 1, $busyURL,$request->{$t3Param} );

#	    SE::Util->execCmdBG ( $command, 1,
#		  "You may monitor its status in the"
#		. " \"T3+ $busyStr\" and \"View Log\" sections." );
	    #print "--$command--";
	}

	$ENV{PASSWD} = $prePasswd;
    }

    print SE::WebUtil->createTail ();
}


sub busyUnits ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $busyAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    if ( $request->{$t3Param} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $busyStr, $busyURL] );
	print SE::WebUtil->createCrumb( \@crumb, 
					$request->{$t3Param} );
	my $catCmd = "/usr/bin/cat /tmp/se6900_$request->{$t3Param}";
	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $catCmd, 0 );

	if ( $retVal == 0)
	{
	    print $stdout;
	    print "</pre><br><br>";
	    print "<a href=$busyURL&$t3Param=$request->{$t3Param}>Refresh</a>";
	}
	else
	{
	    print "<br>No configuration results were found"
	        . " for $request->{$t3Param}.<br>";
	}
	return;
    }

    my @crumb = ( [ $homeStr, $homeURL ] );
    print SE::WebUtil->createCrumb( \@crumb, $busyStr );

    my $cmd=`ls -a /opt/SUNWsecfg/etc/.t3*lock 2>/dev/null`;

    #
    # example file "/opt/SUNWsecfg/etc/.t3b0.lock";
    #

    my @t3locklist = split ' ', $cmd;

    if ( @t3locklist )
    {
	print "<h2>The following Sun StorEdge T3+ Array(s) are"
		    . " being configured or restored.</h2>";

	my $htmlList .= "\n<table border=1 width=90% cellpadding=5 >";

	foreach my $item (@t3locklist)
	{
	    $item =~s/\/opt\/SUNWsecfg\/etc\/\.//g;
	    $item =~s/\.lock//g;
	    $htmlList .= "\n<tr><td>"
		      .  $item;

	    $htmlList .= "</td></tr>"
	}

	$htmlList .= "</table>\n";
	print $htmlList;
    }
    else
    {
	print "<h2>Currently no Sun StorEdge T3+ Array(s) are"
	    . " being configured or restored.</h2>";
    }

    my $doneCmd=`ls -a /tmp/se6900_t3* 2>/dev/null`;
    my @t3donelist = split ' ', $doneCmd;

    if ( @t3donelist )
    {
	print "<h2>You may view the Progress/Results of"
	    . " the last operations"
	    . " on the following StorEdge T3+ Array(s).</h2>";

	my $htmlList .= "\n<table border=1 width=90% cellpadding=5 >";

	foreach my $item (@t3donelist)
	{
	    $item =~s/\/tmp\/se6900_//g;

	    $htmlList .= "\n<tr><td>"
		      .  $item
		      .  "<br>";

	    $htmlList .= "\n<td>"
		      .  "<a href=$busyURL&$t3Param=$item>View"
		      .  " Results/Progress</a>"
		      .  "</td>"
		      .  "<br>";
	    $htmlList .= "</td></tr>"
	}

	$htmlList .= "</table>\n";
	print $htmlList;
    }

    print SE::WebUtil->createTail ();
}


sub modifySys ()
{
    my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $modifySysAction,
						  $modifySysStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $modifySysAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr, $homeURL ] );
	print SE::WebUtil->createCrumb( \@crumb, $modifySysStr );

	## DAVID_NEEDS_LIB for list of t3s
	my ( $t3list, $busyStr, $errStr  ) = &getT3s ();

	if ( $errStr )
	{
	    print "<h3><pre>$errStr</pre></h3>";
	    return;
	}

	my @fields = ( 
		[ "static", $t3InUseStr, $busyStr ],
		[ "radio", $t3AvailStr, $t3Param, \@$t3list ],
		[ "hidden", $stepParam, "2modparam" ],
		);

	my @buttons = ( [ "NOTUSED", "Next" ],
		      );

	print SE::WebUtil->createForm ( $modifySysStr,
				    $modifySysAction,
				    \@buttons,
				    \@fields );
    }
    elsif ( $request->{$stepParam} eq "2modparam" )
    {
	my @crumb = ( [ $homeStr, $homeURL ] );
	print SE::WebUtil->createCrumb( \@crumb, $modifySysStr );

	my @raidLevels = ( "5", "1", "1,5" );
# Update for BugID 4935931: Add No Change to sys param options
	my @readAhead = ( "No Change", "off", "on" );
	my @reconRate = ( "No Change", "med", "low", "high" );
	
	my @fc3900 = ("No Change", "auto","loop","fabric_p2p");
	my @fc6900 = ("No Change", "auto","loop");

	my @mp3900 = ( "No Change", "mpxio", "rw","none" );
	my $mp6900 = "rw";
	my $mp6965 = "mpxio";

	my @fields;

	if ( SE::WebUtil->checkForIndy ( 0, "39" ) )
	{
	    @fields = ( 
		[ "static", $t3SelectedStr, $request->{$t3Param} ],
		[ "hidden", $t3Param, $request->{$t3Param} ],

		[ "radio", "Read Ahead:", $readaheadParam, \@readAhead ],
		[ "radio", "Recon Rate:", $reconRateParam, \@reconRate ],
		[ "radio", "NACA Flag:", $nacaParam, \@readAhead ],
		[ "radio", "MP Support:", $mpParam, \@mp3900 ],
		[ "radio", "FC_Topology:", $fcParam, \@fc3900 ],

		);
	}
	elsif ( SE::WebUtil->checkForIndy ( 0, "6965" ) )
	{
	    @fields = ( 
		[ "static", $t3SelectedStr, $request->{$t3Param} ],
		[ "hidden", $t3Param, $request->{$t3Param} ],

		[ "radio", "Read Ahead:", $readaheadParam, \@readAhead ],
		[ "radio", "Recon Rate:", $reconRateParam, \@reconRate ],
		[ "radio", "FC_Topology:", $fcParam, \@fc3900 ],

		);
	}
	else
	{
	    @fields = ( 
		[ "static", $t3SelectedStr, $request->{$t3Param} ],
		[ "hidden", $t3Param, $request->{$t3Param} ],

		[ "radio", "Read Ahead:", $readaheadParam, \@readAhead ],
		[ "radio", "Recon Rate:", $reconRateParam, \@reconRate ],
		[ "radio", "FC_Topology:", $fcParam, \@fc6900 ],

		);
	}

# Update for BugID 4936849: add options if selected T3(s) running 3.1 or later
	my $t3_31Flag = 1;
	my @checkList = ();
	if ($request->{$t3Param} =~ /all/i) 
	{
		my ( $t3list, $busyStr, $errStr  ) = &getT3s ("NOALL");
		@checkList = @$t3list;
	}
	else
	{
		@checkList = ("$request->{$t3Param}");
	}
	my $revision;
	foreach my $t3 (@checkList)
	{
		$revision = &getT3Revision($t3);
		if($revision < "030100") 
		{
			$t3_31Flag = 0;
			last;
		}
	}
	my @diskScrubber = ();
	my @ondg = ();
        if ($t3_31Flag) {
           @diskScrubber = ("No Change", "off", "on");
           @ondg = ("No Change", "befit", "off");
           push(@fields,[ "radio", "Disk_Scrubber:", $dsParam, \@diskScrubber ]);
           push(@fields,[ "radio", "Ondg:", $ondgParam, \@ondg ]);
        }
	push(@fields,[ "static", "NOTE :", "Default settings are adjacent to the \"No Change\" option." ]);
	push(@fields,[ "hidden", $stepParam, "3modparam" ]);
	my @buttons = ( [ "NEXT", "\"Modify Parameters\"" ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $modifySysStr,
				    $modifySysAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "3modparam" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $modifySysStr, $modifySysURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $request->{$t3Param} );

	# USAGE
        #modifyt3params -n t3b#[[,t3b2]|ALL] [-r read_ahead] 
        #                      [-m mpxio] [-c naca] | [-h]
        # where: 
        #     -n <t3 list>   - list of T3+s to modify
        #     -n ALL         - modify all available T3+s 
        #     -r read_ahead  - set read_ahead_flag,valid options: off or on  
        #     -c naca_flag   - set naca_flag, valid options are:  off or on 
        #     -m mpxio_flag  - set mpxio_flag, valid options:  rw or mpxio 
        #     -o recon_rate  - set recon_rate, valid options:med or low or high
        #     -t fc_topology  - set fc_topology, valid options:auto or loop or fabric_p2p 
        #     -h             - print usage

	my $passwd = &getSavedT3Password ();

	my $prePasswd = $ENV{PASSWD};
	$ENV{PASSWD} = $passwd ;

	my $command = " $T3UI::secfgBinDir/modifyt3params"
		    . " -n $request->{$t3Param}";
	$command .= " -o $request->{$reconRateParam}" if($request->{$reconRateParam} !~ /No Change/);
	$command .= " -t $request->{$fcParam}" if($request->{$fcParam} !~ /No Change/);
	$command .= " -r $request->{$readaheadParam}" if($request->{$readaheadParam} !~ /No Change/);
	$command .= " -s $request->{$dsParam}" if($request->{$dsParam} && $request->{$dsParam} !~ /No Change/);
	$command .= " -d $request->{$ondgParam}" if($request->{$ondgParam} && $request->{$ondgParam} !~ /No Change/);
	if ( $request->{$mpParam} ) #for 3900
	{
	    $command .= " -m $request->{$mpParam}" if ($request->{$mpParam} !~ /No Change/);
	}

	if ( $request->{$nacaParam} ) #for 3900
	{
	    $command .= " -c $request->{$nacaParam}" if ($request->{$nacaParam} !~ /No Change/);
	}

# Determine if any sys params have been changed. If not, skip modifyt3params.
# Update for BugID 4935931
	my $modify = 0;
	foreach my $key ("$readaheadParam", "$mpParam", "$fcParam", "$reconRateParam", "$dsParam", "$ondgParam", "$nacaParam")
	{
		if($request->{$key} && $request->{$key} !~ /No Change/)
		{
			$modify = 1;
			last;
		}
	}
	if($modify)
	{
		my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );
	}
	else
	{
		print "<h3><pre>No T3+ system parameters were changed.</pre></h3>";
	}

	$ENV{PASSWD} = $prePasswd;
    }

    print SE::WebUtil->createTail ();
}


sub startConfig ()
{
    my ( $request ) = @_ if @_;
    my @crumb = ( [ $homeStr, $homeURL ] );

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $configAction,
						  $configStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $configAction );
    print SE::WebUtil->createCrumb( \@crumb, $configStr );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    ## DAVID_NEEDS_LIB for list of t3s
    my ( $t3list, $busyStr, $errStr  ) = &getT3s ();

    if ( $errStr )
    {
	print "<h3><pre>$errStr</pre></h3>";
	return;
    }

    my @fields = ( 
	[ "static", $t3InUseStr, $busyStr ],
	[ "radio", $t3AvailStr, $t3Param, \@$t3list ]
	);

    my @buttons = ( [ "DEFAULT", "Default Config" ],
		    [ "CUSTOM", "Custom Config"]
		  );

    print SE::WebUtil->createForm ( $customConfigStr,
				$chooseAction,
				\@buttons,
				\@fields );

    print SE::WebUtil->createTail ();
}


sub chooseDefaultOrCustom ()
{
    my ( $request ) = @_;

    if ( $request->{CUSTOM} ne "" )
    {
	&customConfig ( @_ );
    }
    else
    {
	&defaultConfig( @_ );
    }
}


sub defaultConfig ()
{
    my ( $request ) = @_;

    my $selectedT3 = $request->{$t3Param};

    my @crumb = ( [ $homeStr , $homeURL ],
		  [ $configStr => $configURL ]
		);

    print SE::WebUtil->createHead ( );
    print SE::WebUtil->createStorAdeHeader ( $configAction );
    print SE::WebUtil->createCrumb( \@crumb, $defaultConfigStr );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    # flib/t3menu sets these as defualts
    #    ALLraidnum=5
    #    ALLluncount=2
    #    ALLrdhad=off
    #    if [[ $cabtype -eq 3910 || $cabtype -eq 3960 ]];then
    #    ALLmpname=mpxio
    #    else
    #    ALLmpname=rw
    #    fi #end of if [[ $cabtype -eq 3910 || $cabtype -eq 3960 ]]
    #    ALLblksize=16k  

    my $tmpRaid = "5";
    my $tmpLUNS = "2";
    my $tmpMP = "rw";
    my $tmpRead = "off";
    my $tmpBlok = "16k";

    if ( SE::WebUtil->checkForIndy ( 0, "39|6965" ) )
    {
	$tmpMP = "mpxio";
    }

    my @fields = ( 
	[ "static", $t3SelectedStr, $request->{$t3Param} ],
	[ "hidden", $t3Param, $request->{$t3Param} ],
	[ "static", "Configuration:", "Default" ],

	[ "static", "RAID Level:", $tmpRaid ],
	[ "hidden", $raidParam, $tmpRaid ],

	[ "static", "LUNs:", $tmpLUNS ],
	[ "hidden", $lunsParam, $tmpLUNS ],

	[ "static", "Read Ahead:", $tmpRead ],
	[ "hidden", $readaheadParam, $tmpRead ],

	[ "static", "MP Support:", $tmpMP ],
	[ "hidden", $mpParam, $tmpMP ],

	[ "static", "Blocksize:", $tmpBlok ],
	[ "hidden", $blocksizeParam, $tmpBlok ],

	);

    my @buttons = ( [ "NEXT", "\"Perform Config\"", $warning ] );
    my %opts = ( "longlived" => "2" );

    print SE::WebUtil->createForm ( $customConfigStr,
				$commitAction,
				\@buttons,
				\@fields,
				\%opts );

    print SE::WebUtil->createTail ();
}


sub customConfig ()
{
    my ( $request ) = @_;

    my $selectedT3 = $request->{$t3Param};

    my @crumb = ( [ $homeStr , $homeURL ],
		  [ $configStr => $configURL ]
		);

    my $versionFlag = 0;
    my @vers = split /\s+/, System->getPackageInfo("","SUNWsecfg", "VERSION");
    my $version = $vers[1];
    @vers = split /\./, $version;
    if (($vers[0] > 1) || (($vers[0] = 1) && ($vers[1] >= 6)))
    {
	$versionFlag = 1;
    }

    my $javascriptFunc;
    if (! $versionFlag)
    {
       $javascriptFunc = "
       <script>
       function checkRaid ()
       {
	    if ( document.forms[0].luns[0].checked       // (2 Luns)
		 && document.forms[0].raid[2].checked )  // (Raid 1,5)
	    {
		alert ( \"Raid 1 & 5 is limited to 4 luns\" );
		document.forms[0].luns[1].checked=true;  // (4 Luns)
	    }
	} 
       </script>
       ";
    }
    else
    {
       $javascriptFunc = "
       <script>
       function checkRaid ()
       {
	    if ( ( document.forms[0].luns[0].checked     // (2 Luns w/ spare)
		 || document.forms[0].luns[1].checked )  // (2 Luns w/o spare)
		 && document.forms[0].raid[2].checked )  // (Raid 1,5)
	    {
		alert ( \"Raid 1 & 5 is limited to 4 luns\" );
		document.forms[0].luns[2].checked=true;  // (4 Luns)
	    }
	} 
       </script>
       ";
    }

    print SE::WebUtil->createHead ( $javascriptFunc );
    print SE::WebUtil->createStorAdeHeader ( $configAction );
    print SE::WebUtil->createCrumb( \@crumb, $customConfigStr );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    my @raidLevels = ( "5", "1", "1,5" );

    my @lunCount;
    if (! $versionFlag)
    {
	@lunCount = ( "2", "4" );
    }
    else
    {
	@lunCount = ( "2 (with hot spare)", "2 (without hot spare)", "4 (with hot spare)" );
    }
    my @readAhead = ( "off", "on" );
# Update for BugID 4936849: add options if selected T3(s) running 3.1 or later
    my @blockSize = ();
    my $t3_31Flag = 1;
    my @checkList = ();
    if ($request->{$t3Param} =~ /all/i) 
    {
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ("NOALL");
        @checkList = @$t3list;
    }
    else
    {
        @checkList = ("$request->{$t3Param}");
    }
    my $revision;
    foreach my $t3 (@checkList)
    {
        $revision = &getT3Revision($t3);
        if($revision < "030100") 
        {
            $t3_31Flag = 0;
            last;
        }
    }
    if (! $t3_31Flag) {
       @blockSize = ( "16k", "32k", "64k" );
    }
    else
    {
#      @blockSize = ( "4k", "8k", "16k", "32k", "64k" );
       @blockSize = ( "16k", "32k", "64k" );
    }
    my $javascript = "onClick='checkRaid();'";

    my @mp3900 = ( "mpxio", "rw", "none" );
    my $mp6900 = "rw";
    my $mp6965 = "mpxio";

    my @fields;
    
    if ( SE::WebUtil->checkForIndy ( 0, "39" ) )
    {
         @fields = ( 
	[ "static", $t3SelectedStr, $request->{$t3Param} ],
	[ "hidden", $t3Param, $request->{$t3Param} ],
	[ "static", "Configuration:", "Custom" ],
	[ "radio", "RAID Level:", $raidParam, \@raidLevels, $javascript ],
	[ "radio", "Sun StorEdge T3+ Array LUNs:", $lunsParam, \@lunCount, $javascript ],
	[ "radio", "Read Ahead:", $readaheadParam, \@readAhead ],
	[ "radio", "MP Support:", $mpParam, \@mp3900 ],
	[ "radio", "Blocksize:", $blocksizeParam, \@blockSize ]
	);
    }
    elsif ( SE::WebUtil->checkForIndy ( 0, "6965" ) )
    {
         @fields = ( 
	[ "static", $t3SelectedStr, $request->{$t3Param} ],
	[ "hidden", $t3Param, $request->{$t3Param} ],
	[ "static", "Configuration:", "Custom" ],
	[ "radio", "RAID Level:", $raidParam, \@raidLevels, $javascript ],
	[ "radio", "Sun StorEdge T3+ Array LUNs:", $lunsParam, \@lunCount, $javascript ],
	[ "radio", "Read Ahead:", $readaheadParam, \@readAhead ],
	[ "static", "MP Support:", $mp6965 ],
	[ "hidden", $mpParam, $mp6965 ],
	[ "radio", "Blocksize:", $blocksizeParam, \@blockSize ]
	);
    }
    else
    {
         @fields = ( 
	[ "static", $t3SelectedStr, $request->{$t3Param} ],
	[ "hidden", $t3Param, $request->{$t3Param} ],
	[ "static", "Configuration:", "Custom" ],
	[ "radio", "RAID Level:", $raidParam, \@raidLevels, $javascript ],
	[ "radio", "Sun StorEdge T3+ Array LUNs:", $lunsParam, \@lunCount, $javascript ],
	[ "radio", "Read Ahead:", $readaheadParam, \@readAhead ],
	[ "static", "MP Support:", $mp6900 ],
	[ "hidden", $mpParam, $mp6900 ],

	[ "radio", "Blocksize:", $blocksizeParam, \@blockSize ]
	);
    }

    my @buttons = ( [ "NEXT", "\"Perform Config\"", $warning ] );
    my %opts = ( "longlived" => "2" );

    print SE::WebUtil->createForm ( $customConfigStr,
				$commitAction,
				\@buttons,
				\@fields,
				\%opts );

    print SE::WebUtil->createTail ();

}


sub commitConfig ()
{
    my ( $request ) = @_ if @_;

    my @crumb = ( [ $homeStr , $homeURL ],
		  [ $configStr => $configURL ]
		);

    print SE::WebUtil->createHead ( );
    print SE::WebUtil->createStorAdeHeader ( $configAction );
    print SE::WebUtil->createCrumb( \@crumb, "Configuring T3+" );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    #print "call config with:";
    #print "<br>T3: ";
    #print $request->{$t3Param};
    #print "<br>Raid: ";
    #print $request->{$raidParam};
    #print "<br>LUNs: ";
    #print $request->{$lunsParam};
    #print "<br>Read Ahead: ";
    #print $request->{$readaheadParam};
    #print "<br>Blocksize: ";
    #print $request->{$blocksizeParam};
    
    #USAGE 
    #modifyt3config -n t3b#[[,t3b2]|ALL] -c [2|4] -r [1|5|1,5] 
	   #[-m rw|mpxio] [-a on|off] [-b 16k[32k][64k] [-help]
    #where: 
    #   -help        - print usage
    #   -n <t3 list> - list of t3s to modify
    #   -c 2         - create one LUN per T3, 2 LUNs per Partner Pair
    #      4         - create two LUNs per T3, 4 LUNs per Partner Pair
    #   -r 1         - create RAID 1 type of LUN  
    #      5         - create RAID 5 type of LUN  
    #      1,5       - create RAID 1 & 5 type of LUNs, vaild with -c 4 only
    #   -m rw|mpxio      - optional, sets mp_support flag 
    #   -a on|off        - optional, sets read_ahead flag 
    #   -b 16k|32k|64k   - optional, sets blocksize 

    my $passwd = &getSavedT3Password ();

    my $prePasswd = $ENV{PASSWD};
    $ENV{PASSWD} = $passwd ;

    my $command;

    if ( $request->{$t3Param} eq $allStr )
    {
	my ( $t3list, $busyStr, $errStr  ) = &getT3s ();

	if ( $errStr )
	{
	    print "<h3><pre>$errStr</pre></h3>";
	    return;
	}

        print "<br><h2>All T3+ are being configured in the background </h2>";
        print "<h2>To check progress click on : </h2> <a href=$busyURL> View the Results";
        print "</a> </br>";

	foreach my $oneT3 ( @$t3list )
	{
	    if ( $oneT3 ne $allStr )
	    {
		my $lunString = $request->{$lunsParam};
		if ($lunString =~ /without hot spare/)
		{
		    $lunString = "2 -d";     #Pass parameter for no spare drive
		}
		elsif ($lunString =~ /with hot spare/)
		{
		    if ($lunString =~ /2/)
		    {
		       $lunString = "2";
		    }
		    else
		    {
		       $lunString = "4";
		    }
		}
		$command 
		    = " $T3UI::secfgBinDir/modifyt3config"
		    . " -n $oneT3"  #key difference
		    . " -c $lunString"
		    . " -r $request->{$raidParam}"
		    . " -m $request->{$mpParam} "
		    . " -a $request->{$readaheadParam}"
		    . " -b $request->{$blocksizeParam}" ;

                SE::Util->execCmdBGOutputToFile ( $command, 0, $busyURL,$oneT3 );

		#SE::Util->execCmdBG ( $command, 1,
		#          "You may monitor its status in the"
		#	. " \"T3+ $busyStr\" and \"View Log\" sections." );
		#print "<br> about to config $command";
	    }
	}
    }
    else
    {
        my $lunString = $request->{$lunsParam};
        if ($lunString =~ /without hot spare/)
        {
	    $lunString = "2 -d";             #Pass parameter for no spare drive
        }
        elsif ($lunString =~ /with hot spare/)
        {
	    if ($lunString =~ /2/)
	    {
	       $lunString = "2";
	    }
	    else
	    {
	       $lunString = "4";
	    }
        }
        $command  
	    = " $T3UI::secfgBinDir/modifyt3config"
	    . " -n $request->{$t3Param}" 
	    . " -c $lunString"
	    . " -r $request->{$raidParam}"
	    . " -m $request->{$mpParam} "
	    . " -a $request->{$readaheadParam}"
	    . " -b $request->{$blocksizeParam}" ;

	#SE::Util->execCmdBG ( $command, 1,
	              #"You may monitor its status in the"
		    #. " \"T3+ $busyStr\" and \"View Log\" sections." );

	SE::Util->execCmdBGOutputToFile ( $command, 1, $busyURL,$request->{$t3Param} );
	#SE::Util->execCmdBGOutputToFile ( "/usr/bin/ls /tmp", 1, $busyURL,
		#$request->{$t3Param} );
    }

    $ENV{PASSWD} = $prePasswd;
}


sub manageLunMasking()
{
    my @crumb = ( [ $homeStr, $homeURL ] );

    print SE::WebUtil->createHead ();

    if ( ! SE::WebUtil->checkForIndy ( 1, "39" ) )
    {
    	print SE::WebUtil->createCrumb( \@crumb, $lunMaskStr );
        print  $indy3900OnlyStr;
	return;
    }
    else
    {

    	print SE::WebUtil->createStorAdeHeader ( $lunMaskAction );
    	print SE::WebUtil->createCrumb( \@crumb, $lunMaskStr );
    	print "<br>";
    	print "<a href=$showSliceURL >$showMaskStr";
    	print "</a>";
    	print "<br>";
    	print "<br>";
    	print "<a href=$createT3GroupURL >$createT3GroupStr";
    	print "</a>";
    	print "<br>";
    	print "<br>";
    	print "<a href=$removeT3GroupURL >$removeT3GroupStr";
    	print "</a>";
    	print "<br>";
    	print "<br>";
    	print "<a href=$addToT3GroupURL >$addToT3GroupStr";
    	print "</a>";
    	print "<br>";
    	print "<br>";
    	print "<a href=$delFromT3GroupURL >$delFromT3GroupStr";
    	print "</a>";
    	print "<br>";
    	print "<br>";
    	print "<a href=$setT3LunPermURL >$setT3LunPermStr";
    	print "</a>";
    	print "<br>";
	print "<br>";
    } #end of if ( SE::WebUtil->checkForIndy ( 1, "69" ) )

    print SE::WebUtil->createTail ();
}


sub createT3Group()
{

    my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $createT3GroupAction,
                                                  $createT3GroupStr ) )
    {
        return;
    }
    # end password check


    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $createT3GroupAction );

   if ($request->{$stepParam} eq "" )
    {

	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ]
		     );

        print SE::WebUtil->createCrumb( \@crumb, $createT3GroupStr );

        #DAVID_NEEDS_LIB_T3
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ("NOALL");

        if ( $errStr )
        {
            print "<h3><pre>$errStr</pre></h3>";
	    return;
        }


        my @fields = (
            [ "static", $t3InUseStr, $busyStr ],
            [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
	    [ "radio", "Do you want to set permissions for a Sun StorEdge T3+ Array LUN to this group now :", $forceParam, \@yesno ],
	    [ "hidden", $stepParam, "1" ]
            );

        my @buttons = ( [ "DEFAULT", "Next" ] );

        print SE::WebUtil->createForm ( $createT3GroupStr,
                                    $createT3GroupAction,
                                    \@buttons,
                                    \@fields );

    }
   elsif ( $request->{$stepParam} eq "2" )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
                      [ $lunMaskStr, $lunMaskURL ],
                      [ $createT3GroupStr, $createT3GroupURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, $request->{$t3Param} );

        #USAGE
	#createt3group -n <t3b name> -g <group_name> -w <wwn>
 	#where: 
        # -n <t3b name>         - T3b name on which group to be created
        # -g <group_name>       - group name to be created 
        # -w <HBA wwn>          - add wwn to the created group

        my $passwd = &getSavedT3Password ();

        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;

	my $optArg;
	if ( $request->{$forceParam} eq "Yes" )
	{
		$optArg = "-l $request->{$lunNameParam} -p $request->{$permNameParam}";
	}
	else
	{
		$optArg = "";
	}

        my $command = "$T3UI::secfgBinDir/createt3group -v"
                    . " -n $request->{$t3Param}"
		    . " -g  $request->{$gNameParam}"
		    . " -w  $request->{$wwnNameParam}"
		    . " $optArg";

        my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );

        $ENV{PASSWD} = $prePasswd;
    }
   elsif ( $request->{$stepParam} eq "1" )
    {
    my @crumb = ( [ $homeStr, $homeURL ] ,
		  [ $lunMaskStr, $lunMaskURL ],
		  [ $createT3GroupStr, $createT3GroupURL ]
		);

        print SE::WebUtil->createCrumb( \@crumb, $createT3GroupStr );


	my @lunList = &getLunList ($request->{$t3Param},"NOALL");

        if($#lunList < 0 ) {

            print "<h3><pre>No Slice existing on T3, create T3 slices before adding to group</pre></h3>";
            return;
         }

	my @permList = ("rw", "ro", "none");

	my @fields;

	if ( $request->{$forceParam} eq "Yes" )
	{
        @fields = (
	    [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],
            [ "hidden", $forceParam, $request->{$forceParam} ],
	    [ "text", "Enter group name :",$gNameParam,"","16","15" ],
	    [ "text", "Enter the wwn name :",$wwnNameParam,"","17","16" ],
	    [ "radio", "Select Lun :", $lunNameParam, \@lunList ],

	    [ "radio", "Select Permission :", $permNameParam, \@permList ],
	    [ "hidden", $stepParam, "2" ]
            );
	}
	else
	{
        @fields = (
	    [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],
            [ "hidden", $forceParam, $request->{$forceParam} ],
	    [ "text", "Enter group name :",$gNameParam,"","16","15" ],
	    [ "text", "Enter the wwn name :",$wwnNameParam,"","17","16" ],
	    [ "hidden", $stepParam, "2" ]
            );
	}

        my @buttons = ( [ "DEFAULT", "Create" ] );

        print SE::WebUtil->createForm ( $createT3GroupStr,
                                    $createT3GroupAction,
                                    \@buttons,
                                    \@fields );
    }

    print SE::WebUtil->createTail ();


} #end of sub createT3Group



sub removeT3Group()
{

    my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $removeT3GroupAction,
                                                  $removeT3GroupStr ) )
    {
        return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $removeT3GroupAction );

    if ( $request->{$stepParam} eq "" )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ]
		    );

        print SE::WebUtil->createCrumb( \@crumb, $removeT3GroupStr );

        #DAVID_NEEDS_LIB_T3
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ("NOALL");

        if ( $errStr )
        {
            print "<h3><pre>$errStr</pre></h3>";
	    return;
        }

        my @fields = (
            [ "static", $t3InUseStr, $busyStr ],
            [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
            [ "hidden", $stepParam, "1" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );
	print SE::WebUtil->createForm ( $removeT3GroupStr,
                                    $removeT3GroupAction,
                                    \@buttons,
                                    \@fields );
                                    #\%opts );
    }
    elsif ( $request->{$stepParam} eq "1" )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ],
                      [ $removeT3GroupStr, $removeT3GroupURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Remove Group(s) for $request->{$t3Param}" );
	
	my @gList = &getGroups ($request->{$t3Param}, "ALL");

        if($#gList < 0 ) {

            print "<h3><pre>No Groups existing on T3, can not remove group</pre></h3>";
            return;
         }


	my @fields = (
            [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],

	    [ "radio", "Select Group :", $gNameParam, \@gList ],


            [ "hidden", $stepParam, "2" ]
            );

        my @buttons = ( [ "NOTUSED", "Remove"] );
   	print SE::WebUtil->createForm ( $removeT3GroupStr,
                                    $removeT3GroupAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "2" )
   {

	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ],
                      [ $removeT3GroupStr, $removeT3GroupURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Removing Group(s) for "
                                          . $request->{$t3Param} );
	#USAGE
        # rmt3group -n t3b#
        #                 -g group_name [-f ] | [-help]

	my $passwd = &getSavedT3Password ();

        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;
	
	my $command = " $T3UI::secfgBinDir/rmt3group -v"
                    . " -n $request->{$t3Param}"
                    . " -g $request->{$gNameParam}";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );

        $ENV{PASSWD} = $prePasswd;
   }

   print SE::WebUtil->createTail ();

} #end of sub removeT3Group



sub addToT3Group()
{

    my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $addToT3GroupAction,
                                                  $addToT3GroupStr ) )
    {
        return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $addToT3GroupAction );

    if ( $request->{$stepParam} eq "" )
    {
        my @crumb = ( [ $homeStr, $homeURL ] ,
		      [ $lunMaskStr, $lunMaskURL ]	
		    );

        print SE::WebUtil->createCrumb( \@crumb, $addToT3GroupStr );

        #DAVID_NEEDS_LIB_T3
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ("NOALL");

        if ( $errStr )
        {
            print "<h3><pre>$errStr</pre></h3>";
	    return;
        }

        my @fields = (
            [ "static", $t3InUseStr, $busyStr ],
            [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
            [ "hidden", $stepParam, "1" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );
	print SE::WebUtil->createForm ( $addToT3GroupStr,
                                    $addToT3GroupAction,
                                    \@buttons,
                                    \@fields );
                                    #\%opts );
    }
    elsif ( $request->{$stepParam} eq "1" )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ],
                      [ $addToT3GroupStr, $addToT3GroupURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Select group name " );
	
	my @gList = &getGroups ($request->{$t3Param});

	my @fields = (
            [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],

	    [ "radio", "Select Group :", $gNameParam, \@gList ],

	    [ "text", "Enter the wwn name :",$wwnNameParam,"","17","16" ],

            [ "hidden", $stepParam, "2" ]
            );

        my @buttons = ( [ "NOTUSED", "Add"] );
   	print SE::WebUtil->createForm ( $addToT3GroupStr,
                                    $addToT3GroupAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "2" )
   {

	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ],
                      [ $addToT3GroupStr, $addToT3GroupURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Add wwn to T3+ group ");
	#USAGE
        # addtot3group -n t3b#
        #                 -g group_name -w wwnname [-f ] | [-help]

	my $passwd = &getSavedT3Password ();

        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;
	
	my $command = " $T3UI::secfgBinDir/addtot3group -v"
                    . " -n $request->{$t3Param}"
                    . " -g $request->{$gNameParam}"
                    . " -w $request->{$wwnNameParam}";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );

        $ENV{PASSWD} = $prePasswd;
   }

   print SE::WebUtil->createTail ();


} #end of sub addToT3Group



sub delFromT3Group()
{

 my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $delFromT3GroupAction,
                                                  $delFromT3GroupStr ) )
    {
        return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $delFromT3GroupAction );

    if ( $request->{$stepParam} eq "" )
    {
        my @crumb = ( [ $homeStr, $homeURL ] ,
		      [ $lunMaskStr, $lunMaskURL ]
		     );

        print SE::WebUtil->createCrumb( \@crumb, $delFromT3GroupStr );

        #DAVID_NEEDS_LIB_T3
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ("NOALL");

        if ( $errStr )
        {
            print "<h3><pre>$errStr</pre></h3>";
	    return;
        }

        my @fields = (
            [ "static", $t3InUseStr, $busyStr ],
            [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
            [ "hidden", $stepParam, "1" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );
	print SE::WebUtil->createForm ( $delFromT3GroupStr,
                                    $delFromT3GroupAction,
                                    \@buttons,
                                    \@fields );
                                    #\%opts );
    }
    elsif ( $request->{$stepParam} eq "1" )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ],
                      [ $delFromT3GroupStr, $delFromT3GroupURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Select group " );
	
	my @gList = &getGroups ($request->{$t3Param});

	my @fields = (
            [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],

	    [ "radio", "Select Group :", $gNameParam, \@gList ],

            [ "hidden", $stepParam, "2" ]
            );

        my @buttons = ( [ "NOTUSED", "Next"] );
   	print SE::WebUtil->createForm ( $delFromT3GroupStr,
                                    $delFromT3GroupAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ],
                      [ $delFromT3GroupStr, $delFromT3GroupURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Select wwn " );
	
	my @wwnList = &getWWN ($request->{$t3Param}, $request->{$gNameParam} );

	my @fields = (
            [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],

            [ "static", "Selected Group :", $request->{$gNameParam} ],
            [ "hidden", $gNameParam, $request->{$gNameParam} ],

	    [ "radio", "Select WWN :", $wwnNameParam, \@wwnList ],

            [ "hidden", $stepParam, "3" ]
            );

        my @buttons = ( [ "NOTUSED", "Delete"] );
   	print SE::WebUtil->createForm ( $delFromT3GroupStr,
                                    $delFromT3GroupAction,
                                    \@buttons,
                                    \@fields );

    }
    elsif ( $request->{$stepParam} eq "3" )
    {

	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ],
                      [ $delFromT3GroupStr, $delFromT3GroupURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Delete wwn from T3+ group ");
	#USAGE
        # delfromt3group -n t3b#
        #                 -g group_name -w wwnname [-f ] | [-help]

	my $passwd = &getSavedT3Password ();

        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;
	
	my $command = " $T3UI::secfgBinDir/delfromt3group -v"
                    . " -n $request->{$t3Param}"
                    . " -g $request->{$gNameParam}"
                    . " -w $request->{$wwnNameParam}";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );

        $ENV{PASSWD} = $prePasswd;
   }

   print SE::WebUtil->createTail ();

} #end of sub delFromT3Group



sub setT3LunPerm()
{

    my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $setT3LunPermAction,
                                                  $setT3LunPermStr ) )
    {
        return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $setT3LunPermAction );

    if ( $request->{$stepParam} eq "" )
    {
        my @crumb = ( [ $homeStr, $homeURL ] ,
		      [ $lunMaskStr, $lunMaskURL ]
		     );

        print SE::WebUtil->createCrumb( \@crumb, $setT3LunPermStr );

        #DAVID_NEEDS_LIB_T3
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ("NOALL");

        if ( $errStr )
        {
            print "<h3><pre>$errStr</pre></h3>";
	    return;
        }

	my @options = ("Group","wwn");
        my @fields = (
            [ "static", $t3InUseStr, $busyStr ],
            [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
            [ "radio", "Set Sun StorEdge T3+ Array LUN Permissions on Group or WWN :", $optListParam, \@options ],
	    
            [ "hidden", $stepParam, "1" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );
	print SE::WebUtil->createForm ( $setT3LunPermStr,
                                    $setT3LunPermAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "1" )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ],
                      [ $setT3LunPermStr, $setT3LunPermURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Select group/wwn " );
	
	my @gList = &getGroups ($request->{$t3Param});
	my @lunList = &getLunList ($request->{$t3Param});

        if($#lunList < 0 ) {

            print "<h3><pre>No Slice existing on T3, create T3 slices before setting permissions </pre></h3>";
            return;
         }
	my @permList = ("rw", "ro", "none");
	my @wwnlist = &getWWNlist ($request->{$t3Param});
	my $slice_lun_list = `/opt/SUNWsecfg/bin/listt3map -x -i -n $request->{$t3Param}`;
	$slice_lun_list =~ s/ /<br>/g;

	my @fields;

	if ( $request->{$optListParam} eq "Group" )
	{
	@fields = (
            [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],

	    [ "radio", "Select Group :", $gNameParam, \@gList ],

	    [ "radio", "Select Lun :", $lunNameParam, \@lunList ],
            [ "static", "Slice names and associated lun numbers:", $slice_lun_list ],

	    [ "radio", "Select Permission :", $permNameParam, \@permList ],

            [ "hidden", $stepParam, "2" ]
            );
	}
	else
	{

	@fields = (
            [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],

	    [ "radio", "Select WWN :", $wwnListParam, \@wwnlist ],
	    [ "text", "Enter wwn name (if selected Other) :",$wwnNameParam,"","17","16" ],

	    [ "radio", "Select Lun :", $lunNameParam, \@lunList ],
            [ "static", "Slice names and associated lun numbers:", $slice_lun_list ],

	    [ "radio", "Select Permission :", $permNameParam, \@permList ],

            [ "hidden", $stepParam, "2" ]
            );
	}

        my @buttons = ( [ "NOTUSED", "Set Permission"] );
   	print SE::WebUtil->createForm ( $setT3LunPermStr,
                                    $setT3LunPermAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunMaskStr, $lunMaskURL ],
                      [ $setT3LunPermStr, $setT3LunPermURL ]
                    );

	if ( $request->{$wwnListParam} eq "Other" ) 
	{
	  if ( ! $request->{$wwnNameParam} ) 
          {
            print "<h2>";
            print "Invalid WWN Name !! <br><br>";
            print "WWN name can not be null.";
            print "</h2>";

            print "\n<form method=post>";

            print "\n<input type=submit"
                . " value=\"Back to Set T3 Lun Permission\" name=back >";

            print "<input type=hidden name=GO"
                . " value=$setT3LunPermAction >";

            print "\n</form>";
            return;
          }
	}

        print SE::WebUtil->createCrumb( \@crumb, "Setting Sun StorEdge T3+ Array LUN Permission ");
	#USAGE
        # sett3lunperm -n t3b#
        #                 -g group_name -w wwnname [-f ] | [-help]

	my $passwd = &getSavedT3Password ();

        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;

	my $option;
	if ($request->{$gNameParam})
	{
		$option = " -g $request->{$gNameParam}";
	}
	else
	{
		if ( $request->{$wwnListParam} eq "Other" )
		{
		 $option = " -w $request->{$wwnNameParam}";
		}
		else
		{
		 $option = " -w $request->{$wwnListParam}";
		}

	}
	
	my $command = " $T3UI::secfgBinDir/sett3lunperm -v"
                    . " -n $request->{$t3Param}"
                    . " -l $request->{$lunNameParam}"
                    . " -p $request->{$permNameParam}"
                    . " $option";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );

        $ENV{PASSWD} = $prePasswd;
   }

   print SE::WebUtil->createTail ();


} #end of sub setT3LunPerm


sub enableT3VolSlicing()
{

    my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $enableT3VolSlicingAction,
                                                  $enableT3VolSlicingStr ) )
    {
        return;
    }
    # end password check


    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $enableT3VolSlicingAction );

   if ( $request->{$t3Param} )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunSliceStr, $lunSliceURL ],
                      [ $enableT3VolSlicingStr, $enableT3VolSlicingURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, $request->{$t3Param} );

        #USAGE
	#enableT3VolSlicing -n <t3b name> 
 	#where: 
        # -n <t3b name>         - T3b name on which group to be created

        my $passwd = &getSavedT3Password ();

        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;

        my $command = "$T3UI::secfgBinDir/enablet3slicing -v"
                    . " -n $request->{$t3Param}";

        my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );

        $ENV{PASSWD} = $prePasswd;
    }
    else
    {
    my @crumb = ( [ $homeStr, $homeURL ] ,
		  [ $lunSliceStr, $lunSliceURL ]
		);

        print SE::WebUtil->createCrumb( \@crumb, $enableT3VolSlicingStr );

        #DAVID_NEEDS_LIB_T3
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ();

        if ( $errStr )
        {
            print "<h3><pre>$errStr</pre></h3>";
	    return;
        }

        my @fields = (
            [ "static", $t3InUseStr, $busyStr ],
            [ "radio", $t3AvailStr, $t3Param, \@$t3list ]
            );

        my @buttons = ( [ "DEFAULT", "Enable" ] );

        print SE::WebUtil->createForm ( $enableT3VolSlicingStr,
                                    $enableT3VolSlicingAction,
                                    \@buttons,
                                    \@fields );
    }

    print SE::WebUtil->createTail ();


} #end of sub enableT3VolSlicing


sub getWWNlist ()
{

    my ( $t3Name ) = @_ if @_;


    my @wwns = ();

    my @recs = split ' ',
        `/opt/SUNWsecfg/bin/listt3map -x -w -n $t3Name`;

    if ( $? ) #listt3map error
    {
        splice ( @recs );
    }

    for my $z ( @recs )
    {
            push @wwns, $z;
    }

    push @wwns, "ALL";
    push @wwns, "Other";

    return @wwns;


} #end of getWWNlist


sub getLunList ()
{

    my ( $t3Name,$opt ) = @_ if @_;


    my @luns = ();

    my @recs = split ' ',
        `/opt/SUNWsecfg/bin/listt3map -x -u -n $t3Name`;
    if ($#recs < 0) { #listt3map error
        splice ( @recs );
        return;
    }

    for my $z ( @recs )
    {
            push @luns, $z;
    }

    if ( ! $opt )
    {
    	push @luns, "ALL";
    }

    return @luns;

} #end of sub getLunList


sub getWWN ()
{

    my ( $t3Name, $grpName ) = @_ if @_;


    my @wwns = ();

    my @recs = split ' ',
        `/opt/SUNWsecfg/bin/listt3map -x -w -n $t3Name -p $grpName`;

    if ( $? ) #listt3map error
    {
        splice ( @recs );
    }

    for my $z ( @recs )
    {
            push @wwns, $z;
    }

    return @wwns;


} #end of sub getWWN


sub getGroups ()
{
    my ( $t3Name,$opt ) = @_ if @_;


    my @groups = ();

    my @recs = split ' ',
        `/opt/SUNWsecfg/bin/listt3map -x -g -n $t3Name`;

    if ( $#recs < 0 ) #listt3map error
    {
        splice ( @recs );
        return;
    }

    for my $z ( @recs )
    {
            push @groups, $z;
    }

    if ( $opt eq "ALL" )
    {
	push @groups, "ALL";
    }

    return @groups;
}



sub manageLunSlicing()
{
    my @crumb = ( [ $homeStr, $homeURL ] );

    print SE::WebUtil->createHead ();

    if ( ! SE::WebUtil->checkForIndy ( 1, "39" ) )
    {
	print SE::WebUtil->createCrumb( \@crumb, $lunSliceStr );
        print  $indy3900OnlyStr;
	return;
    }
    else
    {

    	print SE::WebUtil->createStorAdeHeader ( $lunSliceAction );
    	print SE::WebUtil->createCrumb( \@crumb, $lunSliceStr );
    	print "<br>";
    	print "<a href=$showSliceURL >$showSliceStr";
    	print "</a>";
    	print "<br>";
    	print "<br>";
    	print "<a href=$createSliceURL >$createSliceStr";
    	print "</a>";
    	print "<br>";
    	print "<br>";
    	print "<a href=$removeSliceURL >$removeSliceStr";
    	print "</a>";
    	print "<br>";
    	print "<br>";
    	print "<a href=$enableT3VolSlicingURL >$enableT3VolSlicingStr";
    	print "</a>";
    	print "<br>";
    	print "<br>";
    } #end of if ( SE::WebUtil->checkForIndy ( 1, "69" ) )

    print SE::WebUtil->createTail ();
}


sub createSlice()
{

my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $createSliceAction,
                                                  $createSliceStr ) )
    {
        return;
    }
    # end password check


    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $createSliceAction );

    if ( $request->{$stepParam} eq "" )
    {
    	
        my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunSliceStr, $lunSliceURL ]
		    );

        print SE::WebUtil->createCrumb( \@crumb, $createSliceStr );

        #NEED_LIB_T3
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ("NOALL");

        if ( $errStr )
        {
            print "<h3><pre>$errStr</pre></h3>";
	    return;
        }

        my @fields = (
            [ "static", $t3InUseStr, $busyStr ],
            [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
            [ "hidden", $stepParam, "1" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( $createSliceStr,
                                    $createSliceAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "1" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunSliceStr, $lunSliceURL ],
                      [ $createSliceStr, $createSliceURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Select volume(s) " );

	#my $volCount = `/opt/SUNWsecfg/bin/gett3info -n $request->{$t3Param} -c`;
	my $volCount = `/opt/SUNWsecfg/bin/listt3map -x -n $request->{$t3Param} -c`;

	my @volList;
	$volCount =~ s/^ *//g;

#Call to listt3map to get numSlices available
	my $numSlicesUsed = `/opt/SUNWsecfg/bin/listt3map -x -n $request->{$t3Param} -a`;
	$numSlices = ( 16 - $numSlicesUsed );

	if ( $volCount == 4 )
	{
		my $space1 = `/opt/SUNWsecfg/bin/listt3map -x -t -n $request->{$t3Param} -v vol1`;
		my $space2 = `/opt/SUNWsecfg/bin/listt3map -x -t -n $request->{$t3Param} -v vol2`;
		my $space3 = `/opt/SUNWsecfg/bin/listt3map -x -t -n $request->{$t3Param} -v vol3`;
		my $space4 = `/opt/SUNWsecfg/bin/listt3map -x -t -n $request->{$t3Param} -v vol4`;
                $space1 =~ s/\n//;
                $space2 =~ s/\n//;
                $space3 =~ s/\n//;
                $space4 =~ s/\n//;

		@volList = ("vol1($space1 GB)" ,"vol2($space2 GB)" ,"vol3($space3 GB)" ,"vol4($space4 GB)");
	} 
	elsif ( $volCount == 2 )
	{
		my $space1 = `/opt/SUNWsecfg/bin/listt3map -x -t -n $request->{$t3Param} -v vol1`;
		my $space2 = `/opt/SUNWsecfg/bin/listt3map -x -t -n $request->{$t3Param} -v vol2`;
                $space1 =~ s/\n//;
                $space2 =~ s/\n//;

		@volList = ("vol1($space1 GB)" ,"vol2($space2 GB)");
	}
	else
	{
		print "<h2>";
            	print "No volumes available on $request->{$t3Param} !! <br><br>";
            	print "</h2>";
		
		print "\n<form method=post>";
		
		print "\n<input type=submit"
		      . " value=\"Back to Create T3 Slice \" name=back >";
				
		print "<input type=hidden name=GO"
		       . " value=$createSliceAction >";
		
		print "\n</form>";
		return;

	}

	my @fields = (
            [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],

            [ "radio", "Select a volume on which the slice needs to be created",$volParam,\@volList ],
            [ "text", "Enter size of slice (GB) :",$sliceSizeParam,"","5","4" ],
            [ "text", "Enter name of the slice :",$sliceNameParam,"","11","10" ],
            [ "text", "Enter number of slices to be created <br>(Max of $numSlices) :",$sliceNumParam,"","3","2" ],
	    [ "hidden", $numSliceParam, $numSlices ],

            [ "hidden", $stepParam, "2" ]
            );

	my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( $createSliceStr,
                                    $createSliceAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunSliceStr, $lunSliceURL ],
                      [ $createSliceStr, $createSliceURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Creating slice " );

	#remove leading spaces for comparison
        $request->{$sliceSizeParam} =~ s/^ *//g;

	$request->{$volParam} =~ s/\(.*//g;

	#my $sliceSize = `/opt/SUNWsecfg/bin/gett3info -n $request->{$t3Param} -v $request->{$volParam}`;
	my $sliceSize = `/opt/SUNWsecfg/bin/listt3map -x -b -n $request->{$t3Param} -v $request->{$volParam}`;
	my $totalSliceSize = `/opt/SUNWsecfg/bin/listt3map -x -t -n $request->{$t3Param} -v $request->{$volParam}`;

	if ( ! $request->{$sliceSizeParam}
            || $request->{$sliceSizeParam} < 1
	    || $request->{$sliceSizeParam} > $sliceSize )
        {
            print "<h2>";
            print "Invalid slice size : $request->{$sliceSizeParam}<br><br>";
            print "Slice size should range between 1 GB and $sliceSize GB";
            print "</h2>";

            print "\n<form method=post>";

            print "\n<input type=submit"
                . " value=\"Back to Create Slice\" name=back >";

            print "<input type=hidden name=GO"
                . " value=$createSliceAction >";

            print "\n</form>";
            return;
        }

	if ( $request->{$sliceSizeParam} )
        {

	    my $nslices;
	    if ( $request->{$sliceNumParam} )
	    {
		$nslices = $request->{$sliceNumParam};
	    }
	    else
            {
		$nslices = $request->{$numSliceParam};
	    }

	    my $totalSize = ($nslices * $request->{$sliceSizeParam});
	    if ( $totalSize > $totalSliceSize )
	    {
            print "<h2>";
            print "Invalid slice specification : Number of slices = $nslices ; Size of each slice = $request->{$sliceSizeParam}<br><br>";
            print "Total slice size can not exceed $totalSliceSize GB";
            print "</h2>";

            print "\n<form method=post>";

            print "\n<input type=submit"
                . " value=\"Back to Create Slice\" name=back >";

            print "<input type=hidden name=GO"
                . " value=$createSliceAction >";

            print "\n</form>";
            return;
	    }
        }


	if ( ! $request->{$sliceNameParam})
        {
            print "<h2>";
            print "Slice name can not be null.";
            print "</h2>";

            print "\n<form method=post>";

            print "\n<input type=submit"
                . " value=\"Back to Create Slice\" name=back >";

            print "<input type=hidden name=GO"
                . " value=$createSliceAction >";

            print "\n</form>";
            return;
        }

	if ( $request->{$sliceNumParam} > $request->{$numSliceParam} )
        {
            print "<h2>";
            print "Invalid slice number : $request->{$sliceNumParam}<br>";
            print "Max number of slices = $request->{$numSliceParam}.";
            print "</h2>";

            print "\n<form method=post>";

            print "\n<input type=submit"
                . " value=\"Back to Create Slice\" name=back >";

            print "<input type=hidden name=GO"
                . " value=$createSliceAction >";

            print "\n</form>";
            return;
        }

	my $numSliceOption;

        if ( ! $request->{$sliceNumParam}
            || $request->{$sliceNumParam} eq "0" )
        {
                $numSliceOption = "";
        } else {
                $numSliceOption = " -c $request->{$sliceNumParam}";
        }

	my $passwd = &getSavedT3Password ();

        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;

	my $command = "$T3UI::secfgBinDir/createt3slice -v"
                    . " -n $request->{$t3Param}"
                    . " -d $request->{$volParam} "
                    . " -l $request->{$sliceSizeParam} "
                    . " -s $request->{$sliceNameParam}"
                    . $numSliceOption;

	my $tmp = `echo $request->{$t3Param} > /tmp/t3ID`;
	my $tmp2 = `rm -f /tmp/se6900_slice_$request->{$t3Param}`;
	SE::Util->execCmdBGOutputToFile ( $command, 1, $viewT3SliceResultsURL, "slice_$request->{$t3Param}" );

        #my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );

	$ENV{PASSWD} = $prePasswd;

    } #end of if ( $request->{$stepParam} eq "" )

    print SE::WebUtil->createTail ();
    

} #end of createSlice


sub removeSlice()
{

my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $removeSliceAction,
                                                  $removeSliceStr ) )
    {
        return;
    }
    # end password check


    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $removeSliceAction );

    if ( $request->{$stepParam} eq "" )
    {
    	
        my @crumb = ( [ $homeStr, $homeURL ] ,
		      [ $lunSliceStr, $lunSliceURL ]
		    );

        print SE::WebUtil->createCrumb( \@crumb, $removeSliceStr );

        #NEED_LIB_T3
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ("NOALL");

        if ( $errStr )
        {
            print "<h3><pre>$errStr</pre></h3>";
	    return;
        }

	my @optList = ("slice","volume","ALL");

        my @fields = (
            [ "static", $t3InUseStr, $busyStr ],
            [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
            [ "radio", "Do you want to specify slice or volume or delete all slices on all volumes :", $optListParam, \@optList ],
            [ "hidden", $stepParam, "1" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( $removeSliceStr,
                                    $removeSliceAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "1" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunSliceStr, $lunSliceURL ],
                      [ $removeSliceStr, $removeSliceURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Select slice/volume" );

	my @vol_slice_List;

	if ( $request->{$optListParam} eq "volume" )
	{

		#my $volCount = `/opt/SUNWsecfg/bin/gett3info -n $request->{$t3Param} -c`;
		my $volCount = `/opt/SUNWsecfg/bin/listt3map -x -n $request->{$t3Param} -c`;
		$volCount =~ s/^ *//g;

		if ( $volCount == 4 )
		{
			@vol_slice_List = ("vol1" ,"vol2" ,"vol3" ,"vol4");
		} 
		elsif ( $volCount == 2 )
		{
			@vol_slice_List = ("vol1" ,"vol2");
		}
		else
		{
			print "<h2>";
            		print "No volumes available on $request->{$t3Param} !! <br><br>";
            		print "</h2>";
		
		        print "\n<form method=post>";
		
		        print "\n<input type=submit"
		              . " value=\"Back to Remove T3 Slice \" name=back >";
				
		        print "<input type=hidden name=GO"
		              . " value=$removeSliceAction >";
		
		        print "\n</form>";
		        return;
		}
	}
	else
	{

		#@vol_slice_List =  split ' ', `/opt/SUNWsecfg/bin/gett3info -n $request->{$t3Param} -s`;
		@vol_slice_List =  split ' ', `/opt/SUNWsecfg/bin/listt3map -x -s -n $request->{$t3Param}`;
		if ( scalar(@vol_slice_List) == 0 )
        	{
        	    print "<h2>No slices available for $request->{$t3Param}!!</h2>";
		    print "</h2>";
		
		    print "\n<form method=post>";
		
		    print "\n<input type=submit"
		          . " value=\"Back to Remove T3 Slice \" name=back >";
				
		    print "<input type=hidden name=GO"
		          . " value=$removeSliceAction >";
		
		    print "\n</form>";
        	    return;
        	}

	} #end of if ( $request->{$optListParam} eq "volume" )
	
	my @fields;

	if ( $request->{$optListParam} eq "ALL" )
	{

	@fields = (
            [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],

            [ "static", "Option Selected :", "Delete all slices on all volumes for $request->{$t3Param}." ],

            [ "hidden", $optListParam, $request->{$optListParam} ],
            [ "hidden", $stepParam, "2" ]
            );
	}
	else
	{
	@fields = (
            [ "static", $t3SelectedStr, $request->{$t3Param} ],
            [ "hidden", $t3Param, $request->{$t3Param} ],

            [ "radio", "Select $request->{$optListParam} to be deleted:",$volParam,\@vol_slice_List ],

            [ "hidden", $optListParam, $request->{$optListParam} ],
            [ "hidden", $stepParam, "2" ]
            );
	}

        my @buttons = ( [ "NOTUSED", "Remove" ] );
	print SE::WebUtil->createForm ( $removeSliceStr,
                                    $removeSliceAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
		      [ $lunSliceStr, $lunSliceURL ],
                      [ $removeSliceStr, $removeSliceURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Removing $request->{$optListParam} " );

	my $rmSliceOption;

        if ( $request->{$optListParam} eq "slice" )
        {
                $rmSliceOption = " -s $request->{$volParam}";
        } elsif ( $request->{$optListParam} eq "volume" ) {
                $rmSliceOption = " -d $request->{$volParam}";
        } elsif ( $request->{$optListParam} eq "ALL" ) {
                $rmSliceOption = " -d ALL";
        }

	my $passwd = &getSavedT3Password ();

        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;
	
	my $command = "$T3UI::secfgBinDir/rmt3slice -v"
                    . " -n $request->{$t3Param}"
                    . $rmSliceOption;

	my $tmp = `echo $request->{$t3Param} > /tmp/t3ID`;
	my $tmp2 = `rm -f /tmp/se6900_slice_$request->{$t3Param}`;
	SE::Util->execCmdBGOutputToFile ( $command, 1, $viewT3SliceResultsURL, "slice_$request->{$t3Param}" );

 #       my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );

	$ENV{PASSWD} = $prePasswd;

    } #end of if ( $request->{$stepParam} eq "" )

    print SE::WebUtil->createTail ();

} #end of sub removeSlice


sub showSlice()
{

my ( $request ) = @_ if @_;

    # start password check
    if ( $false == SE::T3UI->validate ( $request, $showSliceAction,
                                                  $showSliceStr ) )
    {
        return;
    }
    # end password check


    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $showSliceAction );

    if ( $request->{$stepParam} eq "" )
    {

        my @crumb = ( [ $homeStr, $homeURL ],
                      [ $lunMaskStr, $lunMaskURL ]
                     );

        print SE::WebUtil->createCrumb( \@crumb, $showSliceStr);
    	
        #NEED_LIB_T3
        my ( $t3list, $busyStr, $errStr  ) = &getT3s ();

        if ( $errStr )
        {
            print "<h3><pre>$errStr</pre></h3>";
	    return;
        }

	my @optList = ("Composite Map","Slice","Map","Permission");

        my @fields = (
            [ "static", $t3InUseStr, $busyStr ],
            [ "radio", $t3AvailStr, $t3Param, \@$t3list ],
            [ "radio", "Select List Options", $optListParam, \@optList ],
	    [ "static", "Note : ", "Composite Map option lists the complete masking and slicing information, <br>Slice option lists the slice info, <br>Map option lists the Lun Map info, <br>Permission option lists the Lun Permission info." ],
            [ "hidden", $stepParam, "1" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( $showSliceStr,
                                    $showSliceAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "1" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
                      [ $lunMaskStr, $lunMaskURL ],
                      [ $showSliceStr, $showSliceURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "List slice/mask information" );
	
	my $listSliceOption;

	if ( $request->{$optListParam} eq "Slice" )
	{
		$listSliceOption = " -s";
	}
	elsif ( $request->{$optListParam} eq "Map" )
	{
		$listSliceOption = " -l";
	}
	elsif ( $request->{$optListParam} eq "Permission" )
	{
		$listSliceOption = " -p";
	}
	else
	{
		$listSliceOption = " -m";
	}

	my $passwd = &getSavedT3Password ();

        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;

	my $command = "$T3UI::secfgBinDir/listt3slice -v"
                    . " -n $request->{$t3Param}"
                    . $listSliceOption;

        my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );

	$ENV{PASSWD} = $prePasswd;

    } #end of if ( $request->{$stepParam} eq "" )

    print SE::WebUtil->createTail ();

} #end of sub showSlice


sub getSavedT3Password ()
{

    my $buf = '';
    open ( O, $passFileName );
    while ( <O> )
    {
        $buf .= $_;
    }
    close(O);

    #print " getsaved: $buf ";
    ## Special treatment of blank password
    if ( $buf eq "\"\"" )
    {
        return "";
    }

    return $buf;

}


sub saveT3Password ()
{
    my ( $passwd ) = @_ if @_;

    unlink ( $passFileName );

    sysopen ( FH, $passFileName, O_WRONLY|O_CREAT, 0600 )
	      or die "Could not save password";

    print FH $passwd;
    close FH;
}

sub portSLMode ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $portSLModeAction );

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr, $homeURL ] );

	print SE::WebUtil->createCrumb( \@crumb, $portSLModeStr );
	if ( ! SE::WebUtil->checkForIndy ( 0, "39" ) )
	{
	    print  $indy3900OnlyStr;
	    return;
	}


	#my ( $t3s, $t3busyStr ) = SE::T3UI::getT3s ();
	my ( $t3list, $busyStr, $errStr  ) = &getT3s ();

	if ( $errStr )
	{
	    print "<h3><pre>$errStr</pre></h3>";
	    return;
	}

	my @fields = ( 
	    [ "static", $t3InUseStr, $busyStr ],
	    [ "radio",  $t3AvailStr, $t3Param, \@$t3list ],
	    [ "radio",  $sLModeStr, $slModeParam, \@slOnOff ],
	    [ "static", 
	      "Note: on is (SL&nbsp;Mode)<br>off is "
	      . "&nbsp;(Default&nbsp;Modes&nbsp;(F&nbsp;and&nbsp;TL))." ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "Default",  $setPortSLModeStr ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $portSLModeStr,
				    $portSLModeAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $portSLModeStr, $portSLModeURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb,
                      "Setting Port SL Mode for T3+ "
					  . $request->{$t3Param} );

	#USAGE 
        #usage : setswitchsl -n <t3_name> -s [on | off] 
        #                 [-c <sys_config_type> [ -f ] ] [ -v ] 
        #where:
        #        -n t3_name - as defined in /etc/hosts file.
        #        -s - on implies set SL mode, off implies clear SL mode.
        #        -c sys_config_type - Sun StorEdge system type, which can be
        #             one of: 3910, 3960
        #        -f - force config, don't validate sys_config_type specified.
        #        -v - verbose option, messages go to stdout as well as log 
        #             file.
	#SAMPLE setswitchsl -n $t3 -s $opt -c $BOXTYPE -v -f

	#my $boxtype = `$T3UI::secfgBinDir/getcabinet`;
	my $boxtype = SE::WebUtil->getHostIndyModelViaStorAde ();

	$boxtype =~ s/\n//;

	my $command = 
	      "$T3UI::secfgBinDir/setswitchsl "
            . " -n $request->{$t3Param}" 
            . " -s $request->{$slModeParam}"
	    . " -c $boxtype" 
	    . " -v -f";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 1 );
    }

    print SE::WebUtil->createTail ();
}

 
sub manageDiskPools()
{
    my ( $request ) = @_ if @_;

    my @crumb = ( [ $homeStr, $homeURL ] );

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $manageDiskPoolsAction );
    print SE::WebUtil->createCrumb ( \@crumb, $manageDiskPoolsStr );

    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        #print  $SE::VEUI::indy6900OnlyStr;
        print  "<h2>This command can only be run on a"
	            . " Sun StorEdge 6910 or 6960 system.</h2>";
	return;
    }

    print "\n<br>";
    print "<a href=$createDiskPoolURL >$createDiskPoolStr";
    print "</a>";
    print "\n<br>";
    print "<a href=$removeDiskPoolURL >$removeDiskPoolStr";
    print "</a>";

    print SE::WebUtil->createTail ();
}


sub removeDiskPool ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $removeDiskPoolAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {

        my @crumb = ( [ $homeStr, $homeURL ],
                      [$manageDiskPoolsStr,$manageDiskPoolsURL]
                    );

	print SE::WebUtil->createCrumb( \@crumb, $removeDiskPoolStr );

	my ( $t3s, $busyStr, $errStr ) = SE::T3UI::getT3s ();

	if ( $errStr )
	{
	    print "<h3><pre>$errStr</pre></h3>";
	    return;
	}

	my @t3List;

	# remove "ALL" from the list
	foreach my $oneT3 ( @$t3s )
	{
	    if ( $oneT3 ne $allStr )
	    {
		push @t3List, $oneT3;
	    }
	}

	my @fields = ( 
	    [ "static", $t3InUseStr, $busyStr ],
	    #[ "radio",  $t3AvailStr, $t3Param, \@$t3s ],
	    [ "radio",  $t3AvailStr, $t3Param, \@t3List ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "Default",  "\"" . $removeDiskPoolStr . "\"",
			$warningPools ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $removeDiskPoolStr,
				    $removeDiskPoolAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
                      [$manageDiskPoolsStr,$manageDiskPoolsURL],
		      [ $removeDiskPoolStr, $removeDiskPoolURL]
		    );

	print SE::WebUtil->createCrumb( \@crumb,
                      $removeDiskPoolStr . " on "
					  . $request->{$t3Param} );

	#usage : rmdiskpools -n <t3host_name>
	#where :
	#	            T3+ hostname - is the hostname 
	#	            -V - verbose option

	my $command = 
	      "$T3UI::secfgBinDir/rmdiskpools"
            . " -n $request->{$t3Param}"
            . " -V";

	my $tmp = `echo $request->{$t3Param} > /tmp/t3ID`;
	my $tmp2 = `rm -f /tmp/se6900_rdp_$request->{$t3Param}`;
	#my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
	SE::Util->execCmdBGOutputToFile ( $command, 1, $viewT3DPResultsURL, "rdp_$request->{$t3Param}" );
    }

    print SE::WebUtil->createTail ();
}


sub createDiskPool ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $createDiskPoolAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {

        my @crumb = ( [ $homeStr, $homeURL ],
                      [$manageDiskPoolsStr,$manageDiskPoolsURL]
                    );

	print SE::WebUtil->createCrumb( \@crumb, $createDiskPoolStr );

	my ( $t3s, $busyStr, $errStr ) = SE::T3UI::getT3s ();

	if ( $errStr )
	{
	    print "<h3><pre>$errStr</pre></h3>";
	    return;
	}

	my @fields = ( 
	    [ "static", $t3InUseStr, $busyStr ],
	    [ "radio",  $t3AvailStr, $t3Param, \@$t3s ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "Default",  "\"" . $createDiskPoolStr . "\""  ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $createDiskPoolStr,
				    $createDiskPoolAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
                      [$manageDiskPoolsStr,$manageDiskPoolsURL],
		      [ $createDiskPoolStr, $createDiskPoolURL]
		    );

	print SE::WebUtil->createCrumb( \@crumb,
                      $createDiskPoolStr . " on "
					  . $request->{$t3Param} );

	#usage : creatediskpools -n <T3+ hostname>
	#where :
	#	            T3+ hostname - is the hostname for  
	#		    which diskpools will be created

	my $command = 
	      "$T3UI::secfgBinDir/creatediskpools"
            . " -n $request->{$t3Param}";

	my $tmp = `echo $request->{$t3Param} > /tmp/t3ID`;
	my $tmp2 = `rm -f /tmp/se6900_cdp_$request->{$t3Param}`;
	#my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
	SE::Util->execCmdBGOutputToFile ( $command, 1, $viewT3ResultsURL, "cdp_$request->{$t3Param}" );
    }

    print SE::WebUtil->createTail ();
}


# return $true if valid
#IMPORTANT IT MUST BE CALLED with "SE::T3UI->validate"
sub validate ( )
{
    my ( $self )  = @_ if @_;

    my $printIndyMsg = $true;
    my $isPasswordValid = $false;
    my $t3Password;

    if ( "SE::T3UI" eq $self )
    {
	$self = shift;
        $printIndyMsg = $false;

    }
    my ( $request, $action, $msg ) = @_ if @_; #MUST BE AFTER SHIFT;

    #TRICKY CODE, apparently Http.pm must have changed to pass 2
    #params and action gets an invalid value so I need to clear it out
    if ( $action =~ /^GO/ )
    {
	$action = $validateAction;
    }

    my @crumb = ( [ $homeStr , $homeURL ] );

    if ( !SE::WebUtil->checkForIndy ( 0, "39|69" ) )
    {
	if ( $printIndyMsg )
	{
	    print SE::WebUtil->createHead ();
	    print SE::WebUtil->createStorAdeHeader ( $validateAction );
	    print SE::WebUtil->createCrumb( \@crumb, $validateStr );
            SE::WebUtil->checkForIndy ( 1, "39|69" ); #call again to print
	}
	return 1;#ok to return true because fucntionality is not present
    }

    if ( $request->{clear} eq "true" )
    {
	unlink ( $passFileName );
    }
    if ( $false == $isPasswordValid ) #cache for performance
    {
	## Special treatment of blank password
	if ( ! $request->{$pswdParam} && ( $request->{clear} ne "true" ) )
	{
	    $request->{$pswdParam} = "\"\"";
	}

	my $command = "$T3UI::secfgBinDir/checkt3pw $request->{$pswdParam}";
        my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $command, 0 );

	# KEEP FOR DEBUG print "<br>1--$command--$?--";
	if ( $retVal == 0 ) #|| $retVal == 256 ) 
	{
	    $t3Password = $request->{$pswdParam};
	    $isPasswordValid = $true;

	    &saveT3Password ( $request->{$pswdParam} );
	}
	else # check file
	{
	    my $buf = &getSavedT3Password ();

	    if ( $buf ) 
	    {
		my $cmd3 = "$T3UI::secfgBinDir/checkt3pw $buf";
                my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd2 ( $cmd3, 0 );
		# KEEP FOR DEBUG print "<br>2--$cmd3--$?--";

		#TODO possible bug return is 256 on success
		#NEWINFO This used to be a proeblem
		#    for some reason we are not getting 256
		#    anymore so I will ingnore it.
		if ( $retVal == 0 ) #|| $retVal == 256 ) 
		{
		    $t3Password      = $buf;
		    $isPasswordValid = $true;
		}
	    }
	}
    }

    # if invalid display the page for the user to enter the password
    if ( $false == $isPasswordValid )
    {
	my $cmdOut = `/opt/SUNWsecfg/bin/listavailable -t`;

	if ( $? ) #no T3s error
	{
	    #if no T3s return true; no need to validate
	    return 1;
	}

	print SE::WebUtil->createHead ();
	print SE::WebUtil->createStorAdeHeader ( $validateAction );
	print SE::WebUtil->createCrumb( \@crumb, $validateStr );

	if ( $action eq "" )
	{
	    $action = $validateAction;
	}

	#print "act = --$action--";

	if ( $msg && ( $action ne $validateAction ) )
	{
	    print "<br>You must enter the T3+ Password in "
		. " order to invoke: <b>$msg</b><br>";
	}

	if ( $request->{anothertry} )
	{
	    print "<br><b>Incorrect password, please try again.</b>";
	    print "  If this problem persists check network connectivity"
		. " to the device.";
	}

	my @fields = ( 
	    [ "password", "Sun StorEdge T3+ Array password:", 
	      $pswdParam, "", "10", "10" ],
	    [ "hidden", "anothertry", "true" ]
	    );

	my @buttons = ( [ "Continue", "\"Save Continue\"" ] );
	my %opts = ( "method" => "get" );

	####IMPORTANT THIS FORM MUST USE "get" METHOD
	print SE::WebUtil->createForm ( $validateStr, 
				    $action,
				    \@buttons,
				    \@fields,
				    \%opts );

	print SE::WebUtil->createTail ();
    }
    elsif ( $action eq "" )
    {
	print SE::WebUtil->createHead ();
	print SE::WebUtil->createStorAdeHeader ( $validateAction );
	print SE::WebUtil->createCrumb( \@crumb, $validateStr );

	print "<h2>The password you entered is valid.</h2>";

	#print "<a href=$validateURL&clear=true>Clear Password</a>";

	print "\n<form>";

	#print "\n<input type=submit"
	#   . " value=\"Clear Password\" name=delit >";

	## Use "button" because on private netowrk
	## master/slaves the submit does not work on the slave.
	print "\n<input type=button"
	    . " value=\"Clear Password\""
	    . " onClick='document.location=\"$validateURL&clear=true\"' >";

	print "<input type=hidden name=clear"
	    . " value=true >";

	print "<input type=hidden name=GO"
	    . " value=$validateAction >";

	print "\n</form>";

	print SE::WebUtil->createTail ();
    }

    return $isPasswordValid;
}


sub getT3s ()
{
    my ( $request ) = @_ if @_;

    my @list;
    my @busylist;
    my $busyStr;
    my $errStr;
    
    # listavailable returns only NON-locked units
    @list = split ' ', `/opt/SUNWsecfg/bin/listavailable -t`;

    if ( $? )
    {
	$errStr = "ERROR: No T3+s available, either"
		. " not found or configuration lock set.";
    }

    #check for busy systems (by lock)
    @busylist = split ' ', 
	`ls -a /opt/SUNWsecfg/etc/.t3*.lock 2>/dev/null`;

    for my $item ( @busylist ) 
    {
	#for some reason the item(s) seem to have a new-line
	#$item =~ s/\n//;
	$item =~s/\/opt\/SUNWsecfg\/etc\/\.//g;
	$item =~s/\.lock//g;

	$busyStr .= " $item ";
    }

    
    if ( scalar(@list) > 0 )
    {
	if ( ! $request )
	{
	
		push @list, $allStr;
	}
    }

    return ( \@list, $busyStr, $errStr );
}


sub sideMenu ()
{
    my @menu = (  [ "SE Config Home" , "/seTop.html", "bottom" ],
                  [ $dispStr , $dispURL, "detail" ],
		  [ $saveStr , $saveURL, "detail" ],
		  [ $configStr , $configURL, "detail" ],
		  [ $restoreStr , $restoreURL, "detail" ],
		  [ $verifyStr , $verifyURL, "detail" ],
		  [ $busyStr , $busyURL, "detail" ],
		  [ $validateStr , $validateURL, "detail" ],
		  [ $portSLModeStr , $portSLModeURL, "detail" ]
		);

    print SE::WebUtil->createSideMenu ( "StorEdge 3900/6900 T3+ Section", 
					\@menu );
}

sub getT3Revision ()
{
    my($ip) = @_;
    my $rev;
    my $system = Agent::T3->getTokens($ip, 0, 100, "sysprop");
    if(!grep {/sysRevision/} @$system)
    {
       $system = Agent::T3->getTokens($ip, 0, 100, "system");
    }
    foreach my $l (@$system)
    {
       next if($l !~ /sysRevision/);
       ($rev) = $l =~ /\S+sysRevision,(\d+)\;/;
       last;
    }
    if(!$rev && -f "/opt/SUNWsecfg/etc/$ip/ver")
    {
       $system = "";
       open (VER,"/opt/SUNWsecfg/etc/$ip/ver");
       while (<VER>)
       {
          $system = $_ if($_ =~ /T3B Release/);
          last if($system);
       }
       ($rev) = $system =~ /T3B Release\s+(\S+)\s+/;
       if($rev && length($rev) < 7)
       {
          $rev =~ s/\./0/g;
       }
       else
       {
          $rev =~ s/\.//g;
       }
    }
    if($rev)
    {
       return $rev;
    }
    else
    {
       return 0;
    }
}

1;


