package SE;
use strict;
use State;
use System;

# v is reportCentent

sub fruInfo {
   my($class, $v, $fru) = @_;
   my( $vendor, $model, $serial, $hwRev, $swRev);
   my @ER = ('OK','Warning','Error','Critical');

   my $x = $fru;
   my $slot     = $v->{"fru.$x.fruSlot"};
   my $type     = $v->{"slot.$slot.dev-type"};
   my $type2    = $v->{"slot.$slot.dev-userLabel"} || $type;
   my $ss       = $v->{"fru.$x.status-sev"};
   $vendor      = "SUN";
   my $frutype  = $type;
   my $name     = $v->{"slot.$slot.dev-name"};
   my $status   = $ER[$v->{"slot.$slot.status-sev"}];
   my $key      = $v->{"slot.$slot.dev-key"};

   my $fruId     = $v->{"fru.$x.fruId"};

   if ($type eq "sp") {
     $name = $model = $v->{"fru.$x.info-model"};
     $hwRev = $v->{"fru.$x.info-os_version"};
     $fruId = $name;
     $key   = System->hostid();

   } elsif ($type eq "dsp") {
     $name  = $v->{"fru.$x.Class"} || 
                ($v->{"fru.$x.fruType"} . " " . $v->{"fru.$x.Label"});
     $serial    = $v->{"fru.$x.SerialNumber"};
     $model     = $v->{"fru.$x.PartNumber"};
     $hwRev     = $v->{"fru.$x.HWRev"};
     $swRev     = $v->{"fru.$x.PCBRev"};
     $status    = $v->{"fru.$x.State"};
     $frutype   = $v->{"fru.$x.fruType"};
     $key       = "$model.$serial" ;
     $key       = "" if ($key eq ".");

   } elsif ($type =~ /switch/) {
     $hwRev     = $v->{"fru.$x.version-HW"};
     $swRev     = $v->{"fru.$x.version-FLASH"};

   } elsif ($type =~ /ve/) {
     $hwRev     = $v->{"fru.$x.version"};

   } elsif (index(",t3,6120,6020,", $type) >= 0) {
     $name      = $v->{"fru.$x.fruType"};
     $vendor    = $v->{"fru.$x.fruVendor"};
     $serial    = $v->{"fru.$x.fruSerialNo"};
     $model     = $v->{"fru.$x.fruModel"};
     $frutype   = $v->{"fru.$x.fruType"};
     $hwRev     = $v->{"fru.$x.fruRevision"};
     $swRev     = $v->{"fru.$x.fruVersion"};
     $status    = $v->{"fru.$x.fruStatus"} . "/" . $v->{"fru.$x.fruState"};
     $key       = "$vendor.$model.$serial";
     $key       = "" if ($key eq "..");
   }
   my $revString = $swRev;
   $revString   .= " / " if ($revString);
   $revString   .= $hwRev;

   return {
             key => $key,
            name => $name,
           fruId => $fruId,
            slot => $slot,
         devType => $type,
         fruType => $frutype,

          vendor => $vendor,
           model => $model,
          serial => $serial,

           hwRev => $hwRev,
           swRev => $swRev,
       revString => $revString,

        devLabel => $v->{"slot.$slot.dev-userLabel"},
        severity => $v->{"fru.$x.status-sev"},
          status => $status,
          };

}



#
# CALL VMCFG
#
use vars qw($LAST_VMCFG);

sub vmcfg {
  my($class) = @_;
  my($x);
  my $renv = System->get_renv();
  return undef if ($renv->{solution} eq "N");
  return if (time - $LAST_VMCFG < 15);
  $LAST_VMCFG = time;

  my $sevs = State->sev_summary();
  my $arg = ($sevs->[3]+0) . "," . ($sevs->[2]+0) . "," . ($sevs->[1]+0) . ",0";

  my @SEV = ('OK','WARNING','ERROR','DOWN');
  my $status = "OK";
  for ($x = 3; $x >= 1; $x--) {
     if ($sevs->[$x]) {
        $status = $SEV[$x]; last;
     }
  }

  if ($renv->{solution_model} eq "6920") { # system1
    system("/opt/se6x20/bin/vmcfg status -t rack -s $status -c $arg&");
  } else {
    system("/opt/se6x20/bin/vmcfg status -t rack -s $status&");
  }
}



sub device_included {

  my($class) = @_;
  my $renv = System->get_renv();
  if ($renv->{solution} eq "se") {
     return "sp,switch,switch2,t3,ve,se";

  } elsif ($renv->{solution} eq "se2") {
     return "sp,6020,dsp,se2";
  } 
  return undef;
}

1;
