package Robin;
use strict;
use System;
use Agent;


# add any missing device in the round robin table and sort them
# by time
#
sub sync {
  my($class, $SINFO, $devs, $hosts ) = @_;

  my $renv = System->get_renv();
  my $robin = $SINFO->{round_robin} || [];
  my(%IN, %MAP);

  foreach my $el (@$robin) {
     my($time, $key) = split(/\t/, $el);
     $IN{$key} = $time;
  }
  my @R1;
  foreach my $d (@$devs, @$hosts) {
     next if ($d->{active} eq "N");
     next if (!Agent->category_selected($d->{type}));
     next if (($d->{host} || $renv->{hostname}) ne $renv->{hostname});
     my $k = $d->{key};
     $MAP{$k} = $d;
     push(@R1, ($IN{$k} || "000") . "\t$k");
  }
  my @R2 = sort(@R1);
  $SINFO->{round_robin} = \@R2;
  if (wantarray) {
    return (\@R2, \%MAP);
  } else {
    return \@R2;
  }
}

# replace or add a device to the round_robin table with the
# scheduled time of the next probe in the time field.
#
sub add {
  my($class, $SINFO_DB, $dev) = @_;
  my($x);
  my $renv = System->get_renv();

  my $agent_freq = $dev->{frequency} || $renv->{"frequency.$dev->{type}"} || $renv->{frequency};
  my $next_time  = time + $agent_freq * 60;
  my $SINFO      = $SINFO_DB->hash();
  my $robin      = $SINFO->{round_robin};

  $SINFO_DB->Lock();
  my $found;
  for ($x=0; $x <= $#$robin; $x++) {
     if ($robin->[$x] =~ /\t$dev->{key}/) {
        $found= 1;
        $robin->[$x] = "$next_time\t$dev->{key}";
        last;
     }
  }
  if (!$found) {
     push(@$robin, "$next_time\t$dev->{key}");
  }
  $SINFO->{round_robin} = $robin;
  $SINFO_DB->UnLock();
}


1;
        
