package Revision::SilkWorm;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub description {"Brocade SilkWorm Firmware ( 1Gb and 2Gb )"}
sub class {"oob.Brocade"}
sub type {"brocade"}

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;

  my $rc2 = $class->checkSilkWormFirmware($Matrix, $InstalledPatches);

  return [@$rc2];
}

sub checkSilkWormFirmware {
    my($class, $Matrix, $InstalledP) = @_;
    my $switch_fw = $Matrix->{Brocade};
    my $category = "SilkWorm";
    my $key_1 = "OS_1";
    my $key_2 = "OS_2";
    my @L;
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    my $d;
    my $req_fw;
    my $found=0;
    my $desc = "Please contact your SUN representative to install the expected level firmware";
    foreach my $dev (@$devs){
          if ( $dev->{class} =~ /brocade/) {

             my $ip_num = $dev->{ipno};
            
             ###############################################
             # need to differentiate 1Gb and 2Gb brocade   #
             ###############################################  

             $found =1;             

             my $curr_fw = Agent::BROCADE->getVersion($ip_num);
	     if($curr_fw =~ /v2/){
	        # This is a 1 Gig brocade
	        $d = $switch_fw->{$key_1};
                $req_fw = $d->[0];
	     }
	     else{
	        # This is a 2 gig brocade
		$d = $switch_fw->{$key_2};
                $req_fw = $d->[0];
	     }

             my $req_patch = $d->[1];
             my $desc2 = $d->[2]; 


             my $comp = $class->compareBrocadeFwLevels($curr_fw, $req_fw);
             if ( $comp==0) {
                   push(@L, [$category, $ip_num,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
             }
             elsif ($comp>0) {
                   push(@L, [$category, $ip_num,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
             }
             elsif (($comp<0) && ($curr_fw =~ /v2/)){
                   push(@L, [$category, $ip_num,'DOWNREV',$curr_fw, $req_fw, undef, undef, $desc]);
             } else {
                   push(@L, [$category, $ip_num,'DOWNREV',$curr_fw, $req_fw, undef, $req_patch, $desc2]);
             }

          }
    }
    if ($found ==0)
    {
            push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No SilkWorm device are present, please check system"]);
    }
 
    return \@L;
}




sub compareBrocadeFwLevels{
    my ($class, $drive, $matrix) = @_;
    my (@matrix, @drive, $indx);

    @matrix = split(//, $matrix); # separate characters
    @drive = split(//, $drive); # separate characters
    if (scalar(@matrix) > scalar(@drive)) {
       $indx = 0;
       my ($m, $d);
       foreach my $char (@matrix) {
          if ($char ne ".") {
            $m .= $char;
            $d .= $drive[$indx];
          }
          if ( $d gt $m) {
              return 1;
          } elsif ( $d lt $m ) {
              return -1;
          }
          $indx++;
       }
       return 0;
   } else {
       $indx = 0;
       my ($m, $d);
       foreach my $char (@drive) {
          if ($char ne ".") {
            $m .= $matrix[$indx]; 
            $d .= $char;
          }
          if ( $d gt $m) {
              return 1;
          } elsif ( $d lt $m ) {
              return -1;
          }
          $indx++;
       }
       return 0;
   }

}


1;


