package Process;

use System;
use strict;
use Util::Http;
use Data::Dumper;
use Util;
use Mail;

use vars qw($ERROR);

sub get_pid {
  my($host, $id, $PIDF) = @_;
  my($pid);
  $ERROR = "";
  if (!$host) {  # local
    if (open(O, $PIDF)) {
      $pid = <O>; close(O);
    }
  } else {
    ($ERROR, $pid) = Util::Http->readFile($host, "tmp/${id}_pid", 10);
  }
  return $pid;
}

sub label {
  my($pro, $status) = @_;
  my $L = Labels->read("Process");
}

sub list {
  my($pro) = @_;
  my $D =  System->get_home() . "/DATA/tmp";
  opendir(D, $D);
  my @F = readdir(D); closedir(D);
  my @LIST;
  foreach my $f (@F) {
     if ($f =~ /(.+)_pid$/) {
       my $id = $1;
       push(@LIST, $pro->details(undef,$id));
     }
  }
  return \@LIST;
}

sub details {
  my($pro, $host, $id) = @_;

  my $D =  System->get_home() . "/DATA/tmp";
  my($st, $pid) = $pro->status($host, $id);
  chomp($st);
  chomp($pid);
  $pid = "" if ($pid !~ /^\d+$/);
  my $f = $id . "_pid";
  my $start = Util->get_file_created("$D/$f");
  my $end   = Util->get_today() if ($st =~ /Done/ || $st =~ /Died/);

  return  {    id => $id, 
              pid => $pid, 
           status => $st,
            start => $start,
              end => $end,
          };
}

sub delete {
  my($pro, $host, $id) = @_;

  my $PIDF = System->get_home() . "/DATA/tmp/${id}_pid";
  my $renv = System->get_renv();
  $host = "" if ($host eq $renv->{hostname});

  if ($host) {
    Util::Http->deleteFile($host, "tmp/${id}_pid", 10);

  } else {
    unlink $PIDF;
  }
}

sub archive {
  my($pro, $host, $id) = @_;

  my $FROM = System->get_home() . "/DATA/tmp/${id}*";
  my $TO   = System->get_home() . "/DATA/tmphist";
  my $renv = System->get_renv();
  $host = "" if ($host eq $renv->{hostname});

  if ($host) {

  } else {
    my $cmd = "/bin/mv $FROM $TO";
    print "cmd=$cmd<br>";
    system($cmd);
  }
}


# returns Running | Not running | Died | Done / pid
# returns ("Running", $pid)
# return $ERROR
# $Process::ERROR
#
sub status {
  my($pro, $host, $id) = @_;
  my ($st, $pid);
  my $PIDF = System->get_home() . "/DATA/tmp/${id}_pid";
  $pid = &get_pid($host, $id, $PIDF);

  if ($pid =~ /^pid=\d+/) {
     my($a,$s) = Util->processTime(substr($pid,4), $host);
     if (!$a) {
       my $pid2 = &get_pid($host, $id, $PIDF);

       if ($pid2 =~ /^pid=\d+/) {  # no time and pid still there means that it died abruptly.
         $st = "Died";
         if ($host) {
            Util::Http->deleteFile($host, "tmp/${id}_pid", 10);
         } else {
            unlink $PIDF;
         }
       } else {
         $st = "Done / $pid";
       }

     } else {
       $st = "Running";
     }
  } elsif ($pid)  {
     $st = "Done / $pid";

  } else {
      $st = "Not running";
  }
  if (wantarray) {
    $pid = substr($pid,4) if ($pid);
    return ($st, $pid);
  } else {
    return $st;
  }
}

# can background itself local/remote 
# default is running in the backgroud.
# Command->run($host or blank, "bin/fccheck 1 2 3", [0|1]);
# return 1

sub run {
  my($class, $host, $program, $run_method, $foreground, $to, $progress) = @_;
  my ($cpid);
  die "run missing!" if (!$run_method);
  my ($renv, $devices, $hosts, $notifs, $Config) = PDM::ConfigFile->read();

  my $host_ip = Util->name2ip($host);
  if (!$host || $host_ip eq $renv->{ipno} || $host eq $renv->{hostname} ) {
     if ($foreground) {
        &$run_method();
     } elsif (($cpid = fork()) == 0) {
        close STDIN; close STDOUT; close STDERR;
        &$run_method();
     } else {
        my $ix = index($program, " ");
        my $prg1 = $ix > 0 ? substr($program,0,$ix) : $program;
        print "OK $prg1 started.\n";
     }

 # } elsif (!$Config->hostByKey($host) ) {
 #    $ERROR = "Cannot find host $host\n";
 #    return undef;
  } else {  # REMOTE 
     $program .= "&" if (!$foreground);
     return Util::Http->runit($host, $program, $to, $progress);
  }
}

sub write {
  my($class, $report, $id) = @_;

   my $F    = System->get_home() . "/DATA/tmp/$id";
   open(O, ">$F");
   $Data::Dumper::Indent=1;
   print O Dumper($report);
   close(O);
}

sub read {
  my($class, $host, $id) = @_;
  my $VAR1;
  my $renv = System->get_renv();
  my $F = "/tmp/${id}";
  my $host_ip = Util->name2ip($host);
  if (!$host || $host_ip eq $renv->{ipno} || $host eq $renv->{hostname}) {
      return Util->deserialize($F);
  } else {
      my $data = Util::Http->readFile($host, $F, 10);
      if ($data) {
          eval $data;
          return $VAR1;
      }
  }
}

sub trace {
  my($class, $host, $id) = @_;
  my $F   = System->get_home() . "/DATA/tmp/${id}_trace";
  if (-f $F) {
    open(O, $F);
    my @L = <O>; close(O);
    return join("", @L);
  } else {
    return undef;
  }
}

sub done {
  my($pro, $id) = @_;

  my $PIDF   = System->get_home() . "/DATA/tmp/${id}_pid";

  open(O, ">$PIDF");
  print O `/bin/date`;
  close(O);
}

sub start {
  my($class, $id) = @_;

  my $F    = System->get_home() . "/DATA/tmp/$id";
  my $PIDF = System->get_home() . "/DATA/tmp/${id}_pid";
  unlink $F;
  open(O, ">$PIDF"); print O "pid=$$"; close(O);
}

sub startIf {
  my($class, $id) = @_;

  my $F    = System->get_home() . "/DATA/tmp/$id";
  my $PIDF = System->get_home() . "/DATA/tmp/${id}_pid";

  my $current;
  open(O, $PIDF); $current = <O>; close(O);
  return 0 if ($current =~ /pid=/);

  unlink $F;
  open(O, ">$PIDF"); print O "pid=$$"; close(O);
  return 1;
}

#
# 
sub age {
  my($class, $ID, $format) = @_;
  $format = "h" if (!$format);

  return Util->getFileAge(System->get_home() . "/DATA/tmp/$ID", $format);
}





sub email {
  my($class, $report, $title) = @_;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $date = $report->{date} || Util->get_today();

  foreach my $notif (@$notifs) {  # Each notification.
     next if (!$notif->{email});
     my $admin = Util->rtrim($notif->{email});
     my $eventType = Util->rtrim($notif->{event});
     next if (($eventType ne "*") && index(lc($eventType),"upgradeevent") < 0 );
     my $content =<<EOF;
--- $title SUMMARY REPORT ---

Site    : $renv->{site_name} $renv->{site_city} 
Hostname: $renv->{hostname}
Date    : $date

--- TRACE ---

$report->{data}{trace}

EOF
     Mail->mail($admin, $renv->{GSV_ACRONYM}, $title, $content, 10);
  }
}


1;
