package NWS::SE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SE.pm,v 1.14 2004/06/11 20:20:53 ccadieux Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;

sub revision {'$Revision: 1.14 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j, $k, $k1, $v);
  my $wwn  = $rep->get('id.wwn'); # really the key now
  my $renv = System->get_renv();

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		=> $wwn ],
                    [OtherIdentifyingInfo  => $rep->{display} ],
                    [SystemName         => $rep->get('id.name')],
                    [IP 		=> $rep->get('id.ipno')],
                    [FruCount           => $rep->get('info.slotTotal')],
                    [VolCount 		=> $rep->get('info.lunTotal')],
                    [SysRevision 	=> $rep->get('info.spRevision')],
                    [FirmwareLevel      => $rep->get('info.firmwareLevel')],
                    [Caption            => $rep->get('info.model')],
                    [SerialNo           => $renv->{cust_no} ],
                    [SolutionModel      => $rep->get('info.model')],
                    [RedundantController=> $rep->get('info.isRedundantController')],
                    [SupportedRAIDType  => $rep->get('info.supportedRAIDType')],
                    [TotalCapacity      => $rep->get('info.totalCapacity')],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 			=> $wwn],
                  [Name			=> $wwn],
                  [Manufacturer 	=> $rep->get("info.vendor")],
                  [Model 		=> $rep->get("info.model")],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element		=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  my $SLOTS =  $rep->get('info.slotTotal');

  for ($i = 0; $i < $SLOTS; $i++) {
    $dd = $class->newSlot($rep,"slot.$i");
    next if (!$dd);
    $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "slot.$i"],
                   ]);
    push (@pil, @$dd);
    push (@pil, $a);
  }


  my $LUNS =  $rep->get('info.lunTotal');
  for ($i = 1; $i <= $LUNS; $i++) {
    $dd = $class->newLun($rep,"lun.$i");
    next if (!$dd);
    my $v2 =  CIM::Instance->new('CIM_MediaPresent', [
                       [Antecedent => $p1 ],
                       [Dependent  => $dd->[0] ],
                       ]);
    push (@pil, @$dd, $v2);
  }

  my $VOLS =  $rep->get('info.volTotal');
  for ($i = 1; $i <= $VOLS; $i++) {
    $dd = $class->newDspLun($rep,"volume.$i");
    my $v2 =  CIM::Instance->new('CIM_MediaPresent', [
                       [Antecedent => $p1 ],
                       [Dependent  => $dd->[0] ],
                       ]);
    push (@pil, @$dd, $v2);
  }

  my $PORTS =  $rep->get('info.portTotal');
  for ($i = 0; $i < $PORTS; $i++) {
    $dd = $class->newPort($rep,"fcPort.$i", $p2);
    my $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "port$i"],
                   ]);
    push (@pil, @$dd, $a);
  }

  my $FRUS =  $rep->get('info.fruTotal');
  for ($i = 0; $i < $FRUS; $i++) {
    $dd = $class->newFru($rep,"fru.$i", $p2);
    next if (!$dd);
    my $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "fru$i"],
                   ]);
    push (@pil, @$dd, $a);
  }

  return Ilist->new(\@pil);

}

sub newFru {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1);
  
  my $slot   = $rep->get("$cd.fruSlot");
  my $dev_type = $rep->get("slot.$slot.dev-type"); # sp,switch,t3,ve,6020,dsp,

  my $FRU = SE->fruInfo($rep, substr($cd,4));

  my $serial_no = $FRU->{key};

  return undef if (!$serial_no);

  $p1 = CIM::Instance->new('NWS_Fru', [
                    [SystemName  =>  $FRU->{name}||$FRU->{fruType}    ], 
                    [DeviceID     => $serial_no           ],
                    [Name         => $serial_no           ],
                    [Status       => $FRU->{status}       ],
                    [Type         => $FRU->{fruType}      ],
                    [FruId        => $FRU->{fruId}        ],
                    [SlotId       => "slot.$slot"         ],
                    [DevType      => $FRU->{devType}      ],
                    [IpNo         => $rep->get("slot.$slot.dev-ipno") ],
                    ]);
  push(@il, $p1);

  $c1 = CIM::Instance->new('CIM_Card', [
               [Removable           => "No"],
               [Tag                 => $serial_no],
               [Name                => $serial_no],
               [SerialNumber        => $FRU->{serial} ],
               [Manufacturer        => $FRU->{vendor} ],
               [Model               => $FRU->{model}  ],
               [HwVersion           => $FRU->{hwRev}  ],
               [Version             => $FRU->{hwRev} . "-" . $FRU->{swRev}  ],
                    ]);
  push(@il, $c1);

  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent     => $c1],
                [Dependent      => $p1],
                    ]);
  push(@il,$a1);

  my $slotsys = CIM::Key->new( ['NWS_System',
                       CreationClassName => 'NWS_System',
                       Name              =>  $rep->get("id.wwn"),
                      ]);

  my($p2) = CIM::Instance->new('NWS_Fru_System', [
                  [Fru        => $p1],
                  [System     => $slotsys],
                  ]);
  push(@il, $p2);
  return Ilist->new(\@il);
}


sub newSlot {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1);
  
  my $wwn       = $rep->get('id.wwn');
  my $serial_no = "$wwn.$cd";

  my $key       = $rep->get("$cd.dev-key");

  return undef if (!$serial_no);
  my($port)   = substr($cd,11,-3) . "p1";
  my($status) = $rep->get("${cd}.status-avail");

  $p1 = CIM::Instance->new('NWS_Slot', [
                    [SystemName  =>  $serial_no], # se.dvt1.slot.7
                    [DeviceID     => $rep->get("$cd.dev-key")], # slr-mi.370-3990-01-e-f1.019662
                    [Name         => $serial_no],
                    [StatusInfo   => $rep->get("$cd.status-desc") ],
                    [SlotId       => $cd     ],
                    [Status       => $status ],
                    [Type         => $rep->get("$cd.dev-type")],
                    [IpNo         => $rep->get("$cd.dev-ipno")],
                    [Key          => $key],
                    [OtherIdentifyingInfo => $rep->get("$cd.dev-name")],
                    [LinkWWN      => $rep->get("$cd.link_wwn")],
                    ]);
  push(@il, $p1);

  $c1 = CIM::Instance->new('CIM_Card', [
               [Removable           => "No"],
               [Tag                 => $serial_no],
               [SerialNumber        => $rep->get("$cd.dev-key")  ],
               [Manufacturer        => "Sun"],
               [Model               => $rep->get("$cd.dev-type") ],
               [PartNumber          => $key ],
               [Version             => $rep->get("$cd.dev-sysRevision")  ],
                    ]);
  push(@il, $c1);

  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent     => $c1],
                [Dependent      => $p1],
                    ]);
  push(@il,$a1);

  my $slotsys = CIM::Key->new( ['NWS_System',
                       CreationClassName => 'NWS_System',
                       Name              =>  $rep->get("id.wwn"),
                      ]);

  my($p2) = CIM::Instance->new('NWS_Slot_System', [
                  [Slot       => $p1],
                  [System     => $slotsys],
                  ]);
  push(@il, $p2);
  return Ilist->new(\@il);
}

sub newDspLun {
  my($class, $rep, $cd) = @_;
  my @pil;
  my $wwn =  $rep->{"$cd.DeviceID"} ;
  my $wwn2 = $wwn; 
  $wwn2 =~ s/\://g;

  my $v1 = CIM::Instance->new('NWS_StorageVolume', [
                  [ Type            => "dsp_volume"                ],
                  [ SystemName      => $wwn2                         ], 
                  [ DeviceID        => $wwn2                         ],
                  [ VolWWN          => $wwn2                         ],
                  [ VolName         => $rep->{"$cd.ElementName"}     ],
                  [ VolId           => $cd                           ],
                  [ Capacity        => $rep->{"$cd.VolumeSize"}      ],
                         ]);

   push(@pil, $v1);
   return Ilist->new(\@pil);
}

sub newLun {
  my($class, $rep, $cd) = @_;
  my @pil;
  my $wwn =  $rep->{"$cd.lunWwn"} ;
  return undef if ($wwn =~ /^0+$/);

  my $v1 = CIM::Instance->new('NWS_StorageVolume', [
                  [ Type            => "array_volume"                ],
                  [ SystemName      => $wwn                          ], 
                  [ DeviceID        => $wwn                          ],
                  [ VolWWN          => $wwn                          ],
                  [ VolName         => $rep->{"$cd.lunName"}         ],
                  [ VolId           => $rep->{"$cd.volId"}           ],
                  [ Capacity        => $rep->{"$cd.lunCapacity"}     ],
                  [ VolStatus       => $rep->{"$cd.lunStatus"}       ],
                  [ VolRaidLevel    => $rep->{"$cd.lunRaidLevel"}    ],
                  [ VolCacheMode    => $rep->{"$cd.lunCacheMode"}    ],
                  [ OtherIdentifyingInfo => $rep->{"$cd.lunDisks"}   ],

                         ]);

   push(@pil, $v1);
   return Ilist->new(\@pil);
}



sub newPort {
  my($class, $rep, $cd) = @_;
  my @il;
  my $serial_no = $rep->{"$cd.LocalPortWWN"} . ".$cd";

  my $p1 = CIM::Instance->new('NWS_SwitchPort',  [
             [SystemName   => "SE" ], 
             [DeviceID     => $serial_no ],
             [Name         => $serial_no ],
             [Status       => 1 ],
                    ]);

  push(@il,$p1);

  my $c1 = CIM::Instance->new('CIM_Card', [
                [Removable        => "Yes"],
                [Tag              => $serial_no],
                [Name             => $serial_no],
                [SerialNumber     => $serial_no],
                    ]);
  push(@il, $c1);

  return Ilist->new(\@il);

}

1;
