package NWS::SAMFS;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SAMFS.pm,v 1.4 2004/08/17 17:28:11 bkeslin Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.4 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j);
  my($CTRL);

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 				  => $rep->get('id.wwn')],
                    [SystemName           => $rep->get('id.name')],
                    [WWN           => $rep->get('id.device_key')],
                    [IP           => $rep->get('id.ipno')],
                    [OtherIdentifyingInfo => "wwn=".$rep->get('id.ipno')],
                    [SysRevision          => $rep->get('samfm.pkg.version')],
                    [Caption              => "SAM-QFS"],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 					=> $rep->get("id.wwn")],
                  [Manufacturer 		=> 'Sun'],
                  [Model 				=> $rep->get("id.device_product_id")],
                  [Name  				=> $rep->get("id.name")],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element 				=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  return Ilist->new(\@pil);

}

1;

