package NWS::Internal;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Internal.pm,v 1.2 2004/02/15 02:39:54 ccadieux Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.2 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j);
  my($CTRL);

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		  => $rep->get('id.wwn')],
                    [SystemName           => $rep->get('id.name')],
                    [OtherIdentifyingInfo => "wwn=".$rep->get('id.wwn')],
                    [SysRevision          => $rep->get('revision.value')],
                    [Caption              => "Internal"],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 			=> $rep->get("id.wwn")],
                  [Manufacturer 	=> 'SUN'],
                  [Model 		=> 'Internal'],
                  [Name  		=> $rep->get("id.wwn")],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element 		=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  for ($j=0; $j < $rep->{"info.count"}; $j++) {
      next if (!$rep->get("disk.$j.NodeWWN"));
      $dd = $class->newDiskDrive($rep,"disk.$j");
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "$i.$j"],
                   ]);
 
      push (@pil, @$dd);
      push (@pil, $a);
  }
  return Ilist->new(\@pil);

}


# create instances of NWS_DiskDrive, CIM_Realizes, CIM_PhysicalPackage, 
# CIM_MediaPresent and CIM_StorageExtent, CIM_SoftwareElement, CIM_DeviceSoftware
#  $disk = NWS::TA5000->newDiskDrive($rep, "u1d1");

sub newDiskDrive {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1, $c2, $a2);
  
  my($status) = $rep->get("${cd}.Status");

  my($map) = PDM->getDeviceStateMap("internal.availability");
  my($state) = $map->get("disk.status." . $rep->get("$cd.status")) ;

  $p1 = CIM::Instance->new('NWS_DiskDrive', [
                [SystemName 		=> $cd],
                [DeviceID	    => $rep->get("${cd}.NodeWWN")],
                [Wwn                => $rep->get("${cd}.NodeWWN")],
                [Port2State         => $rep->get("${cd}.Status")],
                [StatusInfo         => $status],
                [Status             => $state],
                [FruDiskCapacity    => $rep->get("${cd}.Capacity")],
                 ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
                [Removable 		=> "Yes"],
                [Replaceable 		=> ""],
                [Tag 			=> $rep->get("${cd}.NodeWWN")],
                [SerialNumber 		=> $rep->get("${cd}.SerialNum")],
                [Manufacturer 		=> $rep->get("${cd}.Vendor")],  
                [Model 			=> $rep->get("${cd}.ProductID")],  
                [Version 		=> $rep->get("${cd}.Revision")],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                    [Antecedent => $c1],
                    [Dependent  => $p1],
                    ]);
  push(@il, $a1);

  return Ilist->new(\@il);

}

1;
