package NWS::9900;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: 9900.pm,v 1.2 2004/08/13 15:02:23 ccadieux Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.2 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j, $k, $k1, $v);
  my $CTRL;
  my $wwn  = $rep->get('id.wwn'); # really the key now
  my $wwn1 = $rep->get('raid.MibNickName');
  my $renv = System->get_renv();
  my $type = $rep->get("id.device_type");
  my $info = $rep->get("system.sysContact") . ", " .
             $rep->get("system.sysDescr")   . ", " .
             $rep->get("system.sysLocation") . ", " .
             $rep->get("raid.SerialNumber");

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		=> $wwn ],
                    [OtherIdentifyingInfo  => $info ],
                    [SystemName         => $rep->get('id.name')],
                    [IP 		=> $rep->get('id.device_ip') ],
                    [FruCtlrCount 	=> 1 ],
                    [FruDiskDriveCount 	=> 1 ],
                    [FruPowerCount 	=> 2 ],
                    [SysRevision 	=> $rep->get('raid.DKCMainVersion') ],
                    [Caption            => uc($type)],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 			=> $wwn   ],
                  [Name			=> $wwn   ],
                  [Manufacturer 	=> "HDS"  ],
                  [Model 		=> "9900" ],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent          => $p1],
                  [Dependent           => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element 		=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  $dd = $class->newController($rep,"controller");
  if ($dd) {
    $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "controller"],
                   ]);
    push (@pil, @$dd);
    push (@pil, $a);
  }

  $dd = $class->newDiskDrive($rep,"disk");

  if ($dd) {
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "disk"],
                   ]);
      push (@pil, @$dd, $a);
  }
    
  return Ilist->new(\@pil);

}

sub newDiskDrive {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1, $c2, $a2);

  my $serial_no = $rep->{'id.wwn'} . ".disk";

  my $status = $rep->{'disk.Drive'};
  my $st = $status =~ /noError/ ? 1 : 0;

  $p1 = CIM::Instance->new('NWS_DiskDrive', [
                [SystemName 	=> $serial_no],
                [DeviceID 	=> $serial_no ],
                [Name     	=> $serial_no ],
                [StatusInfo     => $status],
                [Status         => $st    ],
                [PowerSupplyStatus  => $rep->{'disk.PS'} ],
                [FanStatus      => $rep->{'disk.Fan'} ],
                [EnvironmentStatus   => $rep->{'disk.Environment'} ],
                 ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
                [Removable 	=> "Yes"],
                [Replaceable 	=> "Yes"],
                [Tag 	        => $serial_no],
                [Name    	=> $serial_no],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                    [Antecedent => $c1],
                    [Dependent => $p1],
                    ]);
                    
  push(@il,$a1);

  return Ilist->new(\@il);

}


sub newController {
  my($class, $rep, $cd, $index) = @_;
  my(@il, $p1, $c1, $a1);
  
  my $wwn       = $rep->{'id.wwn'};
  my $serial_no = "$wwn.controller";

  my $status = $rep->get('controller.Processor');
  my $st     = $status =~ /noError/ ? 1 : 0;

  $p1 = CIM::Instance->new('NWS_Controller', [
                    [SystemName  =>  "Controller"],
                    [DeviceID     => $serial_no],
                    [Name         => $serial_no],
                    [StatusInfo   => $status],
                    [Status       => $st ],
                [PowerSupplyStatus   => $rep->{'controller.PS'} ],
                [FanStatus           => $rep->{'controller.Fan'} ],
                [EnvironmentStatus   => $rep->{'controller.Environment'} ],
                [CacheStatus         => $rep->{'controller.Cache'} ],
                [BatteryStatus       => $rep->{'controller.Battery'} ],
                [ProcessorStatus     => $rep->{'controller.Processor'} ],
                [BusStatus           => $rep->{'controller.CSW'} ],
                    ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_Card', [
                [Removable	=> "Yes"],
                [Replaceable 	=> "Yes"],
                [Tag 		=> $serial_no],
                [WWN 		=> $wwn      ],
                [Name  		=> $serial_no],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent => $c1],
                [Dependent => $p1],
                    ]);
                    
  push(@il,$a1);

  return Ilist->new(\@il);

}


1;
