package Logic::SWITCH;
use Logic;
use Logic::Subnet;
use Agent::BROCADE;
use Agent::3310;
use strict;

#  host => , ip => , name => , 
#  return ($err_object, $nodes_list);
#  $q->{host} = ''         : local
#  $q->{host} = <hostname> : slave

sub addToConfig {
  my ($class, $q) = @_;
  my ($err, $nodes);

  while (1) {
     if ($q->{name} eq "") {
        $err = Error->error(102);
        last;
     } elsif (!$q->{ip}) {
        $err = Error->error("103");
        last;
     } else {
        my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
        my(%F);
        foreach my $d (@$devs) {
          if ($d->{class} =~ /^switch/ ) {
             $F{$d->{wwn}} = 1;
          }
        }
        ($err, $nodes) = $class->add($q, $devs, \%F);
        if (!$err && $nodes) {

           Logic->clearSlave($q->{host}, $hosts);
           if (!PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs)) {
              $err = Error->error('10');
           }
        }
     }
     last;
  }
  return ($err, $nodes);
}

sub addFromFile {

   my($class, $q) = @_;

   my(@nodes,$err, $err_text, $x);
   my $host       = $q->{host};
   my $monitor_on = $q->{monitor_on};
   my $silent     = $q->{silent};
   my $datahost   = $q->{datahost};
   $q->{prefix} =~ s/\./_/g;
   my $br = "<br>" if (!$q->{TEXT});
   my(@DATA, %F, $adding, $found);
   my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
   my $new_dev = $#$devs ;
   my $short = Util->shortHostname($host || $renv->{hostname});

   my $cnt=1;
   foreach my $d (@$devs) {
     $F{$d->{key}} = $cnt;
     $cnt++;
   }
   if (!$q->{select_host} || $q->{select_host} eq "local") {
      # Get info from this host
      $q->{LOCAL} = 1;
      my $dd =  &get_infoFromFile($q);
      push(@DATA, @$dd);
   } 

   foreach my $host0 (@$hosts) {
      if (!$q->{select_host} || $q->{select_host} eq $host0->{hostname}) {
        # Get info from remote host

        my $rc = Util::Http->getCommand($q->{select_host}, "Logic::SWITCH::infoFromFile&REM=1&fileToUse=$q->{fileToUse}", 300);
        if (substr($rc,0,2) ne "OK" || !$rc)  {
           my $err_0 = Error->error(1, "$rc $Util::Http::ERROR");
           $err .= $err_0;
        } else {
           my @A = split(/\n/, substr($rc,2));
           my $x;
           for ($x=0; $x <= $#A; $x++) {
               push(@DATA, "$A[$x]|$host0->{hostname}");
           }
        }
      }
   }
   my $err_text;
   foreach my $line (@DATA) {
     my($adding0, $nodes0) = &process_line($q, $line, \%F, \$err_text, $devs, $short, $br, $silent);
     $adding += $adding0;
     if($adding0){
        push(@nodes, @$nodes0);
     }
   }
   if ($adding) {
      foreach my $h (@$hosts) { 
         $h->{last_push} = undef;
      }
      PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
   }
   return ($err, \@nodes, $err_text);
}

# called by lib/Discover.pm to process what was found in Discovery.

sub process_line {
  my($q, $line, $F, $err_text, $devs, $short, $br, $silent) = @_;
  my($adding, @nodes);
  my $MINNOW = ",3510,3511,3310,3310jbod,3120jbod,";

  $q->{monitor_on} = 1 if (!exists $q->{monitor_on});

   my($class, $type, $ip, $wwn, $key, $wwn2, $ctrl0,  
      $devname,$label, $username, $host1) = split(/\|/, $line) ;
   if ($class eq "ERR") {
      print "ERR: $type$br\n" if (!$silent);
      $$err_text .= "\nERR: $type, ";
      return(0, []);
   } elsif (!$class && !$wwn) {
      # The first line from a slave is all blank except for type so don't print out anything
      return(0, []);


   } elsif (!$type || !$class || !$wwn) {
      my $e1;
      $e1 = "type" if (!$type);
      $e1 .= ",class" if (!$class);
      $e1 .= ",wwn" if (!$wwn);
      print "ERR: skipping $ip/$username because $e1 is blank$br\n" if (!$silent);
      $$err_text .= "\nERR: Skipping $ip because $e1 is blank, ";
      return(0, []);
   }
   if (!$F->{$key}) {
      $F->{$key}  = 1;
      $adding     = 1;
      my $new_dev = $#$devs+1;
      
      my($ip1,$ip2,$ip3, $ip4, $path);
      if (index($ip, "/") >= 0) {
         $path = $ip;
         $ip   = "";
      } else {
         ($ip1,$ip2,$ip3, $ip4) = split(/\./, $ip);
      }

      my $n1 = $devname || "$ip3-$ip4";

      my($ctrl, $units) = split(/\t/, $ctrl0);
      my $nd = {
        type     => $type,
        class    => $class,
        ip       => $ip,
        ipno     => $ip,
        wwn      => $wwn,
        wwn2     => $wwn2,
        key      => $key,
        host     => $host1,
        active   => $q->{monitor_on}? "Y": "N",
        mgmtLevel=> "D",
        };
      $nd->{path} = $path if ($path);

      if (index($wwn2 ,",") >= 0 || index($wwn2 ,"|") >= 0) {  # wwn_list
        $nd->{wwns} = $wwn2;
        $nd->{wwn2} = "";
      }

      if ($q->{prefixT}) {
         # This came by way of subnet discovery where they
         # selected to use host name as prefix
         $nd->{name}     = $short ."-" . ($devname || sprintf("%3.3d", $ip4)) ;

      } elsif ($q->{prefix}) {
         # subnet discovery can come from.
         $nd->{name}     = $q->{prefix} . "-$n1";

      } else {
	 #Print this is where discover from file gets it's name
         my $tt = substr($type,0,2);
	 $nd->{name} = $devname || $username || "$tt-$n1";  
                                       # username is from deviceIP
      }

      if(index($MINNOW, ",$type,") >= 0) {
         $nd->{path}  = $ctrl0 if ($ctrl0);
	 $ctrl = undef;
      }
      if ($type eq "samfs") {
          $nd->{product_id} = $ctrl0;
      }
      $nd->{ctrl_model} = $ctrl  if ($ctrl);
      $nd->{units}      = $units if ($units);
      $nd->{userLabel}  = $label if ($label);

      if ($type =~ /^se\d*/){
         $nd->{model}  = $label;
         $nd->{ipName} = $ip;
      }

      PDM::ConfigFile->addDevice($devs, $nd);
      print " $type:$ip added. $br\n";
      push(@nodes,  $nd);


   } else {
      my $Config  = System->get_Config();
      my $dev1 = $Config->deviceByKey($key);
      my $show = $dev1->{ip} || $dev1->{name};
      my $show1 = $ip || $devname || $username ;  

      print " The unique identifier($key) for $type:$show1 conflicts with device at $show\n<br>";


   }
   return ($adding, \@nodes);
}

sub get_infoFromFile {
   my($q, $post, $util) = @_;
   my(%T, @a, $loc, $ip, $out);
   my(%F, $d, $adding, $found, $l );
   my(@NEW, %IP);
   my($xx, $sub, $remote, $x);

   $remote   = $q->{REM};

   my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

   foreach my $dev (@$devices) {
     next if (!Util->isMineToMonitor($dev));
     my ($baseip, $extension) = split(/:/,$dev->{ipno});
     $IP{$baseip} = 1;
   }
   my $host = $renv->{hostname} if (Util->findMaster());

   my(@L, $file);

   $file = $q->{fileToUse} || "/etc/deviceIP.conf";

   if (!open(OO, $file)) {
      &push(\@L, Error->error(104, $!), $q);

   } else {
     my ($adding, @nodes, $info);
     while ($l = <OO>) {
        chomp($l);
        next if (substr($l,0,1) eq "#");
        next if ($l !~ /^\d+/);
        my($ip, $name, $type) = split(/\s+/, $l);
	print "Reading $l\n" if ($q->{LOCAL} && $q->{TEXT});
        if ($IP{$ip}) {
	  print "  device $ip/$name already in configuration\n" if ($q->{LOCAL} && $q->{TEXT});
          &push(\@L, "ERR|device $name/$ip already in configuration", $q);
          next;
        }
        
        $type = undef if (substr($type,0,1) eq "#");
        if ($type && index("3310,3510,3511", $type) >= 0) {
           my $rc = Agent::3310->getFastWWN($ip);
	   if($rc->{error}){
	      $out = ["ERR|Could not retrieve information for $ip $rc->{error}"];
	   }elsif($rc) {
             my $t = $rc->{type};
             $out = ["storage.$t|$t|$ip|$rc->{wwn}|$rc->{key}|$rc->{wwn2}||$name|"];
           }
        } elsif ($type eq "samfs") {    # 172.20.35.46 samfs-spetest1 samfs
           require Agent::SAMFS;
           my $rc = Agent::SAMFS->getWWN($ip);
	   if ($rc->{error}) {
	      $out = ["ERR|Could not retrieve information for $ip $rc->{error}"];
	   } elsif ($rc) {
             my $t = $rc->{type};
             $out = ["application.$t|$t|$rc->{ipno}|$rc->{wwn}|$rc->{key}|$rc->{wwn2}|$rc->{product}|$name|SAM-QFS"];
           }

        } elsif ($type && substr($type,0,3) =~ /^se\d*/ || substr($type,0,4) eq "rack") {
           my($solution, $wwn, $model, $hostname, $port) = Logic::SE->find_solution($ip);
  
           if ($solution =~ /^se/) {
             my $ipno = $ip;
             $ipno .= ":$port" if ($port);
             $out = ["storage.$solution|$solution|$ipno|$wwn|$wwn|$wwn|||$model"];
           }
        } else {
           $out = Logic::Subnet->snmpget1($ip, undef, 4);
        }
        my $found = 0;
        foreach my $node (@$out) {
            $found = 1;
             &push(\@L, "$node|$name|$host", $q);
        }
        if($found == 0){
           &push(\@L, "ERR|Couldn't detect a device at IP: $ip", $q);
        }
  
     }
     close(OO);
  }


  if ($remote) {
     print "OK\n" . join("\n", @L);
  } else {
     return \@L;
  }
}

sub push {
  my($L, $line, $q) = @_;
  push(@$L, $line);
  if ($q->{callback}) {
     my $f = $q->{callback};
     &$f($line);
  }
}



sub add {
  my($class, $q, $devs, $F) = @_;
  my (@nodes, $err);
  my($ipno, $python, $msg, $adding);
  my $host = $q->{host};
  my $ip   = $q->{ip};
  my $name = $q->{name};


  if (!($ipno = Util->testIp($ip))) {
      my $err = Error->error("switch.101", $ip);
      return ($err, []);
  }
  my($wwn, $type, $label) = $class->find_wwn($ipno, $q->{host});
  if (!$wwn) {
      my $err = Error->error("switch.102", $ipno);
      return ($err, []);
  
  } elsif (!$F->{$wwn} ) {
      $F->{$wwn} = 1;
      my($new_dev) = $#$devs  + 1;

      my $nd = PDM::ConfigFile->addDevice($devs, {
      type     => $type,
      class    => "switch.$type",
      name     => $name || "S" . $ip,
      ip       => $ip,
      telnet   => Util->encodeAll($q->{password}),
      wwn      => $wwn,
      userLabel=> $label,
      key      => $wwn,
      ipno     => $ipno,
      host     => $q->{host},
      active   => "Y",
      });

      my($renv, $devs1, $hosts1,$notifs1) = PDM::ConfigFile->read();

      $F->{$wwn} = 1;
      push(@nodes, $nd);

  } else {
      my $err = Error->error("switch.103");
      return ($err, []);
  }
  return (undef, \@nodes);  #  if ($type ne "switch");  look for more switch if its a sunswitch

#
#     LOOK FOR MORE SWITCHES, may not be used anymore
#     
  my($err,$com) = Util->run_command( System->get_home() .
                      "/bin/sanbox port_status $ip all", "raidutil.txt", 10);
  foreach my $l (@$com) {
     if ($l =~ /T_Port\s+Linked-to:/) {
        my($l0) = $l;
        $l0 =~ /Port:\s+(\d+)/;
        my($port) = $1;
        $l =~ /Linked-to: ([0-9a-f]+)\s+IP:\s+([0-9\.]+)\s+FC:\s+(\w+)/;
        my($wwn2, $ipno2, $fc2) = ($1,$2,$3);
        if ($wwn2) {
           if (!$F->{$wwn2} ) {
              $F->{$wwn2} = 1;
              my($new_dev) = $#$devs  + 1;

              my($wwn, $type, $label) = $class->find_wwn($ipno2);
              $devs->[$new_dev]{_name}    = "device" . $new_dev;
              $devs->[$new_dev]{type}     = 'switch';
              $devs->[$new_dev]{class}    = 'switch.switch';
              if ($ipno2 =~ /\d+\.\d+\.\d+\.(\d+)/) {
                 $devs->[$new_dev]{name}     = "csw-" . $1;
              } else {
                 $devs->[$new_dev]{name}     = "csw-$fc2";
              }
              $devs->[$new_dev]{ip}       = $ipno2;
              $devs->[$new_dev]{wwn}      = $wwn;
              $devs->[$new_dev]{fc}       = $fc2;
              $devs->[$new_dev]{port}     = $port;
              $devs->[$new_dev]{primary}  = $ip;
              $devs->[$new_dev]{wwn}      = $wwn;
              $devs->[$new_dev]{key}      = $wwn;
              $devs->[$new_dev]{ipno}     = $ipno2;
              $devs->[$new_dev]{host}     = $host;
              $devs->[$new_dev]{active}   = "Y";
              $F->{$ipno2} = 1;
              push(@nodes, $devs->[$new_dev]);
            }
        }
     } # end if T port
  } #end foreach

  return ($err, \@nodes);
}

sub find_wwn {
   my($class, $ip, $host) = @_;
   my($wwn, $type);
   my $renv = System->get_renv();
   my $TO = $renv->{"timeout.http"} || 30;

   if (!$host) {
      return &get_find_wwn0({ip => $ip});
   } else {
      my $rc = Util::Http->getCommand($host, "Logic::SWITCH::find_wwn0&ip=$ip&HTTP=1", $TO);
      if ($rc =~ /OK /) {
         my @report = split(/\|/, substr($rc,3));
         return @report;
      } else {
         return ();
      }
   }
}


sub get_find_wwn0 {
   my($q) = @_;

   my $ip   = $q->{ip};
   my $http = $q->{HTTP};

   my($wwn, $type);
   
   # first try to get OID for this hardware
   my $comm;
   my $DIR = System->get_home();
   my $err;
   my $id;
   my $response = undef;
   my $ipno = Util->name2ip($ip);

   $comm = "$DIR/snmp/bin/snmpwalk -r 0 -t 15 -m all -Osb  $ip public mib-2.1.2.0";
   ($err,$id) = Util->run_command($comm, "getWWN", 10);

   my $oid;
   if($id->[0] =~ /sysObjectID.0 = OID: enterprises.(.+)/){
      $oid = $1;
      $response = 1;
   } elsif ($id->[0] =~ /sysObjectID.0 = OID: storage-subsystem.(.+)/){
      #  2g 8port shows up as sysObjectID.0 = OID: storage-subsystem.3.4.1.1.4
      $oid = "42.2.28." . $1;
      $response = 1;

   } elsif ($id->[0] =~ /sysObjectID.0 = OID: private.(.+)/){
      #  2g 8port shows up as sysObjectID.0 = OID: storage-subsystem.3.4.1.1.4
      $oid = "private." . $1;
      $response = 1;

   } elsif ($id->[0] =~ /OID/){
     # We received a response from this device
     $response = 1;
   }
   my(@return);
   while (1) {
     if ($oid) {
        if (($oid =~ /1663.1.1.1.1.12/) || # 64 port qlogic switch QLOGIC branded
           ($oid =~ /42.2.28.3.4.1.1.5/)|| # 64 port qlogic switch SUN branded
  	 ($oid =~ /1663.1.1.1.1.11/)  || # 2g 16 port qlogic switch QLOGIC branded
  	 ($oid =~ /42.2.28.3.4.1.1.3/)|| # 2g 16 port qlogic switch SUN branded
  	 ($oid =~ /1663.1.1.1.1.14/)  || # 2g 8 port qlogic switch QLOGIC branded
  	 ($oid =~ /42.2.28.3.4.1.1.4/)	 # 2g 8  port qlogic switch SUN branded
  	  ) {
           # was 1.1.1.0
  	 $comm = "$DIR/snmp/bin/snmpwalk -r 0 -t 15 -m all -Os  $ip public mib-2.75.1.1.2.0";
           my $id;
           ($err,$id) = Util->run_command($comm, "getWWN", 10);
           my ($name, $wwn) = split(/ *= */, $id->[0]);
           $wwn = lc($wwn);
           $wwn =~ s/hex://; 
           $wwn =~ s/ //g;
           @return = ($wwn, 'switch2','Switch2');
           last;
  
	} elsif ( ($oid =~ /.1.3.6.1.4.1.289/) || ($id->[0]) =~ /enterprises.289/){
	  # McDATA Switch
	  my $wwn = Util->snmpWWN($ipno);
	  @return = ($wwn, 'mcdata','mcdata');
          last;

        } elsif ( $oid =~ /private.824.1.9/){
           #Inrange switch
  	 $comm = "$DIR/snmp/bin/snmpwalk -r 0 -t 15 -m all -Os  $ip public mib-2.75.1.1.2.0";
           my $id;
           ($err,$id) = Util->run_command($comm, "getWWN", 10);
           my ($name, $wwn) = split(/ *= */, $id->[0]);
           $wwn = lc($wwn);
           $wwn =~ s/hex://; 
           $wwn =~ s/ //g;
           @return = ($wwn, 'inrange','inrange');
           last;
        }
     }
     
     my $com;
     ($err,$com) = Util->run_command(
           System->get_home() . "/bin/sanbox version $ip", "raidutil.txt", 10);
     "@$com" =~ /WWN:\s+(\w+)/;
     $wwn = lc($1);
  
     if ("@$com" =~ /No response/) {
        my $wwn = Agent::BROCADE->getWWN($ip); 
        my $mymodel = Agent::BROCADE->getModel($ip); 
        @return = ($wwn, 'brocade', $mymodel);
        last;
  
     } elsif("@$com" =~ /Command requires user login/) {
        # a qlogic switch with security turned on
        # Try snmp to get information
        # should be 1.1.1.0
        $comm = "$DIR/snmp/bin/snmpwalk -r 0 -t 5 -m all -Os  $ip public mib-2.75.1.1.2.0";
        my $id;
        ($err,$id) = Util->run_command($comm, "getWWN", 10);
  
        my ($name, $wwn) = split(/ *= */, $id->[0]);
        $wwn = lc($wwn);
        $wwn =~ s/hex://; 
        $wwn =~ s/ //g;
        @return = ($wwn, 'switch2','Switch2');
        last;
     
     } else {
       ($err,$com) = Util->run_command(
          System->get_home() . "/bin/sanbox get_zone $ip sl all", "raidutil.txt", 10);
       if ("@$com" !~ /Port: \d/) {
  	if ($response){
             @return = ($wwn, 'switch2', 'Switch1'); last;
  	} else {
  	   # This device didn't support snmp, so it can't be a switch
  	   # Not sure what this device would be(Could be inrange switch)
  	   @return = (undef, undef, undef); last;
  	}
       }else{
          @return = ($wwn, 'switch', 'Switch1'); last;
       }
     }
     last;
  }
  if ($http) {
     print "\nOK $return[0]|$return[1]|$return[2]|$ipno";
  } else {
     return @return;
  }
}
sub find_name {
   my($class, $ip) = @_;

   
   my $comm;
   my $DIR = System->get_home();
   my $err;
   my $id;
   $comm = "$DIR/snmp/bin/snmpwalk -r 0 -t 15 -m all -Osb  $ip public sysName";
   ($err,$id) = Util->run_command($comm, "getWWN", 10);

   my $name;
   if($id->[0] =~ /sysName.0 = (.+)/){
      $name = $1;
      $name =~ s/[<>"]//g;
      return ($name);
   } 

   return undef;
}
1;
