package Logic::SAMFS;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Name:  $ 
#  $Id: SAMFS.pm,v 1.9 2004/08/17 01:11:46 bkeslin Exp $


use Util;
use strict;
use Agent::SAMFS;
use Logic;

sub addToConfig {
   my($class, $samfs_config) = @_;
   my ($err, $ipno, $active, $x, $pingout);
   $active = "Y";
   my $q = $samfs_config;
   my @nodes;

   while (1) {
     if (!$samfs_config->{ip}) {
        $err = Error->error(103);
        last;
     } else {

        my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();

        my ($rc) = Agent::SAMFS->getWWN($q->{ip}, $q->{host});
        if ($rc->{error}) {
	   $err = Error->warning("cannot_discover",  $rc->{error});
           last;
	}

        my $key = $rc->{key};
        if (!$key) {
           $err = Error->warning("cannot_discover",  "$samfs_config->{ip}");
           last;
        }
        my %THERE;
        foreach $x (@$devs) {
          if (index("samfs", $x->{type}) >= 0) {
             $THERE{$x->{key}} = 1;
          }
        }
        if (!$THERE{$key}) {
           my $prodID = System->getPackageInfo("", "SUNWsamfsr", "NAME");
           $x = $#$devs + 1;
           PDM::ConfigFile->addDevice($devs, {
           type       => "samfs",
           class      => "application.samfs",
           key        => $key,
           name       => $samfs_config->{name} || $samfs_config->{ip},
           active     => $active,
           ip         => $samfs_config->{ip},
           ipno       => Util->name2ip($samfs_config->{ip}),
           host       => $samfs_config->{host},
           userLabel  => "SAM-QFS",
	       product_id => $prodID,
           });
           Logic->clearSlave($samfs_config->{host}, $hosts);
           push(@nodes, $devs->[$x]);

           if (!PDM::ConfigFile->write($renv, $devs, $hosts,$notifs)) {
             $err = Error->error(101);
           }
        }
     }
     last;
    }
out:
    return ($err, \@nodes);
}

1;

