package Logic::3310;

use Util;
use strict;
use Agent::3310;
use Logic;

sub addToConfig {
   my($class, $q) = @_;
   my ($err, $ipno, $active, $x);
   $active = "Y";
   my @nodes;

   while (1) {
     if (!$q->{ip}) {
        $err = Error->error(103);
        last;
     } else {

        my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
        my $rc = Agent::3310->getFastWWN($q->{ip}, $q->{host});
        if (!$rc->{key} || $rc->{error} ) {
           $err = Error->error(no_device => "$q->{ip}</b> $rc->{error}");
           last;
        }
        my $key = $rc->{key};

        my %THERE;
        foreach $x (@$devs) {
          if (index("3310,3510,3511", $x->{type}) >= 0) {
             $THERE{$x->{key}} = 1;
          }
        }
        if (!$THERE{$key}) {
           $x = $#$devs + 1;

           my $nd = {
              type     => $rc->{type},
              class    => "storage." . $rc->{type},
              key      => $key,
              wwn      => $rc->{wwn},
              wwns     => $rc->{wwns},
              name     => $q->{name} || $q->{ip},
              active   => $active,
              userLabel=> $rc->{userLabel} || $q->{userLabel},
              ip       => $q->{ip},
              ipno     => $rc->{ipno} || $q->{ip},
               telnet   => Util->encodeAll($q->{telnet}),
              host     => $q->{host},
           };
           if (index($rc->{wwn2},",") >= 0 || index($rc->{wwn2},"|") >= 0) {  # wwn_list
             $nd->{wwns} = $rc->{wwn2};
             $nd->{wwn2} = "";
           }

           PDM::ConfigFile->addDevice($devs, $nd);
 
           Logic->clearSlave($q->{host}, $hosts);
           push(@nodes, $devs->[$x]);

           if (!PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs)) {
             $err = Error->error(101);
           }
        }
     }
     last;
    }
out:
    return ($err, \@nodes);
}

sub discover {
  my($class, $SELECT, $desc2, $html) = @_;

 my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my $G = Labels->read();
  my %F;
  my($cnt) = 0;
  foreach my $d (@$devs) {
     if (index("3310,3510,3511", $d->{type}) >= 0) {
        $cnt++;
        $F{$d->{key}} = 1;
     }
  }
  print "<pre>" if ($html);
  print "1 - " . $G->expand('find_already', "$cnt $desc2") . " $SELECT...\n";

  if (!$SELECT || $SELECT eq "local") {
    print "2 - " . $G->expand('find_local', $desc2) . "\n";
    my $locals = Agent::3310->discover(undef, {});
 
    my($skipit, $j, $addit) = 0;
 
    my($new_dev) = $#$devs;
 
    foreach my $l (@$locals) {
       my $key  = $l->{key};
       my $name = ($l->{name});
       my $path = $l->{path};
       next if (!$key);
       if (!$F{$key}) {
         $cnt++;
         print $G->expand('found_new',  "$path/$key") . "\n";
         $new_dev++;
	 my $hexstr = sprintf("%6.6x",substr($key,-6));
         my $nd = {
           type     => $l->{type},
           class    => "storage." . $l->{type},
           name     => $l->{type} . "-" . uc($hexstr),
           ipno     => $l->{ip},
           ip       => $l->{ip},
           path     => $path,
           wwn      => $l->{wwn},
           key      => $key,
           active   => 'Y',
           host     => "",
         };
         $nd->{wwn2}     = $l->{wwn2} if ($l->{wwn2});
         $nd->{wwn3}     = $l->{wwn2} if ($l->{wwn3});
         $nd->{wwn4}     = $l->{wwn2} if ($l->{wwn4});
         PDM::ConfigFile->addDevice($devs, $nd);
          
       } else {
         print "   $G->{already_exist} $path/$key \n";
       }
    }
  }
 my($data, $d2, $file, $h, $url, $hbano);
  my($TO) = 20;
  print "3 - " . $G->expand('find_slave', $desc2) . "\n";
  my($new_dev) = $#$devs;

  foreach $h (@$hosts) {
    next if($h->{dh} eq "Y");

    if (!$SELECT || $SELECT eq $h->{hostname}) {
      print "  - " . $G->expand('querying_host', "$h->{hostname} / $h->{ip}") .
"\n";

      my $data = Agent::3310->discover($h->{ipno});
      foreach my $d2 (@$data) {
        my $key  = $d2->{key};
        my $name = $d2->{name};
        my $path = $d2->{path};
        next if (!$key);
        if (!$F{$key}) {
          $F{$key} =1;
          $cnt++;
          print "    ". $G->expand('found_new', "$path/ $key") . "\n";
          $new_dev++;
          PDM::ConfigFile->addDevice($devs, {
            type     => $d2->{type},
            class    => "storage." . $d2->{type},
            name     => $name,
            wwn      => $key,
            key      => $key,
            path     => $path,
            active   => 'Y',
            host     => $h->{hostname},
           });
        }
      }
    }
  }
  print $G->expand('fount_cnt_dev', $cnt,  $desc2) . "\n";
  if ($cnt) {
     PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
  }
}


1;

