package Linktest::BROCADE;
use strict;
use Report;
use Linktest;
use Linktest::Node;
use base 'Linktest::Node';


sub class {'switch.brocade'}

sub type2 {"SW"}

sub needPassword {1}

sub prompt_info {
  my($node) = @_;
  return ($node->{WWN}, $node->{port});
}


sub portTest {
  my($switch, $nodeB) = @_;

  if ($nodeB->class() =~ /storage.t3/ && $switch->portType() eq "f-port") {
     return 0;
  }
  my ($switch_type, $port_type);
  if ($nodeB->type2() eq "HB") {
    my($port_type, $label) = $switch->portAndLabel();
    if ($port_type eq "f-port" && ( ($label =~ /2x00/) || ($label =~ /2800/) ) ) {
        return 0;
    }
    return 1;
  }
  return 1;

}
sub portAndLabel {
  my($sw) = @_;
  my $config_node = $sw->config();
  my $to_node     = $sw->topo();

  if (!$to_node || !$config_node) {
    $sw->prompt('no_instrumentation' );
    $sw->prompt('ra_instrumentation' );
    Linktest->program_error();
  }
  my $ports = $to_node->portInfo();
  my $port = $ports->[$sw->{port}];

  return ($port->{sw_PortType}, $config_node->{userLabel});
}


sub start_test_msg {
  my($node, $test, $options, $verbose, $estimated_time) = @_;

  my($port_type, $label) = $node->portAndLabel();

  if ($port_type ne "fl-port" && ( ($label =~ /2x00/) || ($label =~ /2800/) ) ) {
      print( "linktest -Pattern- option unsupported and ignored for this device.\n" );
  }elsif ( ($label ne "2x00") && 
       (( $port_type ne "fl-port" ) && ( $port_type ne "f-port" ))) {
      print( "linktest -Pattern- option unsupported and ignored for this device.\n" );
  }
  print( "$test started on " . $node->id() . "\n" );
  print "options= $options \n" if (System->get_debug());
}




sub start_diagnostic {
  my($node, $mode) = @_;
  my($test, $options, $sparcv9, $estimated_time);

  my($verbose, $wb_patterns, $option_user_pattern, $option_pattern_type) = $node->diag_defaults();

  $test = "brocadetest";

  my $user_password = $node->password();

  $options = "$verbose -q -f -o " . '"' . "dev=$node->{port}:$node->{ip}|passwd=$user_password|selectpattern=$wb_patterns" . $option_user_pattern . '"'; #$options = "$verbose -q -f -o " . '"' . "dev=$node->{port}:$node->{ip}|passwd=$user_password" . '"';

  if ($option_pattern_type eq "user") {
    $estimated_time = 1;
  } elsif ($option_pattern_type eq "critical") {
    $estimated_time = 7;
  } else {
    $estimated_time = 70;
  }

  return $node->run_diagnostic($test, $sparcv9, $options, $estimated_time);
}


  

1;
