package Linktest::3511;

use strict;
use Linktest::Node;
use base 'Linktest::Node';


sub portTest {0}

sub class {'storage.3511'}

sub type2 {"ST"}

sub prompt_info {
  my($node) = @_;
  return ($node->{logical}, $node->{port});
}

sub node_isolation {
  my ( $node_a, $node_b, $failed_node, $mode ) = @_;

  Linktest->debug_header( $node_a, $node_b, "3511_node_isolation" );
  my $linkEnv = System->get_linkEnv();

  my $diagnostic_node;
  my $answer;
  my $status;
  my $out;

  if ( $mode eq "PORT" ) {
    $diagnostic_node = $node_a;
  } else {
    if ( $node_a->{driver} eq 'ifp' ) {
      Linktest->skip_io_device( $node_a->{type} );
    }
    $diagnostic_node = $node_b;
  }
  # Try device sfp
  $node_a->prompt('remove_device_sfp' );
  $node_a->prompt('replace_port_sfp' );
  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    $out = $node_b->start_diagnostic( "E" );
  } else {
    $node_b->prompt('remove_device_sfp' );
    $node_b->prompt('restore_device_sfp' );
    Linktest->premature_exit();
  }

  if ( $out->{rc} == 0 ) {
    # the test passed with a new sfp. The sfp is the suspect.
    $node_a->prompt('suspect_device_sfp' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }

  #else not the sfp
  # restore original
  $node_a->prompt('remove_device_sfp' );
  $node_a->prompt('restore_device_sfp' );

  # try cable

  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('replace_device_cable' );
  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    $out = $node_b->start_diagnostic( "E" );
  } else {
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_cable' );
    Linktest->premature_exit();
  }
  if ( $out->{rc} == 0 ) {
    # the test passed with a new cable. The cable is the suspect.
    $node_a->prompt('suspect_device_cable' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }

  # it wasn't the CABLE/SFP Must be the device
  $node_a->prompt('suspect_3310');

  $node_a->prompt('ra_3310_tools' );
  return $Linktest::PROBLEM_UNDETECTED;

}


sub start_diagnostic {
  my($node, $mode) = @_;
  my($test, $options, $sparcv9, $estimated_time);

  my($verbose, $wb_patterns, $option_user_pattern, $option_pattern_type) = $node->diag_defaults();

  #$test           = "fctapetest";
  #$options        = "$verbose -q -i1 -f -o " . '"' . "dev=$node->{logical}|m=Readonly|l=Short|s=25300|d=Compression|ft=Disable" . '"';
  $estimated_time = 5;

  #return $node->run_diagnostic($test, $sparcv9, $options, $estimated_time);
  return 0;
}



1;

  

