package GUIAdmin::T3;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: T3.pm,v 1.12 2004/03/30 16:34:50 mckenney Exp $

use PDM;
use Util;
use Html;
use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';
use Logic::T3;
use Discover;

sub isDevice {
   my $renv = System->get_renv();
   return 0 if ($renv->{solution} eq "se2");
   return 1;
}

sub description {'Sun T3'};

sub ipRequired {1}

sub discoverNU {
  my( $q, $post, $util) = @_;
  my($o, $warn);
  print Html->text_header();

  my $name = $q->{NAME} || "T3";
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  my $use;
  my $L = Labels->read("GUIAdmin::default")->section("discover");

  foreach my $h1 (@$host) {
      last;
      next if ($q->{select_host} && $q->{select_host} ne $h1->{hostname});
      if (!$h1->{t300logfile}) {
        $warn .= "<b><font color=red>Warning: The $name logfile on $h1->{hostname} has not been entered.</font></b><br>";
      } elsif ($q->{select_host}) {
        $use = "<br> </b>($h1->{t300logfile})";
      }

  }

  if (!$renv->{t300logfile} && (!$q->{select_host} || $q->{select_host} eq "local") ) {
     $warn .= "<b><font color=red>" . $L->expand(warn1 =>  $name) . "</font></b>";
  }

  if ($q->{ACTION_confirm}) {
     my $f = "-f $q->{logfile}" if ($q->{logfile});
     Discover->ras_admin($q->{select_host}, "discover_t3 -p $f", $renv, $host, "arrayFromLog");
     return 'DISCO';
  }

  my $h = Html->header2("admin.gen_maint.discovery", undef, "Sun $name", "discover_t3");

  my $sel = $q->{select_host} || $L->{all_hosts};
  my $scr = Html::Screen->new();
  $scr->add(" <center> $h <form method=get autocomplete=off> <input type=hidden name=GO value=GUI::Discover::discover>
      <input type=hidden name=PKG value=GUIAdmin::T3::discover>
      <input type=hidden name=select_host value=\"$q->{select_host}\"> $warn");

  $scr->table( { title => ""},
    [
    [ f => $L->{select} , "$sel $use" ],
    [ f => $L->{use},   "<input type=text name=logfile size=50 value=$renv->{t300logfile}>" ],
    ]);

  $scr->button2( [
     [ l => 'ACTION_confirm', $L->{confirm} ],
     ]);
  $scr->add(" </form>");
  print $scr->out();

  return 0;

}

# returns the t3 that a slave has.
# response to a http request made by a master rasagent.

sub get_Devices {
  my($q, $post, $util) = @_;
  my($l, $loc, @a, $out, $t);

  my(%F);
  if (open(O, $q->{file})) {
     my $cnt1;
     while ($l = <O>) { 
       last if ($cnt1++ > 20000);
       @a = split(/ +/, $l);
       $loc = $a[3];
       $loc = substr($loc,1) if (substr($loc,0,1) eq "[");
       chop($loc) if (substr($loc,-1) eq "]");
       next if ($loc =~ /^\s*$/);
       next if ($loc =~ /\:/);
       $F{$loc} = 1;
     }
     close(O);
     $out = ""; 
     foreach $t (sort keys %F) {
        
        my($ip) = Util->testIp($t,5);
        my $h =  Agent::T3->getWWN($ip);
        if (!$ip) {
           $out .= "ERR=cannot ping $t\n";
        } elsif (!$h->{key}) {
           $out .= "ERR=No Midplane Serial# for $t\n";
        } elsif (!$h->{wwn}) {
           $out .= "ERR=No wwn for $t, probably not a T3\n";
        } else {
           $h->{ip} = $t;
           $h->{ipno} = $ip;
           require Data::Dumper;
           $Data::Dumper::Indent = 0;
           my $v = Data::Dumper::Dumper($h);
           $out .= "OK=$v\n";
        }
     }
     print "OK $out\n";
  } else {
     print "ERR $q->{file} $!";
  }
}

sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel, $warn);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::default")->section("add");

  require "GUI/Devices.pm";
  print Html->body();

  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my($err, $dev) = Logic::T3->addToConfig($q);
    if ($err) {
       $info = $err->toHtml();
    } elsif ($dev) {
       print Html->info($G->{device_added});
       GUI::Devices::list($q);
       return;
    }
  }

  print Html->header2("admin.gen_maint.add_device", undef, "Sun T3"," ", {nocrumb => 1});
  print GUI::Devices::add0($q);

  ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";

  my($phost) = "<select name=host><option value=\"\">[$G->{select}]</option>".
              "<option value=\"\" $sel>$G->{local}</option>";
  foreach $x (@$host) {
    next if($x->{dh} eq "Y");
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  my($phostD) = "<select name=datahost>".  "<option value=\"\" $sel>Same Host</option>";
  my $l1 = {hostname => System->hostname(), ip => System->hostname()};
  foreach $x (@$host, $l1) {
    next if($x->{dh} eq "Y");

    $sel = ($q->{datahost} eq $x->{ip})? "selected":"";
    $phostD .= "<option value=\"" . $x->{ip} . "\" $sel>" . $x->{hostname} ."</option>";
  }
  $phostD .= "<option value=\"*None\">*None</option></select>";

  my $scr = Html::Screen->new();
  $scr->add(" <form  method=get autocomplete=off> <input type=hidden name=GO value=\"GUIAdmin::T3->addDevice\">
      <input type=hidden name=ADD value=T3> <center> $info");

  $scr->table( { title => $L->{enter}, labelWidth => "40%" },
   [
   [ f => $L->{dev_name}, "<input type=text name=name size=15 maxlength=35 value=\"$q->{name}\">" ],
   [ f => $L->{telnet},   "<input type=password name=telnet size=20 maxlength=30 value=\"$q->{telnet}\">"],
   [ f => $L->{primary},  $phost ],
   [ f => $L->{ip},  "<input type=text name=ip size=40 maxlength=40 value=\"$q->{ip}\">" ],
   ]);
   
  my @buttons;
  if (!$deny) {
     push(@buttons, Html::Screen->submitButton("ACTION_add", $L->{submit_add}));
  }
  push(@buttons, Html::Screen->submitButton("ACTION_back", $L->{submit_back}));
  $scr->button(undef, \@buttons);
  $scr->add("</form>");

  print $scr->out();

}

sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);

  print Html->body();
  require "GUI/Devices.pm";
   my $deny = Roles->verifyRole($q, "admin");
   my $L = Labels->read("GUIAdmin::default")->section("update");

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_reNotUsed}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $dev->[$x]{ip}          = $q->{ip};
    $dev->[$x]{ipno}        = Util->name2ip($q->{ip});
    my($key, $wwn, $wwn2, $ctrl, $t3name) =  
    my $hash = Agent::T3->getWWN($dev->[$x]{ipno}, $q->{host});

    $dev->[$x]{key}   = $hash->{key};
    $dev->[$x]{units} = $hash->{units};
    $dev->[$x]{wwn}   = $hash->{wwn};
    $dev->[$x]{wwn2}  = $hash->{wwn2};
    $dev->[$x]{ctrl_model} = $hash->{ctrl_model};
    $dev->[$x]{name}  = $hash->{name} if ($hash->{name});

    GUIAdmin->clearSlave($q->{host}, $host);
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->error("Device $name updated!", "green");

  } elsif ($q->{ACTION_upd}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host}        = $q->{host};
    #$dev->[$x]{datahost}   = $q->{datahost};
    $dev->[$x]{name}        = $q->{name};
    my $old_ipno = $dev->[$x]{ipno} ;
    $dev->[$x]{ip}          = $q->{ip};
    $dev->[$x]{ipno}        = Util->name2ip($q->{ip});
    $dev->[$x]{volVerify}   = $q->{volVerify};
    $dev->[$x]{telnet} = Util->encodeAll($q->{telnet});
    $dev->[$x]{class}  = "storage." . $dev->[$x]{type};
    $dev->[$x]{hba}    = $q->{hba};
    my $old_key        = $dev->[$x]{key};
    my $update = 1;
    if ($old_ipno ne $dev->[$x]{ipno}) {  #  rediscover in case it's a new one

      my $hash = Agent::T3->getWWN($dev->[$x]{ipno}, $q->{host});
      if ($hash->{key} ne $old_key) {
        $err = Html->error("Not the same array: nothing was changed!");
        $update = 0;
      }
    }
    if ($update) {
      GUIAdmin->clearSlave($q->{host}, $host);
      PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
      $err = Html->error("Device $name updated!", "green");
    }

  } elsif ($q->{ACTION_del}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    #my($State) = State->read();
    #my $key = $dev->[$x]{key};
    #print "Clearing cache on  $key <br>";
    #$State->clearComponent("t3:$key");
    #$State->write();

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change("Device $name deleted");
    $q->{ERR} = Html->error("Device $name deleted!");
    GUI::Devices::list($q);
    return;
  }
out:

  print Html->header2("admin.gen_maint.maint_device", undef, "Sun T3"," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];
  $ip = $h->{ip}; 
  $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";

  $ho = "<select name=host><option value=\"\" $sel>Local</option>";
  foreach $h1 (@$host) {
       next if($h1->{dh} eq "Y");

       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $sel = ($h->{datahost})? "":"selected";
  my($dataho) = "<select name=datahost><option value=\"\" $sel>Same Host</option>";
  my $l1 = {hostname => System->hostname(), ip => System->hostname()};
  foreach $h1 (@$host, $l1 ) {
       next if($h1->{dh} eq "Y");

       $sel = ($h1->{ip} eq $h->{datahost}) ? "selected":"";
       $dataho .= "<option value=\"$h1->{ip}\" $sel>$h1->{hostname}</option>";
  }
  $sel = ($h->{datahost} eq "*None")? "selected":"";
  $dataho .= "<option value=\"*None\" $sel>*None</option></select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $telnet = Util->decode($h->{telnet});
  my $verify = Html->makeSelect("volVerify", "=Default|N=Off|Y=On", $h->{volVerify});

  my $scr = Html::Screen->new();
  $scr->add(" <form method=get autocomplete=off> <input type=hidden name=GO value=\"GUIAdmin::T3->updDevice\">
              <input type=hidden name=WIN value=$q->{WIN}>
              <input type=hidden name=no value=$q->{no}> <center> $err");

  my $show_wwn = $h->{wwn};
  $show_wwn .= " / " . $h->{wwn2} if($h->{wwn2});

  my $show_type = $h->{userLabel} || $h->{type};

  $scr->table({ title => $L->{title} },
  [
   [ f => $L->{type}, $show_type ],
   [ f => $L->{monitoring}, $active ],
   [ f => $L->{name}, "<input type=text name=name size=40 maxlength=40 value=\"$h->{name}\">"],
   [ f => $L->{telnet}, "<input type=password name=telnet size=20 maxlength=40 value=\"$telnet\">"],
   [ f => $L->{ip},     "<input type=text size=40 name=ip value=\"$ip\">" ],
   [ f => $L->{ipno},   $ipno ],
   [ f => $L->{key},   $h->{key} ],
   [ f => $L->{wwn},   $show_wwn ],
   [ f => $L->{primary}, $ho ],
   [ f => $L->{verify}, $verify ],
   ]);

  my ($del_but, $back_but);
  if (!$q->{WIN}) {
    $del_but = Html::Screen->submitButton("ACTION_del", $L->{submit_delete});
    $back_but= Html::Screen->submitButton("ACTION_back",$L->{submit_back});
  }
  my @buttons;
  if (!$deny) {
     push(@buttons, Html::Screen->submitButton("ACTION_upd", $L->{submit_update}), $del_but);
  }
  push(@buttons, $back_but) if ($back_but);
  $scr->button(undef, \@buttons);
  $scr->add("</form>");
  print $scr->out();

}


1;

