package GUIAdmin::SWITCH;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SWITCH.pm,v 1.9 2004/01/24 23:01:25 ccadieux Exp $

use PDM;

use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';
use Logic::SWITCH;
use Labels;
use Discover;

sub description {
     return 'Sun Switch';
}
sub isDevice {1}

sub ipRequired {1}



sub addDevice {
  my($class, $q) = @_;

  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel);
  print Html->body();
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::default")->section("add");

  my $deny = Roles->verifyRole($q, "admin");
  require "GUI/Devices.pm";
  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my ($err, $nodes) = Logic::SWITCH->addToConfig($q);
    if ($err) {
       $info = $err->toHtml();
    } elsif ($#$nodes >= 0) {
       print Html->info($G->expand('x_devices_added', ($#$nodes + 1)));
       GUI::Devices::list($q);
       return;
    }
  }
out:
  print Html->header("Add " . $class->description(),"","",
              "Maintenance.General#adddevice", undef, {nohelp => 1});
  print GUI::Devices::add0($q);

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";

  my($phost) = "<select name=host><option value=\"\" $sel>$G->{local}</option>";

  foreach $x (@$host) {
    next if($x->{dh} eq "Y");
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  my $scr = Html::Screen->new();
  $scr->add("<form  autocomplete=off method=get> <input type=hidden name=GO value=\"GUIAdmin::SWITCH->addDevice\"> $info");

  $scr->table( { title => $L->{enter} },
   [
   [ f => $L->{dev_name}, "<input type=text name=name size=15 maxlength=15 value=\"$q->{name}\">" ],
   [ f => $L->{primary},  $phost ],
   [ f => $L->{telnet}, "<input type=password name=password size=20 maxlength=30 value=\"$q->{password}\">"],
   [ f => $L->{ip}, "<input type=text name=ip size=40 maxlength=40 value=\"$q->{ip}\">"],
   ]);

  my(@buttons);
  if (!$deny) {
     push(@buttons, Html::Screen->submitButton("ACTION_add", $L->{submit_add}));
  }
  push(@buttons, Html::Screen->submitButton("ACTION_back", $L->{submit_back}));
  $scr->button(undef, \@buttons);
  $scr->add("</form>");
  print $scr->out();

}


sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);
   my $deny = Roles->verifyRole($q, "admin");
  print Html->body();
  require "GUI/Devices.pm";
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::default")->section("update");

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_upd})  {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host} = $q->{host};
    $dev->[$x]{name} = $q->{name};
    $dev->[$x]{telnet}   = Util->encodeAll($q->{password});

    $dev->[$x]{key}  = $dev->[$x]{wwn};
    #$dev->[$x]{class} = "switch.switch";
    $dev->[$x]{hba}  = $q->{hba};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->info($G->expand('device_updated', $name));

  } elsif ($q->{ACTION_del}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change("Device $name deleted");
    $q->{ERR} = Html->header("Device $name deleted!");
    GUI::Devices::list($q);
    return;
  }
out:

 print Html->header2("admin.gen_maint.maint_device", 
           undef, $class->description()," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";
  $ho = "<select name=host><option value=\"\" $sel>Local</option>";
  foreach $h1 (@$host) {
       next if($h1->{dh} eq "Y");

       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? $G->{mode_on} : $G->{mode_off};
  my($primary);
  $primary = "<br><b>[ Monitored thru $h->{primary} port:$h->{port} on fc:$h->{fc} ]"
              if ($h->{primary});
  my $telnet = Util->decode($h->{telnet});
  my $type = $h->{userLabel} || $h->{type};

  my $scr = Html::Screen->new();
  $scr->add(" <form autocomplete=off method=get> <input type=hidden name=GO value=\"GUIAdmin::SWITCH->updDevice\">
           <input type=hidden name=no value=$q->{no}> <center> $err");

  $scr->table( {title => $L->{title} },
   [
   [ f => $L->{type}, $type ],
   [ f => $L->{monitoring}, $active ],
   [ f => $L->{name}, "<input type=text name=name size=20 maxlength=40 value=\"$h->{name}\">$primary"],
   [ f => $L->{ip}, $ip ],
   [ f => $L->{ipno}, $ipno ],
   [ f => $L->{telnet}, "<input type=password name=password size=20 maxlength=30 value=\"$telnet\">"],
   [ f => $L->{wwn}, $h->{wwn}],
   [ f => $L->{primary}, $ho],
   ]);
  my @buttons;
  if (!$deny) {
      push(@buttons, 
          Html::Screen->submitButton("ACTION_upd", $L->{submit_update}),
          Html::Screen->submitButton("ACTION_del", $L->{submit_delete}));
  }
  push(@buttons, Html::Screen->submitButton("ACTION_back", $L->{submit_back}));
  $scr->button(undef, \@buttons);
  $scr->add(" </form>");
  print $scr->out();

}

1;

