package GUIAdmin::BROCADE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: BROCADE.pm,v 1.12 2004/07/29 19:54:42 mckenney Exp $

use PDM;

use strict;
use Debug;
use Carp;
use GUI::Devices;
use GUIAdmin;
use base 'GUIAdmin';
use Agent::BROCADE;
use Logic::SWITCH;

sub description {'Brocade Silkworm'};

sub isDevice {1}

sub ipRequired {1}


sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel);

  my $deny = Roles->verifyRole($q, "admin");
  print Html->body();
  my $G = Labels->read();

  require "GUI/Devices.pm";
  if ($q->{ACTION_back})  {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my ($err, $nodes) = Logic::SWITCH->addToConfig($q);
    if ($err) {
       $info = $err->toHtml();
    } elsif ($#$nodes >= 0) {
       print Html->info($G->expand('x_devices_added', ($#$nodes + 1)));
       GUI::Devices::list($q);
       return;
    }
  }
out:
  print  Html->header("$G->{add} Silkworm Switch","","",
        "Maintenance.General#adddevice", undef , {nohelp => 1});
  print GUI::Devices::add0($q);


  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";

  my($phost) = "<select name=host><option value=\"\">[$G->{select}]</option>".
              "<option value=\"\" $sel>$G->{local}</option>";

  foreach $x (@$host) {
    next if($x->{dh} eq "Y");
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  my $scr = Html::Screen->new();
  $scr->add(" <form  autocomplete=off method=get> <input type=hidden name=GO value=\"GUIAdmin::BROCADE->addDevice\">  $err");

  $scr->table( {title => $G->{enter_device_info} },
    [
    [ f => $G->{device_name},  "<input type=text name=name size=15 maxlength=15 value=\"$q->{name}\">" ],
    [ f => $G->{telnet},       "<input type=password name=telnet size=20 maxlength=30>" ],
    [ f => $G->{primary_host}, $phost ],
    [ f => $G->{ip_name},      "<input type=text name=ip size=40 maxlength=40 value=\"$q->{ip}\">"],
    ]);

  my @buttons;
  if (!$deny) {
     push(@buttons, Html::Screen->submitButton("ACTION_add", $G->{submit_add}));
  }
  push(@buttons, Html::Screen->submitButton("ACTION_back", $G->{submit_back}));
  $scr->button(undef, \@buttons);
  $scr->add("</form>");
  print $scr->out();

}

sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);
  my $G = Labels->read();

  print Html->body();
  require "GUI/Devices.pm";
   my $deny = Roles->verifyRole($q, "admin");

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host} = $q->{host};
    $dev->[$x]{name} = $q->{name};
    $dev->[$x]{telnet} = Util->encodeAll($q->{telnet});

    $dev->[$x]{class}= "switch.brocade";
    $dev->[$x]{hba}  = $q->{hba};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->info($G->expand('device_updated',  $name));

  } elsif ($q->{ACTION_delete}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change($G->expand('device_deleted', $name));
    $q->{ERR} = Html->error($G->expand('device_deleted', $name)); 
    GUI::Devices::list($q);
    return;
  }
out:

  print Html->header2("admin.gen_maint.maint_device", undef, "> Sun Brocade Switch"," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";
  $ho = "<select name=host><option value=\"\" $sel>$G->{local}</option>";
  foreach $h1 (@$host) {
       next if($h1->{dh} eq "Y");
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $telnet = Util->decode($h->{telnet});

  my $scr = Html::Screen->new();
  $scr->add(" <form autocomplete=off method=get> <input type=hidden name=GO value=\"GUIAdmin::BROCADE->updDevice\"> 
           <input type=hidden name=no value=$q->{no}>  $err");

  $scr->table({ title => $G->{enter_device_info} },
     [
     [ f => $G->{device_type}, $h->{type} ],
     [ f => $G->{monitoring}, $active     ],
     [ f => $G->{device_name}, "<input type=text name=name size=20 maxlength=40 value=\"$h->{name}\">"],
     [ f => $G->{ip_name}, $ip ],
     [ f => $G->{ip_number}, $ipno ],
     [ f => $G->{telnet}, "<input type=password name=telnet size=20 maxlength=30 value=\"$telnet\">"],
     [ f => "WWN", $h->{wwn} ],
     [ f => $G->{primary_host}, $ho ],
     ]);

  my @buttons;
  if (!$deny) {
      push(@buttons, 
            Html::Screen->submitButton("ACTION_update", $G->{submit_update}),
            Html::Screen->submitButton("ACTION_delete", $G->{submit_delete}));
  }
  push(@buttons, Html::Screen->submitButton("ACTION_back", $G->{submit_back}));
  $scr->button(undef, \@buttons);
  $scr->add(" </form>");
  print $scr->out();
}


1;

1;
