package GUIAdmin::A3500FC;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: A3500FC.pm,v 1.12 2004/06/03 16:19:10 ccadieux Exp $

use PDM;

use strict;
use Debug;
use RM6;
use Util;
use Util::Http;
use System;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';

sub description {'Sun A3500FC'}
sub isDevice {1}

sub discover {
  my($q,$post,$util) = @_;
  my(%T, @a, $loc, $ip, $new_dev, $d, $adding, $name, $wwn, $hba, $local, $found, $l, $h);
  my($url);
  my($TO) = $util->{TO} || 20;
  my($RASPORT) = $util->{RASPORT} || "7654";
  my $G = Labels->read();
  my $SELECT = $q->{select_host};

  my(%F);
  my(@NEW);

  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $new_dev= $#$dev ;
  foreach $d (@$dev) {
     if ($d->{type} eq "a3500fc") {
        $F{$d->{name}} = 1;
     }
  }
  $found = keys(%F);
  print "<pre>1 - ".  $G->expand('found_already', $found, &description) . "\n";

  my($devs, $wwn2, $dev_type) ;
  if (!$SELECT || $SELECT eq "local") {
    print "2 - " . $G->expand('find_local', &description()) . "\n";
    $adding = 0; $found = 0;
    $q->{type} = "A3500";
    $local = RM6::get_devices($q);

    if (substr($local,0,3) eq "ERR") {
       print "   $local<br>";
    } else {
      @a = split(/\n/, substr($local,3));
      foreach $l (@a) {
        $wwn2 = "";
        ($name, $devs, $wwn, $wwn2, $dev_type) = split(/=/, $l);
        $found++;
        print "  - " . $G->expand('found_new', "$name/$wwn");
        if (!$F{$name}) {
         $F{$name} = 1;
         $adding = 1;
         $new_dev++;
         my $type2 = $dev_type || 'a3500fc';
         PDM::ConfigFile->addDevice($dev,
            {  
                type    => $type2,
               class    => "storage." . $dev->[$new_dev]{type},
                 wwn    => $wwn,
                wwn2    => $wwn2,
                 key    => "$type2." . ($wwn || $name),
              active    => 'Y',
                name    => $name,
                host    => ""
             });
         print $G->{device_added} . "\n"; 
        } else {
           print " " . $G->{already_exist} . "\n";
        }
      }
    }
    if (!$found) {
      print "  - " . $G->expand('no_found_master', &description()) . "\n";
    }
  }

  my($data, $a5, $file);
  print "3 - " . $G->expand('find_slave', &description()) . "\n";
  foreach $h (@$host) {
    next if ($SELECT && $SELECT ne $h->{hostname});
    next if($h->{dh} eq "Y");
    print "  -" .  $G->expand('querying_host', "$h->{hostname} / $h->{ip}") . "\n";

    if (($data = Util::Http->getCommand($h->{ip}, "RM6::devices&type=A3500&print=1", 10)) ) {
      if (substr($data,0,3) eq "ERR") {
           print "  $data<br>";
           next;
      } else {
           $data = substr($data,3);
      }
      @a = split(/\n/, $data);
      foreach $a5 (@a) {
           $wwn2 = "";
           ($name, $devs, $wwn, $wwn2) = split(/=/, $a5);
           next if (!$name);
           print "  - " . $G->expand('found_new', "$name/$wwn") ;
           if (!$F{$name}) {
              $adding = 1;
              $new_dev++;
              PDM::ConfigFile->addDevice($dev, {
                 type     => 'a3500fc',
                 class    => 'storage.a3500fc',
                 wwn      => $wwn,
                 wwn2     => $wwn2,
                 key      => $name,
                 name     => $name,
                 active   => 'Y',
                 host     => $h->{hostname}
                  });

              $h->{last_push} = "";
              print ", " . $G->{device_added} . "\n";
              $F{$name} = 1;
           } else {
              print ", " . $G->{already_exist} . "\n";
           }
      }
    } else {
      print $G->expand('no_response', $h->{ip}) . "\n";
    } 
  }

  if ($adding) {
      PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
  } else {
    print $G->{no_new_dev} . "\n";
  }
  print "</pre>";
  return "DONE";
}

#
# returns the a3500 that a slave has.
# response to a http request made by a master rasagent.

sub getDevicesDI {
  my($q, $post, $util) = @_;
  my(@out, $f, $l, $name, $hba, $in , $wwn, $x, $i, $path, $out, $out2, $err);
  my($details, $dev, $vendor);

  my($di) = System->get_home() . "/bin/disk_inquiry";

  ($err,$out) = Util->run_command($di, "luxprobe.txt", 20);

  return "\nERR $err" if ($err);

  for ($x=0; $x <= $#$out; $x++) {
    $l= $out->[$x];
    my($ix) = index($l, ":");
    $l= substr($l, $ix+2);
    my(@a) = split(/\s+/, $l);
    $dev = $a[0]; $vendor = $a[2]; $wwn = $a[1];
    next if ($a[2] !~ /A3500/);
    $f .= "$dev=$wwn=X\n";
  }

  return "OK $f\n";
}

sub getDevicesLUX {
  my($q, $post, $util) = @_;
  my(@out, $f, $l, $name, $hba, $in , $wwn, $x, $i, $path, $out, $out2, $err);
  my($details);

  my($lux) = "/usr/sbin/luxadm";

  my($HOME) = System->get_home();
  ($err,$out) = Util->run_command("$lux probe", "luxprobe.txt", 20);
  return "\nERR $err" if ($err);
  for ($x=0; $x <= $#$out; $x++) {
    $l= $out->[$x];
    $name = $out->[$x+1];
    $name =~ /Logical Path:\/.*\/.*\/(.*)/;
    $name = $1;
    if ($l =~ / Node WWN:(.+)\s+Device Type:Disk/) { # A3500
      $wwn = $1;
      ($err,$out2) = Util->run_command("$lux display $wwn", "luxadm_disk3.txt",
 10);
      next if ($err);
      $details = "@$out2";
      $f .= "$name=$wwn=X\n" if ($details =~ /A3500/);
    }
  }
  return "OK $f";
}




sub addDevice {
  my($class, $q) = @_;

  my $G = Labels->read();
  print Html->body();
  print "&nbsp;<p>";
  print Html->info(Util->abb("a3500fc.medium") . "<br>" . $G->expand(discover_redirect => "A3500FC")) ;
}


sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);

  my $L = Labels->read('GUIAdmin::A3500FC')->section('update'); 
  my $G = Labels->read();

  my $deny = Roles->verifyRole($q, "admin");
  print Html->body();
  require "GUI/Devices.pm";

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host} = $q->{host};
    $dev->[$x]{name} = $q->{name};
    $dev->[$x]{class} = "storage.a3500fc";
    $dev->[$x]{wwn} = $q->{wwn};
    $dev->[$x]{key} = $q->{name};
    $dev->[$x]{wwn2} = $q->{wwn2};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->info($G->expand('device_updated', $name));

  } elsif ($q->{ACTION_delete}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{name};

    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change($G->expand('device_deleted', $name));
    $q->{ERR} = Html->error($G->expand('device_deleted', $name));
    GUI::Devices::list($q);
    return;
  }
out:

  print Html->header2("admin.gen_maint.maint_device", undef, &description()," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $sel = ($h->{host})? "":"selected";
  $ho = "<select name=host><option value=\"\" $sel>$G->{local}</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $dev_type = $h->{userLabel} || $h->{type};

  my $scr = Html::Screen->new();
  $scr->add("<form  autocomplete=off method=get> <input type=hidden name=GO value=\"GUIAdmin::A3500FC->updDevice\">
              <input type=hidden name=no value=$q->{no}> $err");

  $scr->table({ title => $L->{title}},
    [
    [ f => $L->{type}, $dev_type ],
    [ f => $L->{monitoring}, $active ],
   [ f => $L->{name}, "<input type=text name=name size=20 maxlength=40 value=\"$h->{name}\">"],
   [ f => $L->{serial}, "<input type=text name=wwn size=20 maxlength=20 value=\"$h->{wwn}\">" ],
   [ f => $L->{serial2}, "<input type=text name=wwn2 size=20 maxlength=20 value=\"$h->{wwn2}\">" ],
   [ f => $L->{host}, $ho ],
   ]);

  my(@buttons);
  if (!$deny) {
     push(@buttons, Html::Screen->submitButton("ACTION_update", $G->{submit_update}) , 
                    Html::Screen->submitButton("ACTION_delete", $G->{submit_delete}) );
  }
  push(@buttons, "<input type=submit name=ACTION_back value=\"$G->{submit_back}\">");
  $scr->button(undef, \@buttons);
  $scr->add(" </form>");
  print $scr->out();

}




1;
