package GUI::Welcome;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
use System;
use Util;
use strict;

#  $Id: Welcome.pm,v 1.19 2004/04/26 19:50:08 ccadieux Exp $


sub welcome {
  my($q) = @_;
  my $out;
  print Html->body();
  my $G = Labels->read();
  my $L = Labels->read('GUI::Review')->section('welcome');
  my $NARROW = Http->isNarrow();

  my $altactive;
  if (-f System->get_home() . "/DATA/ALTACTIVE") {
    print "&nbsp;<p>" . Html->warning($L->{altactive}) ;
    $altactive = 1;
  }

  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
  if (!$renv) {
     print "&nbsp;<p><center>$L->{err_1}";
     return;
  }
  my $master = Util->findMaster();
  my $port   = System->get_rasport();
  if ($master) {
     print "&nbsp;<p>&nbsp;<br>
      <table border=0 cellpadding=4 cellspacing=0 bgcolor=white width=60%>
       <tr><td><center><big><a href=http://$master:$port target=_top>
        <font color=red>$L->{err_2}
      </table>";
     return;
  }
  my($acronym) = $renv->{GSV_ACRONYM};

  print Html->header2('ROOT.about', undef,undef,{noHelp =>1});

  #my $welcome = Util->readHtdocs("welcome");
  my $copyright = Util->readHtdocs("copyright");
  $copyright =~ s/<body /<Xody /;
  $copyright =~ s/<p>//;

  my ($extra, $config_summary) = &config_summary($renv, $devs, $hosts, $notifs, $G, $L);

  my $state_summary  = $NARROW ? "" : &state_summary($extra, $G, $L);

  print "<table border=0 cellspacing=0 cellpadding=0 width=$Style::WIDTH><tr>
        <td valign=top width=50%>$config_summary</td><td valign=top>$state_summary</td></table>
  <table border=0><tr><td></table>";
  return if ($NARROW);

  
  if (!$altactive) {
    my $steps = &steps($L);

    print "
    <script>
    function win1() {
      var O = window.open('$Http::WEBPROC?GO=GUI::Welcome::steps_win', 'install',
                'menubar=no,resizable=yes,scrollbars=no,width=720,height=220');
      O.focus();
    }
    </script>
    <table border=1 cellspacing=0 cellpadding=0 width=$Style::WIDTH><tr><td bgcolor=black>
    <table border=0 cellpadding=2 cellspacing=0 width=100% bgcolor=#F0F0F0>
      <tr><td bgcolor=\"$Style::LIGHT\">
       <table border=0 cellspacing=0 cellpadding=0 width=100%>
          <tr><td><b>$L->{steps}</td>
              <td align=right>[ <a href=javascript:win1()>$L->{steps2}</a> ]
       </table>
      <tr><td> $steps </td>
     </table></table>";

    print " </table> ";
  }
  print "&nbsp;<table border=0 cellpadding=5 width=$Style::WIDTH bgcolor=#F0F0F0><tr><td>$copyright</table>";
}
# <a href=$Http::WEBPROC?GO=GUI::AlertReport::state>$LB->{details}</a> |

sub state_summary {
  my($extra, $G, $LB) = @_;
  my $renv = System->get_renv();
  require GUI::AlertReport;
  my $L = GUI::AlertReport->state_();
  my $cnt=0;
  my $out = "
  <table border=1 cellspacing=0 cellpadding=0 width=100%><tr><td>
  <table border=0 cellpadding=2 cellspacing=0 width=100% bgcolor=white>
   <tr  bgcolor=$Style::LIGHT> <td>
    <table border=0 cellspacing=0 cellpadding=0 width=100%>
        <tr><td><b>&nbsp;$LB->{alert_summ}</b></td>
        <td align=right>[ 
     <a href=$Http::WEBPROC?GO=GUI::DeviceReport::run>$LB->{health}</a> |
     <a href=$Http::WEBPROC?GO=GUI::DeviceReport::run&summary=2>$LB->{dev_details}</a> 
     ]&nbsp;</table>
   <tr><td >
    <table border=0 cellspacing=1 cellpadding=2 width=100%>
        <tr bgcolor=$Style::BGCOLOR><td><b>$LB->{cat0}</th>
           <th><img src=/gif/al_down.gif vspace=0 title=\"$LB->{downD}\" alt=\"$LB->{downD}\"></th>
           <th><img src=/gif/al_crit.gif vspace=0 title=\"$LB->{errD}\" alt=\"$LB->{errD}\"></th>
           <th><img src=/gif/al_alert.gif vspace=0 title=\"$LB->{warnD}\" alt=\"$LB->{warnD}\"></th>
           <th><img src=/gif/al_caution.gif title=\"$LB->{infoD}\" alt=\"$LB->{infoD}\" vspace=0></th>
            ";
  foreach my $l (@$L) {
     if ($l->[5] =~ /^se\d*/ && $renv->{solution} ne "N") {
       my $bg = $cnt % 2 == 1 ? "bgcolor=#F0F0F0":"";
       $out .= "<tr $bg><td colspan=4><b>System</td>";
       $cnt++;
     }
     my $bg = $cnt % 2 == 1 ? "bgcolor=#F0F0F0":"";
     $out .= "<tr $bg><td>$l->[1]</td><td><b><center>$l->[4]&nbsp;</td><td><b><center>$l->[3]&nbsp;</td><td><b><center>$l->[2]&nbsp;</td><td>&nbsp;</td>";
     $cnt++;
  }
  my($x);
  for ($x = $cnt ; $x <= 3 + $extra; $x++) {
     my $bg = $cnt % 2 == 1 ? "bgcolor=#F0F0F0": "";
     $out .= "<tr $bg><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>";
     $cnt++;
  }
  $out .= "</table></table></table>";
  return $out;
}


sub config_summary {
  my($renv,  $devs, $hosts, $notifs, $G, $L) = @_;

  my $LB = Labels->read('GUI::Review')->section('welcome');

  my $hcnt = $#$hosts + 2;
  my $dcnt = $#$devs + 1;
  my $not;
  $not .= "Http, " if ($renv->{'pro.http.active'} eq "Y");
  $not .= "NetConnect, " if ($renv->{'pro.netconnect.active'} eq "Y");
  $not .= "SRS, " if ($renv->{'pro.srs.active'} eq "Y");
  $not .= "SSRR, " if ($renv->{'pro.ssrr.active'} eq "Y");
  $not .= "Trap, " if ($renv->{'pro.trap.active'} eq "Y");
  $not .= "Email, " if ($renv->{'pro.nscc_email.active'} eq "Y");
  $not .= "SunMC, " if ($renv->{'pro.sunmc.active'} eq "Y");

  my $not_title;
  if ($not) {
    chop($not);chop($not);
    $not_title = $L->{notifs} ;
  } else {
    $not = $LB->{none};
    $not_title = $L->{notif};
  }
  my $em = $notifs->[0]{email} . " " . $notifs->[1]{email};
  my $info = $renv->{customer} . " " . $renv->{site_city} . " " . $renv->{site_state};
  if (!$renv->{site_country}) {
     $info .= "&nbsp;<b><a href=$Http::WEBPROC?GO=GUI::Config::site>".
               "<font color=red>$L->{site_err}</font></a>";
  }
  my $last = Util->get_file_created(System->get_home() . "/DATA/Events.log");
  $last = "[$LB->{no_event}]" if (!$last);

  my $laste = Util->get_file_created(System->get_home() . "/DATA/Alerts.log");
  $laste = "[$LB->{no_alert}]" if (!$laste);
  my %C;
  foreach my $d (@$devs) {
    $C{$d->{type}}++;
  }
  my(%SP);
  $SP{$renv->{solution_model}}++ if ($renv->{solution_model});
  foreach my $h (@$hosts) {
     if ($h->{solution_model}) {
       $SP{$h->{solution_model}}++;
     }
  }
  my ($sol, $sol2, $extra);
  my $next = "";
  
  return ($extra, "
  <table border=1 cellspacing=0 cellpadding=0 width=100%><tr><td>
  <table border=0 cellpadding=2 cellspacing=0 width=100% bgcolor=white>
   <tr><td colspan=2 bgcolor=$Style::LIGHT><b>&nbsp;$L->{conf_summ}</td>
   <tr><td colspan=2>
    <table border=0 cellspacing=1 cellpadding=2 width=100%>
     <tr  bgcolor=$Style::BGCOLOR>
       <td align=right>$L->{site}:</td><td><b>$info $renv->{cust_no}<img src=/gif/dot_clear.gif height=13 width=1></td>
     <tr>
       <td align=right>$L->{ins}:</td><td>$hcnt $LB->{hosts}, $dcnt $LB->{devices}</td>
     <tr  bgcolor=#F0F0F0>
       <td align=right>$not_title:</td><td>$not</td>
     <tr>
       <td align=right width=25%>$L->{email}:</td><td>$em</td>
     <tr bgcolor=#F0F0F0>
       <td align=right width=25%>$L->{event}:</td><td>$last</td>
     </table>
  </table></table>");
}

use vars qw (@A @B $RACK_SKIP);

@A = ('site','hosts','devices','email','notif','topo','config','start');
@B = ('GUI::Config::site',      'GUI::Hosts::list',
           'GUI::Discover::run',     'GUI::Notifs::list',
           'GUI::Providers::display','GUI::SAN::snapshot', 
           'GUI::Review::run&no_start=1',       'GUI::Start::Agents'
           );
$RACK_SKIP = "devices,hosts,topo,";

sub steps {
  my ($L) = @_;
  my ($x, $out);
  my $renv = System->get_renv();

  $out = "<table border=0 cellspacing=0 cellpadding=0  width=100%><tr><td>";
  
  for ($x=0; $x <= $#A; $x++) {
     next if ($renv->{solution} ne "N" && index($RACK_SKIP, $A[$x]) >= 0);
     my $l = "step_" . $A[$x];
     $out .= "<td>
    <table border=1 cellspacing=0 cellpadding=4 bgcolor=white width=100%>
      <tr><td><b><center>
        <a href=$Http::WEBPROC?GO=$B[$x]>$L->{$l}</a></td>
      </table>
    </td>";
     $out .= "<td> <img src=/gif/arrow.gif></td>" if ($x < $#A);
  }
  $out .= "</table>";

  return $out;
}

sub steps_win {

  my $L = Labels->read('GUI::Review')->section('welcome');
  my $js = &js2();
  my ($x, $out, $layers);
  my $renv = System->get_renv();
  print Html->body();
  $out =<<EOF;
$js<Xbody bgcolor=$Style::DARK>
<table border=0 cellspacing=2 cellpadding=1 width=70%><tr><td bgcolor=black>
    <table border=0 cellpadding=2 cellspacing=1 width=100% bgcolor=#F0F0F0>
      <tr><td bgcolor=$Style::LIGHT>
          <b>$L->{steps}</td>
      <tr><td>
<table border=0 cellspacing=0 cellpadding=0><tr>
EOF
  my $cnt = 11;
  for ($x=0; $x <= $#A; $x++) {
     next if ($renv->{solution} ne "N" && index($RACK_SKIP, $A[$x]) >= 0);
     my $l = "step_" . $A[$x];
     my $info  = "info_" . $A[$x];
     $out .=<<EOF;
 <td> <center>
     <table border=1 cellspacing=0 cellpadding=4 bgcolor=white width=100%>
      <tr><td><b><center>
       <a href=$Http::WEBPROC?GO=$B[$x]  target=bottom
        onclick="set('$A[$x]',2,$cnt)" onmouseover="set('$A[$x]',1,$cnt)"
        onmouseout="set('$A[$x]',0,$cnt)">$L->{$l}</a></td>
     </table>
     <img name=b$cnt src=gif/lineout.gif width=65 height=5 vspace=2>
     </td>
EOF

     $out .= "<td> <img src=/gif/arrow.gif></td>" if ($x < $#A);
     $cnt++;
     $layers .=<<EOF;
<layer id=$A[$x] left=14 visibility=hide>
  <table border=0 cellspacing=0 cellpadding=4 width=98% bgcolor=#FFFFDD>
   <tr><td>$L->{$info}
  </table>
</layer>
EOF

  }
  $out .= "</table> </td></table></table> <table border=0><tr><td></table>";
   
  print $out . $layers;

  
}



  


sub js2 {
  return <<EOF;
<script>
var browser = select_browser();
var click = new Array(10);

 function pic(id,gif) {
    if (navigator.appName == "Netscape") {
      document.images["b" + id].src = "/gif/" + gif + ".gif";
    } else {
      document.all["b" + id].src = "/gif/" + gif + ".gif";
    }
 }

function select_browser() {
  var browser="None";

  if (navigator.appName.indexOf("Netscape")>=0 && parseFloat(navigator.appVersion) >=4){
    browser="NS4";
    version=4;
  }

  if(document.getElementById){
    browser="NS6";
    version=6;
  }

  if(document.all){
    if(document.getElementById){
      version=5;
    } else {
      version=4;
    }
    browser="IE";
  }
  return browser;
}
function set_visible(element,show) {
  if(browser=="NS4"){
    if(document.layers[element] != undefined){
      if (show >= 1){
        document.layers[element].visibility="show";
      } else {
        document.layers[element].visibility="hide";
      }
    }
  } else if (browser == "IE"){
    if(document.all[element]!=null){
      if(show >= 1){
        document.all[element].style.visibility="visible";
      } else {
        document.all[element].style.visibility="hidden";
      }
    }
  }
}
var save = "X";
var erase = "X";
function set(element, show, id) {
  if (show == 2) {
    click[id] = 1;
    pic(id,'linein');

  } else if (show == 1) {
    if (click[id] != 1) pic(id,'lineover');
    if (erase != "X") {
      set_visible(erase, 0);
      erase = "X";
    }

    if (save != element) {
      set_visible(save, 0);
      set_visible(element, show);
      save = "X";
    }
  } else if (show == 0) {
    if (click[id] != 1) pic(id,'lineout');
    erase = element;
  }
}
</script>
EOF
}


sub storade_admin {
  my($q) = @_;

  print Html->body();
  print Html->header2("doc.admin.strategy");
  print "</center>";

  print Html->readHtdocs("storade_admin");
}



1;
 
