package GUI::Timeouts;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Timeouts.pm,v 1.7 2004/03/17 17:40:10 mckenney Exp $


sub upd {
  my($q, $post) = @_;
  my($renv, $dev, $c1, $c2, $err1, $info, $err2, $err3, $err5);
  $info = "";
  my $G = Labels->read();
  my $L = Labels->read("GUI::Timeouts");

  my $deny = Roles->verifyRole($q, "admin");
  @list = ('ping','http','snmp','luxadm','rm6','discman', 'slicd', 'email', 'power_seq','sccli');
  my($desc) = $renv->{GSV_DESC};
  print Html->body();

  if ($q->{ACTION_defaults}) {
     ($renv, $dev, $host,$notifs)  = PDM::ConfigFile->read;
     $renv->{"timeout.ping"}       = $q->{'ping'} = 10;
     $renv->{"timeout.email"}      = $q->{'email'} = 30;
     $renv->{"timeout.http"}       = $q->{'http'} = 60;
     $renv->{"timeout.snmp"}       = $q->{'snmp'} = 60;
     $renv->{"timeout.luxadm"}     = $q->{'luxadm'} = 600;
     $renv->{"timeout.rm6"}        = $q->{'rm6'}    = 200;
     $renv->{"timeout.discman"}    = $q->{'discovery'} = 1200;
     $renv->{"timeout.slicd"}      = $q->{'slicd'} = 180;
     $renv->{"timeout.sccli"}      = $q->{'sccli'} = 360;
     $renv->{"timeout.power_seq"}  = $q->{'power_seq'} = 480;



     if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
        print $G->{e_100} . "  $CONF<br>";
     } else {
        $info = Html->info($G->{conf_upd});
     }

  } elsif ($q->{ACTION_submit}) {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

     foreach my $ev (@list) {
        $renv->{"timeout.$ev"} = $q->{$ev} if ($q->{$ev});
     }

     if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
        print $G->{e_100} . " $CONF<br>";
     } else {
        $info = Html->info($G->{conf_upd});
     }

  } else {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  }
  print Html->header2('admin.system.timeout');
  my $sec = $L->{seconds};

  my (@de, @de2);
  if ($renv->{solution} eq "N") {
    @de = (
   [ f => $L->{lux}, "<input type=text name=luxadm size=5  maxlength=5 value=$renv->{'timeout.luxadm'}> $sec"],
   [ f => $L->{rm6}, "<input type=text name=rm6 size=5  maxlength=5 value=$renv->{'timeout.rm6'}> $sec"],
   [ f => $L->{sccli}, "<input type=text name=sccli size=5  maxlength=5 value=$renv->{'timeout.sccli'}> $sec"],
     );
  }

  if ($renv->{solution} eq "se") {
    @de2 = (
   [ f => $L->{slicd}, "<input type=text name=slicd size=5  maxlength=5 value=$renv->{'timeout.slicd'}> $sec"],
    );
  }

  if ($renv->{solution} eq "se2") {
    @de2 = (
   [ f => $L->{power_seq}, "<input type=text name=power_seq size=5  maxlength=5 value=$renv->{'timeout.power_seq'}> $sec"],
    );
  }


  my $scr = Html::Screen->new();
  $scr->add(" <form> <input type=hidden name=GO value=GUI::Timeouts::upd>  $info");
  $scr->table( { title => $L->{label}, labelWidth => "40%" },
   [
   [ f => $L->{ping}, "<input type=text name=ping size=5  maxlength=5 value=$renv->{'timeout.ping'}> $sec"],
   [ f => $L->{email}, "<input type=text name=email size=5  maxlength=5 value=$renv->{'timeout.email'}> $sec"],
   [ f => $L->{t3token}, "<input type=text name=http size=5  maxlength=5 value=$renv->{'timeout.http'}> $sec"],
   [ f => $L->{snmp} , "<input type=text name=snmp size=5  maxlength=5 value=$renv->{'timeout.snmp'}> $sec"],
   [ f => $L->{disco}, "<input type=text name=discman size=5  maxlength=5 value=$renv->{'timeout.discman'}> $sec"],
    @de, @de2,
   ]);
  $scr->button2( [
    [ l => 'ACTION_submit' ,  $G->{submit}, $deny ],
    [ l => 'ACTION_defaults' ,  $G->{defaults}, $deny ],
    ]);
  $scr->add("</form>");
  print $scr->out();
}

1;
 
