package GUI::Stats;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use System;
use Util;
use Timelapse;
use strict;
use MaxEvents;

sub email {
  my($q) = @_;
  my $L = Labels->read("GUI::Stats");
  print Html->body();
  print Html->header2("report.system.email_stats");
  if ($q->{ACTION_clear}) {
     MaxEvents->clear("events");
     MaxEvents->clear("email");
     print Html->info($L->{clear_all});
  }

  my $renv = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  print "<form><input type=hidden name=GO value=GUI::Stats::email>";

  print &email2($Config, "events", $L->{events}, 6);
  print "&nbsp;";

  print &email2($Config, "email",  $L->{email}, $renv->{max_daily_email});

  my $l1 = $L->expand('clear');
  print Html::Screen->submitButton("ACTION_clear", $l1);

  print "</form>";
}

sub email2 {
  my($Config, $id, $title, $max_daily) = @_;

  my $L = Labels->read("GUI::Stats");
  my $G = Labels->read();


  my $MAX_DB = RasDB->new("MAXEVENTS");
  my $MAX = $MAX_DB->hash();
  $MAX_DB->ReadLock();

  my (@array, $cnt);
  foreach my $el (sort keys %$MAX) {
     my($etype, $user, $type, $key, $topic,$act) = split(/\:/, $el);
     next if ($etype ne $id);
     my $e = $MAX->{$el};
     my $dev = $Config->deviceByKey($key);
     my $name = $dev ? $dev->{name} : $key;

     my $lastdate = $e->[2];
     my $tot      = $e->[0] - $max_daily;
     next if (!$lastdate || $tot < 0);

     push(@array, [ $key, $user||"All", "$type:$name", $topic, $lastdate, $tot ]);
     $cnt++;
  }
  $MAX_DB->UnLock();

  push(@array, [ $L->{no_dev} ]) if (!$cnt);

  my $scr = Html::Screen->new();
  $scr->list({}, { title => "$L->{$title} $L->{max} ($G->{max}=$max_daily)" },
   [
   [ l => $L->{dev} ],
   [ l => $L->{user} ],
   [ l => $L->{name} ],
   [ l => $L->{comp} ],
   [ l => "$L->{last} $title" ],
   [ l => "${title} $L->{not}" ],
   ],
   \@array,
   );

  return $scr->out();
}


#  'COMMAND:/usr/bin/ps -ef' => {
#    'last_run_duration' => '0',
#    'count' => 3,
#    'last_run_date' => '2003-07-21 14:27:03',
#    'duration' => '0'
#  },
#  't3:slr-mi.370-3990-01-e-e1.002776' => {
#    'last_run_duration' => 22,
#    'count' => 2,
#    'last_run_date' => '2003-07-21 14:22:41',
#    'duration' => 55
#  },
#  'host:logfile' => {
#    'last_run_duration' => '0',
#    'count' => 6,
#    'last_run_date' => '2003-07-21 14:27:04',
#    'duration' => '0'
#  }
#

sub agent {
  my($q) = @_;
  my($v, %M, $tt, $mins, %X, $secs, $out, $x, %TOT);

  my $L = Labels->read("GUI::Stats");
  print Html->body();
  print Html->header2("report.system.agent_stats");

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  $q->{SPAGE} = 1 if (!$q->{SPAGE});

  if ($q->{ACTION} eq "clear") {
     Timelapse->clear();
     foreach my $h (@$hosts) {
       Timelapse->clear($h->{ipno});
     }
  }

  my $S = {};
#
# hostname:type:key
# hostname:COMMAND:command
#
  my $a = Timelapse->readAll();
  foreach my $k (keys %$a) {
    $S->{"$renv->{hostname}:$k"} = $a->{$k};
  }
  foreach my $h (@$hosts) {
    my $b = Timelapse->readAll($h->{ipno});
    foreach my $k (keys %$b) {
      $S->{"$h->{hostname}:$k"} = $b->{$k};
    }
  }

  my (@array, %S2);

  foreach $x (keys %$S) {
     my($host, $type, $key) = split(/\:/, $x, 3);
     my $d;
     my $el = $S->{$x};
     if ($q->{SPAGE} == 1) {
       next if ($type =~ /^COMMAND/);
       $d = "$type:" . ($el->{name}||$key);

     } elsif ($q->{SPAGE} == 3) {
       next if ($type !~ /^COMMAND/);
       $d = $key;
     }
     $el->{count} = 1 if (!$el->{count});
     push(@array, [Util->shortHostname($host), $d, 
                   sprintf("<sort %8.8d>%d",$el->{count},$el->{count}), $el->{last_run_date}, 
                   &cell($el->{last_run_duration}), 
                   &cell($el->{max_run_duration}),
                   $el->{max_run_date},
                   &cell($el->{duration}/$el->{count})]);
  }

  my $page = Html->makeSelect("SPAGE", "1=$L->{page1}|3=$L->{page3}",
                              $q->{SPAGE});

  print "<table border=0 width=90%><tr><td align=right>[ <a href=$Http::WEBPROC?GO=GUI::Stats::agent&ACTION=clear>$L->{clear1}</a> ]</table>";
  
  my $scr = Html::Screen->new();
  my $go1 = $scr->goForm(['GO=GUI::Stats::agent'], $page );
  $q->{SORT} = 1 if (!$q->{SORT});
  $scr->list($q, { title => $L->{title}, interactive => 1 }, 
    [
    [ l => $L->{host} ,  '+sn'  ],
    [ l => $L->{device}, '+'    ],
    [ l => $L->{count},  '-'    ],
    [ l => $L->{last_date}, '+' ],
    [ l => $L->{last_duration},'-'  ],
    [ l => $L->{max}, '-'            ],
    [ l => $L->{max_date}       ],
    [ l => $L->{average}        ],
    ],
    \@array,
    [
    [ l => 'DATA' , $go1 ],
    ]);

  print $scr->out();
}

sub display {
  my($host, $v, $array) = @_;

  foreach my $m (sort keys %$v) {
     my $name = Util->abb(lc($m) . ".medium") || $m;
     $name =~ s/\/opt\/SUNWstade//g;
     push(@$array, [$host, $name, $v->{$m}{cnt}, 
                    &cell($v->{$m}{min}),  &cell($v->{$m}{max}), &cell($v->{$m}{avg}) ]);
  }
}
     

sub cell {
  my($v1) = @_;
  my $mins = int($v1/60);
  my $secs = $v1 % 60;
  return sprintf("%2.2d:%2.2d", $mins,$secs);
}

1;
