package GUI::Start;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Start.pm,v 1.18 2004/07/30 17:06:04 ccadieux Exp $

use Util;
use Util::Http;
use GUI::Hosts;
use System;
use Events;
use Timer;

sub Devices {

  my($q) = @_;
  my(@a, @b, %S);
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>This function is not allowed on a slave!";
    return;
  }
  my $G = Labels->read();
  my $L = Labels->read('GUI::Start')->section('device');

  my $deny = Roles->verifyRole($q, "admin");
  ($q->{HOST}) = split(/\t/, $q->{HOST});

  print Html->body();
  print Html->header2("admin.gen_maint.start_device");

  if ($q->{ACTION_submit}) {
     ($renv, $devs, $host,$notifs) = PDM::ConfigFile->read;
     my($hostlist);
     foreach $x (keys %$q) {
        $no = 0;
        if (substr($x,0,6) eq "start_") {
          $no = substr($x,6) ; $active = "Y";
        } elsif (substr($x,0,5) eq "stop_") {
          $no = substr($x,5); $active = "N";
        }
        next if (!$no);
        $no--;
        $dev = $devs->[$no];
        if ($active eq "Y") {
           Events->saveEvent("QE", $dev->{type}, $dev->{key}, "$q->{reason}|$q->{info}"); # QuieceEnd
           delete $dev->{skip};
        } elsif ($active eq "N") {
           Events->saveEvent("QS", $dev->{type}, $dev->{key}, "$q->{reason}|$q->{info}"); # QuiescStart
        }
        $dev->{active} = $active;
     }
     PDM::ConfigFile->write( $renv, $devs, $host,$notifs);
  }

  ($renv, $devs, $host,$notifs) = PDM::ConfigFile->read;
  my($CAT);
  my %Agent;
  $Agent{""} = 1 if ($renv->{active} eq "Y");
  my $sel_host = "<select name=HOST><option>$renv->{hostname}</option>";

  foreach my $h (@$host) {
     $CAT->{$h->{hostname}} = $h->{categories};
     $Agent{$h->{hostname}} = 1 if ($h->{active} eq "Y");
  }
  foreach my $h (sort keys %$CAT) {
    my $ck = "selected" if ($h eq $q->{HOST});
    $sel_host .= "<option $ck>$h</option>";
  }
  $sel_host .= "</select>";


  my(@array, %DEV);
  foreach $dev (@$devs) {
     $DEV{"$dev->{host}:$dev->{name}:$dev->{key}"} = $dev;
  }
  $q->{HOST} = $renv->{hostname} if (!$q->{HOST});

  my $lasth;
  foreach $dev0 (sort keys %DEV) {
    $dev = $DEV{$dev0};
    next if ($dev->{type} eq $renv->{solution});

    if ($dev->{ipno}) {
      $ip = ($dev->{name} eq $dev->{ip})? $dev->{ipno}:$dev->{ip};
    } else {
      $ip = $dev->{wwn};
    }
    $loc0 = $loc = $dev->{host} || $renv->{hostname};
    my $ii = index($loc, ".");
    $loc = substr($loc,0,$ii) if ($ii > 0);

    next if ($loc0 ne $q->{HOST});

    $col = "";
    $start = $stop= "";
    $no = substr($dev->{_name},6);
    if ($dev->{active} eq "Y"){
       $active = "$L->{On}";
      $stop = "<input type=checkbox name=stop_$no>";
    } else {
       $active = "<b><font color=#FF0000>$L->{Off}</font></b>";
       $start = "<input type=checkbox name=start_$no>";
    }
    
    if($dev->{host}){
       $categories = $CAT->{$dev->{host}};
     }else{
       $categories = $renv->{categories};
     }
     $categories .= "|$renv->{solution}|";
     my $hactive;
     if (index("|$categories|", "|$dev->{type}|") < 0){
        $active .= " <b><font color=#FF0000>$L->{Off}</font></b>";
     }else{
        $active .= " $L->{On}";
     }
    $active .= $Agent{$dev->{host}} ? " $L->{On}" : " <font color=#FF0000>$L->{Off}";

    push(@array, 
       [ $start, $stop, 
          $dev->{name}, 
          $active ,
          $loc, 
          $dev->{userLabel}||$dev->{type}, 
          $ip, 
        ]);
  }
  my $reasons = "<select name=reason>";
  for ($x=0; $x <= 6; $x++) {
     $reasons .= "<option value=R$x>" . $L->{"reason$x"} . "</option>";
  }
  $reasons .= "</select>";
  print "<table border=0 width=$Style::WIDTH cellspacing=0 cellpadding=0>
         <tr><td align=right><form>
           <input type=hidden name=GO value=GUI::Start::Devices>
             $G->{host}:$sel_host<input type=submit name=ACTION value=\"$G->{go}\">
           </td>
       <tr><td></form>
          <form  method=get><input type=hidden name=GO value=GUI::Start::Devices>
          <table border=0 cellspacing=0 cellpadding=1 bgcolor=$Style::LIGHT>
            <tr><td align=right>&nbsp;$L->{reason}:</td><td>$reasons</td>
                <td align=right>&nbsp;$L->{info}:</td><td><input type=text name=info size=22>&nbsp;</td>
          </table>
       </table>";

  my $scr = Html::Screen->new();

  $scr->list ($q, { title => $L->{label1}, XtopAndBottom => 1, interactive => 1 },
   [
   [ c => $L->{start}     ],
   [ c => $L->{stop}      ],
   [ l => $L->{name}, '+' ],
   [ l => $L->{mon}       ],
   [ l => $L->{host}, '+' ],
   [ l => $L->{type} ,'+' ],
   [ l => $L->{add}       ],
   ],
   \@array,
   [
   [ l => 'ACTION_submit', $L->{submit1} , $deny ],
   ]);
  $scr->add("<input type=hidden name=HOST value=\"$q->{HOST}\"></form>");
  print $scr->out();
}

sub Agents {
  my($q, $post, $util) = @_;

  print Html->body();
  print Html->header2("admin.gen_maint.start_agent");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Start')->section('agent');

 if ( Util->findMaster()) {
    print "<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }

  my $deny = Roles->verifyRole($q, "admin");

  if ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
    for ($x=0; $x <= $#$host; $x++) {
       $start = "";
       $h = $host->[$x];
       $h->{last_push} = "";
       if ($q->{"start_$h->{hostname}"}) {
             $start = "Y";
       } elsif ($q->{"stop_$h->{hostname}"}) {
             $start = "N";
       }
       if ($start) {
         $h->{active} = $start;
       }
    }
    if ($q->{start_LOCAL}) {
      $renv->{active} = "Y";
    } elsif ($q->{stop_LOCAL}) {
      $renv->{active} = "N";
    }
    PDM::ConfigFile->write( $renv, $dev, $host, $notifs);
  }



  $hname = System->hostname;
  $hid = System->hostid;
  $ip  = System->local_ip;
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;


  $local = $renv->{active} eq "Y" ? "Yes":"No";
  $col = ($local =~ /Yes/)? "#C0FFC0" : "#FFC0C0";
  $start = $stop = "";
  if ($local =~ /Yes/) {
      $local0 = $L->{On};
      $stop = "<input type=checkbox name=stop_LOCAL>";
  } else {
      $local0 = $L->{Off};
      $start = "<input type=checkbox name=start_LOCAL>";
  }
  my (@array);
  push(@array, [$start, $stop, $hname, 
          " bgcolor=$col><center>$local0" ,
          $G->{master}, $hid, $ip, 
           ]);

  my $UPDATE;

  for ($x=0; $x <= $#$hosts; $x++) {
     $h = $hosts->[$x];
#     $url     =  Util->makeUrl($h->{ip}, "?GET=start");
     $start0 = $stop = "";
     my $mon;
     if ($h->{dh} ne "Y") {
       $type = "Slave";

       $col = ($h->{active} eq "Y")? "#C0FFC0" : "#FFC0C0";
       if ($h->{active} eq "Y") {
           $stop = "<input type=checkbox name=stop_$h->{hostname} >";
           $mon = $L->{On};
       } else {
           $start0 = "<input type=checkbox name=start_$h->{hostname} >";
           $mon = $L->{Off};
       }

     } else {
       $type = "DataHost";
       $col  = "white";
       $mon  = $L->{datahost};
       $start0 = $stop = "&nbsp;";
     }
     push(@array, [ $start0, $stop,  $h->{hostname},
        " bgcolor=$col><center>$mon" ,
         $type, $h->{hostid}, $h->{ipno}, 
        ]);

  }
  PDM::ConfigFile->write( $renv, $devs, $hosts, $notifs) if ($UPDATE);

  my $scr = Html::Screen->new();
  $scr->add(" $head <form  method=get><input type=hidden name=GO value=GUI::Start::Agents>");
  $scr->list ($q, { title => $L->{label1}, interactive => 1 },
   [ 
   [ c => $L->{start} ],
   [ c => $L->{stop} ],
   [ l => $L->{name}, '+' ],
   [ h => $L->{mon}  ],
   [ l => $L->{type}  ],
   [ l => $L->{host} ],
   [ l => $L->{ip}   ],
   ],
   \@array,
   [
   [ l => 'ACTION_update', $L->{submit1}, $deny ],
   ]);
  
  $scr->add("</form>");
  print $scr->out();
}


1;
 
