package GUI::Scheduler;
use System;
use RasScheduler;
use Html;

sub add {
  my($q) = @_;

  print Html->body();
  my $L = Labels->read("GUI::Scheduler");
  my $G = Labels->read();

  if ($q->{ACTION_add}) {
     if (index($q->{_email_}, "\@") < 0) {
        print Html->warning($L->{valid_email});
     } else {
       my $db = RasScheduler->read();
       $db->add($q->{_command_}, $q->{ARGS}, $q->{_freq_}, $q->{_time_}, $q->{_dow_}, $q->{_email_}, $q->{_desc_});
       $db->write();
       print Html->info("$L->{added}");
       print "<form><input type=submit value=Close onclick=window.close()></form>";
       return;    
     }
  }

  my $command = $q->{_command_} || $q->{_GO};
  my $args;
  if ($q->{ARGS}) {
    $args = Util->decode($q->{ARGS});
  } else {
    foreach my $l (sort keys %$q) {
       next if (substr($l,0,6) eq "COOKIE");
       next if (index(",ARGS,GO,_freq_,_time_,_command_,_email_,_desc_,", ",$l,") >= 0); 
       $args .= "$l=$q->{$l}&";
    }
  }    
  $args = Util->encode($args);
  my $time = Html->makeSelect("_time_", "6=6$L->{am}|8=8$L->{am}|12=12$L->{pm}|16=4$L->{pm}|20=8$L->{pm}");
  my $freq = Html->makeSelect("_freq_", "d=$L->{daily}|w=$L->{weekly}");
  my @D    = split(/,/, $G->{dow});
  my $dow  = Html->makeSelect("_dow_",  "99=$L->{all}|0=$D[0]|1=$D[1]|2=$D[2]|3=$D[3]|4=$D[4]|5=$D[5]|6=$D[6]");
 
  my $scr = Html::Screen->new();
  $scr->add(" <form><input type=hidden name=GO value=GUI::Scheduler::add>
      <input type=hidden name=_command_ value=\"$command\">
      <input type=hidden name=ARGS    value=\"$args\">
      ");

  $scr->table( { title => $L->{add} },
   [
   [ f => $L->{time}, $time ],
   [ f => $L->{dow},  $dow  ],
   [ f => $L->{email}, "<input type=text size=40 name=_email_>"],
   [ f => $L->{desc},  "<input type=text size=40 name=_desc_>" ],
   [ f => $L->{command}, $command ],
   ]);
   $scr->button2( 
    [
    [ l => 'ACTION_add', $L->{submit} ],
    ]);
   $scr->add("</form>");
   print $scr->out();
}

sub list {
  my($q) = @_;

  my $L = Labels->read("GUI::Scheduler");
  my $G = Labels->read();
  my @D    = split(/,/, $G->{dow});
  $D[99]  = $L->{all};

  print Html->body();
  print Html->header2("report.general.sched");
  my $db = RasScheduler->read();
  if ($q->{ACTION_all}) {
       RasScheduler->clear();
       $db = RasScheduler->read();
       print Html->info("$L->{deleted}");
  }
  if ($q->{ACTION_sel}) {
     foreach my $el (keys %$q) {
        if (substr($el,0,4) eq "del_") {
          my $k = substr($el,4);
          $db->delete($k);
        }
     }
     $db->write();
  }


  my (@array, $cnt);
  foreach my $e (sort keys %$db) {
      $cnt++;
      my $el = $db->{$e};
      my $freq = $D[$el->{dow}];
      my $time;
      if ($el->{time} < 12) {
        $time = "$el->{time} AM";
      } elsif ($el->{time} == 12) {
         $time = "12 PM";
      }else {
        $time = ($el->{time} - 12) . " PM";
      }
      my $dtime;
      if($el->{last_run_time} > 0){
         $dtime = Util->get_date($el->{last_run_time});
      }else{
        $dtime = $L->{not_run};
      }
      push(@array, [ 
                     "<input type=checkbox name=del_$e>" ,
                     $el->{command}, $el->{desc}, $el->{email}, $time, $freq, $dtime,
                    ]);
  }
  push(@array, [$L->{none}]) if (!$cnt);

  my $scr = Html::Screen->new();
  $scr->add("<form><input type=hidden name=GO value=GUI::Scheduler::list>");

  $scr->list($q, { title => $L->{list} },
   [
   [ c => $L->{del} ],
   [ l => $L->{command} ],
   [ l => $L->{desc} ],
   [ l => $L->{email} ],
   [ l => $L->{time} ],
   [ l => $L->{dow} ],
   [ l => $L->{last_run} ],
   ],
   \@array,
   [
   [ l => 'ACTION_sel', $L->{del_sel} ],
   [ l => 'ACTION_all', $L->{del_all} ],
   ]);

   $scr->add("</form>");
   print $scr->out();
}

1;
