package GUI::Roles;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
use strict;
use AdminGroup;
# WINDOW = S : small window, few frames.
#          B : big window, many frames.
#          N : no frames at all.

use Roles;


sub test {
  my($q) = @_;
  foreach my $x (keys %$q) {print "$x=$q->{$x}<br>"}
  print "\n<body bgcolor=white>
  <a href=$Http::WEBPROC?GO=GUI::Roles::test>Test link</a><br>
  <form>
  <input type=hidden name=GO value=GUI::Roles::test>
  <input type=text name=field1 value=field1>
  <input type=submit name=ACTION value=Submit>
  </form>";
}

sub update {
  my($q) = @_;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Roles');

  print Html->body();
  if ( Util->findMaster()) {
    print "<h1><center>$G->{e_101}";
    return;
  }

  print Html->header2("admin.system.roles");

  if (my $err = Roles->verifyRole($q, "admin|c_admin")) {
     print $err;
     return;
  }
  my $renv       = System->get_renv();
  my $ruser      = System->get_ruser();
  my $isCustomer = $ruser->{isCustomer};
  my $info;

  my $db = Roles->read();

  my ($adds, $dels, $INFO, $WARNS, $NIS);
  my $roles = $db->getRoles();

  $#$roles-- if ($roles->[$#$roles] eq "peer");

  if ($q->{ACTION_update}) {
     foreach my $k (keys %$q) {
       if (substr($k,0,4) eq "del_") {
          my $user = substr($k,4);
          $dels .= "$user,";
          $db->deleteUser($user);
           
       } elsif (substr($k,0,5) eq "USER_") { # ADD USER
          my $ix = substr($k,5);
          my $user = lc($q->{$k});
          $user =~ s/\W+/_/g;
          $user = "u$user" if ($user =~ /^\d+/);
          next if (!$user);
          my $name     = $q->{"USER_$ix"};
          my $password = $q->{"PASS_$ix"};
          my $nis      = $q->{"NIS_$ix"} ? "Y": "";
          my $lang     = $q->{"LANG_$ix"};
          my $group    = $q->{"GROUP_$ix"};
          my $window   = $q->{"WINDOW_$ix"};
          my $access   = "N";
          my $rlist;
          
          foreach my $r (@$roles) {
             my $r0 = "ROLE_" . $ix . "_$r";
             if ($q->{$r0}) {
                if (substr($r,0,2) ne "c_" && index($rlist, "c_") >= 0) {
                   $INFO = Html->info("$user:" . $L->{invalid_role});
                   goto out;        
                }
                $rlist .= "$r|";
             }
          }
          my @NIS = getpwnam($name) if ($nis);
          if ($nis && $NIS[0] ne $name) {
            $NIS .= "$name, ";
          }
          if ($name && ($password||$nis) && $rlist) {
            $db->addUser($user, $name,$password, $rlist, $lang, $window, $access, $nis, $group);
            $adds .= "$user, ";

          } else {
            $WARNS .= Html->error($L->expand('err_no_name', $user));
          }         
       } elsif (substr($k,0,5) eq "pass_") { # update
          my $id = substr($k,5);
          my $user = $db->getUser($id);
          my $name = $id;
          if ($user) {
             if ($q->{"pass_$id"}) {
                $user->{password} = Roles->encode($q->{"pass_$id"});
             }
             $user->{window}   = $q->{"window_$id"};
             $user->{language} = $q->{"lang_$id"};
             $user->{adm_group} = $q->{"group_$id"};
             $user->{nis}      = $q->{"nis_$id"} ? "Y" : "";
             $user->{access}   = "N";
             my $rlist;
             foreach my $r (@$roles) {
                my $r0 = "role_$r" ."_$id";
                if ($q->{$r0}) {
                   if (substr($r,0,2) ne "c_" && index($rlist, "c_") >= 0) {
                      $INFO = Html->info("$name:". $L->{err_2users});
                      $db->deleteUser($id);
                      goto out;        
                  }
                  $rlist .= "$r|";
                }
             }
             my @NIS = getpwnam($name) if ($user->{nis});
             if ($user->{nis} && $NIS[0] ne $name) {
               $NIS .= "$name, ";
             } elsif ($rlist) {
               $user->{roles} = $rlist;
             } else {
               $WARNS .= Html->error($L->expand('err_cannot_rem', $id));
             }
          }
       }
     }
     $INFO = Html->error($L->expand('err_dels', $dels)) if ($dels);
     $INFO = Html->info( $L->expand('info_add', $adds))  if ($adds);
     
     $db->write();
  }
out:
  $WARNS .= Html->warning($L->expand(bad_nis => $NIS ) ) if ($NIS);
  print "
  <table border=0 width=$Style::WIDTH bgcolor=white cellpadding=4><tr><td>$info</table>
  $WARNS
  $INFO
  <form><input type=hidden name=GO value=GUI::Roles::update>";

  my $userlist = $db->idList();
  my $TOT = 8;
  use  Html::Tabs;

  $q->{option} = 1 if (!$q->{option});

  my $table = Html::Tabs->create(list  =>  ["1=$L->{label}", "2=$L->{submit_add}"],
                       url  => "$Http::WEBPROC?GO=GUI::Roles::update",
                     width  => $Style::WIDTH,
             selectedColor  => $Style::DARK,
         selectedTextColor  => "white",
           backgroundColor  => $Style::LIGHT,
        backgroundTextColor => 'black',
                  selection => $q->{option},
               );
  print "$table <table border=0><tr><td></table>";


  my $cols = ($isCustomer ? 1 : $#$roles)+$TOT + 1;

  my @head0 = ( 
    [ l => $L->{l_user}],
    [ c => $L->{l_nis}] ,
    [ l => $L->{l_pass}],
    [ l => $L->{l_lang}],
    [ l => $L->{l_window}],
    [ l => $L->{l_group} ]);


  foreach my $r (@$roles) {
     my $r0 = $r;
     next if ($isCustomer && substr($r0,0,2) ne "c_");
     my $tname = $L->{$r0};
     $r0 = substr($r0,2) if (substr($r0,0,2) eq "c_");
     push(@head0, [ c => $tname] );
  }
  my @head  = (
    [ l => '#'         ],
    [ l => $L->{l_del} ],
    @head0 );


  my ($data, $cnt, @array);
  my $WIN_OPTIONS = "B=$L->{big}|S=$L->{small}|N=$L->{nof}";
  my $LEVELS = "d=$L->{level_d}|s=$L->{level_s}";
  my $groups = AdminGroup->new();
  my $gr_list = "=$G->{all}|" . $groups->list();

  if ($q->{option} == 1) {
    foreach my $userid (sort @$userlist) {
       my $user = $db->getUser($userid);
       my $lang = $user->{language};
       next if ($isCustomer && index($user->{roles}, "c_") < 0);
       next if (index($user->{roles}, "peer") >= 0);
       $cnt++;
       my ($ck, @cks);
       my $peer = 1 if (index($user->{roles}, "peer") >= 0);
       foreach my $r (@$roles) {
         my $checked = (index("|$user->{roles}|", "|$r|") >= 0) ? "checked":"";
         next if (substr($r,0,2) ne "c_" && $isCustomer);
         my $bg = "bgcolor=#FFFFDD" if (substr($r,0,2) eq "c_");
         if ($peer) {
           $ck = $checked ? 
             "X<input type=hidden name=role_${r}_$userid value=X>": "&nbsp;";
         } else {
           $ck = "<input type=checkbox $checked name=role_${r}_$userid>";
         }
         push(@cks, $ck);
       }
       
       my($pass,$del, $lang2, $window, $nis, $grp);
       if (!$peer) { 
           $del  = "<input type=checkbox name=del_$userid>" ;
           my $nis_ck = "checked" if ($user->{nis});
           $nis  = "<input type=checkbox name=nis_$userid $nis_ck>";
           $pass = "<input type=password size=8 name=pass_$userid>";

           $window = Html->makeSelect("window_$userid", $WIN_OPTIONS, $user->{window} );
           $lang2 = Html->makeSelect("lang_$userid", Util->languageList(). "|B=$L->{browser}", $user->{language});
           $grp   = Html->makeSelect("group_$userid", $gr_list, $user->{adm_group});
       }
       push(@array, [ $cnt, $del, $userid, $nis, $pass, $lang2, $window, $grp, @cks ]);
    }
    my $scr = Html::Screen->new({ });
    $scr->list($q, { title => $L->{label} }, 
      \@head, \@array,
      [
      [ l => 'ACTION_update', $L->{submit_del} ],
      [ l => 'ACTION_update', $L->{submit_update} ],
      ]);
    $scr->add("</form>");
    print $scr->out();
  }

  if ($q->{option} == 2) {
    my  $last = 5; # ($cnt < 6) ? 6:5;
    my($x, @array);
    for ($x=1; $x <= $last; $x++) {
       my $sel1 =  Html->makeSelect("WINDOW_$x", $WIN_OPTIONS);
       my ($ck, @cks);
       foreach my $r (@$roles) {
         next if (substr($r,0,2) ne "c_" && $isCustomer);
         my $bg = "bgcolor=#FFFFDD" if (substr($r,0,2) eq "c_");
         push(@cks, "<input type=checkbox name=ROLE_${x}_$r>");
       }
       my $lang2 = Html->makeSelect("LANG_$x", Util->languageList(). "|B=$L->{browser}");
       my $grp = Html->makeSelect("GROUP_$x", $gr_list);
       push(@array, [ 
           "<input type=text name=USER_$x size=8>",
           "<input type=checkbox name=NIS_$x>",
           "<input type=password name=PASS_$x size=8>",
           $lang2,
           $sel1 ,
           $grp, @cks ]);
    }

    my $scr = Html::Screen->new( { width => "95%"} );
    $scr->list($q, { width => "95%", title => $L->{submit_add}}, \@head0, \@array,
      [
      [ l => 'ACTION_update', $L->{submit_add} ],
      ]);
    $scr->add("</form>");
    print $scr->out();
  
  }
}

1;

