package GUI::Revision;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use strict;
use Modules;
use Html;
use Util;
use Data::Dumper;
use Matrix;
use Revision;
use Html::Tabs;
use Process;
use System;

sub run {
  my($q) = @_;
  print "\n<body bgcolor=$Style::BGCOLOR>";
  my $L = Labels->read('GUI::Revision')->section('run');

  my($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read;

  my $F = System->get_home() . "/DATA/tmp/Revision";
  my $PIDF = System->get_home() . "/DATA/tmp/Revision_pid";
  my $LOG = System->get_home() . "/DATA/tmp/Revision_log";
  my $mods = Modules->load("Revision");
  print Html->header2("diagnose.revision.run", "95%");

  if ($q->{ACTION_run} || $q->{ACTION_args}) {
    while (1) {
      if (Process->status($q->{host}, "Revision") =~ /Running/) {
         print "<font color=red><b>$L->{err_already}</b></font>";
         last;
      }
      if($Process::ERROR =~ /Can't connect/){
        my $msg = $L->expand('err_communicate', $q->{host});
        print "<font color=red><b>$msg</b></font>";
        last;
      }


      my ($some , $args);
      foreach my $m (sort @$mods) {
         if ($q->{"check_$m"}) {
           $some = 1;
           $args .= "$m|";
         }
      }
      if (!$some) {
         print "<font color=red><b>$L->{err_at_least1}</b></font>";
         last;
      }
      my (@REPORTS);

      my $matrix_name = $q->{matrix};
      # always in the background
      my $command = System->get_home() . "/bin/ras_revcheck -h \"$q->{host}\" -m \"$matrix_name\" -M \"$args\" -e \"$q->{email}\" -b";
      if ($q->{ACTION_run}) {
        system($command);
        sleep(1);
      }
      my $hh = $q->{host} ? $q->{host} : "LocalHost";
      print "<b>'$command'</b><br> $L->{please_click_1} $hh, $L->{please_click_2} <br>";
      last;
    }
  }
  print "<center>";


  my $hostname = System->hostname();
  my $info     =  Util->readHtdocs("revision");
  my $solution = $renv->{solution} ne "N";
  my $model    = $renv->{solution_model};
  my $select_host = "<select name=host onchange=form.submit() ><option value=\"\">$L->{l_local} $model</option>";
  my $cats = $Config->findActiveCategories($q->{host});

  foreach my $h (@$hosts) {
     my $sel;
     if ($h->{hostname} eq $q->{host}) {
       $sel = "selected";
       $solution = $h->{solution} ne "N";
     } 
     $model    = $h->{solution_model};
     $select_host .= "<option value=\"$h->{hostname}\" $sel>$h->{hostname} $model</option>";
  }
  $cats .= "|hba|host|" if (!$solution);
  $select_host .= "</select>";
  $cats .= "|switch2|switch" if ($cats =~ /switch2/);

  my $modlist = "<table border=1 cellspacing=0 width=100% bgcolor=white>";
       #"<b><input type=checkbox name=check_ALL>: $L->{l_all_mod}";
  my $cnt = 0;
  foreach my $m (sort @$mods) {
     my $func = "Revision::$m";           
     my $type = $func->type();
     my $sel;
     $sel = "checked" if (index("|$cats|", "|$type|") >= 0);
     next if ( !$sel);
     $sel = "checked" if ($type eq "host");
     $cnt++;
     $modlist .= "<tr><td><b><input type=checkbox name=check_$m $sel>: ". $func->description() . "</td>";
  }
  $modlist .= "</td></table>\n";
  $modlist = "<b><big>&nbsp;No Revision Modules found." if (!$cnt);

  my($D) =  System->get_home() . "/System/Matrix";
  opendir(O, $D);
  my @mats = readdir(O); closedir(O);

  my $matrix = "<select name=matrix>";
  my ($tem1, $tem2, $revi, $expire, $date);
  my @rev_mats = reverse @mats;
  my $today = substr(Util->get_today(), 0, 10);
  my $matrix_cnt;
  foreach my $m (@rev_mats) {
     next if (substr($m,0,1) eq ".");
     next if (-d "$D/$m");
     open(OO2,"$D/$m");
     my $l;
     my $cnt;
     $expire = "";
     while ($l = <OO2>) {
          last if ($cnt++ > 40);
          if ($l =~ /XXEXPIRATION\s+(.*)/ ){
             $expire = $1;
          }
          if ($l =~ /Created/ ){
             ($tem1, $tem2, $date) = split (/\s+/, $l);
              if (!$expire || $expire ge $today) {
                $matrix .= "<option value=\"$m\">$m  -- $tem2 $date";
                $matrix .= "</option>";
                $matrix_cnt++;
              }
          }

     }
     close(OO2); 
  }
  $matrix .= "</select>";
  if ($matrix_cnt == 0) {
    $matrix = Html->warning("<b>No matrix available or matrix is expired!");
  }
  my $lastrun;
  if (-f $F) {
    my $fn = Util->get_file_created($F);
    $lastrun = "<a href=$Http::WEBPROC?GO=GUI::Revision::readLastReport>$fn</a>";
  } else {
    $lastrun = "N/A";
  }
#  <tr>
#     <td width=30% bgcolor=$Style::LIGHT align=right>Device :&nbsp;</td>
#     <td><table border=0><tr><td>&nbsp;$device <b>&nbsp;[ <a href=$Http::WEBPROC?GO=GUI::Devices::selectList>Select Device</a> ]</table>

  my $pid;
 my $device = $q->{DEVICE} || "ALL";
 my $email = Util->readf(System->get_home() . "/DATA/revision_email");
  print "
  <table border=0><tr><td></table>

 <table border=1 cellpadding=0 cellspacing=0 bgcolor=white width=95%>
  <tr><td colspan=2 bgcolor=$Style::DARK><b>
      <form><input type=hidden name=GO value=GUI::Revision::run>
      <font color=white>$L->{l_select}</td>
  <tr>
     <td width=30% bgcolor=$Style::LIGHT align=right>$L->{l_host}:&nbsp;</td>
     <td><table border=0><tr>
         <td> $select_host </td> <td><input type=submit name=ACTION value=GO>
         </table>

  <tr>
     <td width=30% bgcolor=$Style::LIGHT align=right>$L->{l_matrix}:&nbsp;</td>
     <td>$matrix
  <tr><td width=30% bgcolor=$Style::LIGHT align=right>$L->{l_module}:&nbsp;</td>
      <td >$modlist
  <tr><td width=30% bgcolor=$Style::LIGHT align=right>$L->{l_email}:&nbsp;</td>
      <td> <input type=text name=email size=30 value=\"$email\">

  </table>
  &nbsp;<br>
  <b><input type=submit name=ACTION_run value=\"$L->{submit_run}\">&nbsp;
  <input type=submit name=ACTION_args value=\"$L->{submit_args}\">
  </form>
  ";
}

sub readLastReport {
  my($q) = @_;
  my ($rep, $VAR1);
  print Html->body();
  print Html->header2('diagnose.revision.history');

  print "<table border=0><tr><td></table>";

  my $host = $q->{host};
  my $renv = System->get_renv();
  my $hostname = $q->{hostname} || System->hostname();
  my $L = Labels->read('GUI::Revision')->section('readLastReport');

  my ($date, $info, $del);
  if ($q->{hist}) {
    $rep = Util->deserialize("Revision_history/$q->{hist}");
    my $ix = rindex($q->{hist}, ".");
    $date = substr($q->{hist}, $ix+1);
    $info = " (history)";
    $del = " | <a href=$Http::WEBPROC?GO=GUI::Process::history&delete=$q->{hist}&ID=Revision&NAME=Revision+History>Delete";
  } elsif (!$host) {
    $rep = Util->deserialize("tmp/Revision");
    $date = Util->get_file_created(System->get_home() . "/DATA/tmp/Revision");

  } else {
    my $rc = Util::Http->readFile($q->{host}, "tmp/Revision");
    eval $rc;
    $rep = $VAR1;
   $date = $rep->{date};
  }
  my $data = $rep->{data};
  my $matrix = $rep->{matrix};
  my $include = $rep->{include};
  my $mat = Matrix->read($matrix , {});
  my $map = $mat->{map};

  my $MAP = {NI => "Not Installed" };

  my %X;
  foreach my $line (@$data) {
      $X{$line->[2]}++;
  }
  my $categories = "[ ";
  my($first_cnt, $first);
  my $filename = $q->{hist};
  foreach my $t (keys %X) {
     my $cnt = $X{$t};
     if ($cnt) { 
        $categories .= " <a href=$Http::WEBPROC?GO=GUI::Revision::readLastReport&hist=$filename&debug=$t&host=$q->{host}&hostname=$q->{hostname}>".
             ($MAP->{$t}||$t) . "=$cnt</a> |";
        $first = $t if (!$first); 
        
     }
  }
  chop($categories);
  $categories .= " | <a href=$Http::WEBPROC?GO=GUI::Revision::readLastReport&hist=$filename&host=$q->{host}&hostname=$q->{hostname}&debug=*ALL>ALL</a> ]";
  $q->{debug} = "DOWNREV:ERR:NI" if(!$q->{debug});
  my $hh = $q->{hostname} || $renv->{hostname};
  # curretn running level of sp image
  my $se_version = System::get_se_version();
  my $latest_version = "2.3.3";

  print "<table border=0><tr><td></table>";
  if ($se_version) {
   print "
   <table border=0 cellspacing=0 width=90%>
    <tr>
        <td><font color=navy><big><b>$L->{title} $info</td>
        <td align=right>$L->{date}: $date $del</table>
   </table>
   <table border=1 cellspacing=0 width=90% bgcolor=white>
   <tr><td colspan=7><form>
    <input type=hidden name=GO value=GUI::Revision::readLastReport>
    <table border=0 cellpadding=0 cellspacing=0 width=100%><tr>
       <tr><td>&nbsp;<b>$L->{host}:</b> $hh<td><td><b>$L->{matrix}:</b> $matrix &nbsp;</td>
           <td align=right><b>$L->{section}:</b> $categories</td>
       <tr><td colspan=3>&nbsp;<b>$L->{section}:</b> $include</td> 
       <tr><td colspan=3>&nbsp;<b>Current SP Image Level : </b> $se_version</td>
       <tr><td colspan=3>&nbsp;<b>Latest Released SP Image Level : </b> $latest_version</td> 
    </table>
   <tr bgcolor=#DDDDFF>
      <th>$L->{name}<th>$L->{status}
      <th>$L->{curr_ver}<th>$L->{exp_ver}
      <th>$L->{curr_patch}<th>$L->{exp_patch}
      <th>$L->{comm}";
  } else {
    print "
    <table border=0 cellspacing=0 width=90%>
    <tr>
        <td><font color=navy><big><b>$L->{title} $info</td>
        <td align=right>$L->{date}: $date $del</table>
   </table>
   <table border=1 cellspacing=0 width=90% bgcolor=white>
   <tr><td colspan=7><form>
    <input type=hidden name=GO value=GUI::Revision::readLastReport>
    <table border=0 cellpadding=0 cellspacing=0 width=100%><tr>
       <tr><td>&nbsp;<b>$L->{host}:</b> $hh<td><td><b>$L->{matrix}:</b> $matrix &nbsp;</td>
           <td align=right><b>$L->{section}:</b> $categories</td>
       <tr><td colspan=3>&nbsp;<b>$L->{section}:</b> $include</td> </tr>
    </table>
   <tr bgcolor=#DDDDFF>
      <th>$L->{name}<th>$L->{status}
      <th>$L->{curr_ver}<th>$L->{exp_ver}
      <th>$L->{curr_patch}<th>$L->{exp_patch}
      <th>$L->{comm}";

  }
  my $last;
  my $cnt;
  foreach my $line (@$data) {
      my $d = $line->[2];
      my $ok = 0;
      if (($q->{debug} =~ /$d/) || ($q->{debug} eq "*ALL" ) ){
         $ok= 1;
      }
      next if (!$ok);
      $cnt++;
      if ($last ne $line->[0]) {
         print "<tr><td colspan=7><b>$line->[0] $map->{$line->[0]}</td>";
         $last = $line->[0];
      }
      my $col = ($line->[2] eq "PASS") ? "green":"red";
      if ($line->[2] eq "ERR") {
         print "<tr><td>&nbsp;$line->[1]<td> <font color=$col><center>$line->[2]".
               "<td colspan=5>$line->[7]";
      } else {
         print "<tr>
   <td>&nbsp;$line->[1]<td> <font color=$col><b><center>$line->[2]
   <td>&nbsp;$line->[3]<td>&nbsp;$line->[4]<td>&nbsp;$line->[5]
   <td>&nbsp;$line->[6]<td><small>&nbsp;$line->[7]";
      }
  }
  if (!$cnt) {
    print "<tr><td colspan=7><br><center>" . 
     $L->expand('err_nothing', $q->{debug}) . "<br>&nbsp;";
  }
  print "</table>&nbsp;<br></form>";

}


1;
