package GUI::RUNAgent;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Id: RUNAgent.pm,v 1.13 2004/07/07 17:51:17 ccadieux Exp $

use Util;
use Agent;
use Html;

sub run {
  my($q) = @_;
  print Html->body();

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my $G = Labels->read();
  my $L = Labels->read('GUI::RUNAgent');

  my($acronym) = $renv->{GSV_ACRONYM};

  print Html->header2('admin.system.run_agent');

  my $l = "Local=$G->{local}|";
  foreach my $h (@$hosts) {
     next if ($h->{dh} eq "Y");
     $l .= "$h->{ipno}=$h->{hostname}|";
  }
  my $select = Util->makeSelect("host", $l, $q->{host});

  my($err, $but2, $S);
  if (($st_found = Agent->stor_conflicts()) ) {
    $err = "<br><font color=red>" . $L->expand('err_1', $renv->{frequency});
  }
  my $process = Util->findProcessByName("/rasagent");
  if ($process) {
    $S = "&nbsp;<p>" . Html->error("rasagent already running, cannot start!<br></b><small>$process");
  }

  my $scr = Html::Screen->new(); 
  $scr->add(" $err <form><input type=hidden name=GO value=GUI::RUNAgent::run2>");
  $scr->table( { title => "$L->{run_agent}", labelWidth => "40%" },
   [
   [ f => $L->{l1},         $select ],
   [ f => $L->{l2},         "<input type=checkbox name=audit>" ],
   [ f => $L->{ignore_max}, "<input type=checkbox name=nomax checked>" ],
   ]);

  $scr->button2( [
     [ l => 'ACTION_run',   $L->{submit1}, $process ],
     [ l => 'ACTION_force', $L->{submit2}, !$st_found ],
   ]);

  $scr->add("$S </form>");
  print $scr->out();
}


sub meta {
  my($to, $q) = @_;
  
  return "<meta http-equiv=Refresh content=\"$to;URL=$Http::WEBPROC?GO=GUI::RUNAgent::run2&TO=$to&host=$q->{host}&PID=$q->{PID}\">\n";
}


sub run2 {
 my($q) = @_;
 my($force);
 my($renv) = System->get_renv();
 my($acronym) = $renv->{GSV_ACRONYM};
 #$q->{host} = "ccadieux";
 my $L = Labels->read('GUI::RUNAgent');

 if ($q->{TO} && $q->{host}) {
   my $display = &display($q);
   print Html->body(undef, { extra => "onload=window.scroll(0,100000)"});
   print &meta(3, $q) if ($display !~ /_DONE_/);
   print Html->header2('admin.system.run_agent');
   print "</center><b>$L->{reading} $q->{host}:</b><br>\n";
   print $display;
   return;
 }
 $q->{PID} = "";
 print Html->body();
 print &meta(3, $q);
 print Html->header2('admin.system.run_agent');
   
 $force = "-f" if ($q->{ACTION_force});
 my $audit = "-A" if ($q->{audit});
 my $nomax = "-M" if ($q->{nomax});

 my $T = System->get_home() . "/DATA/tmp/run_agent$q->{PID}.out";

 if ($q->{host} eq "Local") {
   print "<b>" . $L->expand(running => $renv->{hostname}) . "</b>";
   print "<pre>";
   $h = System->get_home() . "/bin/rasagent -d2 -r -a $force $audit $nomax >$T 2>&1";
   system("$h &");
   

 } elsif ($q->{host}) {
   if (!Util->ping($q->{host}, 5)) {
      print "&nbsp;<p><center><font color=red><h2>$L->{cannotping}";
      return;
   }
   print "<b>" . $L->expand(running => $q->{host}) . "</b>";
   Util::Http->deleteFile($q->{host}, "/tmp/run_agent$q->{PID}.out");

   my($err, $rc) = Util::Http->runshell($q->{host}, "/bin/rasagent -d2 -a -r $force $audit $nomax>$T 2>&1");
   print "<br>";
   print "Error: $err<br>" if ($err);
   print $rc;
   # Give process time to create files so we don't get an error of no
   # files found.
   sleep(2);
 }
 #sleep(2);
 #&display($q);

}

sub display {
  my($q) = @_;
  my ($err, $rc);
  my $out;
  my $L = Labels->read('GUI::RUNAgent');
  my $T = System->get_home() . "/DATA/tmp/run_agent$q->{PID}.out";

  if ($q->{host}  eq "Local") {
    open(O, $T);
    my @lines = <O>; 
    close(O);
    $rc = "@lines";
  } else {
    ($err, $rc) = Util::Http->readFile($q->{host}, "/tmp/run_agent$q->{PID}.out");
  }
  my $done;
  if ($err) {
    $out .= "Error on $q->{host}: $err<br>";
    # Ensure rc has remove pid
    $rc .= "REMOVE_PID";

  } 
  if (($rc !~ /REMOVE_PID/) && ($rc !~ /Exiting from this run/)) {
    $out .= $meta;

  } else {
    $done = "<b _DONE_>$L->{done}</b>";
  }
  $out .= $head;
  $out .= "<pre>";
  $out .= $rc;
  $out .= $done;
  $out .= "<br>&nbsp;<p>&nbsp;";
  return $out;
}


1;
