package GUI::Policy;

use System;
use Map;
use strict;
use SE;

sub list {
  my($q) = @_;
  my $SKIP = "a1000";
  my $m = Map->getDeviceStateMap();
  $m = $m->{map};
  my $G = Labels->read();
  my $LB = Labels->read("GUI::Policy");

  print Html->body();
  print Html->header2("report.system.policy");
  my($b1,$b2,$b3,$b4);
  my $INC = SE->device_included();

  my $select = "<select name=device><option value=\"\"> $G->{all_dev}</option>";
  foreach my $e0 (sort keys %$m) {
    next if ($e0 =~ /^$SKIP/);
    my $aa = $e0;
    $aa =~ s/.availability//;
    next if ($INC && index(",$INC,", ",$aa,") < 0);
    #next if (index(",se,se2,", ",$aa,") >= 0);
    my $long = Util->abb("$aa.medium") || $aa;

    my $ck = "selected" if ($e0 eq $q->{device});
    $select .= "<option $ck value=\"$e0\">$long</option>";
  }
  $select .= "</select>";

  my @SEV = ("><center>$G->{notice}",
             " bgcolor=#FFFFD0><center>$G->{warning}",
             " bgcolor=#FFC0C0><center><b><b>$G->{error}",
             " bgcolor=#FFC0C0><center>$G->{down}");
  my (@array, $sign, $sign0);
  if ($q->{device} && $q->{device} ne "CLOSE") {
     $sign = $q->{sign} eq "P" ? "M" : "P";
     $sign0 = $sign eq "P" ? "+" : "";
     $q->{device} = "CLOSE" if ($sign eq "M");
  }
  my ($last_dev, $last_tag);
  foreach my $e0 (sort keys %$m) {
     next if ($e0 =~ /^$SKIP/);
     my $device = $e0;
     $device =~ s/.availability//;
     #next if (index(",se,se2,", ",$device,") >= 0) ;
     my $vals = $m->{$e0};
     next if ($INC && index(",$INC,", ",$device,") < 0);
     next if ($sign eq "M");
     next if ($q->{device} && $q->{device} ne $e0);

     foreach my $v (sort keys %$vals) {
         my ($v1, $v2, $tag_value, $tag_value2, $tag_name, $tag_name2);
         my ($avail, $sev, $action);
         my $availS = "";
         if (substr($v,-1) eq "~") { # transition
            ($v1,$v2) = split(/\,/, substr($v,0,-1));
            $v1 =~ s/O\.K\./OK/;
            $v2 =~ s/O\.K\./OK/;
            if ($v2 eq "START") {
              my $ix = rindex($v1, ".");
              $tag_name   = substr($v1,0,$ix);
              $tag_value2  = " (FIRST_REPORT)";
              $tag_value = substr($v1,$ix+1);

            } else {
              my $ix = rindex($v2, ".");
              $tag_name = substr($v2,0,$ix);
              $tag_value = substr($v2,$ix+1) . " <b>=></b>";

              my $ix = rindex($v1, ".");
              $tag_name2 = substr($v1,0,$ix);
              $tag_value2 = substr($v1,$ix+1);
            }
            ($sev, $action) = @{$vals->{$v}};

         } else {
            $v1 = $v;
            $v1 =~ s/O\.K\./OK/;
            my $ix = rindex($v1, ".");
            $tag_name = substr($v1,0,$ix);
            $tag_value = substr($v1,$ix+1);
            ($avail, $sev, $action) = @{$vals->{$v}};
            if ($tag_name ne "changeEvent") {
              $availS = ($avail == 1) ? "<b>$LB->{yes}" : "$LB->{no}";
            }
         }

         my $act = $action || "N";
         if ($sev >= 0) {
             $sev = $sev;
         } elsif ($avail == 1) {
             $sev = 0;
         } elsif ($avail == 0) {
             $sev = 2; $act = "Y"
         }
         $act = $act eq "Y" ? "<b>$LB->{yes}":"$LB->{no}";
         $last_dev = $device;
         my $tag0 = $tag_name if ($tag_name ne $last_tag);
         $last_tag = $tag_name;
         push(@array, [ $device, $tag0, "$tag_value&nbsp;$tag_value2" , $SEV[$sev], $act ]);
      }
  }
  my $scr = Html::Screen->new();
  $q->{SORT} = 1 if (!$q->{SORT});
  my $go = $scr->goForm([ "GO=GUI::Policy::list" ], $select );

  $scr->report($q, { title => "", interactive => 1, pageSize => 100 },
   [
   [ l => $LB->{dev}, '+sn'],
   [ r => $LB->{name}  ],
   [ l => $LB->{value} ],
   [ h => $LB->{sev}   ],
   [ c => $LB->{act}   ],
   ],
   \@array,
   [
    [ l => 'DATA', $go ],
   ]
   );
            
   print $scr->out();

}

1;
