package GUI::Options;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use GUI::Hosts;
use strict;
use Html;
use MIME::Base64;

#  $Id: Options.pm,v 1.31 2004/04/06 15:37:44 ccadieux Exp $

sub upd {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my($error);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUI::Options");
  my $ruser = System->get_ruser();

  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  print "<a name=top>";
  $info = "";
  my($warn2, $warn3, $cat, $last_win, $ERR);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  if ($q->{ACTION_submit}) {
    while (1) {
       my $mailer = $q->{mailer};
       my $ix = index($mailer, " ");
       $mailer = substr($mailer,0,$ix) if ($ix > 0);
       if ($mailer && !-x $mailer) {
         $err2 = Html->warning($G->expand('cannot_ex', $q->{mailer}));
       }
       if ($q->{sendmail_server} && !Util->ping($q->{sendmail_server})) {
          $ERR = Html->error($L->{bad_sendmail});
       }
       $renv->{gui_bandwidth}       = $q->{band} || "L";
       $renv->{mailer}              = $q->{mailer};
       $renv->{email_from}          = $q->{email_from};
       $renv->{max_email_size}      = $q->{max_email};
       $renv->{sendmail_server}     = $q->{sendmail_server};
       #$renv->{email_per_event}    = $q->{one} ? 1:0;
       $renv->{max_daily_email}     = $q->{max_daily_email};

       $renv->{use_hub}             = $q->{use_hub} ? 1:0;
       System->setPassword('array', $q->{telnet});
       $renv->{production}          = $q->{production};
       $renv->{'t3.telnet_monitor'} = $q->{glist};
       $renv->{'snmp.community'}    = $q->{community};
       $renv->{session_timeout}     = $q->{session} * 60;
       #$renv->{show_unk_wwn}        = $q->{show_unk_wwn} ? 1:0;
       $renv->{topo_history_size}   = $q->{topo} || 5;
       $renv->{max_event_file_size} = $q->{max_event_file_size};
       my $hh = System->get_home() . "/htdocs";
       #my $cmd = "/bin/cp $hh/graph$renv->{window}.html $hh/graph.html";
       #print "$cmd<br>";
       #system($cmd);
       $q->{test_refresh}           = 5 if ($q->{test_refresh} < 5);
       $renv->{'test.refresh_rate'} = ($q->{test_refresh} + 0) ;
  
       if ($ERR) {
       } elsif (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
          print "$G->{e_100} <br>";
       } else {
          System->set_renv($renv);
          $info = Html->info($L->{l1});
       }
       last;
    }
  }

  print Html->header2("admin.gen_maint.options", undef);
  print $ERR if ($ERR);
  $renv->{topo_history_size} = 5 if (!$renv->{topo_history_size});

  my $telnet  = System->getPassword("array");
  my $showoob = "<input type=checkbox name=showoob " . 
                ($renv->{showoob} eq "Y"?"checked":"") .  ">";
  #my $ck5 = $renv->{email_per_event} ? "checked" : "";
  my $refresh = $renv->{'test.refresh_rate'} || 30;
  my $maxevents = $renv->{'max_event_file_size'} || 2;
  my $band = Util->makeSelect("band", "L=$L->{b_low}|H=$L->{b_high}", $renv->{gui_bandwidth});

  my $hub     = "checked" if ($renv->{use_hub});
  my $prod    = Html->makeSelect("production", "0=$L->{prod0}|1=$L->{prod1}", $renv->{production});
  my $max     = Html->makeSelect("max_daily_email", "4|6|2|99=$L->{nomax}", $renv->{max_daily_email});
  my $community = $renv->{"snmp.community"};

  my $session =  Html->makeSelect("session", "0=$L->{never}|30=30 $L->{mins}|60=60 $L->{mins}|1440=1 $L->{day}", $renv->{session_timeout}/60);
  my $session_field = [  f =>  $L->{timeout},    $session ] if ($renv->{solution} eq "N");


  my $glist_checked =  Html->makeSelect("glist", "N=$G->{no}|Y=$G->{yes}",
                         $renv->{"t3.telnet_monitor"});

  #my $ck10 = $renv->{show_unk_wwn} ? "checked" : "";
  my $prod_info = $renv->{production} ? $G->{yes} : $G->{no};
  my $maxemail = Html->makeSelect("max_email", "6|2|4|8|10",
                       $renv->{max_email_size});

  my $scr = Html::Screen->new();

  $scr->add(" <form method=post>
      <input type=hidden name=GO value=GUI::Options::upd>  $info $error $err2");

  $scr->table( { title => $L->{label} , labelWidth=> "50%" },
   [
   [ f =>  $L->{old_topo_cnt}, "<input type=text size=3 name=topo value=\"$renv->{topo_history_size}\">" ],
   [ f =>  $L->{refresh}, "<input type=text name=test_refresh size=4 value=$refresh> $L->{min}" ],
   [ f =>  $L->{max_events}, "<input type=text name=max_event_file_size size=4 value=$maxevents> ($L->{meg})" ],
   [ f =>  $L->{bandwidth}, $band ],
   [ f =>  $L->{use_hub}, "<input type=checkbox name=use_hub $hub>"],
   [ f =>  $L->{production}, $prod ],
   $session_field,
   [ f =>  $L->{pass}, "<input type=password name=telnet value=\"$telnet\">" ],
   [ f =>  $L->{community}, "<input type=text name=community value=\"$community\"> $L->{optional}" ],

   [ l =>  $L->{email}],
   [ f =>  $L->{sendmail}, "$ERR<input type=text name=sendmail_server size=30 value=\"$renv->{sendmail_server}\">  $L->{optional}" ],
   [ f =>  $L->{email_from}, "<input type=text name=email_from size=30 value=\"$renv->{email_from}\"> $L->{optional}" ],
   [ f =>  $L->{max_email_size}, $maxemail ],
   [ f =>  $L->{max_daily_email}, "$max $L->{max}" ],
   [ f =>  $L->{email_path} , "<input type=text name=mailer size=30 value=\"$renv->{mailer}\">" ],
   ] );

  $scr->button2( [
    [ l => 'ACTION_submit',   $L->{submit_options} , $deny]
    ]);
  $scr->add("</form>");
  print $scr->out();
   
}

sub updW {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my($error);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUI::Options");
  my $ruser = System->get_ruser();
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  $info = "";
  my($warn2, $warn3, $cat, $last_win);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  if ($q->{ACTION_basic}) {
    $q->{window} = "N";
    $q->{color_scheme} = "hci2";
    $q->{topo_mode}    = "G";
    $q->{ACTION_submit} = 1;
    $q->{list_size}     = "";
  }
  if ($q->{ACTION_advanced}) {
    $q->{window} = "S";
    $q->{color_scheme} = "hci2";
    $q->{adjust_frames} = "N";
    $q->{topo_mode}     = "A";
    $q->{ACTION_submit} = 1;
  }

  if ($q->{ACTION_submit}) {
    while (1) {
      $last_win = $renv->{window};
      $renv->{window}             = $q->{window};
      $renv->{accessible}         = "N";
      $renv->{color_scheme}       = $q->{color_scheme};
      $renv->{adjust_frames}      = $q->{adjust_frames};
      $renv->{topo_mode}          = $q->{topo_mode};
      $renv->{'screen.list_size'} = $q->{list_size};
      $renv->{no_applet}          = $q->{applet} eq "N" ? 1 : 0;
      Style->init($renv);
      if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
          print "$G->{e_100} <br>";
      } else {
          System->set_renv($renv);
          $info = Html->info($L->{l1});
      }
      last;
    }
    print "<meta http-equiv=Refresh target=_top content=\"0;URL=/\">";
    return;
  }
  print Html->header2("admin.gen_maint.win_options", undef);

  my $w = $renv->{window};
  my $ssize = Html->makeSelect("window", 
               "N=$L->{w_n}|S=$L->{w_s}|B=$L->{w_b}",$w);
  my $scheme  = Html->makeSelect("color_scheme", 
     "hci2=$L->{scheme1}|hci2_blue=$L->{scheme2}", $renv->{color_scheme});
  my $frames =  Html->makeSelect("adjust_frames", "N=$G->{no}|Y=$G->{yes}", 
                    $renv->{adjust_frames});
  my $list_size =    Html->makeSelect("list_size", "=$G->{default}|10|20|50|100|500", $renv->{"screen.list_size"});
  my $applet = Html->makeSelect("topo_mode", "A=$L->{applet}|G=$L->{image}",
                                $renv->{topo_mode});
  my $o;
  my $scr = Html::Screen->new();
  $scr->add(" <form method=post target=_top> <input type=hidden name=GO value=GUI::Options::updW> $info $error $err2");
  $scr->table( { title => $L->{submit_window} , labelWidth => "45%"},
   [
   [ f =>  $L->{window}, $ssize ],
   [ f =>  $L->{scheme}, $scheme ],
   [ f =>  $L->{frames} , $frames ],
   [ f =>  $L->{topo_mode} , $applet ],
   [ f =>  $L->{list_size},   $list_size ], 
   ]);

  $scr->button2( [
   [ l => 'ACTION_basic',    $L->{submit_basic} ],
   [ l => 'ACTION_advanced', $L->{submit_advanced} ],
   [ l => 'ACTION_submit',   $L->{submit_window} ],
   ]);

  $scr->add("</form>");
  print $scr->out();
}



1;
 
