package GUI::Filters;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------

#</copyright>

use Html;
#  $Id: Filters.pm,v 1.13 2004/03/16 21:28:08 ccadieux Exp $

use Labels;
use Agent;
use  Html::Tabs;
use strict;
use Filters;
use GUI::Notifs;

sub get_DAYS {
  my $G = Labels->read();
  return 
        "0a=$G->{sun} 5$G->{am} - 5$G->{pm}|0p=$G->{sun} 5$G->{pm} - 5$G->{am}|".
        "1a=$G->{mon} 5$G->{am} - 5$G->{pm}|1p=$G->{mon} 5$G->{pm} - 5$G->{am}|".
        "2a=$G->{tue} 5$G->{am} - 5$G->{pm}|2p=$G->{tue} 5$G->{pm} - 5$G->{am}|".
        "3a=$G->{wed} 5$G->{am} - 5$G->{pm}|3p=$G->{wed} 5$G->{pm} - 5$G->{am}|".
        "4a=$G->{thu} 5$G->{am} - 5$G->{pm}|4p=$G->{thu} 5$G->{pm} - 5$G->{am}|".
        "5a=$G->{fri} 5$G->{am} - 5$G->{pm}|5p=$G->{fri} 5$G->{pm} - 5$G->{am}|".
        "6a=$G->{sat} 5$G->{am} - 5$G->{pm}|6p=$G->{sat} 5$G->{pm} - 5$G->{am}|";
}


sub list {
  my($q) = @_;
  my($ho, $o, $err);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Filters');
  my($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
  if ($q->{ACTION_add}) {
     &add($q);
     return;
  }
  if ($q->{ACTION_del}) {
     my $filters = Filters->new();
     foreach my $x (keys %$q) {
        if (substr($x,0,4) eq "del_") {
            my $ix = substr($x,4);
            $filters->[$ix] = undef;
        }
     }
     $filters->write();
  }

  my $filters = Filters->new();
  print Html->body();
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }

  print Html->header2("admin.not_maint.filters");

  my($x, $h, $lnk, $type, $device, $prio, $ho);
  
  my $scr = Html::Screen->new();
  $scr->add(" <form  method=get> <input type=hidden name=GO value=GUI::Filters::list> $q->{ERR}");

  my (@array, $cnt);
  for ($x=0; $x <= $#$filters; $x++) {
    my $f = $filters->[$x];
    my $x2 = sprintf("%-5.5d", $x);
    $lnk  = "<a href=$Http::WEBPROC?GO=GUI::Filters::upd&ix=$x><b>0$x2</b></a>";
    $cnt++;
    my $del = "<input type=checkbox name=del_$x>";
    my $sev = $L->{"sev_$f->{severity}"};

    push(@array, 
      [ $del, $lnk, $f->{type}, $f->{code}, $f->{days}, $f->{pattern}, $sev ]);
  }
  if ($cnt == 0) {
     push(@array, [$L->{none}]);
  }

  $scr->list($q, { title => $L->{title} },
   [
   [ c => $G->{submit_delete}],
   [ l => '#' ],
   [ l => $L->{type} ],
   [ l => $L->{code} ],
   [ l => $L->{days} ],
   [ l => $L->{pattern} ],
   [ l => $L->{severity} ],
   ],
   \@array,
   [
   [ l => 'ACTION_del' , $L->{submit_del}, $deny ],
   [ l => 'ACTION_add',  $L->{submit_add}, $deny ],
   ]
   );
   $scr->add("</form>");
   print $scr->out();
}


sub upd {
  my($q) = @_;
  my($ho, $o);
  my($name,$renv, $dev, $hosts, $notifs);

  my $G = Labels->read();
  my $L = Labels->read('GUI::Filters');
  my $deny = Roles->verifyRole($q, "admin");
  my($err, $renv, $dev, $host, $notifs, $x, $h);
  my $filters = Filters->new();

  if ($q->{ACTION_upd}) {
    my $filter = $filters->[$q->{ix}];
    if ($filter) {
      if (!$q->{code} && !$q->{pattern}) {
         $err = Html->error("$L->{enter_code}");
      } else {
        $filter->{code}     = $q->{code};
        $filter->{type}     = $q->{type};
        $filter->{pattern}  = $q->{pattern};
        $filter->{days}     = $q->{days};
        $filter->{severity} = $q->{severity};
        $filters->write();
        $err = Html->info("$L->{filter_updated}");
      }
    }
      
  } elsif ($q->{ACTION_back}) {
    $q->{option} = "";
    &list($q);
    return;
  }
  print Html->body();
  print Html->header2("admin.not_maint.filters", undef, $L->{upd_label});

  ($renv, $dev, $hosts, $notifs) = PDM::ConfigFile->read();


  my $filter = $filters->[$q->{ix}];
  my($types, $days, $sevs);

  my $types = Html->makeSelect("type", GUI::Notifs::selectAgents() , $filter->{type},
                  {select => 1});

  my $days = Html->makeSelect("days",  &get_DAYS,$filter->{days}, {multiple => 4});

  my $sevs = Html->makeSelect("severity", 
          "1=$L->{dec_1}|2=$L->{dec_2}|0=$L->{dec_0}|9=$L->{dec_9}",
                    $filter->{severity});

  my $scr = Html::Screen->new();
  $scr->add(" <form  method=get> <input type=hidden name=GO value=GUI::Filters::upd> $h $err
              <input type=hidden name=ix value=$q->{ix}>");

  $scr->table( { title => $L->{upd} },
   [
   [ f => $L->{days} , "$days ($L->{opt})" ],
   [ f => $L->{type}, "$types ($L->{opt})" ],
   [ lh => " bgcolor=#F0F0C0> " . $L->expand(atleast => $L->{code}, $L->{pattern}) ],
   [ f => $L->{code}, "<input type=text name=code size=20 value=\"$filter->{code}\">" ],
   [ f => $L->{pattern}, "<input type=text size=60 name=pattern value=\"$filter->{pattern}\">"],
   [ lh => " bgcolor=#F0F0C0>&nbsp;"],
   [ f => $L->{sev}, $sevs ],
   ]);
   $scr->button2(
     [
     [ l => "ACTION_upd",  $G->{submit_update} ],
     [ l => "ACTION_back", $G->{submit_back} ],
     ]);

   $scr->add("</form>");
   print $scr->out();
}


sub add {
  my($q) = @_;
  my($ho, $o, $err);

  my $G = Labels->read();
  my $L = Labels->read('GUI::Filters');

  my($renv, $dev, $host, $notifs, $info);
  if ($q->{ACTION_add1}) {
     my $filters = Filters->new();
     $q->{code}    = Util->rtrim($q->{code});
     $q->{pattern} = Util->rtrim($q->{pattern});
     if (!$q->{code} && !$q->{pattern}) {
         $err = Html->error("$L->{enter_code}");
     } else {
       $filters->add($q->{code}, $q->{type}, $q->{days}, $q->{pattern}, $q->{severity});
       $filters->write();
       $err = Html->info("$L->{filter_added}");
     }
  }

  if ($q->{ACTION_back}) {
    $q->{option} = "";
    &list($q);
    return;
  }
  print Html->body();
  

  print Html->header2("admin.not_maint.filters", undef);

  my($types, $days, $sevs);
  my $types = Html->makeSelect("type", GUI::Notifs::selectAgents() , undef,
                  {select => 1});

  my $days = Html->makeSelect("days",  &get_DAYS, undef, {multiple => 4});

  my $sevs = Html->makeSelect("severity", 
                "1=$L->{dec_1}|2=$L->{dec_2}|0=$L->{dec_0}|9=$L->{dec_9}");

  my $scr = Html::Screen->new();
  $scr->add(" <form  method=get> <input type=hidden name=GO value=GUI::Filters::add> <center> $err");
  $scr->table( {title => $L->{title2} },
   [
   [ f => $L->{days}, "$days ($L->{opt})" ],
   [ f => $L->{type}, "$types ($L->{opt})" ],
   [ lh => " bgcolor=#F0F0C0> " . $L->expand(atleast => $L->{code}, $L->{pattern}) ],
   [ f => $L->{code}, "<input type=text name=code size=20>" ],
   [ f => $L->{pattern}, "<input type=text size=60 name=pattern>" ],
   [ lh => " bgcolor=#F0F0C0>&nbsp;"],
   [ f => $L->{sev}, $sevs ],
   ]);

  $scr->button2( [
    [ l => "ACTION_add1", $G->{submit_add} ],
    [ l => "ACTION_back", $G->{submit_back} ],
    ]);
  $scr->add("</form>");
  print $scr->out();

}

sub display_event_list {
  my($q, $filter) = @_;
  my($x, $ck, $out);

  foreach $x (sort keys %{Event->get_types} ) {
     if (substr($filter,0,1) eq "-") {
        next if (Event->get_category($x) eq substr($filter,1));
        $ck = ($q->{"event_$x"})? "checked":"";
        $out .= "<input type=checkbox name=event_$x $ck>: " .
             Event->get_description($x) . "<br>";

     } else {
       if (Event->get_category($x) eq $filter) {
         $ck = ($q->{"event_$x"})? "checked":"";
         $out .= "<input type=checkbox name=event_$x $ck>: " .
             Event->get_description($x) . "<br>";
       }
     }
  }
  return $out;
}


sub find_events {
  my $ruser = System->get_ruser();
  my $renv = System->get_renv();
  my($l);
  my $lang = $ruser->{language} || $renv->{language};

  my $F = System->get_home() ."/Lang/System/Labels/$lang/Events.lb";
  if (-f $F) {
    open(O, $F);
  } else {
    open(O, System->get_home() . "/System/Labels/Events.lb");
  }
  my($out); 
  while ($l = <O>) {
    chop($l);
    $l =~ s/\s*=\s*/=/;
    $out .= "$l|";
  }
  close(O);
  chop($out);
  return $out;
}




1;
