package GUI::ExceptionReport;
use Report;
use Reports;
use Reports::Exception;
use System;
use Html::List;
use strict;
use Modules;
use Process;
use Math;
use AdminGroup;

sub RUN {
  my($q) = @_;
  my $F = System->get_home() . "/DATA/tmp/exception_report";
  my $age = Util->getFileAge($F, "h");
  if (!-f $F || $age > 12) {
    my $st = Process->status(undef, "exception_report");
    if ($st =~ /Running/) {
       print "Exception report already running!\n";
    } else {
       Process->start("exception_report");
       Reports::Exception->new(1);
    }
  }
}
     


sub list {
  my($q) = @_;
  my $LB = Labels->read('GUI::ExceptionReport');

  my $LIST = [
    [ "ExConfig.html",   "GUI::ExceptionReport::config", $LB->{report1}],
    ];
  my ($info, $started);
  
  if ($q->{ACTION_new}) {
    my $st = Process->status(undef, "exception_report");
    my $cpid;
    if ($st =~ /Running/) {
       print Html->warning($LB->{running});
    } else {
      $SIG{CHLD} = 'IGNORE';
      if (($cpid = fork()) == 0) {
        Process->start("exception_report");
        close STDIN; 
        close STDOUT if (!$ENV{FCGI});
        close STDERR;
        Reports::Exception->new(1);
        exit;
      } else {
        sleep(1);
        $info = Html->info($LB->expand(started => $cpid) );
        $started = 1;
      }
    }

  } elsif ($q->{ACTION_email}) {
    if ($q->{email}) {
      Reports->email($q, $q->{email}, "Exception Report", $LIST);
      $info= "$LB->{email_sent}!<br>";
    } else {
      print Html->error($LB->{email});
    }
    $Html::HEADER2_DONE = 0;
  }
  my $st = Process->status(undef, "exception_report");
  my($new, $meta);
  if ($st =~ /Running/ || $started) {
    $meta = "<meta http-equiv=Refresh content=\"10;URL=$Http::WEBPROC?GO=GUI::ExceptionReport::list\">" 
  } else {
    $new = 1;
  }

  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/exception_report");
  my ($archive);

  print Html->body();
  print $meta;
  print Html->header2("report.general.ex");
  my $dis1 = $st;
  $dis1 .= "..." if ($st =~ /Running/);
  my $last_run = Util->get_file_created(System->get_home() . '/DATA/tmp/exception_report');

  my $scr = Html::Screen->new();
  $scr->add(" $info <form> <input type=hidden name=GO value=GUI::ExceptionReport::list>");
  $scr->table( { title => $LB->{create} },
   [
   [ f => "$LB->{last_run}", $last_run ],
   [ f => $LB->{report_status}, $dis1 ],
   ]);
  $scr->button2( [
   [ l => 'ACTION_new', $LB->{submit_new},  !$new ],
   ]);

   $scr->add( Reports->list($q, $LIST, $date) );
   $scr->add("</form>");
   print $scr->out();

}


use GUI::FruReport;

sub config {
  my($q) = @_;
  my $out;
  $out .= Html->header2("report.general.ex", undef, undef, undef, 
         {nohelp => $q->{email}, right => Util->get_today(), noDoc => 1});
  if (!$q->{SORT}) {
    $q->{SORT} = 1 ; $q->{SIGN} = 1;
  }
  my $REP = Reports::Exception->new();
  my $LB = Labels->read('GUI::ExceptionReport');
  my $AG = GUI::FruReport::read_admin_groups();

  if (! $REP) {
     print Html->body();
     print Html->error($LB->{no_report});
     return;
  } 
  my @tt = split(/,/, $LB->{titles2});
  my @REP1;
  foreach my $e (@$REP) {
    my $name = $e->[0];
    next if ($q->{ADMGRP} && ($AG->{$e->[0]} ne $q->{ADMGRP}));
    my $ix = rindex($e->[3],".");
    my $el = $ix > 0 ? $e->[2] . "." . substr($e->[3],0,$ix) : $e->[3];
    next if ($q->{ATTR} && index($e->[3], $q->{ATTR}) < 0);
    push(@REP1, [$e->[0], $e->[1],$el, $e->[4], $e->[5], $e->[6] ]);
  }

  my $ex = Reports::Exception->read_ex();
  my $sel = "<select name=ATTR><option value=\"\">[ Attribute ]";
  use Data::Dumper;
  my(%EX);
  foreach my $e (sort keys %$ex) {
	  $EX{$ex->{$e}{name}.$e} = $e;
  }
  my $DONE;
  foreach my $e0 (sort keys %EX) {
	  my $e = $EX{$e0};
	  my $ix = rindex($e, ".");
	  my $e0 = substr($e,$ix+1);
	  my $selected = "selected" if ($q->{ATTR} eq $e0);
          next if (!$ex->{$e}{name});
          if (index($DONE, ",$e0,") < 0) {
	    $sel .= "<option $selected value=\"$e0\">$ex->{$e}{name}</option>\n";
            $DONE .= ",$e0,";
          }
  }
  $sel .= "</select>";

  my $adm_sel = AdminGroup->select2($q->{ADMGRP});

  if ($#$REP < 0) {
     push(@REP1, [ "<b>No Exception found!" ]);
  }

  my $scr = Html::Screen->new();
  my $go = $scr->goForm([ "GO=GUI::ExceptionReport::config","SORT=$q->{SORT}","SIGN=$q->{SIGN}"],
            "$adm_sel $sel");

  $scr->list($q, { title =>  $LB->{report2}, pageSize => 200, interactive => !$q->{email} },
    [
    [ l => $LB->{col1}, '+sn' ],
    [ l => $LB->{col2}, '+' ],
    [ l => $LB->{col3}, '+' ],
    [ l => $LB->{col4}, '+' ],
    [ l => $LB->{col5}, '+' ],
    [ l => $LB->{col6}, '+' ],
    ],
    \@REP1,
    [
    [ l => 'DATA' , $go ]
    ]);
  my $out = $scr->out();

  Reports->format($q, \@REP1, \$out);
}




1;

