package GUI::EventLog;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: EventLog.pm,v 1.48 2004/08/23 21:57:16 ccadieux Exp $

use strict;
use Modules;
use State;
use System;
use bytes;
use Util::Http;
use Html::Tabs;
use vars qw ($CATEGORY $EVENT);


sub get_categories {

  my $G = Labels->read();
  my $L = Labels->read("GUI::EventLog")->section("events");

  my $out =  "<select name=category>
            <option value=\"\">$G->{all}</option>
            <option value=message.>$L->{message_e}</option>
            <option value=host.>$L->{host_e}</option>
            <option value=topo.>$L->{topo_e}</option>
            <option value=agent.>$L->{agent_e}</option>";

   my $sel;
   require Agent;
   my $mods = Agent->findSelectableAgents();
   foreach my $ag0 (@$mods) {
       my @A = split(/=/, $ag0);
       $out .= "<option value=$A[0].>$A[1]</option>\n";
    }
    $out .= "</select>";
}

sub get_EVENTS {

  my $G = Labels->read();
  my $L = Labels->read('GUI::EventLog')->section('events');

  return "<select name=event>
            <option value=\"\">$G->{all}</option>
            <option value=.Communication>$L->{comm}</option>
            <option value=.DiscoveryEvent>$L->{disco}</option>
            <option value=.RemovalEvent>$L->{remove}</option>
            <option value=.DiagnosticTest>$L->{diag}</option>
            <option value=.TopologyEvent>$L->{topo}</option>
            <option value=.AuditEvent>$L->{audit}</option>
            <option value=.StateChangeEvent>$L->{state}</option>
            <option value=.ValueChangeEvent>$L->{valueChange}</option>
            <option value=.Agent>$L->{agent}</option>
            <option value=.backup>$L->{backup}</option>
            <option value=.patch>$L->{patch}</option>
            <option value=.LinkEvent>$L->{link}</option>
            <option value=.LocationCh>$L->{location}</option>
            <option value=.Statistics>$L->{stats}</option>
          </select>";
}


#
#  EVENTS
#
sub list {
  my($q) = @_;

  print Html->body();
  print Html->header2("monitor.log.events");

  $q->{ALERT} = 0;
  print &form1($q);
}

#
#  ALERTS
#
sub alerts {
  my($q) = @_;

  print Html->body();
  print Html->header2("monitor.log.alerts");
  $q->{ALERT} = 1;
  print &form1($q);
}

sub form1 {
  my($q) = @_;
  my ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my $L = Labels->read('GUI::EventLog')->section('events');
  my $G = Labels->read();

  my $sel_hosts = "<select name=hostname><option value=\"\">$G->{all}</option>
   <option value=local>" . $renv->{hostname} . "</option>";

  foreach my $h (@$host) {
    $sel_hosts .= "<option>$h->{hostname}</option>";
  }
  $sel_hosts .= "</select>";
  my $MAX = "<select name=MAXSIZE><option value=25000>25KB<option value=50000>50KB<option value=75000>75KB<option value=100000>100KB</select>";

  my $EVENT = get_EVENTS();
  my $ET = "<select name=eventtype>
      <option value=\"\">$L->{type_all}</option>
      <option value=mgmtLevel:C>$L->{type_sys}</option>
      <option value=mgmtLevel:D>$L->{type_comp}</option>
      </select>";
  $CATEGORY = &get_categories();

  my $scr = Html::Screen->new();
  $scr->add(" <form> <input type=hidden name=GO value=GUI::EventLog::display> 
          <input type=hidden name=ALERT value=$q->{ALERT}>");

  $scr->table( { title => "&nbsp;", labelWidth => "40%"},
   [
   [ f => $L->{agentHost}, $sel_hosts ],
   [ f => $L->{category}, $CATEGORY ],
   [ f => $L->{severity}, "<select name=sev>
            <option value=\"\">$L->{sev_all}</option>
            <option value=\"Sev:3\">$L->{sev_down}</option>
            <option value=\"Sev:2\">$L->{sev_crit}</option>
            <option value=\"Sev:1\">$L->{sev_alert}</option>
            <option value=\"Sev:0\">$L->{sev_caution}</option>
         </select>" ],
   [ f => $L->{event} , $EVENT ],
   [ f => $L->{eventtype} , $ET ],
   [ f => $L->{maxsize} , $MAX ],
   [ f => $L->{filter1}, "<input type=text name=filter1 size=20>" ]
   ]);
  $scr->button2( [
   [ l => 'ACTION', $L->{submit_search} ],
    ]);
  $scr->add("</form>");
  return $scr->out();
}

sub info {
  my($q) = @_;
  require "Grid.pm";
  my($type, $comp, $ev, $desc, $severity, $code, $title);
  my($actionable, $im, $code2 );
  my $renv = System->get_renv();
  my $MAINWIN  = $q->{MAINWIN};
  my $NARROW = Http->isNarrow();
  require Advisor;

  print Html->body();
  print Advisor->functions();
  my $L = Labels->read('GUI::EventLog')->section('info');
  my $G = Labels->read();
  my $service;
       
  my ($agg_data, $involved, $sub_events, $help);

  if ($q->{event}) {
    my $event = State->readEvent($q->{event});
    my $H     = State->eventHash($event->[4]);
    $code     = $H->{GridCode};
    $severity = $event->[0];
    $desc     = $event->[1];
    my $agg   = $event->[5];
    $desc    .= " [$agg sub-events]" if ($agg > 0);
    $ev       = Grid->getInfo($type, $comp, {code => $code});
    $title    = $H->{TargetName};
    $title   .= " : $H->{Component}" if ($H->{Component});

    if ($ev->{service} && $renv->{solution} ne "N") {
      my $name = $H->{TargetName};
      my $ix = index($name, "(");
      $name = substr($name, 0, $ix) if ($ix > 0);
      $name =~ s/ //g;
      my ($cat, $target) = split(/\:/, $H->{Target});
      $q->{_SELECTED} = "$target:$H->{Component}:$name";

      my @ev_data = split(/\s*\;\s*/, $ev->{service});
      my ($ev_inc);
      foreach my $ed (@ev_data) {
         if ($ed =~ /include=y/i) {
           $ev_inc=1;
         }
      }
      if ($ev_inc) {
        $ev->{action} .= "<p><svc include=$ev_data[0]>";
      } else {
        $ev->{action} .= "<p>[ <svc mainPage=$ev_data[0]>$L->{click_advisor}</a> ]";
      }
    }
    if ($event->[5] > 1) {
      if ($q->{details} == 1) {
	$help = Html->linkToggle("GUI::EventLog::info&event=$q->{event}&MAINWIN=$MAINWIN",
	                "details",[$L->{details},$L->{summary}], 1);
        require EventDB;
        ($involved, $sub_events) = EventDB->sub_events($event->[6], 1, 0);
        $involved =~ s/\n/<br>/g;
        $sub_events =~ s/\n/<br>/g;
        my $title1 = $L->expand(agg => $event->[5]);
        $agg_data = "
          <table border=1 width=100% cellspacing=0 cellpadding=2>
          <tr><td bgcolor=$Style::LIGHT><b>$title1</td>
	  <tr><td><b>$L->{involved}</b><br>$involved</td>
	  <tr><td><b>$L->{subevents}</b>$sub_events</td>
	  <tr><td><small> $L->{disclaimer}</table>&nbsp;<p>";
      } else {
	$help = Html->linkToggle("GUI::EventLog::info&event=$q->{event}&MAINWIN=$MAINWIN",
	               "details", [$L->{details},$L->{summary}], 2);
      }
    }
  } else {
    $code = $q->{code};
    $type = $q->{type};
    $comp = $q->{comp};
    $desc = $q->{desc};
    $ev   = Grid->getInfo($type, $comp, {code => $code});
    $severity  = (exists $q->{sev}) ? $q->{sev} : $ev->{severity};
  }
  if ($MAINWIN) {
    print Html->header2("alarms.alarms2", undef, $L->{detail}, undef,
         {right => $help, nohelp =>1, noDoc => 1});
  } else {
    print Html->header2("service.event.grid", undef, undef, undef,
         {popup => 1,  noDoc => 1, noTabs => 1,
          nohelp => 1, right => $help});
  }

  $im = $G->{"sev" . int($severity+0.5)};
  if ($ev) {
    $actionable = ($ev->{actionable})? $G->{yes}: $G->{no};
    $code2 = $ev->{code};
    if (!$desc) {
      $desc = $ev->{desc} || "No description available!";
    }
  } else {
    $actionable = "N/A";
    $code2 = $code || "N/A";
    if (!$desc) {
      $desc = "<center>No Event Advisor information available!";
    }
  }

  my($cat, $rest) = split(/\./, $type, 2);
  my $pattern;
  if (exists $ev->{pattern}) {
    $pattern = " <tr><td align=right >$L->{pattern}:</td>
                <td colspan=3><b>$ev->{pattern}</td>";
  }
  my $type2 = $ev->{type} || $type;
  #$type2 =~ s/Event//;
  my $comp2 = $ev->{comp} || $comp;
  my $tr = "<tr>" if ($NARROW);
  print "
  <table border=0 cellspacing=0 cellpadding=2 width=$Style::WIDTH bgcolor=white><tr><td>
   <b>$title</table>
  <table border=1 cellspacing=0 cellpadding=3 width=$Style::WIDTH bgcolor=white>
    <tr><td align=right ><form>$L->{event}:</td>
        <td><b>&nbsp;$type2
        $tr<td align=right >$L->{sev}:</td><td><b>$im</td>
    <tr><td align=right >$L->{comp}:</td> 
        <td width=20%>&nbsp;<b>$comp2</td>
        $tr<td align=right >$L->{actionable}:</td><td width=20%><b>$actionable</td>
    <tr><td align=right >$L->{code}:</td><td width=20% colspan=3>&nbsp;<b>$code2</td>
    <tr bgcolor=$Style::LIGHT><td colspan=4><b>$L->{description}</td>
    <tr><td bgcolor=white colspan=4>$desc</td>
   ";
  if (length($ev->{info}) > 1) {
     print "<tr bgcolor=$Style::LIGHT><td colspan=4><b>&nbsp;$L->{info}</td>
           <tr bgcolor=white><td colspan=4><pre>$ev->{info}</pre></td>";
  }
  if (length($ev->{cause}) > 1) {
     print "<tr bgcolor=$Style::LIGHT><td colspan=4><b>&nbsp;$L->{cause}</td>
           <tr bgcolor=white><td colspan=4><pre>$ev->{cause}</pre></td>";
  }
  if (length($ev->{action}) > 1 || $service) {
     my $action = Advisor->process($ev->{action}, "Grid", undef, $q);
     print "<tr bgcolor=$Style::LIGHT><td colspan=4><b>&nbsp;$L->{action}</td>
           <tr bgcolor=white><td colspan=4><pre>$action\n</pre></td>";
  }
  print "</table>&nbsp;<br>";
  print "</center>$agg_data";

}


# from list or alerts

sub display {
  my($q) = @_;
  my(@a, $cnt, $name);

  my( $back);
  print Html->body();
  if ($q->{ALERT}) {
    print Html->header2("monitor.log.alerts", undef,undef,undef, {noDoc => 1});
  } elsif (!$q->{Roption}) {
    print Html->header2("monitor.log.events", undef,undef,undef, {noDoc => 1});
  }

  if ($q->{file}) {
     if ($q->{host}) {
       $q->{"host_" . $q->{host}} = 1;
     } else {
       $q->{host_local} = 1;
     }
     my($c1, $k1) = split(/\:/, $q->{file});
     $q->{filter1}  = "Enc:$k1";
     $q->{filterOR} = "AgentH:$k1" if ($q->{file} =~ /se\d*\:/);
     &display0($q);

  } else {
     &display0($q);
  }
}

sub display0 {
  my($q) = @_;

  my $renv = System->get_renv();
  my $G = Labels->read();
  my $L = Labels->read("GUI::EventLog")->section("display");
  my($sev) = $q->{sev};
  my $EV = &get_event_log($q);
  my (@SEV);

# EVENTS
  my $SEV = $q->{option} if ($q->{option}); # used for alerts only
  foreach my $ev (@$EV) {
      my $l = $ev->[0];
      if ($l =~ /Sev:(\d)/) {
         $SEV[$1]++;
      }
  }
  &sev_header($q, \@SEV) if (!$q->{Roption});

  my $scr = Html::Screen->new();
  #$scr->add("<form> <input type=hidden name=GO value=GUI::EventLog::display>");
  $scr->add("
   <script>
   function info(sev,a,b, c, desc) {
      var b = '$Http::WEBPROC?GO=GUI::EventLog::info&type=' + a + 
               '&comp=' + b + '&code=' + c + '&sev=' + sev + '&desc=' + desc;
      var O = window.open(b,'linfo','menubar=yes,resizable=yes,scrollbars=yes,width=500,height=600');
      O.focus();
   }
   </script>
   ");

   my(@array);

   my @gifs = ('al_ok','al_alert','al_crit','al_down');
   my $sev_txt = State->sev_labels();
   my ($lines, $l, $y);
   for ($y=$#$EV; $y >= 0; $y--) {
     my $ev = $EV->[$y];
     $l = $ev->[0];
     next if ($l =~ /AggregatedEvent/);
     my $data = $ev->[1];
     my @O = split(/\t/, $l);
     next if ($#O < 4);
     next if (substr($O[0],0,2) eq "--");
     my $act = substr($O[4],7) eq "TRUE" ? "<br>Act" : "&nbsp;";
     my $sev = substr($O[3],4);
     next if ($SEV && $sev != ($SEV-1));
     my $host = substr($O[7], 7);
     $host = $renv->{hostname} if ($host eq "local");
     my $ix2 = index($host, ".");
     $host = substr($host,0,$ix2) if ($ix2 > 0);
     my $ev = $O[1];  $ev =~ s/ /','/;
     my $ev2 = $O[1]; 
     my $ecode = substr($O[9],6);   # ECode:1.1.1
     $ev2 =~ s/Communication/Comm-/;
     $ev2 =~ s/Event//;
     $ev2 =~ s/\./. /;
     my $desc = $O[2];
     $desc =~ s/[\(\)\']/ /g;
     $desc =~ s/[\=]/:/g;
     $desc =~ s/ /\+/g;
     my $url = "<a href=\"javascript:info('$sev','$ev','$ecode', '$desc')\">$ev2</a>";
     my $sevImg;
     if ($sev == 0) {
        $sevImg = $G->{notice};
     } elsif ($sev < 4) {
        $sevImg  = "<img src=/gif/" . $gifs[$sev] . ".gif width=13  alt=\"$sev_txt->[$sev]\">";
     }
     if ($data) {
         chomp($data);
         $data =~ s/\n/<br>/g;
         $data = "<br><b>$L->{event_data}</b>: $data";
     }
     push(@array, [$O[0], $host, $sevImg , $url, "<small>$O[2] $data" ]);

     $lines++;
   }

   $scr->list($q, { interactive => 1 , pageSize => 50, xline2 => 4,2 },
    [
    [ l => $L->{header_time}  ],
    [ l => $G->{host}  ],
    [ c => $L->{header_sev}   ],
    [ l => $L->{header_event} ],
    [ l => $L->{desc} ],
    ],
    \@array,
    );
   $scr->add("</form>");
   print $scr->out();

}

sub sev_header {
  my($q, $sev) = @_;
  my ($al, $l, $x);
  $sev->[0] += 0;
  $sev->[1] += 0;
  $sev->[2] += 0;
  $sev->[3] += 0;
  $sev->[4] += 0;
  my $L = Labels->read('GUI::EventLog')->section('events');
  my $S = State->sev_labels();
  
  my $select = "<select name=option onchange=form.submit()><option value=0>$L->{all}</option>";
  for ($x=0; $x <= 3; $x++) {
     my $o = $x+1;
     my $sel = "selected" if ($q->{option} == $o);
     $select .= "<option value=$o $sel>$S->[$x]: $sev->[$x]</option>";
  }
  $select .= "</select>";

  print "<table border=0 cellspacing=0 cellpadding=0 width=$Style::WIDTH><tr>
    <td width=4%><form><input type=hidden name=GO value=GUI::EventLog::display>
     <input type=hidden name=ALERT value=$q->{ALERT}>
     $L->{filter}:</td>
    <td> $select</td>
    </table>";

}



#
# always pulls local data
#
sub get_event_log {
  my($q) = @_;
  my($out, @EV, $file, $l);
  my $MAXSIZE = $q->{MAXSIZE} || 50000;
  my($grep) = System->get_home() . "/bin/rgrep";
  $file = System->get_home() . "/DATA/" . ($q->{SYSTEM} ? "EventsSys.log" : "Events.log");
  my $ofile = $file;

  if ($q->{ALERT}) {  # alerts have a sev
     $q->{action} = "Action:TRUE";
  }
  if ($q->{hostname}) {  # specific slave host
     $q->{agenth} = "AgentH:$q->{hostname}";
  }
  my $erase;
  if ($q->{filter1} || $q->{filter2} || $q->{category} || $q->{event} ||
      $q->{sev} || $q->{action} || $q->{agenth} || $q->{eventtype}) {
     my($command);
     foreach my $c ('filter1','category','event','sev', 'action', 'agenth',
                    'eventtype') {
        if ($q->{$c}) {
           if ($command) {
              $command .= "|$grep  -p \"$q->{$c}\" -i L";
           } else {
              my $P = "-P \"$q->{filterOR}\"" if ($q->{filterOR});
              $command = "$grep -p \"$q->{$c}\" $P -f $file -i L";
           }
        }
     }
     $ofile = "/tmp/_rasevents.$$";
     system("$command > $ofile");
     $erase = 1;
  }
  if (!open(O, $ofile)) {
      $out .= "ERR Cannot read $ofile: $!<br>";
      return;
  }
  my $fsize = (stat($ofile))[7];
  if ($fsize > $MAXSIZE) {
     seek(O, - $MAXSIZE, 2);
     $l = <O>;
  }

  my $time;
  while ($l = <O>) {
     chop($l);
     my(@b) = split(/\t/, $l);
     if (substr($l, 0, 1) eq "L") {
        $EV[$#EV][1] .= substr($l,1) . "\n" if ($#EV >= 0);
     } else {
       $time = $b[0];
       $time =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/;
#      next if (!$1);
       $time = "$1-$2-$3 $4:$5:$6";
#      next if (!$b[1]);
       # my $type = sprintf("%-25.25s", $b[1]);
#       push(@a, "$time  $type  $b[2] $b[3]\n");
       $EV[$#EV+1][0] =  "$time\t$b[1] $b[2]\t$b[3]\t$b[4]\t$b[5]\t$b[6]\t$b[7]\t$b[8]\t$b[9]\t$b[10]";
     }
   }
   close(O);
   unlink $ofile if ($erase);
   return \@EV;
}

1;

