package GUI::Devices;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Devices.pm,v 1.21 2004/08/10 17:53:18 mckenney Exp $

use PDM;
use Launch;
use Report;
use Serialize;
use GUI::Config;
use GUI::Hosts;
use AdminGroup;
#
# List all devices, refer to GUIAdmin::<device>::addDevice and updDevice for 
# maintenance.

sub list {
 my($q) = @_;
 my($ho, $o, @devs);
 my $deny = Roles->verifyRole($q, "admin");
 my $G = Labels->read();
 my $L = Labels->read('GUI::Devices');
 my $ruser = System->get_ruser();
 print Html->body();
 
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  my $groups = AdminGroup->new();
  $q->{GROUP} = $ruser->{adm_group} if (! exists $q->{GROUP} && $ruser->{adm_group});

  if ($q->{ACTION_ass} && $q->{GROUP}) {
    if (!exists $groups->{$q->{GROUP}}) {
       print Html->warning("Invalid group: $q->{GROUP}");
    } else {
      my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
      my $cnt;
      foreach my $d (@$devs) {
        if ($d->{host} eq $q->{HOST}) {
           $d->{adm_group} = $q->{GROUP};
           $cnt++;
        }
      }
      PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);
      print Html->info("Updated $cnt devices!");
    }

  } elsif ($q->{ACTION_selected}) {
    my $err;
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    foreach my $e (keys %$q) {
       if (substr($e,0,4) eq "del_") {
          my $no = substr($e,4);
          $devs->[$no] = undef;     
       }
    }
    PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);
    print Html->warning("Invalid group(s): $err") if ($err);

  } elsif ($q->{ACTION_all}) {
    ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;
    PDM::ConfigFile->write( $renv, [], $hosts,$notifs);

  } elsif ($q->{ACTION_group}) {
    ($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    my $x;
    for ($x=0; $x <= $#$devs; $x++) {
      my $d = $devs->[$x];
      if ($q->{GROUP} && $d->{adm_group} eq $q->{GROUP}) {
          $devs->[$x] = undef;
      }
    }
    print $G->expand('deleted', $q->{GROUP});

    PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);

  } elsif ($q->{ACTION_only}) {
    ($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;
    my $x;
    for ($x=0; $x <= $#$devs; $x++) {
      my $d = $devs->[$x];
      if (($q->{HOST} && $d->{host} eq $q->{HOST}) ||
          ($q->{HOST} eq "LOCAL" && !$d->{host}))  {
          $devs->[$x] = undef;
      }
    }
    print $G->expand('deleted', $q->{HOST});
    delete $q->{HOST};
    PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);

  } elsif ($q->{ACTION} eq "Push Slave Configs") {
    GUI::Hosts::push_slaves($q);
  }

  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;

  if (!$renv->{site_country}) {
     $q->{SITE_FIRST} = 1;
     GUI::Config::site($q);
     return;
  }

  print Html->header2("admin.gen_maint.maint_device");
  %H = ();

  $H{Master} = $renv->{active};
  foreach $h (@$hosts) {
    $H{$h->{hostname}} = $h->{active};
  }
  my $sel;
  if ($#$dev > 200 && !$q->{HOST}) {
     $sel = "selected";
     $q->{HOST} = "LOCAL";
  }
  my $groupsD = $groups->select("GROUP", $q->{GROUP}, $G->{group});

  my($hostsD) = "<select name=HOST><option value=LOCAL $sel>" . Util->shortHostname($renv->{hostname}) . "</option>";

  $sel = ($q->{HOST} eq "")? "selected":"";
  $hostsD .= "<option value=\"\" $sel>$G->{all_hosts}</option>";
  my(@H);
  my($CAT, %AGENT);
  $AGENT{""} = $renv->{active};

  foreach $h (@$hosts) {
     $AGENT{$h->{hostname}} = $h->{active};
     push(@H, $h->{hostname});
     $CAT->{$h->{hostname}} = $h->{categories};
  }
  foreach $h (sort @H) {
     $sel = ($h eq $q->{HOST})? "selected":"";
     $hostsD .= "<option value=\"$h\" $sel>" . Util->shortHostname($h) . "</option>";
  }
  $hostsD .= "</select>";
  my $categories;
  #
  # FILTERING
  #
  for ($x=0; $x <= $#$dev; $x++) {
     $d = $dev->[$x];
     next if ($ruser->{isCustomer} && $d->{mgmtLevel} eq "C");
     my $ho = $d->{host} || "LOCAL" ;
     next if ($q->{HOST} && $q->{HOST} ne $ho);
     next if ($q->{GROUP} && $d->{adm_group} ne $q->{GROUP});
     $d->{no} = $x;
     if($d->{host}  && ($renv->{solution} eq "N")){
       $categories = $CAT->{$d->{host}};
     }else{
       $categories = $renv->{categories};
     }
     $categories .= "|$renv->{solution}|";
     $d->{hactive} = "Y";
     $d->{hactive} = "N" if (index("|$categories|", "|$d->{type}|") < 0);
     $s = Serialize->hash_join($d);
     $loc = lc($d->{host}) || (System->hostname() . " (local)");

     push(@devs, $d);
  }
  my $urls = Launch->read();
  my($last, $cnt2, $no_dev, @array, $active1, $active2, $active3);

  foreach $h (@devs) {
    $type = $h->{userLabel} || $h->{type};
    $type .= "-$h->{model}" if ($h->{model} && $h->{model} ne $h->{userLabel});

    my $agent = $AGENT{$h->{host}} eq "Y" ? $G->{On} : "<font color=red>$G->{Off}</font>";
    $ip  = $h->{ipno} || $h->{ip};
    $loc = $h->{host} || System->hostname();
    my $ix2 = index($loc, ".");
    $col = "black";

    $active1 = ($h->{active}  eq "Y") ? $G->{On}  : "<font color=red>$G->{Off}</font>";
    $active2 = ($h->{hactive} eq "Y") ? $G->{On} :  "<font color=red>$G->{Off}</font>";
    $active3 = $agent;

    if ($h->{skip}) {
       $active3 .= "<br></b></b><font color=red><small>(Skipped since " . Util->get_today($h->{skip}) . ")";
    }
    my($bold);

    $loc0 = $loc;
    $loc0 = substr($loc,0,$ix2) if ($ix2 > 0);

    my $WWN = $h->{wwn} || $h->{key};
    my $wwn_err;
    if ($h->{type} eq "t3" && length($WWN) < 2) {
       $wwn_err = "<font color=red>$L->{'dev_list.err_1'}";
    }
    if ($h->{type} eq "t3" && (!$h->{key} || index($h->{key}, ". .") >= 0)) {
       $wwn_err .= "<font color=red>$L->{'dev_list.err_2'}";
    }
    $wwn_err = "<br>$wwn_err" if ($wwn_err);
    my $module = Modules->findFromClass('GUIAdmin', $h->{class});
    $lnk = "<a href=\"$Http::WEBPROC?GO=${module}->updDevice&no=$h->{no}\">$h->{name}</a>";
    $xurl = "";
    if ($module) {
      my $mlist = {};
      if ($module->can("MAINTAIN")) {
         $mlist = $module->MAINTAIN();
      }
      my $xurl;
      foreach my $x (keys %$mlist) {
          $xurl  .= " | <a href=\"$Http::WEBPROC?GO=GUIAdmin::${b}::$x\">$mlist->{$x}</a>";
      }
    } else {
      $lnk = "$h->{name}";
    }
    my $agroup = $h->{adm_group};
    if (!$deny){
      $xurl = "<input type=checkbox name=del_$h->{no}>";
    }
    my $l1;
    if (($urls->{$h->{type}}[1]  || ($urls->{$h->{type}}[3]))  && $h->{mgmtLevel} ne "DS") {

        $launch = $urls->link($h->{type}, $h);
        $l1 = "<table class=Tclear border=0 width=100% cellspacing=0 cellpadding=0>
          <tr><td class=TclearTd>$lnk</td><td class=TclearTd align=right>$launch</table>";
    } else {
        $l1 = $lnk;
    }
    $WWN = substr($WWN,0,6) . ".." if ($q->{DOC});
    push(@array, 
      [ $xurl, $loc0, "><sort $h->{name}>$l1", $type, 
        "<a href=$Http::WEBPROC?GO=GUI::Devices::comments&key=$h->{key}>Info</a>",
        "$ip $wwn_err",  
        $active1, $active2, $active3,
        $agroup ]);

    $bold="";
    $cnt2++;
  }
  if ($cnt2 == 0) {
     $no_dev .= "<b>$L->{'dev_list.err_3'}";
  }

  my $comment = GUI->needToPush($hosts);
  my $cnt = $#devs + 1;
  my $g1 = "&GROUP=$q->{GROUP}" if (exists $q->{GROUP});

   my ($assign, $del_group);
   my $del_all =  Html::Screen->submitButton("ACTION_all", $L->{'dev_list.submit2'},undef,
             { confirm => $L->{'dev_list.l11'} });


  if (!$deny) {
     my $del_host;
     my $h1 = $q->{HOST};
     $h1 = $renv->{hostname} if ($h1 eq "LOCAL");
     my $gr_select = $groups->select("GROUP", undef, $L->{'dev_list.sel'});
     $del_all = "" if ($q->{GROUP});
     if ($q->{GROUP}) {
        $del_group = Html::Screen->submitButton("ACTION_group", $L->expand('dev_list.submitG', $q->{GROUP}), undef,
           { confirm => $L->{'dev_list.lgroup'} } );
     }
     if ($cnt && $h1 &&  $h1 !~ /^\d+\.\d+\./) {
        my $ix = index($h1, ".");
        $h1 = substr($h1,0,$ix) if ($ix > 0);
        $del_all = "";
        $del_host =  Html::Screen->submitButton("ACTION_only", $L->expand('dev_list.submit1', $h1), undef,
            { confirm => $L->expand('dev_list.l10', $h1)} ) . "&nbsp;";
        if ($groups->count() > 0) {
          $assign = "<tr><td colspan=2>
           <table border=0 bgcolor=#F0F0F0><tr><td>&nbsp;
             <b>" . $L->expand('dev_list.assign' => $h1) . ":$gr_select" .
            Html::Screen->submitButton("ACTION_ass", $L->{'dev_list.assign0'}) . "&nbsp;</table>";
        }
     }
   }
   my $scr = Html::Screen->new();
   my $FILTER = "<table border=1 cellspacing=0 cellpadding=0><tr><td>
    &nbsp;$G->{filter}:$groupsD &nbsp;$hostsD" . Html::Screen->submitButton("ACTION", "GO") .
    "</table>";

   $scr->add("<form><input type=hidden name=GO value=GUI::Devices::list> <center> $head $q->{ERR} $comment ");

   my $del = $renv->{solution} ne "N" ? 2 : ($deny ? 1:0);

   $q->{SORT} = 3 if (!$q->{SORT});
   $scr->list( $q, { title => $L->{'dev_list.l1'}, interactive => 1 },
   [
   [ c => $L->{'dev_list.l8'}, undef, undef, $del ],
   [ l => $L->{'dev_list.host'},'+'],
   [ h => $L->{'dev_list.l3'},  '+'],
   [ l => $L->{'dev_list.l4'},  '+'],
   [ l => $L->{'dev_list.comment'} ],
   [ l => $L->{'dev_list.l5'},  '+'],
   [ c => $L->{'dev_list.dev'} ],
   [ c => $L->{'dev_list.cat'} ],
   [ c => $L->{'dev_list.agent'} ],
   [ l => $L->{'dev_list.group'} ],
   ],
   \@array,
   [
   [ l => "ACTION_selected", $L->{'dev_list.submit3'}, $del ],
   [ l => "DATA", $del_all ,  $del ],
   [ l => "DATA", $del_group, $del ],
   [ l => "DATA", $del_host,  $del ],
   [ l => "FILTER", $FILTER,    $del ],
   ]
   );

   $scr->add($assign);
   $scr->add("</form>");
   print $scr->out();
}

sub comments {
  my($q) = @_;

  my $G = Labels->read();
  my $L = Labels->read('GUI::Devices')->section("comments");
  print Html->body();
  my $key = $q->{key};

  if ($q->{ACTION_back}) {
    &list($q);
    return;
  }
  my $deny = Roles->verifyRole($q, "admin|c_admin");
  my $button;
  
  print Html->header2("admin.gen_maint.maint_device", undef, $L->{comment}, 
      undef, {noDoc => 1});

  if ($q->{ACTION_update}) {
    my $comment = Util->deserialize("Comments.txt") || {};
    $q->{comments} =~ s/\r//g;
    $q->{comments} =~ s/\n /\n/g;
    $q->{comments} =~ s/<\//< \//g;
    $comment->{$key} = $q->{comments};
    Util->serialize("Comments.txt", $comment);
    print Html->info($L->{updated});
  }
  my $renv   = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  
  my $dev1 = $Config->deviceByKey($q->{key});
  my $comment = Util->deserialize("Comments.txt") || {};
  my $co = $comment->{$key};
  my $scr = Html::Screen->new();
  $scr->add(" <form><input type=hidden name=GO value=GUI::Devices::comments> <input type=hidden name=key value=\"$q->{key}\">");
  $scr->table( { title => $L->{enter_info}, labelWidth => "20%" }, 
   [ 
   [ f => "Device", $dev1->{name} ],
   [ f => "IP", $dev1->{ipno} ],
   [ f => $L->{comment}, "<textarea name=comments cols=80 rows=20>$co</textarea>" ],
   ]);
   $scr->button2( [
    [ l => 'ACTION_update', $G->{submit_update} , $deny ],
    [ l => 'ACTION_back', $G->{back} ], 
    ]);
  
   $scr->add("</form>");
   print $scr->out();
}


sub add {
  my ($q) = @_;
  print Html->body();

  my $deny = Roles->verifyRole($q, "admin");
  if ($deny) {
    print $deny;
    return;
  }
  print Html->header2("admin.gen_maint.add_device");
  print &add0($q);
}

sub add0 {
  my($q) = @_;
  my $add ;
  my $L = Labels->read("GUI::Devices")->section("dev_list");
  my $categories = Modules->load("GUIAdmin");
  my $renv = System->get_renv();
  $add = "<table border=0 width=80%><tr><td valign=top>";
  my $cn = 0;
  my $tot = 0;
  foreach my $cat (sort @$categories) {
    next if ($renv->{solution} ne "N" && index(Report::CAT_LEGACY, lc(",$cat,")) >= 0);
    my $fun = "GUIAdmin::${cat}";
    if ($fun->isDevice() ) {
      $tot++;
    }
  }
  $tot++;
  foreach my $cat (sort @$categories) {
    next if ($renv->{solution} ne "N" && index(Report::CAT_LEGACY, lc(",$cat,")) >= 0);
    my $fun = "GUIAdmin::${cat}";
    if ($fun->isDevice() ) {
       my $desc = $fun->description() ;
       my $b = ($cat eq $q->{ADD}) ? "<b>": "";
       $add .= "<big>&nbsp;</big>-<a href=\"$Http::WEBPROC?GO=GUIAdmin::${cat}->addDevice\">" .($desc||$cat) . "</a><br>";
       $cn++;
       $add .= "</td><td valign=top>"  if ($cn == int($tot/3) || $cn == int(2*$tot/3));
    }
  }
  $add .= "</table>";

  return "
   <table border=1 cellspacing=0 width=$Style::WIDTH bgcolor=white>
   <tr><td colspan=3 bgcolor=$Style::DARK>
   <table border=0><tr><td><b><font color=white>&nbsp;$L->{select}
   </table></td>
   <tr><td colspan=3 bgcolor=white><center>$add</td>
   </table>";

}

sub selectList {
  my($q) = @_;

}


1;
