package FSA::T3Rules;
use strict;
use FSA;
use base 'FSA';


# faulted fan should be before stateChange of the PCU
# volumes will go to writethru
# if it's the same fru
# return ($new_event, $target_list);
# DPL/075.sp
#
sub RULE1 {
 my($class, $Config, $topo, $targets, $elist) = @_;
 my ($bat, $log, $other, $bat_ev);

 return () if ($class->exclude($targets, "t3,6120,6020"));

 my ($fan_fru, $fru,  $x1, $x2, $x, $val1, $val2, $ev1);

 for ($x=0; $x <= $#$elist; $x++) {
    my $ed    = $elist->[$x];
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    my($cat, $et0) = split(/\./, $et);
    my $cap   = $ev->value("Caption");
    my $comp  = $ev->value("Component");
    if ($cap =~ /power\.(u\dpcu\d)\.fruPowerFan/) { 
      $fan_fru = $1; 
      $val1 = $ev->value("CurrentValue");
      $x1 = $x;
      $ev1 = $ev;
    } elsif ($et =~ /StateChange/ && $cap =~ /power\.(u\dpcu\d)$/) {
      $val2 = $ev->value("CurrentValue");
      $fru = $1;  
      $x2 = $x;
    }
 }
 if ($fan_fru && $fan_fru eq $fru && $x1 > $x2 && $val1 eq "fault") {
    my @ev = FSA->newEvent($elist, $targets, $ev1);
    return @ev;
 }
 return ();
}


# GENERATE FAULT
# new event when 2 LoopCableState Event occurs
# 056.sp
sub RULE2 {
  my($class, $Config, $topo, $targets, $elist) = @_;
  my ($loop2, $loop1, $l1, $l2, $state, $name);
  my $sev;

  return () if ($class->exclude($targets,"t3,6120,6020"));
  my($cat, $rest) = split(/\:/, $targets->[0]);

  foreach my $ed (@$elist) {
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    my $cap   = $ev->value("Caption");

    my $class = $ed->id("class");
    if ($et =~ /ValueChangeEvent/ && $cap =~ /loopcard\.(u\dl\d)\.fruLoopCable2State/) {
       $l2 = $1;
       $loop2 = $ev;
       $sev   = $ev->value("Severity"); # 0: insert, else: Remove
    } elsif ($et =~ /ValueChangeEvent/ && $cap =~ /loopcard\.(u\dl\d)\.fruLoopCable1State/) {
       $l1 = $1;
       $loop1 = $ev;
       $name = $ev->value("TargetName");
       $sev   = $ev->value("Severity"); # 0: insert, else: Remove
    } elsif ($et =~ /StateChange/ && $cap =~ /loopcard/) {
       $state = $ev;
       $sev   = $ev->value("Severity"); # 0: insert, else: Remove
    }
  }
  if ($state && $loop1 && $loop2) {

    my $connectionString = "disconnected";
    my $eventType = "ComponentRemoveEvent";
    if ($sev eq "0") {
       $connectionString = "connected";
       $eventType = "ComponentInsertEvent";	
    }

    my $desc = "Cable between '$l1' and '$l2' on $name is $connectionString";
    my $etype= "$cat.$eventType";
    my @ev = FSA->newEvent($elist, $targets, $loop1, $desc,
              { EventType => $etype ,
                Component => "loopcard.$l1.cable",
                Caption   => "M.loopcard.$l1.cable",
                Fault     => "T3Rules::RULE3, elist=" . ($#$elist+1),
                GridCode  => "$etype.interface.loopcard.cable",
              });
    return @ev;
  }
  return ();
}


# remove a disk and insert the same disk: call it replace the disk
# bug 4812064

sub RULE3 {

  my($class, $Config, $topo, $targets, $elist) = @_;

  return () if ($class->exclude($targets,"t3,6120,6020"));
  my($cat, $rest) = split(/\:/, $targets->[0]);
  my($x,$d1,$d2,$ev1, $more, $old, $new, $name);

 for ($x=0; $x <= $#$elist; $x++) {
    my $ed    = $elist->[$x];
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    my $cap   = $ev->value("Caption");
    my $class = $ed->id("class");
    if ($et =~ /ComponentRemove/ && $cap =~ /disk\.(u\dd\d+)/) {
        $d1   = $1;
        $ev1  = $ev;
        $old  = $ev->value("PriorValue");
    } elsif ($et =~ /ComponentInsert/ && $cap =~ /disk\.(u\dd\d+)/) {
        $d2   = $1;
        $new  = $ev->value("CurrentValue");
        $name = $ev->value("TargetName");
    } elsif ($et !~ /LogEvent/) {
        $more++;
    }
  }
  if ($d1 && $d1 eq $d2 && !$more) {
     my($cat, $rest) = split(/\:/, $targets->[0]);
     my $desc = "Disk '$d1' on $name was replaced from '$old' to '$new'";

     my @ev = FSA->newEvent($elist, $targets, $ev1, $desc, 
              { Fault     => "T3Rules:RULE3",
                EventType => "$cat.ComponentReplaceEvent",
                GridCode  => "$cat.ComponentReplaceEvent.disk",
                Severity  => 1,
                Actionable => 0,
             });
     return @ev;
  }
  return ();
     
}

#
# PATH_DOWN
#

sub RULE4 {
  my($class, $Config, $topo, $targets, $elist) = @_;

  return ();
  return () if ($class->exclude($targets,"t3,6120,6020"));
  my($cat, $rest) = split(/\:/, $targets->[0]);
  my($x,$d1,$d2,$ev1, $more, $old, $new, $name);

 for ($x=0; $x <= $#$elist; $x++) {
    my $ed    = $elist->[$x];
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    my $cap   = $ev->value("Caption");
    my $class = $ed->id("class");
    if ($et =~ /LogEvent.controller.failover/) {
        $d1   = $1;
        $ev1  = $ev;
        $old  = $ev->value("PriorValue");
    } elsif ($et =~ /ComponentInsert/ && $cap =~ /disk\.(u\dd\d+)/) {
        $d2   = $1;
        $new  = $ev->value("CurrentValue");
        $name = $ev->value("TargetName");
    } elsif ($et !~ /LogEvent/) {
        $more++;
    }
  }
  if ($d1 && $d1 eq $d2 && !$more) {
     my($cat, $rest) = split(/\:/, $targets->[0]);
     my $desc = "Disk '$d1' on $name was replaced from '$old' to '$new'";

     my @ev = FSA->newEvent($elist, $targets, $ev1, $desc, );
  }
}


# remove a disk and insert the same disk: call it replace the disk
# bug 5025966
# snapshot DPL/127a.sp,REPAIR

sub RULE5 {
  my($class, $Config, $topo, $targets, $elist) = @_;

  return () if ($class->exclude($targets,"t3,6120,6020"));
  my($cat, $rest) = split(/\:/, $targets->[0]);
  my($x,$ev1, $more, $old, $new, $name, $crc);
  my($volcache, $diskstate, $main, $disk_log, $loop_cable, $other);

 for ($x=0; $x <= $#$elist; $x++) {
    my $ed    = $elist->[$x];
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    my $cap   = $ev->value("Caption");
    my $class = $ed->id("class");

    if ($et =~ /LogEvent.controller.port/) {
        $ev1  = $ev;

    } elsif ($et =~ /ValueChangeEvent/ && $cap =~ /fruDiskPort/) {
        $diskstate++;

    } elsif ($et =~ /ValueChangeEvent/ && $cap =~ /disk.statistics/) {
        $crc++;

    } elsif ($et =~ /ValueChangeEvent/ && $cap =~ /volCacheMode/) {
        $volcache++;

    } elsif ($et =~ /StateChangeEvent/ && $cap =~ /P.loopcard/) {
        $main = $ev;

    } elsif ($et =~ /ValueChange/ && $cap =~ /P.loopcard/) {
        $loop_cable = $ev;

    } elsif ($et =~ /LogEvent.disk/) {
        $disk_log++;
    } else {
        $other++;
    }
  }
  if ($main && $volcache >= 0 && $diskstate >= 1  &&  $loop_cable > 0 &&
      $crc >= 0 && $disk_log >= 0 && !$other) {
     
     my @ev = FSA->newEvent($elist, $targets, $main, undef,
              { Fault     => "T3Rules:RULE5",
                Repair    => 1,
             });
     return @ev;
  }
  return ();

}



1;
